/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.StringFun;
import java.io.BufferedWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"DiagnosticMonitorFormatVersion", "", "currTime", "", "exportDateTimeStr", "", "time", "appendShortTimeStr", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "closeSafely", "Ljava/io/BufferedWriter;", "intellij.database.core.impl"})
@JvmName(name="DiagnosticMonitorInternals")
public final class DiagnosticMonitorInternals {
    public static final int DiagnosticMonitorFormatVersion = 1;

    public static final long currTime() {
        return System.currentTimeMillis();
    }

    public static final void appendShortTimeStr(@NotNull StringBuilder $this$appendShortTimeStr, long time) {
        Intrinsics.checkNotNullParameter((Object)$this$appendShortTimeStr, (String)"<this>");
        Instant instant = Instant.ofEpochMilli(time);
        LocalDateTime lt = instant.atZone(ZoneOffset.UTC).toLocalDateTime();
        StringFun.appendWithLeadingZeros($this$appendShortTimeStr, lt.getHour(), 2);
        $this$appendShortTimeStr.append(':');
        StringFun.appendWithLeadingZeros($this$appendShortTimeStr, lt.getMinute(), 2);
        $this$appendShortTimeStr.append(':');
        StringFun.appendWithLeadingZeros($this$appendShortTimeStr, lt.getSecond(), 2);
    }

    @NotNull
    public static final String exportDateTimeStr(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        Intrinsics.checkNotNull((Object)instant);
        return CalendarFun.export(instant, false);
    }

    public static final void closeSafely(@NotNull BufferedWriter $this$closeSafely) {
        Intrinsics.checkNotNullParameter((Object)$this$closeSafely, (String)"<this>");
        try {
            $this$closeSafely.close();
        }
        catch (Exception e2) {
            System.err.println("Cannot close file!");
            e2.printStackTrace();
        }
    }
}

