/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.diagnostic.DiagnosticMonitorInternals;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/diagnostic/DiagnosticMonitorFiles;", "", "()V", "dirRef", "Ljava/nio/file/Path;", "dirRefLock", "Ljava/lang/Object;", "obtainDiagnosticLogDirectory", "obtainDiagnosticLogDirectory$intellij_database_core_impl", "prepareEmptyDiagnosticSessionFilePath", "time", "", "infix", "", "intellij.database.core.impl"})
public final class DiagnosticMonitorFiles {
    @NotNull
    public static final DiagnosticMonitorFiles INSTANCE = new DiagnosticMonitorFiles();
    @Nullable
    private static transient Path dirRef;
    @NotNull
    private static final Object dirRefLock;

    private DiagnosticMonitorFiles() {
    }

    @NotNull
    public final Path prepareEmptyDiagnosticSessionFilePath(long time, @NotNull CharSequence infix) {
        Intrinsics.checkNotNullParameter((Object)infix, (String)"infix");
        Path tempDir = this.obtainDiagnosticLogDirectory$intellij_database_core_impl();
        String tms = StringsKt.replace$default((String)StringsKt.replace$default((String)DiagnosticMonitorInternals.exportDateTimeStr(time), (char)':', (char)'-', (boolean)false, (int)4, null), (char)'.', (char)'-', (boolean)false, (int)4, null);
        String tempFileName = "dgmon-" + tms + "-" + infix + ".dlog";
        Path path = tempDir.resolve(tempFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path obtainDiagnosticLogDirectory$intellij_database_core_impl() {
        Path dr = null;
        Object object = dirRefLock;
        synchronized (object) {
            boolean bl = false;
            dr = dirRef;
            if (dr == null) {
                dr = Files.createTempDirectory("DataGripDiagnosticLog-", new FileAttribute[0]);
                dirRef = dr;
            }
            Unit unit = Unit.INSTANCE;
        }
        Path path = dr;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    static {
        dirRefLock = new Object();
    }
}

