/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticMonitorFiles;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\fJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 J\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ \u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010$\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/diagnostic/DiagnosticMonitor;", "", "()V", "enabled", "", "getEnabled", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "recorders", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/database/diagnostic/DataSourceDiagnosticRecorder;", "formDataSourceAbbreviation", "", "ds", "Lcom/intellij/database/model/DasDataSource;", "getRecorder", "dsId", "initNewRecorder", "introspectionContext", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "isRecordingDataSource", "notifyUserAboutRecording", "", "eventType", "Lcom/intellij/database/introspection/DBIntrospectionContext$DiagnosticNotificationEventType;", "filePath", "Ljava/nio/file/Path;", "record", "messageMaker", "Lkotlin/Function0;", "message", "showMessageThatRecordingIsStarted", "showMessageThatRecordingIsStopped", "startRecordingDataSource", "stopRecordingDataSource", "intellij.database.core.impl"})
public final class DiagnosticMonitor {
    @NotNull
    public static final DiagnosticMonitor INSTANCE = new DiagnosticMonitor();
    private static final boolean enabled = Registry.is((String)"database.diagnostic.monitor.enable");
    @NotNull
    private static final ConcurrentHashMap<String, DataSourceDiagnosticRecorder> recorders = new ConcurrentHashMap();
    @NotNull
    private static final Logger logger;

    private DiagnosticMonitor() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void startRecordingDataSource(@NotNull DasDataSource ds, @NotNull DBIntrospectionContext introspectionContext) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)introspectionContext, (String)"introspectionContext");
        if (!enabled) {
            return;
        }
        recorders.computeIfAbsent(ds.getUniqueId(), arg_0 -> DiagnosticMonitor.startRecordingDataSource$lambda$0((Function1)new Function1<String, DataSourceDiagnosticRecorder>(ds, introspectionContext){
            final /* synthetic */ DasDataSource $ds;
            final /* synthetic */ DBIntrospectionContext $introspectionContext;
            {
                this.$ds = $ds;
                this.$introspectionContext = $introspectionContext;
                super(1);
            }

            @NotNull
            public final DataSourceDiagnosticRecorder invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return DiagnosticMonitor.access$initNewRecorder(DiagnosticMonitor.INSTANCE, this.$ds, this.$introspectionContext);
            }
        }, arg_0));
    }

    private final DataSourceDiagnosticRecorder initNewRecorder(DasDataSource ds, DBIntrospectionContext introspectionContext) {
        long beginTime = System.currentTimeMillis();
        CharSequence infix = this.formDataSourceAbbreviation(ds);
        Path path = DiagnosticMonitorFiles.INSTANCE.prepareEmptyDiagnosticSessionFilePath(beginTime, infix);
        DataSourceDiagnosticRecorder recorder = new DataSourceDiagnosticRecorder(introspectionContext, path);
        try {
            recorder.makeHeader(ds, beginTime);
            this.showMessageThatRecordingIsStarted(introspectionContext, ds, path);
            return recorder;
        }
        catch (Throwable e2) {
            recorder.close();
            throw e2;
        }
    }

    private final CharSequence formDataSourceAbbreviation(DasDataSource ds) {
        String string = ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String dsName = string;
        StringBuilder b2 = new StringBuilder();
        int g2 = 0;
        int n = dsName.length();
        for (int j = 0; j < n; ++j) {
            char c2 = dsName.charAt(j);
            if (Character.isLetterOrDigit(c2)) {
                b2.append(c2);
            }
            if (!Character.isUpperCase(c2)) continue;
            ++g2;
        }
        int n3 = b2.length();
        if (g2 >= n3 / 2) {
            for (int i2 = 1; i2 < n3; ++i2) {
                b2.setCharAt(i2, Character.toLowerCase(b2.charAt(i2)));
            }
        }
        if (n3 == 0) {
            b2.append(ds.getDbms().getName());
        }
        return b2;
    }

    public final boolean isRecordingDataSource(@NotNull String dsId) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        return enabled && recorders.containsKey(dsId);
    }

    public final void stopRecordingDataSource(@NotNull DasDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DataSourceDiagnosticRecorder recorder = recorders.remove(ds.getUniqueId());
        if (recorder != null) {
            recorder.recordFlow("Ending the diagnostic session.");
            recorder.close();
            this.showMessageThatRecordingIsStopped(recorder.getIntrospectionContext(), ds, recorder.getFilePath());
        }
    }

    private final void showMessageThatRecordingIsStarted(DBIntrospectionContext introspectionContext, DasDataSource ds, Path filePath) {
        logger.info("Diagnostic is started for data source " + ds.getName() + ". Log file: " + ((Object)filePath.toAbsolutePath()).toString());
        this.notifyUserAboutRecording(introspectionContext, ds, DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STARTED, filePath);
    }

    private final void showMessageThatRecordingIsStopped(DBIntrospectionContext introspectionContext, DasDataSource ds, Path filePath) {
        logger.info("Diagnostic is stopped for data source " + ds.getName() + ". Log file: " + ((Object)filePath.toAbsolutePath()).toString());
        this.notifyUserAboutRecording(introspectionContext, ds, DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STOPPED, filePath);
    }

    private final void notifyUserAboutRecording(DBIntrospectionContext introspectionContext, DasDataSource ds, DBIntrospectionContext.DiagnosticNotificationEventType eventType, Path filePath) {
        String string = ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        DBIntrospectionContext.UserNotifier notifier = introspectionContext.getUserNotifier(string);
        notifier.notifyDiagnosticMonitorFile(eventType, filePath);
    }

    @Nullable
    public final DataSourceDiagnosticRecorder getRecorder(@NotNull String dsId) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        return enabled ? recorders.get(dsId) : null;
    }

    public final void record(@NotNull String dsId, @NotNull String message2) {
        block1: {
            DataSourceDiagnosticRecorder recorder;
            Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            if (!enabled) {
                return;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = recorder = recorders.get(dsId);
            if (dataSourceDiagnosticRecorder == null) break block1;
            dataSourceDiagnosticRecorder.recordFlow(message2);
        }
    }

    public final void record(@NotNull String dsId, @NotNull Function0<String> messageMaker) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        Intrinsics.checkNotNullParameter(messageMaker, (String)"messageMaker");
        if (!enabled) {
            return;
        }
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = recorders.get(dsId);
        if (dataSourceDiagnosticRecorder == null) {
            return;
        }
        DataSourceDiagnosticRecorder recorder = dataSourceDiagnosticRecorder;
        String message2 = (String)messageMaker.invoke();
        recorder.recordFlow(message2);
    }

    private static final DataSourceDiagnosticRecorder startRecordingDataSource$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataSourceDiagnosticRecorder)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DataSourceDiagnosticRecorder access$initNewRecorder(DiagnosticMonitor $this, DasDataSource ds, DBIntrospectionContext introspectionContext) {
        return $this.initNewRecorder(ds, introspectionContext);
    }

    static {
        Logger logger2 = Logger.getInstance(DiagnosticMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

