/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.diagnostic.DiagnosticMessageCategory;
import com.intellij.database.diagnostic.DiagnosticMonitorInternals;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.model.DasDataSource;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020 2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010%\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/diagnostic/DataSourceDiagnosticRecorder;", "Ljava/io/Closeable;", "introspectionContext", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "filePath", "Ljava/nio/file/Path;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Ljava/nio/file/Path;)V", "closed", "", "file", "Ljava/io/BufferedWriter;", "getFilePath", "()Ljava/nio/file/Path;", "getIntrospectionContext", "()Lcom/intellij/database/introspection/DBIntrospectionContext;", "sectionCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "close", "", "makeHeader", "ds", "Lcom/intellij/database/model/DasDataSource;", "beginTime", "", "print", "time", "category", "Lcom/intellij/database/diagnostic/DiagnosticMessageCategory;", "message", "", "recordFlow", "recordSectionBegin", "Lcom/intellij/database/diagnostic/DiagnosticSectionReference;", "name", "", "recordSectionEnd", "sectionReference", "recordTrace", "Companion", "intellij.database.core.impl"})
public final class DataSourceDiagnosticRecorder
implements Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DBIntrospectionContext introspectionContext;
    @NotNull
    private final Path filePath;
    @NotNull
    private final BufferedWriter file;
    @NotNull
    private final AtomicInteger sectionCounter;
    private volatile boolean closed;
    @NotNull
    private static final String FILE_HEADER_STR_1 = "========= DATAGRIP DIAGNOSTIC MONITOR LOG =========\n";
    @NotNull
    private static final String FILE_HEADER_STR_2 = "---------------------------------------------------\n\n";
    @NotNull
    private static final String INDENT = "            ";

    public DataSourceDiagnosticRecorder(@NotNull DBIntrospectionContext introspectionContext, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)introspectionContext, (String)"introspectionContext");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.introspectionContext = introspectionContext;
        this.filePath = filePath;
        this.sectionCounter = new AtomicInteger();
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.filePath, Charsets.UTF_8, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(...)");
        this.file = bufferedWriter;
    }

    @NotNull
    public final DBIntrospectionContext getIntrospectionContext() {
        return this.introspectionContext;
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    public final void makeHeader(@NotNull DasDataSource ds, long beginTime) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        if (this.closed) {
            return;
        }
        this.file.write(FILE_HEADER_STR_1);
        String text2 = StringsKt.trimMargin$default((String)("|Format version:    1 \n                  |Current timestamp: " + DiagnosticMonitorInternals.exportDateTimeStr(beginTime) + "\n                  |DBMS:              " + ds.getDbms().getName() + "\n                  |DataSource name:   " + ds.getName() + "\n               "), null, (int)1, null);
        this.file.write(text2);
        this.file.write("\n");
        this.file.write(FILE_HEADER_STR_2);
        this.file.flush();
    }

    @NotNull
    public final DiagnosticSectionReference recordSectionBegin(@NotNull String name2, @Nullable CharSequence message2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int sectionId = this.sectionCounter.incrementAndGet();
        long time1 = DiagnosticMonitorInternals.currTime();
        StringBuilder $this$recordSectionBegin_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$recordSectionBegin_u24lambda_u240.append(name2);
        $this$recordSectionBegin_u24lambda_u240.append(" #-");
        $this$recordSectionBegin_u24lambda_u240.append(sectionId);
        if (message2 != null) {
            $this$recordSectionBegin_u24lambda_u240.append('\n').append(message2);
        }
        StringBuilder text2 = stringBuilder;
        this.print(time1, DiagnosticMessageCategory.MC_SECTION_BEGIN, text2);
        return new DiagnosticSectionReference(name2, sectionId, time1);
    }

    public static /* synthetic */ DiagnosticSectionReference recordSectionBegin$default(DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder, String string, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            charSequence = null;
        }
        return dataSourceDiagnosticRecorder.recordSectionBegin(string, charSequence);
    }

    public final void recordSectionEnd(@NotNull DiagnosticSectionReference sectionReference, @Nullable CharSequence message2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)sectionReference, (String)"sectionReference");
        long time1 = sectionReference.time;
        long time2 = DiagnosticMonitorInternals.currTime();
        long delta = time2 - time1;
        StringBuilder $this$recordSectionEnd_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$recordSectionEnd_u24lambda_u241.append(sectionReference.name);
        $this$recordSectionEnd_u24lambda_u241.append(" #-");
        $this$recordSectionEnd_u24lambda_u241.append(sectionReference.id);
        $this$recordSectionEnd_u24lambda_u241.append(" [dur=");
        $this$recordSectionEnd_u24lambda_u241.append(delta / (long)1000);
        $this$recordSectionEnd_u24lambda_u241.append('.');
        $this$recordSectionEnd_u24lambda_u241.append(delta % (long)1000);
        $this$recordSectionEnd_u24lambda_u241.append("s]");
        if (message2 != null) {
            $this$recordSectionEnd_u24lambda_u241.append('\n').append(message2);
        }
        StringBuilder text2 = stringBuilder;
        this.print(time2, DiagnosticMessageCategory.MC_SECTION_END, text2);
    }

    public static /* synthetic */ void recordSectionEnd$default(DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder, DiagnosticSectionReference diagnosticSectionReference, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            charSequence = null;
        }
        dataSourceDiagnosticRecorder.recordSectionEnd(diagnosticSectionReference, charSequence);
    }

    public final void recordFlow(@NotNull CharSequence message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.print(DiagnosticMonitorInternals.currTime(), DiagnosticMessageCategory.MC_FLOW, message2);
    }

    public final void recordTrace(@NotNull CharSequence message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.print(DiagnosticMonitorInternals.currTime(), DiagnosticMessageCategory.MC_TRACE, message2);
    }

    private final void print(long time, DiagnosticMessageCategory category, CharSequence message2) {
        int n;
        if (this.closed) {
            return;
        }
        StringBuilder b2 = new StringBuilder(message2.length() + 24);
        DiagnosticMonitorInternals.appendShortTimeStr(b2, time);
        b2.append(' ');
        b2.append(category.getCode());
        b2.append("  ");
        for (n = message2.length(); n > 0 && CharsKt.isWhitespace((char)message2.charAt(n - 1)); --n) {
        }
        for (int p2 = 0; p2 < n && CharsKt.isWhitespace((char)message2.charAt(p2)); ++p2) {
        }
        int n3 = n;
        for (int i2 = p2; i2 < n3; ++i2) {
            char c2 = message2.charAt(i2);
            b2.append(c2);
            if (c2 != '\n') continue;
            b2.append(INDENT);
        }
        b2.append('\n');
        int len = b2.length();
        char[] buf = new char[len];
        b2.getChars(0, len, buf, 0);
        this.file.write(buf, 0, len);
        this.file.flush();
    }

    @Override
    public void close() {
        this.closed = true;
        DiagnosticMonitorInternals.closeSafely(this.file);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/diagnostic/DataSourceDiagnosticRecorder$Companion;", "", "()V", "FILE_HEADER_STR_1", "", "FILE_HEADER_STR_2", "INDENT", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

