/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.RegularIntrospectionContext;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/diagnostic/DataSourceDiagnosticMonitorAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getDataSource", "Lcom/intellij/database/model/DasDataSource;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "", "state", "startDiagnosticLog", "ds", "project", "Lcom/intellij/openapi/project/Project;", "stopDiagnosticLog", "update", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceDiagnosticMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceDiagnosticMonitorAction.kt\ncom/intellij/database/diagnostic/DataSourceDiagnosticMonitorAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n31#2,2:65\n*S KotlinDebug\n*F\n+ 1 DataSourceDiagnosticMonitorAction.kt\ncom/intellij/database/diagnostic/DataSourceDiagnosticMonitorAction\n*L\n46#1:65,2\n*E\n"})
public final class DataSourceDiagnosticMonitorAction
extends ToggleAction {
    public DataSourceDiagnosticMonitorAction() {
        super("Diagnostic Monitor");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DasDataSource ds = this.getDataSource(e2);
        if (ds == null) return false;
        String string = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        if (!DiagnosticMonitor.INSTANCE.isRecordingDataSource(string)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ds = this.getDataSource(e);
        v0 = ok = ds != null;
        if (ds == null) ** GOTO lbl-1000
        v1 = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getUniqueId(...)");
        if (DiagnosticMonitor.INSTANCE.isRecordingDataSource(v1)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        running = v2;
        v3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPresentation(...)");
        presentation = v3;
        presentation.setEnabledAndVisible(ok);
        Toggleable.setSelected((Presentation)presentation, (boolean)running);
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DasDataSource dasDataSource = this.getDataSource(e2);
        if (dasDataSource == null) {
            return;
        }
        DasDataSource ds = dasDataSource;
        String string = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        boolean oldState = DiagnosticMonitor.INSTANCE.isRecordingDataSource(string);
        if (oldState == state) {
            return;
        }
        if (state) {
            this.startDiagnosticLog(ds, project2);
        } else {
            this.stopDiagnosticLog(ds);
        }
    }

    private final void startDiagnosticLog(DasDataSource ds, Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RegularIntrospectionContext> serviceClass$iv = RegularIntrospectionContext.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DBIntrospectionContext introspectionContext = (DBIntrospectionContext)object;
        DiagnosticMonitor.INSTANCE.startRecordingDataSource(ds, introspectionContext);
    }

    private final void stopDiagnosticLog(DasDataSource ds) {
        DiagnosticMonitor.INSTANCE.stopRecordingDataSource(ds);
    }

    private final DasDataSource getDataSource(AnActionEvent e2) {
        if (!DiagnosticMonitor.INSTANCE.getEnabled()) {
            return null;
        }
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dc);
        if (!CollectionFun.containsOnly((Collection)ranks, DvTreeNodeRank.TL_ROOT)) {
            return null;
        }
        Collection<LocalDataSource> selectedDSs = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dc);
        if (selectedDSs == null || selectedDSs.size() != 1) {
            return null;
        }
        return (DasDataSource)CollectionsKt.first((Iterable)selectedDSs);
    }
}

