/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.debugger.SqlDebugRunner;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/debugger/SqlDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "makeRequest", "Lcom/intellij/database/datagrid/GridDataRequest;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "client", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "sp", "Lcom/intellij/database/util/SearchPath;", "intellij.database.impl"})
public final class SqlDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof DatabaseScriptTextRunProfileState)) {
            return Promises.rejectedPromise();
        }
        String string = ((DatabaseScriptTextRunProfileState)state).getName();
        if (string == null) {
            string = "script";
        }
        String name2 = string;
        DGDepartment.RunConfigurationRunner dp = new DGDepartment.RunConfigurationRunner(name2);
        SearchPath sp = ((DatabaseScriptTextRunProfileState)state).getSearchPath();
        LocalDataSource ds = ((DatabaseScriptTextRunProfileState)state).getDataSource();
        DatabaseSessionManager.Facade facade = DatabaseSessionManager.getFacade(((DatabaseScriptTextRunProfileState)state).getProject(), ds, null, sp, false, null, dp);
        DatabaseSession session2 = DatabaseSessionManager.getSession(((DatabaseScriptTextRunProfileState)state).getProject(), ds, name2);
        VisibleDatabaseSessionClient client = facade.client(session2);
        LightVirtualFile f = new LightVirtualFile(name2, (CharSequence)((DatabaseScriptTextRunProfileState)state).getScriptText());
        f.setLanguage((Language)DbSqlUtil.getSqlDialect(ds));
        ScriptingClientDataConsumer.install(((DatabaseScriptTextRunProfileState)state).getProject(), client);
        GridDataRequest gridDataRequest = this.makeRequest(session2, client, f, sp);
        if (gridDataRequest == null) {
            return Promises.rejectedPromise();
        }
        GridDataRequest request2 = gridDataRequest;
        SqlDebugSessionRunner runner = SqlDebugSessionRunner.Handler.INSTANCE.createRunner((DatabaseSessionClient)client, request2, false, (VirtualFile)f, null, sp);
        runner.setOnFinish((Function0<Unit>)((Function0)new Function0<Unit>(client){
            final /* synthetic */ VisibleDatabaseSessionClient $client;
            {
                this.$client = $client;
                super(0);
            }

            public final void invoke() {
                Disposer.dispose((Disposable)this.$client);
            }
        }));
        return runner.execute(environment);
    }

    private final GridDataRequest makeRequest(DatabaseSession session2, VisibleDatabaseSessionClient client, LightVirtualFile file, SearchPath sp) {
        ScriptModel scriptModel = SqlDebugSessionRunner.Handler.obtainActualScriptModel$default(SqlDebugSessionRunner.Handler.INSTANCE, session2.getProject(), (VirtualFile)file, false, null, 8, null);
        if (scriptModel == null) {
            return null;
        }
        ScriptModel sm = scriptModel;
        List list = sm.statements().transform(ScriptModelUtilCore.TO_QUERY).map(arg_0 -> SqlDebugRunner.makeRequest$lambda$0(makeRequest.ss.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List ss2 = list;
        return DataRequest.newCallRequest(client, ss2, sp);
    }

    @NotNull
    public String getRunnerId() {
        return "sqlDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        if (!(profile2 instanceof DatabaseScriptRunConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)executorId, (Object)"Debug")) {
            return false;
        }
        DatabaseScriptRunConfigurationOptions options2 = ((DatabaseScriptRunConfiguration)profile2).getOptions();
        if (options2.getMode() != DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            return false;
        }
        Object object = (DatabaseScriptRunConfigurationOptions.Target)((Object)CollectionsKt.singleOrNull(options2.getTargets()));
        if (object == null || (object = object.getDataSourceId()) == null) {
            return false;
        }
        Object target2 = object;
        LocalDataSource localDataSource = DataSourceStorage.getProjectStorage(((DatabaseScriptRunConfiguration)profile2).getProject()).getDataSourceById((String)target2);
        if (localDataSource == null) {
            return false;
        }
        LocalDataSource ds = localDataSource;
        SqlDebuggerFacade sqlDebuggerFacade = SqlDebugSessionRunner.Handler.obtainDebuggerFacadeWhenApplicable(ds);
        return sqlDebuggerFacade != null ? sqlDebuggerFacade.canDebug(ds) : false;
    }

    private static final DataRequest.CallRequest.Statement makeRequest$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataRequest.CallRequest.Statement)$tmp0.invoke(p0);
    }
}

