/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.objects;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasGridDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn> {
    private final DasGridModel myModel;
    private final GridMutationModel myMutationModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    private final Supplier<@Nullable Iterable<BasicElement>> myObjects;

    public DasGridDataHookUp(Project project, String dataSourceId, @NotNull Supplier<@Nullable Iterable<BasicElement>> objects2, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual) {
        if (objects2 == null) {
            DasGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (valuesEqual == null) {
            DasGridDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.myObjects = objects2;
        this.myModel = new DasGridModel(dataSourceId, (v1, v2) -> (Boolean)valuesEqual.fun(v1, v2, (Object)this));
        this.myMutationModel = new GridMutationModel((GridDataHookUp)this);
        this.myModelUpdater = new GridStorageAndModelUpdater((GridListModelBase)this.myModel, this.myMutationModel, null);
    }

    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        return new GridPagingModelImpl.SinglePage((GridModel)this.myModel);
    }

    @NotNull
    public GridLoader getLoader() {
        return new GridLoader(){

            public void reloadCurrentPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.load(source, 0);
            }

            public void loadNextPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.load(source, 0);
            }

            public void loadPreviousPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.load(source, 0);
            }

            public void loadLastPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.load(source, 0);
            }

            public void loadFirstPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.load(source, 0);
            }

            public void load(@NotNull GridRequestSource source, int offset) {
                if (source == null) {
                    1.$$$reportNull$$$0(5);
                }
                ArrayList<GridColumn> columns2 = new ArrayList<GridColumn>();
                ArrayList<GridRow> rows = new ArrayList<GridRow>();
                ArrayList<ObjectPath> paths2 = new ArrayList<ObjectPath>();
                1.fill(DasGridDataHookUp.this.myObjects, columns2, rows, paths2);
                DasGridDataHookUp.this.myModel.setPaths(paths2);
                DasGridDataHookUp.this.myModelUpdater.removeRows(0, DasGridDataHookUp.this.myModel.getRowCount());
                DasGridDataHookUp.this.myModelUpdater.setColumns(columns2);
                DasGridDataHookUp.this.myModelUpdater.addRows(rows);
            }

            private static <E extends BasicElement> void fill(Supplier<@Nullable Iterable<E>> objects2, List<GridColumn> columns2, List<GridRow> rows, List<ObjectPath> paths2) {
                Iterable<E> objectsIt = objects2.get();
                if (objectsIt == null) {
                    return;
                }
                JBIterator objIt = JBIterator.from(objectsIt.iterator());
                if (!objIt.advance()) {
                    return;
                }
                BasicMetaObject<BasicElement> meta = BasicMetaUtils.getMetaObject((BasicElement)objIt.current());
                ArrayList rowProps = ContainerUtil.newArrayList(meta.getAllProperties());
                Dbms dbms = DbImplUtilCore.getDbms((BasicElement)objIt.current());
                ModelHelper helper = DbImplUtilCore.getModelHelper(dbms);
                helper.prepareProperties(meta, rowProps);
                Iterator it2 = rowProps.iterator();
                while (it2.hasNext()) {
                    BasicMetaProperty property = (BasicMetaProperty)it2.next();
                    if (property.isInternal() || property.isAbstract()) {
                        it2.remove();
                        continue;
                    }
                    BasicMetaType type2 = property.id.type;
                    Class valClass = BasicMetaUtils.isSimpleType(type2) ? type2.valueClass : String.class;
                    columns2.add((GridColumn)new DataConsumer.Column(columns2.size(), helper.getTitle(meta, property.id), 1111, valClass.getSimpleName(), valClass.getCanonicalName()));
                }
                do {
                    BasicElement element2 = (BasicElement)objIt.current();
                    Object[] values2 = new Object[rowProps.size()];
                    int size = rowProps.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        values2[i2] = BasicMetaUtils.getPropertySimpleValue(element2, (BasicMetaProperty)rowProps.get(i2));
                    }
                    rows.add((GridRow)DataConsumer.Row.create((int)rows.size(), (Object[])values2));
                    paths2.add(ObjectPaths.of(element2));
                } while (objIt.advance());
            }

            public void updateTotalRowCount(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(6);
                }
                DasGridDataHookUp.this.notifyRequestFinished(source, false);
            }

            public void applyFilterAndSorting(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(7);
                }
                DasGridDataHookUp.this.notifyRequestFinished(source, false);
            }

            public void updateIsTotalRowCountUpdateable() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "source";
                objectArray2[1] = "com/intellij/database/datagrid/objects/DasGridDataHookUp$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadCurrentPage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadNextPage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadPreviousPage";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadLastPage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadFirstPage";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "load";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateTotalRowCount";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyFilterAndSorting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            DasGridDataHookUp.$$$reportNull$$$0(2);
        }
        return gridMutationModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        DasGridModel dasGridModel = this.myModel;
        if (dasGridModel == null) {
            DasGridDataHookUp.$$$reportNull$$$0(3);
        }
        return dasGridModel;
    }

    @Nullable
    public DasObject getDatabaseObject(@Nullable GridRow row) {
        ObjectPath path;
        int idx = row == null ? -1 : GridRow.toRealIdx((GridRow)row);
        ObjectPath objectPath = path = idx < 0 || idx >= this.myModel.myPaths.size() ? null : this.myModel.myPaths.get(idx);
        if (path == null) {
            return null;
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance(this.getProject()).findDataSource(this.myModel.myDataSourceId);
        return dataSource2 == null ? null : dataSource2.findElement(path);
    }

    public static Supplier<Iterable<BasicElement>> createProvider(@NotNull Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind family) {
        if (project == null) {
            DasGridDataHookUp.$$$reportNull$$$0(4);
        }
        if (dataSourceId == null) {
            DasGridDataHookUp.$$$reportNull$$$0(5);
        }
        return () -> {
            if (family == null) {
                return JBIterable.empty();
            }
            BasicElement obj2 = DasGridDataHookUp.findObject(project, dataSourceId, path);
            return obj2 == null ? null : DasGridDataHookUp.extractFamily(project, obj2, family);
        };
    }

    @NotNull
    private static Iterable<BasicElement> extractFamily(@NotNull Project project, BasicElement obj2, @NotNull ObjectKind family) {
        Family<BasicElement> f;
        if (project == null) {
            DasGridDataHookUp.$$$reportNull$$$0(6);
        }
        if (family == null) {
            DasGridDataHookUp.$$$reportNull$$$0(7);
        }
        if ((f = obj2.familyOf(family)) != null) {
            Family<BasicElement> family2 = f;
            if (family2 == null) {
                DasGridDataHookUp.$$$reportNull$$$0(8);
            }
            return family2;
        }
        JBIterable jBIterable = DatabaseCoreUiService.getInstance().treeChildren(project, obj2, family).filter(BasicElement.class);
        if (jBIterable == null) {
            DasGridDataHookUp.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Nullable
    private static BasicElement findObject(@NotNull Project project, @NotNull String dataSourceId, @Nullable ObjectPath path) {
        DbDataSource dataSource2;
        if (project == null) {
            DasGridDataHookUp.$$$reportNull$$$0(10);
        }
        if (dataSourceId == null) {
            DasGridDataHookUp.$$$reportNull$$$0(11);
        }
        if ((dataSource2 = DbPsiFacade.getInstance(project).findDataSource(dataSourceId)) == null) {
            return null;
        }
        if (path == null) {
            BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            return model2 == null ? null : model2.getRoot();
        }
        return DbImplUtilCore.getMaybeBasicElement(dataSource2.findElement(path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/objects/DasGridDataHookUp";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/objects/DasGridDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractFamily";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class DasGridModel
    extends DataGridListModel {
        private final List<ObjectPath> myPaths;
        private final String myDataSourceId;

        private DasGridModel(String dataSourceId, @NotNull BiFunction<Object, Object, Boolean> valuesEquals) {
            if (valuesEquals == null) {
                DasGridModel.$$$reportNull$$$0(0);
            }
            super(valuesEquals);
            this.myPaths = new ArrayList<ObjectPath>();
            this.myDataSourceId = dataSourceId;
        }

        public void setPaths(List<ObjectPath> paths2) {
            this.myPaths.clear();
            this.myPaths.addAll(paths2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesEquals", "com/intellij/database/datagrid/objects/DasGridDataHookUp$DasGridModel", "<init>"));
        }
    }
}

