/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfo;
import com.intellij.database.connection.throwable.info.WarningInfo;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataAuditors
extends DataAuditor {

    public static class PrintingAdapter
    implements DataAuditor {
        private static final Logger LOG = Logger.getInstance(PrintingAdapter.class);

        public void rawPrint(@Nls @NotNull String s2, @NotNull ConsoleViewContentType output) {
            if (s2 == null) {
                PrintingAdapter.$$$reportNull$$$0(0);
            }
            if (output == null) {
                PrintingAdapter.$$$reportNull$$$0(1);
            }
        }

        @Nls
        @NotNull
        public String rawDecorateLine(@Nls @NotNull String s2, @NotNull ConsoleViewContentType output, @Nullable ThrowableInfo info2) {
            if (s2 == null) {
                PrintingAdapter.$$$reportNull$$$0(2);
            }
            if (output == null) {
                PrintingAdapter.$$$reportNull$$$0(3);
            }
            String string = s2;
            if (string == null) {
                PrintingAdapter.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(5);
            }
            this.print(message2);
        }

        public void print(@Nls String message2) {
            this.println(message2, ConsoleViewContentType.NORMAL_OUTPUT);
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(6);
            }
            if (warningInfo == null) {
                PrintingAdapter.$$$reportNull$$$0(7);
            }
            this.println((ThrowableInfo)warningInfo, ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(8);
            }
            if (errorInfo == null) {
                PrintingAdapter.$$$reportNull$$$0(9);
            }
            this.error(errorInfo);
        }

        public void error(@NotNull ErrorInfo errorInfo) {
            if (errorInfo == null) {
                PrintingAdapter.$$$reportNull$$$0(10);
            }
            this.printlnError(errorInfo);
        }

        public void error(@NotNull Throwable throwable) {
            if (throwable == null) {
                PrintingAdapter.$$$reportNull$$$0(11);
            }
            ExceptionUtil.getUserStackTrace((Throwable)throwable, (Logger)LOG);
            this.printlnError(SimpleErrorInfo.create((Throwable)throwable));
        }

        public void error(@Nls @NotNull String message2) {
            if (message2 == null) {
                PrintingAdapter.$$$reportNull$$$0(12);
            }
            this.printlnError(SimpleErrorInfo.create((String)message2));
        }

        private void printlnError(@NotNull ErrorInfo errorInfo) {
            if (errorInfo == null) {
                PrintingAdapter.$$$reportNull$$$0(13);
            }
            this.println((ThrowableInfo)errorInfo, ConsoleViewContentType.ERROR_OUTPUT);
        }

        public void println(@Nls @NotNull String message2, ConsoleViewContentType output) {
            if (message2 == null) {
                PrintingAdapter.$$$reportNull$$$0(14);
            }
            this.println(message2, null, output);
        }

        public void println(@NotNull ThrowableInfo info2, ConsoleViewContentType output) {
            if (info2 == null) {
                PrintingAdapter.$$$reportNull$$$0(15);
            }
            this.println(info2.getLogMessage(), info2, output);
        }

        private void println(@Nls @NotNull String message2, @Nullable ThrowableInfo info2, ConsoleViewContentType output) {
            if (message2 == null) {
                PrintingAdapter.$$$reportNull$$$0(16);
            }
            if (StringUtil.isEmptyOrSpaces((String)message2)) {
                this.newLine();
            } else {
                for (String s2 : StringUtil.splitByLines((String)message2)) {
                    this.rawPrint(this.rawDecorateLine(s2, output, info2), output);
                    this.newLine();
                }
            }
        }

        public void newLine() {
            this.rawPrint("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataAuditors$PrintingAdapter";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warningInfo";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "throwable";
                    break;
                }
                case 12: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataAuditors$PrintingAdapter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawDecorateLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rawPrint";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rawDecorateLine";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "print";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "warn";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "printlnError";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "println";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class BusyCounter
    implements DataAuditor {
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
            if (request2 == null) {
                BusyCounter.$$$reportNull$$$0(0);
            }
            if (producer == null) {
                BusyCounter.$$$reportNull$$$0(1);
            }
            this.update(this.count.incrementAndGet());
        }

        @Override
        public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
            if (request2 == null) {
                BusyCounter.$$$reportNull$$$0(2);
            }
            if (producer == null) {
                BusyCounter.$$$reportNull$$$0(3);
            }
            this.update(this.count.decrementAndGet());
        }

        public int getCount() {
            return this.count.intValue();
        }

        protected void update(int current) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataAuditors$BusyCounter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Adapter
    implements DataAuditor {
    }
}

