/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextDecompositionUtil {
    private static final JBTreeTraverser<TextDecompositionNodes.SNode> SNODE_TRAVERSER = JBTreeTraverser.from(node2 -> node2.children());

    @NotNull
    static List<TextRange> extractBadRanges(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(0);
        }
        List<TextRange> list = new TextDecompositionNodes.NodeVisitor<Void>(){
            private final List<TextRange> myRanges = new ArrayList<TextRange>();
            private final Set<TextDecompositionNodes.BadGroup> myVisited = new HashSet<TextDecompositionNodes.BadGroup>();

            public List<TextRange> getResult(@NotNull TextDecompositionNodes.SNode root2) {
                if (root2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visit(root2);
                return this.myRanges;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node2, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node2, TextDecompositionNodes.StartEndBadable.class);
                this.processBadGroup(bad == null ? null : bad.getBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getStartBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getEndBadGroup());
                node2.visitChildren(this);
                return null;
            }

            private void processBadGroup(TextDecompositionNodes.BadGroup badGroup) {
                if (badGroup != null && !this.myVisited.contains(badGroup)) {
                    assert (badGroup.getFrom() != -1);
                    this.myRanges.add(TextRange.create((int)badGroup.getFrom(), (int)badGroup.getTo()));
                    this.myVisited.add(badGroup);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResult";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.getResult(root2);
        if (list == null) {
            TextDecompositionUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    static void buildText(final @NotNull StringBuilder builder, @NotNull TextDecompositionNodes.SNode root2) {
        if (builder == null) {
            TextDecompositionUtil.$$$reportNull$$$0(2);
        }
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(3);
        }
        new SimpleNodeVisitor<Void>(){
            private boolean myDisabled = false;
            private final Set<TextDecompositionNodes.BadGroup> myVisited = new HashSet<TextDecompositionNodes.BadGroup>();

            private boolean processBadGroup(@Nullable TextDecompositionNodes.BadGroup b2) {
                if (b2 != null && !this.myVisited.contains(b2)) {
                    int start2 = builder.length();
                    builder.append(b2.getBadText());
                    int end = builder.length();
                    b2.setRange(start2, end);
                    this.myVisited.add(b2);
                }
                return b2 != null;
            }

            private void processBadTextPre(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.processBadGroup(node2 instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node2)).getStartBadGroup() : null);
            }

            private boolean processBadTextInstead(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return this.processBadGroup(node2 instanceof TextDecompositionNodes.Badable ? ((TextDecompositionNodes.Badable)((Object)node2)).getBadGroup() : null);
            }

            private void processBadTextPost(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.processBadGroup(node2 instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node2)).getEndBadGroup() : null);
            }

            private static void updateNodeRange(@NotNull TextDecompositionNodes.SNode node2, int start2, int end) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (start2 == end) {
                    node2.setMatchRange(-1, -1);
                } else {
                    node2.setMatchRange(start2, end);
                }
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                int start2 = builder.length();
                this.processBadTextPre(node2);
                boolean bad = this.processBadTextInstead(node2);
                if (bad || this.myDisabled) {
                    node2.visitChildren(this);
                } else {
                    super.visit(node2);
                }
                this.processBadTextPost(node2);
                int end = builder.length();
                2.updateNodeRange(node2, start2, end);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ParameterSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                builder.append(node2.getText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.TextSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                builder.append(node2.getMatchedText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.AntiSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.CompositeSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(8);
                }
                node2.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.OptionalSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(9);
                }
                assert (!this.myDisabled);
                this.myDisabled = !node2.isEnabled();
                node2.visitChildren(this);
                this.myDisabled = false;
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListChoiceSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(10);
                }
                node2.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListSNode node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(11);
                }
                boolean first2 = true;
                for (TextDecompositionNodes.ListChoiceSNode m : node2.getMatches()) {
                    if (!m.isEnabled()) continue;
                    if (!first2) {
                        builder.append(node2.getStateless().getSeparatorText());
                    } else {
                        first2 = false;
                    }
                    this.visit((TextDecompositionNodes.SNode)m);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextPre";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextInstead";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextPost";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateNodeRange";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(root2);
    }

    public static void purgeBadGroups(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(4);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node2, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node2, TextDecompositionNodes.StartEndBadable.class);
                if (bad != null) {
                    bad.setBadGroup(null);
                    TextDecompositionNodes.TextSNode text2 = (TextDecompositionNodes.TextSNode)ObjectUtils.tryCast((Object)node2, TextDecompositionNodes.TextSNode.class);
                    if (text2 != null) {
                        text2.setMatchedText(text2.getStateless().getText());
                    }
                }
                if (sebad != null) {
                    sebad.setStartBadGroup(null);
                    sebad.setEndBadGroup(null);
                }
                node2.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$3", "visit"));
            }
        }.visit(root2);
    }

    private static void assignGroups(@NotNull TextDecompositionNodes.SNode node2, int offset) {
        if (node2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(5);
        }
        ((TextDecompositionNodes.AbstractMatchable)((Object)node2)).setGroupNumber(offset);
        if (node2 instanceof TextDecompositionNodes.ListSNode) {
            return;
        }
        StatelessTextDecomposition.Node[] children2 = node2.getStateless().getChildren();
        Iterator scIt = node2.children().iterator();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            StatelessTextDecomposition.Node child = children2[i2];
            if (!scIt.hasNext()) {
                throw new AssertionError((Object)"children number mismatch");
            }
            TextDecompositionNodes.SNode sChild = (TextDecompositionNodes.SNode)scIt.next();
            if (sChild.getStateless() != child) {
                throw new AssertionError((Object)"children mismatch");
            }
            int cOffset = node2.getStateless().getChildGroupOffset(i2, 0);
            TextDecompositionUtil.assignGroups(sChild, offset + cOffset);
        }
    }

    public static void assignGroups(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(6);
        }
        TextDecompositionUtil.assignGroups(root2, 1);
    }

    public static void resetDisabledMatchables(@NotNull TextDecompositionNodes.SNode node2) {
        if (node2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(7);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private boolean myInsideDisabled = false;

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                boolean prev = this.myInsideDisabled;
                if (node2 instanceof TextDecompositionNodes.OptionalSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.OptionalSNode)node2).isEnabled();
                } else if (node2 instanceof TextDecompositionNodes.ListChoiceSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.ListChoiceSNode)node2).isEnabled();
                }
                node2.visitChildren(this);
                if (this.myInsideDisabled) {
                    node2.setMatch(null);
                }
                this.myInsideDisabled = prev;
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
            }
        }.visit(node2);
    }

    public static void nullizeMatch(@NotNull TextDecompositionNodes.SNode node2) {
        if (node2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(8);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                node2.setMatch(null);
                node2.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$5", "visit"));
            }
        }.visit(node2);
    }

    @NotNull
    public static TextDecompositionNodes.Matchable[] collectMatchables(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(9);
        }
        final ArrayList res2 = new ArrayList();
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node2) {
                if (node2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!(node2 instanceof TextDecompositionNodes.ListSNode)) {
                    node2.visitChildren(this);
                }
                res2.add(node2);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$6", "visit"));
            }
        }.visit(root2);
        TextDecompositionNodes.Matchable[] ares = res2.toArray(new TextDecompositionNodes.Matchable[0]);
        Arrays.sort(ares, Comparator.comparingInt(TextDecompositionNodes.Matchable::getGroupNumber));
        if (ares == null) {
            TextDecompositionUtil.$$$reportNull$$$0(10);
        }
        return ares;
    }

    @NotNull
    public static JBTreeTraverser<TextDecompositionNodes.SNode> traverse(@NotNull TextDecompositionNodes.SNode node2) {
        if (node2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(11);
        }
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)SNODE_TRAVERSER.withRoot((Object)node2);
        if (jBTreeTraverser == null) {
            TextDecompositionUtil.$$$reportNull$$$0(12);
        }
        return jBTreeTraverser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBadRanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchables";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractBadRanges";
                break;
            }
            case 1: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "purgeBadGroups";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assignGroups";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetDisabledMatchables";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "nullizeMatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchables";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 12 -> new IllegalStateException(string);
        };
    }

    static abstract class SimpleNodeVisitor<R>
    implements TextDecompositionNodes.NodeVisitor<R> {
        SimpleNodeVisitor() {
        }

        @Override
        public R visit(@NotNull TextDecompositionNodes.SNode node2) {
            if (node2 == null) {
                SimpleNodeVisitor.$$$reportNull$$$0(0);
            }
            if (node2.getClass() == TextDecompositionNodes.ParameterSNode.class) {
                return this.visit((TextDecompositionNodes.ParameterSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.TextSNode.class) {
                return this.visit((TextDecompositionNodes.TextSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.CompositeSNode.class) {
                return this.visit((TextDecompositionNodes.CompositeSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.OptionalSNode.class) {
                return this.visit((TextDecompositionNodes.OptionalSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.AntiSNode.class) {
                return this.visit((TextDecompositionNodes.AntiSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.ListSNode.class) {
                return this.visit((TextDecompositionNodes.ListSNode)node2);
            }
            if (node2.getClass() == TextDecompositionNodes.ListChoiceSNode.class) {
                return this.visit((TextDecompositionNodes.ListChoiceSNode)node2);
            }
            assert (false);
            return null;
        }

        public abstract R visit(@NotNull TextDecompositionNodes.AntiSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ParameterSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.TextSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.CompositeSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.OptionalSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListChoiceSNode var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$SimpleNodeVisitor", "visit"));
        }
    }
}

