/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTrackerBase;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0015J\u0012\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication;", "Lcom/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myAdded", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/Disposable;", "myDirtyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myFileStatus", "Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus;", "myListener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "myUpdates", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/openapi/application/ModalityState;", "distributeUpdates", "", "files", "", "ensureListenerAdded", "ensureListenerRemoved", "fileDirty", "file", "getFileStatus", "launchUpdater", "update", "validate", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.database.impl"})
public final class DbSrcChangesTrackerApplication
extends DbSrcChangesTrackerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DbSrcFileStatus myFileStatus;
    @NotNull
    private final Set<VirtualFile> myDirtyFiles;
    @NotNull
    private final MutableSharedFlow<ModalityState> myUpdates;
    @NotNull
    private final AtomicReference<Disposable> myAdded;
    @NotNull
    private final DocumentListener myListener;

    public DbSrcChangesTrackerApplication(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(null);
        this.cs = cs;
        this.myFileStatus = new DbSrcFileStatus();
        this.myDirtyFiles = new HashSet();
        this.myUpdates = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.myAdded = new AtomicReference();
        this.myListener = new DocumentListener(this){
            @NotNull
            private final FileDocumentManager documentManager;
            final /* synthetic */ DbSrcChangesTrackerApplication this$0;
            {
                this.this$0 = $receiver;
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                this.documentManager = fileDocumentManager;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile file = this.documentManager.getFile(event.getDocument());
                if (DbSrcUtilsCore.isDbSrcFile(file)) {
                    DbSrcChangesTrackerApplication.access$fileDirty(this.this$0, file);
                }
            }
        };
        this.launchUpdater();
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        appConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                    this.fileDirty(vFileEvent.getFile());
                }
            }
        });
        Topic topic2 = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        appConnection.subscribe(topic2, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.ensureListenerAdded();
            }

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                if (((Object[])projectArray).length == 0) {
                    this.ensureListenerRemoved();
                }
            }
        });
        Project[] projectArray = ProjectUtilCore.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        if (!(((Object[])projectArray).length == 0)) {
            this.ensureListenerAdded();
        }
        Topic<DataSourceStorage.Listener> topic3 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        appConnection.subscribe(topic3, (Object)new DbSrcChangesTrackerBase.DbSrcDataSourceListener(this));
        this.validate(null);
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    private final void launchUpdater() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DbSrcChangesTrackerApplication this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)DbSrcChangesTrackerApplication.access$getMyUpdates$p(this.this$0)), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)), (Function2)((Function2)new Function2<ModalityState, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ DbSrcChangesTrackerApplication this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ModalityState modalityState = (ModalityState)this.L$0;
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ DbSrcChangesTrackerApplication this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DbSrcChangesTrackerApplication.access$update(this.this$0);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull ModalityState p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void validate(@Nullable Project project) {
        VirtualFile root2 = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
        this.fileDirty(root2);
    }

    public final void ensureListenerAdded() {
        if (this.myAdded.get() == null) {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            if (this.myAdded.compareAndSet(null, disposable2)) {
                Disposer.register((Disposable)this, (Disposable)disposable2);
                EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, disposable2);
            }
        }
    }

    public final void ensureListenerRemoved() {
        Disposable disposable = this.myAdded.getAndSet(null);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fileDirty(VirtualFile file) {
        if (file == null || !DbSrcUtilsCore.isDbSrcFile(file)) {
            return;
        }
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.myDirtyFiles.add(file);
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        this.myUpdates.tryEmit((Object)modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update() {
        Ref.ObjectRef files2 = new Ref.ObjectRef();
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            boolean bl = false;
            files2.element = new ArrayList(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        AppJavaExecutorUtil.executeOnPooledIoThread(() -> DbSrcChangesTrackerApplication.update$lambda$2(this, files2));
    }

    /*
     * WARNING - void declaration
     */
    public void distributeUpdates(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap byProject = multiMap;
        for (VirtualFile entry : files2) {
            Ref<Project> p2 = DbSrcUtils.getProject(entry.getPath());
            if (p2 == null) continue;
            byProject.putValue(p2.get(), (Object)entry);
        }
        if (byProject.containsKey(null)) {
            void var4_6;
            this.updateFiles(byProject.get(null));
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Iterator<Object> iterator = projectArray;
            boolean bl = false;
            int p2 = ((Iterator<Object>)iterator).length;
            while (var4_6 < p2) {
                Iterator<Object> iterator2 = iterator[var4_6];
                Intrinsics.checkNotNull(iterator2);
                Collection collection2 = byProject.get(iterator2);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                DbSrcChangesTrackerApplication.Companion.updateFiles(iterator2, collection2);
                ++var4_6;
            }
        } else {
            for (Map.Entry entry : byProject.entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                Project key2 = (Project)entry.getKey();
                Collection collection3 = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)key2);
                Intrinsics.checkNotNull((Object)collection3);
                DbSrcChangesTrackerApplication.Companion.updateFiles(key2, collection3);
            }
        }
    }

    @Override
    @NotNull
    public DbSrcFileStatus getFileStatus() {
        return this.myFileStatus;
    }

    private static final void update$lambda$2(DbSrcChangesTrackerApplication this$0, Ref.ObjectRef $files) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        this$0.distributeUpdates((List)$files.element);
    }

    public static final /* synthetic */ MutableSharedFlow access$getMyUpdates$p(DbSrcChangesTrackerApplication $this) {
        return $this.myUpdates;
    }

    public static final /* synthetic */ void access$update(DbSrcChangesTrackerApplication $this) {
        $this.update();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$Companion;", "", "()V", "updateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "pFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateFiles(Project project, Collection<? extends VirtualFile> pFiles) {
            block0: {
                DbSrcChangesTrackerBase tracker;
                DbSrcChangesTrackerBase dbSrcChangesTrackerBase = tracker = (DbSrcChangesTrackerBase)ReadAction.compute(() -> Companion.updateFiles$lambda$0(project));
                if (dbSrcChangesTrackerBase == null) break block0;
                dbSrcChangesTrackerBase.updateFiles(pFiles);
            }
        }

        private static final DbSrcChangesTrackerBase updateFiles$lambda$0(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            return !$project.isDisposed() && $project.isOpen() ? DbSrcChangesTrackerBase.getInstanceBase($project) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

