/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.artifacts;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DatabaseArtifactList {
    public static final String STABLE_CHANNEL = "stable";
    private static final String SOURCE_PROP = "source";
    public static final String DRIVER_CLASS_PROP = "driver.class";
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactList.class);
    public static final DatabaseArtifactList EMPTY = new DatabaseArtifactList(false, new URL[0]);
    private static final Version IDE_VERSION = Version.of(ApplicationInfo.getInstance().getBuild().getComponents());
    private static final PathMacroManager PATH_MACRO_MANAGER = new PathMacroManager(null);
    private final Map<String, Artifact> myArtifacts;
    private final Map<String, Channel> myChannels;
    private final List<Repository> myRepositories;
    private final Channel myStableChannel;
    public static final ExtensionPointName<ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.artifactsConfig");

    public DatabaseArtifactList(boolean checkDuplicates, URL ... urls) {
        if (urls == null) {
            DatabaseArtifactList.$$$reportNull$$$0(0);
        }
        this.myArtifacts = new TreeMap<String, Artifact>();
        this.myChannels = new TreeMap<String, Channel>();
        this.myRepositories = new ArrayList<Repository>();
        this.myStableChannel = new Channel(STABLE_CHANNEL, "Latest stable", false);
        this.myChannels.put(this.myStableChannel.id, this.myStableChannel);
        for (URL url : urls) {
            this.loadList(url, checkDuplicates);
        }
    }

    @Nullable
    public Artifact getArtifact(@Nullable String id) {
        return id == null ? null : this.myArtifacts.get(id);
    }

    @Nullable
    public ArtifactVersion resolveVersion(@NotNull String artifactId, @Nullable Version version) {
        Artifact artifact;
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(1);
        }
        if ((artifact = this.getArtifact(artifactId)) == null) {
            return null;
        }
        return version == null ? null : artifact.get(version);
    }

    @Nullable
    public ArtifactVersion resolveVersion(@NotNull String artifactId, @Nullable Version version, @Nullable String channelId, @Nullable Condition<? super ArtifactVersion> filter2) {
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(2);
        }
        if (channelId != null) {
            Channel channel = this.getChannel(channelId);
            Artifact artifact = this.getArtifact(artifactId);
            return artifact == null || channel == null ? null : channel.getLatest(artifact, filter2);
        }
        return this.resolveVersion(artifactId, version);
    }

    @Nullable
    public Channel getChannel(@Nullable String id) {
        return id == null ? null : this.myChannels.get(id);
    }

    @NotNull
    public Set<Artifact> getArtifacts() {
        return new LinkedHashSet<Artifact>(this.myArtifacts.values());
    }

    @NotNull
    public List<Repository> getRepositories() {
        List<Repository> list = this.myRepositories;
        if (list == null) {
            DatabaseArtifactList.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.myChannels.values());
    }

    public void loadList(@NotNull URL url, boolean checkDuplicates) {
        if (url == null) {
            DatabaseArtifactList.$$$reportNull$$$0(4);
        }
        try (InputStream stream = url.openStream();){
            String file = PathUtil.getFileName((String)url.getPath());
            if (!file.startsWith("test-") && !file.startsWith("builtin-")) {
                file = null;
            }
            this.loadList(new XppReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new MXParser()), checkDuplicates, file);
        }
        catch (IOException e2) {
            LOG.warnInProduction((Throwable)e2);
        }
    }

    void loadList(@NotNull HierarchicalStreamReader reader, boolean checkDuplicates, @Nullable String source) throws IOException {
        if (reader == null) {
            DatabaseArtifactList.$$$reportNull$$$0(5);
        }
        if (!"artifacts".equals(reader.getNodeName())) {
            throw new IOException("Unexpected root: " + reader.getNodeName());
        }
        HashMap<String, String> properties2 = new HashMap<String, String>(0);
        properties2.put(SOURCE_PROP, source);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "repository": {
                    this.readRepository(reader);
                    break;
                }
                case "artifact": {
                    this.readArtifact(reader, checkDuplicates, properties2);
                    break;
                }
                case "channel": {
                    this.readChannel(reader, null, null);
                    break;
                }
                case "constraint": {
                    LOG.warn("skipping constraint");
                    break;
                }
                case "unsupported": {
                    this.readConstraint(reader);
                    break;
                }
                case "property": {
                    DatabaseArtifactList.readProperty(reader, properties2);
                }
            }
            reader.moveUp();
        }
    }

    private void readConstraint(@NotNull HierarchicalStreamReader reader) throws IOException {
        String id;
        if (reader == null) {
            DatabaseArtifactList.$$$reportNull$$$0(6);
        }
        if ((id = reader.getAttribute("artifact-id")) == null) {
            throw new IOException("No artifact id for constraint");
        }
        Artifact artifact = this.getArtifact(id);
        if (artifact == null) {
            throw new IOException("Unable to find artifact " + id);
        }
        DatabaseArtifactList.readConstraint(reader, artifact);
    }

    private static void readConstraint(HierarchicalStreamReader reader, @NotNull Artifact artifact) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(7);
        }
        Version from = Version.of(reader.getAttribute("from"));
        Version to = Version.of(reader.getAttribute("to"));
        DatabaseArtifactList.readConstraint(reader, artifact, from, to);
    }

    private static void readConstraint(HierarchicalStreamReader reader, @NotNull Artifact artifact, @Nullable Version from, @Nullable Version to) {
        Dbms dbms;
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(8);
        }
        String dbmsName = reader.getAttribute("dbms");
        Version dbForm = Version.of(reader.getAttribute("db-from"));
        Version dbTo = Version.of(reader.getAttribute("db-to"));
        Version ideForm = Version.of(reader.getAttribute("ide-from"));
        Version ideTo = Version.of(reader.getAttribute("ide-to"));
        Dbms dbms2 = dbms = dbmsName == null ? null : Dbms.byName(dbmsName);
        if (dbms == null && dbmsName != null) {
            return;
        }
        artifact.constraints.add(new Constraint(from, to, dbms, dbForm, dbTo, ideForm, ideTo));
    }

    private void readChannel(HierarchicalStreamReader reader, @Nullable String artifactId, @Nullable Version version) {
        String id = reader.getAttribute("id");
        Channel channel = this.myChannels.get(id);
        if (channel == null) {
            String name2 = reader.getAttribute("name");
            String implicit = reader.getAttribute("implicit");
            channel = new Channel(id, name2, "true".equals(implicit));
            this.myChannels.put(channel.id, channel);
        }
        if (artifactId == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("artifact".equals(reader.getNodeName())) {
                    artifactId = reader.getAttribute("id");
                    version = Version.parse(reader.getAttribute("version"));
                    if (artifactId != null && version != null) {
                        channel.addHead(artifactId, version);
                    }
                }
                reader.moveUp();
            }
        } else {
            String versionStr = reader.getAttribute("version");
            if (versionStr != null) {
                version = Version.parse(versionStr);
            }
            if (version != null) {
                channel.addHead(artifactId, version);
            }
        }
    }

    private void readRepository(HierarchicalStreamReader reader) throws IOException {
        String id = reader.getAttribute("id");
        if (id == null) {
            throw new IOException("No id for repository");
        }
        String url = reader.getAttribute("url");
        if (url == null) {
            throw new IOException("No url for repository");
        }
        for (Repository repository : this.myRepositories) {
            if (!repository.id.equals(id)) continue;
            if (repository.url.equals(url)) {
                return;
            }
            throw new IOException("Repository " + id + " is registered twice:\n" + repository.url + "\n" + url);
        }
        this.myRepositories.add(new Repository(id, url));
    }

    private void readArtifact(HierarchicalStreamReader reader, boolean checkDuplicates, @NotNull Map<String, String> baseProperties) throws IOException {
        Artifact artifact;
        if (baseProperties == null) {
            DatabaseArtifactList.$$$reportNull$$$0(9);
        }
        String id = reader.getAttribute("id");
        String name2 = reader.getAttribute("name");
        if (id == null) {
            id = StringUtil.trimEnd((String)name2.replaceAll("[^a-zA-Z0-9. _-]", ""), (String)" 8");
        }
        if ("Redshift 2".equals(id)) {
            id = "Redshift";
            name2 = "Redshift";
        }
        if ("PostgreSQL 2".equals(id)) {
            id = "PostgreSQL";
            name2 = "PostgreSQL";
        }
        if ((artifact = this.myArtifacts.get(id)) == null) {
            artifact = new Artifact(id, name2);
            this.checkIndexConsistency(artifact);
            this.myArtifacts.put(artifact.id, artifact);
        }
        this.myArtifacts.put(name2, artifact);
        artifact.names.add(name2);
        HashMap<String, String> properties2 = new HashMap<String, String>(artifact.properties);
        properties2.putAll(baseProperties);
        ArtifactVersion prevVersion = null;
        if (reader.getAttribute("version") == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                switch (reader.getNodeName()) {
                    case "version": {
                        prevVersion = this.readArtifactVersion(reader, artifact, checkDuplicates, properties2);
                        break;
                    }
                    case "constraint": {
                        LOG.info("skipping constraint");
                        break;
                    }
                    case "unsupported": {
                        DatabaseArtifactList.readConstraint(reader, artifact);
                        break;
                    }
                    case "channel": {
                        this.readChannel(reader, artifact.id, prevVersion == null ? null : prevVersion.version);
                        break;
                    }
                    case "property": {
                        DatabaseArtifactList.readProperty(reader, properties2);
                    }
                }
                reader.moveUp();
            }
        } else {
            this.readArtifactVersion(reader, artifact, checkDuplicates, properties2);
        }
        for (Map.Entry entry : properties2.entrySet()) {
            artifact.properties.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void checkIndexConsistency(Artifact artifact) throws IOException {
        Artifact byName2;
        Artifact byId2 = this.myArtifacts.get(artifact.id);
        if (byId2 != (byName2 = this.myArtifacts.get(artifact.name))) {
            throw new IOException("id/name inconsistency: " + (byId2 == null ? null : byId2.id + ":" + byId2.name) + "/" + (byName2 == null ? null : byName2.id + ":" + byName2.name));
        }
    }

    private ArtifactVersion readArtifactVersion(HierarchicalStreamReader reader, @NotNull Artifact artifact, boolean checkDuplicates, @NotNull Map<String, String> baseProperties) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(10);
        }
        if (baseProperties == null) {
            DatabaseArtifactList.$$$reportNull$$$0(11);
        }
        Version version = Version.of(reader.getAttribute("version"));
        ArrayList<Item> items2 = new ArrayList<Item>();
        HashMap<String, String> properties2 = new HashMap<String, String>(baseProperties);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "item": {
                    items2.add(this.readItem(reader));
                    break;
                }
                case "channel": {
                    this.readChannel(reader, artifact.id, version);
                    break;
                }
                case "constraint": {
                    LOG.info("skipping constraint");
                    break;
                }
                case "unsupported": {
                    DatabaseArtifactList.readConstraint(reader, artifact, version, version);
                    break;
                }
                case "property": {
                    DatabaseArtifactList.readProperty(reader, properties2);
                }
            }
            reader.moveUp();
        }
        ArtifactVersion prev = artifact.get(version);
        if (prev != null) {
            if (checkDuplicates) {
                LOG.error("Duplicate artifact version " + prev);
            }
            properties2.putAll(prev.properties);
            artifact.versions.remove(prev);
        }
        ArtifactVersion av = new ArtifactVersion(artifact, version, items2, properties2);
        artifact.versions.add(av);
        return av;
    }

    private static void readProperty(HierarchicalStreamReader reader, Map<String, String> properties2) {
        String name2 = reader.getAttribute("name");
        if (name2 == null) {
            return;
        }
        String value2 = reader.getAttribute("value");
        DbImplUtilCore.putOrRemove(properties2, name2, value2);
    }

    private Item readItem(HierarchicalStreamReader reader) {
        String archName;
        Item.Arch arch;
        String osName;
        Item.OS os;
        String url = reader.getAttribute("url");
        url = url.startsWith("file://") ? PATH_MACRO_MANAGER.expandPath(url) : url;
        String name2 = reader.getAttribute("name");
        if (name2 == null) {
            name2 = PathUtil.getFileName((String)url);
        }
        Item.OS oS = os = (osName = reader.getAttribute("os")) == null ? null : (Item.OS)((Object)ContainerUtil.find((Object[])Item.OS.values(), o2 -> o2.name().equalsIgnoreCase(osName)));
        if (os == null) {
            os = name2.contains("win") ? Item.OS.WIN : Item.OS.ANY;
        }
        Item.Arch arch2 = arch = (archName = reader.getAttribute("arch")) == null ? null : (Item.Arch)((Object)ContainerUtil.find((Object[])Item.Arch.values(), o2 -> o2.name().equalsIgnoreCase(archName)));
        if (arch == null) {
            arch = Item.Arch.ANY;
        }
        String typeName = reader.getAttribute("type");
        Item.Type type2 = (Item.Type)((Object)ContainerUtil.find((Object[])Item.Type.values(), o2 -> o2.name().equalsIgnoreCase(typeName)));
        if (type2 == null) {
            type2 = name2.endsWith(".txt") ? Item.Type.LICENSE : ((name2.startsWith("sqlserver") || name2.startsWith("jtds")) && name2.endsWith("win-auth.jar") ? Item.Type.NATIVE : Item.Type.JAR);
        }
        return new Item(this, name2, url, os, arch, type2);
    }

    public static boolean isCompatible(@NotNull DatabaseDriver driver2, @NotNull ArtifactVersion v2) {
        Set<DatabaseDriver.Constraint> constraints;
        if (driver2 == null) {
            DatabaseArtifactList.$$$reportNull$$$0(12);
        }
        if (v2 == null) {
            DatabaseArtifactList.$$$reportNull$$$0(13);
        }
        if ((constraints = driver2.getConstraints()).isEmpty()) {
            return v2.matches(null, null);
        }
        return ContainerUtil.find(constraints, c2 -> c2.dbms == null || v2.matches(c2.dbms, (Version)ObjectUtils.notNull((Object)c2.from, (Object)Version.ZERO), c2.to == null ? Version.INFINITY : c2.to)) != null;
    }

    @Nullable
    public static ArtifactVersion resolveVersion(@NotNull DatabaseArtifactList artifacts, @NotNull String artifactId, @Nullable Version version, @Nullable String channelId, @NotNull DatabaseDriver driver2) {
        if (artifacts == null) {
            DatabaseArtifactList.$$$reportNull$$$0(14);
        }
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(15);
        }
        if (driver2 == null) {
            DatabaseArtifactList.$$$reportNull$$$0(16);
        }
        return artifacts.resolveVersion(artifactId, version, channelId, (Condition<? super ArtifactVersion>)((Condition)v2 -> DatabaseArtifactList.isCompatible(driver2, v2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProperties";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveVersion";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadList";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readConstraint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readArtifact";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readArtifactVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Channel
    implements VersionRef {
        public final String id;
        @NlsSafe
        public final String name;
        public final boolean implicit;
        public final Map<String, Version> heads;

        public Channel(@NotNull String id, @NotNull String name2, boolean implicit) {
            if (id == null) {
                Channel.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Channel.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.name = name2;
            this.implicit = implicit;
            this.heads = new LinkedHashMap<String, Version>();
        }

        private void addHead(@NotNull String artifactId, @NotNull Version version) {
            Version prev;
            if (artifactId == null) {
                Channel.$$$reportNull$$$0(2);
            }
            if (version == null) {
                Channel.$$$reportNull$$$0(3);
            }
            if ((prev = this.heads.get(artifactId)) == null || prev.less(version)) {
                this.heads.put(artifactId, version);
            }
        }

        public boolean contains(@NotNull ArtifactVersion version) {
            if (version == null) {
                Channel.$$$reportNull$$$0(4);
            }
            Version head = this.getHead(version.artifact.id);
            return head.isOrGreater(version.version);
        }

        public boolean isEnabledFor(@NotNull Artifact artifact) {
            if (artifact == null) {
                Channel.$$$reportNull$$$0(5);
            }
            return !this.implicit || this.heads.containsKey(artifact.id);
        }

        private Version getHead(String artifactId) {
            return this.heads.getOrDefault(artifactId, this.implicit ? null : Version.INFINITY);
        }

        @Nullable
        public ArtifactVersion getLatest(@NotNull Artifact artifact, @Nullable Condition<? super ArtifactVersion> filter2) {
            Version head;
            if (artifact == null) {
                Channel.$$$reportNull$$$0(6);
            }
            return (head = this.getHead(artifact.id)) == null ? null : (ArtifactVersion)ContainerUtil.find(artifact.versions, v2 -> head.isOrGreater(v2.version) && (filter2 == null || filter2.value(v2)));
        }

        @Override
        public String getVersionDisplayName() {
            return this.name;
        }

        public String toString() {
            return "Channel: " + this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$Channel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addHead";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLatest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Artifact {
        @NonNls
        public final String id;
        @NlsSafe
        public final String name;
        public final SortedSet<ArtifactVersion> versions;
        public final List<Constraint> constraints;
        public final Map<String, String> properties;
        final Set<String> names;

        public Artifact(@NotNull String id, @NotNull String name2) {
            if (id == null) {
                Artifact.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Artifact.$$$reportNull$$$0(1);
            }
            this.properties = new HashMap<String, String>(0);
            this.names = new HashSet<String>();
            this.id = id;
            this.name = name2;
            this.versions = new TreeSet<ArtifactVersion>();
            this.constraints = new ArrayList<Constraint>();
            this.names.add(id);
            this.names.add(name2);
        }

        @Nullable
        public ArtifactVersion get(@NotNull Version version) {
            if (version == null) {
                Artifact.$$$reportNull$$$0(2);
            }
            return (ArtifactVersion)ContainerUtil.find(this.versions, v2 -> v2.version.equals(version));
        }

        public String toString() {
            return this.name;
        }

        public boolean isId(String id) {
            return this.names.contains(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$Artifact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ArtifactVersion
    implements Comparable<ArtifactVersion>,
    VersionRef {
        public final Artifact artifact;
        public final Version version;
        public final List<Item> items;
        public final Map<String, String> properties;

        public ArtifactVersion(@NotNull Artifact artifact, @NotNull Version version, @NotNull List<Item> items2, @NotNull Map<String, String> properties2) {
            if (artifact == null) {
                ArtifactVersion.$$$reportNull$$$0(0);
            }
            if (version == null) {
                ArtifactVersion.$$$reportNull$$$0(1);
            }
            if (items2 == null) {
                ArtifactVersion.$$$reportNull$$$0(2);
            }
            if (properties2 == null) {
                ArtifactVersion.$$$reportNull$$$0(3);
            }
            this.artifact = artifact;
            this.version = version;
            this.items = items2;
            this.properties = properties2;
        }

        @Override
        public int compareTo(@NotNull ArtifactVersion o2) {
            if (o2 == null) {
                ArtifactVersion.$$$reportNull$$$0(4);
            }
            return o2.version.compareTo(this.version);
        }

        public boolean matches(@Nullable Dbms dbms, @Nullable Version version) {
            return this.matches(dbms, version, version);
        }

        public boolean matches(@Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            for (Constraint constraint : this.artifact.constraints) {
                if (constraint.passes(this.version, dbms, dbFrom, dbTo, true)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NlsSafe
        public String getVersionDisplayName() {
            String verS = this.version.toString();
            String source = this.getProperty(DatabaseArtifactList.SOURCE_PROP);
            return source == null ? verS : verS + " (" + source + ")";
        }

        @Nullable
        public String getProperty(@NotNull String prop) {
            if (prop == null) {
                ArtifactVersion.$$$reportNull$$$0(5);
            }
            return this.properties.get(prop);
        }

        public String toString() {
            return this.artifact.name + ":" + this.version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prop";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Constraint {
        @Nullable
        public final Version from;
        @Nullable
        public final Version to;
        @Nullable
        public final Dbms dbms;
        @Nullable
        public final Version dbFrom;
        @Nullable
        public final Version dbTo;
        @Nullable
        public final Version ideFrom;
        @Nullable
        public final Version ideTo;

        public Constraint(@Nullable Version from, @Nullable Version to, @Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo, @Nullable Version ideFrom, @Nullable Version ideTo) {
            this.from = from;
            this.to = to;
            this.dbms = dbms;
            this.dbFrom = dbFrom;
            this.dbTo = dbTo;
            this.ideFrom = ideFrom;
            this.ideTo = ideTo;
        }

        public boolean passes(@Nullable Version ver, @Nullable Dbms dbms, @Nullable Version dbVer, boolean matchIde) {
            return this.passes(ver, dbms, dbVer, dbVer, matchIde);
        }

        public boolean passes(@Nullable Version ver, @Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo, boolean matchIde) {
            if (!this.matches(ver, dbms, matchIde)) {
                return true;
            }
            if (dbFrom == null && dbTo == null) {
                return true;
            }
            return !this.checkDbVersion(dbFrom, dbTo);
        }

        private boolean checkDbVersion(@Nullable Version dbFrom, @Nullable Version dbTo) {
            if (Objects.equals(dbFrom, dbTo)) {
                if (dbFrom != null && this.dbFrom != null && dbFrom.less(this.dbFrom)) {
                    return false;
                }
                if (dbFrom != null && this.dbTo != null && dbFrom.isOrGreater(this.dbTo)) {
                    return false;
                }
            } else {
                if (dbFrom != null && this.dbFrom != null && dbFrom.less(this.dbFrom)) {
                    return false;
                }
                if (dbTo != null && this.dbTo != null && dbTo.compareTo(this.dbTo) > 0) {
                    return false;
                }
            }
            return true;
        }

        public boolean matches(@Nullable Version ver, @Nullable Dbms dbms, boolean matchIde) {
            if (matchIde && this.ideFrom != null && IDE_VERSION.less(this.ideFrom)) {
                return false;
            }
            if (matchIde && this.ideTo != null && IDE_VERSION.isOrGreater(this.ideTo)) {
                return false;
            }
            if (Objects.equals(this.from, this.to)) {
                if (ver != null && this.from != null && !ver.equals(this.from)) {
                    return false;
                }
            } else {
                if (ver != null && this.from != null && ver.less(this.from)) {
                    return false;
                }
                if (ver != null && this.to != null && ver.isOrGreater(this.to)) {
                    return false;
                }
            }
            return dbms == null || this.dbms == null || this.dbms == dbms;
        }
    }

    public static final class Repository {
        @NonNls
        public final String id;
        @NonNls
        public final String url;

        public Repository(@NotNull String id, @NotNull String url) {
            if (id == null) {
                Repository.$$$reportNull$$$0(0);
            }
            if (url == null) {
                Repository.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.url = url;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Repository)) {
                return false;
            }
            Repository that = (Repository)o2;
            return this.id.equals(that.id) && this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$Repository";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Item {
        public final DatabaseArtifactList list;
        public final String name;
        public final String url;
        public final OS os;
        public final Arch arch;
        public final Type type;
        public volatile Pair<List<File>, Boolean> classpath;

        public Item(@NotNull DatabaseArtifactList list, @NotNull String name2, @NotNull String url, @NotNull OS os, @NotNull Arch arch, @NotNull Type type2) {
            if (list == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Item.$$$reportNull$$$0(1);
            }
            if (url == null) {
                Item.$$$reportNull$$$0(2);
            }
            if (os == null) {
                Item.$$$reportNull$$$0(3);
            }
            if (arch == null) {
                Item.$$$reportNull$$$0(4);
            }
            if (type2 == null) {
                Item.$$$reportNull$$$0(5);
            }
            this.list = list;
            this.name = name2;
            this.url = url;
            this.os = os;
            this.type = type2;
            this.arch = arch;
        }

        public String toString() {
            return this.name;
        }

        public boolean isLocal() {
            return this.url.startsWith("file://");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "os";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "arch";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum OS {
            ANY(true),
            LINUX(SystemInfo.isLinux),
            MAC(SystemInfo.isMac),
            WIN(SystemInfo.isWindows);

            public final boolean applicable;

            private OS(boolean applicable) {
                this.applicable = applicable;
            }
        }

        public static enum Type {
            JAR,
            PACK,
            NATIVE,
            LICENSE,
            MAVEN,
            NONE;

        }

        public static enum Arch {
            ANY,
            X86,
            X86_64,
            ARM64;


            public boolean matches(@NotNull Arch arch) {
                if (arch == null) {
                    Arch.$$$reportNull$$$0(0);
                }
                return arch == this || this == ANY || arch == ANY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arch", "com/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch", "matches"));
            }
        }
    }

    public static interface VersionRef {
        @Nls
        public String getVersionDisplayName();
    }
}

