/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DesktopUserNotifier;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier;", "Lcom/intellij/database/introspection/DBIntrospectionContext$UserNotifier;", "project", "Lcom/intellij/openapi/project/Project;", "dsName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getDsName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "makeLevelList", "Lorg/jetbrains/annotations/Nls;", "level", "Lcom/intellij/database/model/properties/Level;", "schemas", "", "Lcom/intellij/database/model/basic/BasicSchema;", "notifyDiagnosticMonitorFile", "", "eventType", "Lcom/intellij/database/introspection/DBIntrospectionContext$DiagnosticNotificationEventType;", "filePath", "Ljava/nio/file/Path;", "notifyLevelAutoSelection", "Lcom/intellij/database/model/basic/BasicMultiLevelSchema;", "Companion", "DiagnosticFileRevealAction", "LevelsHelpAction", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDesktopUserNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUserNotifier.kt\ncom/intellij/database/dataSource/DesktopUserNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n766#2:108\n857#2,2:109\n766#2:111\n857#2,2:112\n766#2:114\n857#2,2:115\n*S KotlinDebug\n*F\n+ 1 DesktopUserNotifier.kt\ncom/intellij/database/dataSource/DesktopUserNotifier\n*L\n42#1:108\n42#1:109,2\n43#1:111\n43#1:112,2\n44#1:114\n44#1:115,2\n*E\n"})
public final class DesktopUserNotifier
implements DBIntrospectionContext.UserNotifier {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String dsName;
    @NotNull
    private static final String helpId = "oracle.introspection.levels";

    public DesktopUserNotifier(@NotNull Project project, @NotNull String dsName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dsName, (String)"dsName");
        this.project = project;
        this.dsName = dsName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getDsName() {
        return this.dsName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notifyLevelAutoSelection(@NotNull Collection<? extends BasicMultiLevelSchema> schemas2) {
        Object object;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        Iterable $this$filter$iv = schemas2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            BasicMultiLevelSchema it2 = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it2.getAutoIntrospectionLevel() == Level.L3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List schemas3 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = schemas2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            BasicMultiLevelSchema it3 = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it3.getAutoIntrospectionLevel() == Level.L2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List schemas22 = (List)destination$iv$iv2;
        Iterable $this$filter$iv3 = schemas2;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicMultiLevelSchema it4 = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it4.getAutoIntrospectionLevel() == Level.L1)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List schemas1 = (List)destination$iv$iv3;
        Object object2 = new Object[]{this.dsName};
        String string = DatabaseBundle.message("introspection.level.autoSelect.notification.title", (Object[])object2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Object $this$notifyLevelAutoSelection_u24lambda_u243 = object2 = new StringBuilder();
        boolean bl = false;
        if (IntrospectionTaskHelperFun.isNotEmpty(schemas3)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L3, schemas3));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            object = stringBuilder;
            StringBuilder stringBuilder2 = ((StringBuilder)object).append("<br/>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        if (IntrospectionTaskHelperFun.isNotEmpty(schemas22)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L2, schemas22));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            object = stringBuilder;
            StringBuilder stringBuilder3 = ((StringBuilder)object).append("<br/>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        if (IntrospectionTaskHelperFun.isNotEmpty(schemas1)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L1, schemas1));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            object = stringBuilder;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append("<br/>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append("<p>").append(DatabaseBundle.message("introspection.level.autoSelect.notification.footer", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        object = stringBuilder;
        StringBuilder stringBuilder5 = ((StringBuilder)object).append("</p>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        String string2 = ((StringBuilder)object2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String text2 = string2;
        ApplicationManager.getApplication().invokeLater(() -> DesktopUserNotifier.notifyLevelAutoSelection$lambda$4(title, text2, this));
    }

    private final String makeLevelList(Level level, Collection<? extends BasicSchema> schemas2) {
        int n = schemas2.size();
        Object list = null;
        if (n <= 6) {
            list = CollectionsKt.joinToString$default((Iterable)schemas2, null, null, null, (int)0, null, (Function1)makeLevelList.1.INSTANCE, (int)31, null);
        } else {
            String listPart12 = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)schemas2), (int)5), null, null, null, (int)0, null, (Function1)makeLevelList.listPart1.1.INSTANCE, (int)31, null);
            Object[] objectArray = new Object[]{n - 5};
            String string = DatabaseBundle.message("introspection.level.autoSelect.notification.level.andMore", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String listPart2 = string;
            list = listPart12 + ", " + listPart2;
        }
        Object[] objectArray = new Object[]{level.level, list};
        String string = DatabaseBundle.message("introspection.level.autoSelect.notification.level.list", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public void notifyDiagnosticMonitorFile(@NotNull DBIntrospectionContext.DiagnosticNotificationEventType eventType, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String title = null;
        String text2 = null;
        String filePathStr = ((Object)filePath.toAbsolutePath()).toString();
        switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
            case 1: {
                String string = DatabaseBundle.message("introspector.diagnostic.notification.start.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                title = string;
                Object[] objectArray = new Object[]{filePathStr};
                String string2 = DatabaseBundle.message("introspector.diagnostic.notification.start.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                text2 = string2;
                break;
            }
            case 2: {
                String string = DatabaseBundle.message("introspector.diagnostic.notification.stop.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                title = string;
                Object[] objectArray = new Object[]{filePathStr};
                String string3 = DatabaseBundle.message("introspector.diagnostic.notification.stop.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                text2 = string3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> DesktopUserNotifier.notifyDiagnosticMonitorFile$lambda$5(title, text2, filePath, this));
    }

    private static final void notifyLevelAutoSelection$lambda$4(String $title, String $text, DesktopUserNotifier this$0) {
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        NotificationGroupManager.getInstance().getNotificationGroup("Introspection Level Auto-selection").createNotification($title, $text, NotificationType.INFORMATION).addAction((AnAction)LevelsHelpAction.INSTANCE).notify(this$0.project);
    }

    private static final void notifyDiagnosticMonitorFile$lambda$5(String $title, String $text, Path $filePath, DesktopUserNotifier this$0) {
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        NotificationGroupManager.getInstance().getNotificationGroup("Introspection Diagnostic").createNotification($title, $text, NotificationType.INFORMATION).addAction((AnAction)new DiagnosticFileRevealAction($filePath)).notify(this$0.project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$Companion;", "", "()V", "helpId", "", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$DiagnosticFileRevealAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "filePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static final class DiagnosticFileRevealAction
    extends DumbAwareAction {
        @NotNull
        private final Path filePath;

        public DiagnosticFileRevealAction(@NotNull Path filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            super(DatabaseBundle.messagePointer("introspector.diagnostic.notification.action.text", new Object[0]));
            this.filePath = filePath;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            RevealFileAction.openFile((Path)this.filePath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$LevelsHelpAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static final class LevelsHelpAction
    extends DumbAwareAction {
        @NotNull
        public static final LevelsHelpAction INSTANCE = new LevelsHelpAction();

        private LevelsHelpAction() {
            super(DatabaseBundle.messagePointer("introspection.level.autoSelect.notification.help.action.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            HelpManager.getInstance().invokeHelp(DesktopUserNotifier.helpId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DBIntrospectionContext.DiagnosticNotificationEventType.values().length];
            try {
                nArray[DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STOPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

