/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u001a\n\u0010 \u001a\u00020!*\u00020\u0010\u001a\u0012\u0010\"\u001a\u00020\f*\u00020\u00052\u0006\u0010#\u001a\u00020$\u001a\f\u0010\"\u001a\u00020\f*\u00020%H\u0007\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0005*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\"\u0017\u0010\u0018\u001a\u0004\u0018\u00010\b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"basicModel", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/DasDataSource;", "getBasicModel", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/RawDataSource;", "(Lcom/intellij/database/model/RawDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "basicModelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getBasicModelRoot", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/basic/BasicRoot;", "isJdbcLogEnabled", "", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)Z", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getLocalDataSource", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/dataSource/LocalDataSource;", "rawDataSource", "getRawDataSource", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/psi/DbDataSource;", "(Lcom/intellij/database/psi/DbDataSource;)Lcom/intellij/database/model/RawDataSource;", "realModelRoot", "getRealModelRoot", "(Lcom/intellij/database/model/RawDataSource;)Lcom/intellij/database/model/basic/BasicRoot;", "preparePathBasedIntrospectionTask", "Lcom/intellij/database/introspection/IntrospectionTask;", "connectionPoint", "objectPath", "Lcom/intellij/database/util/ObjectPath;", "getIntrospectionOptions", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "isLoading", "inProject", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/view/DataSourceNode;", "intellij.database.core.impl"})
@JvmName(name="DataSourceFun")
@SourceDebugExtension(value={"SMAP\nDataSourceFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceFun.kt\ncom/intellij/database/dataSource/DataSourceFun\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class DataSourceFun {
    @Nullable
    public static final RawDataSource getRawDataSource(@NotNull DasDataSource $this$rawDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$rawDataSource, (String)"<this>");
        DasDataSource dasDataSource = $this$rawDataSource;
        return dasDataSource instanceof RawDataSource ? (RawDataSource)$this$rawDataSource : (dasDataSource instanceof DbDataSource ? DataSourceFun.getRawDataSource((DbDataSource)$this$rawDataSource) : null);
    }

    @Nullable
    public static final RawDataSource getRawDataSource(@NotNull DbDataSource $this$rawDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$rawDataSource, (String)"<this>");
        return $this$rawDataSource.getDelegate();
    }

    @Nullable
    public static final BasicModel getBasicModel(@NotNull DasDataSource $this$basicModel) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModel, (String)"<this>");
        RawDataSource rawDataSource = DataSourceFun.getRawDataSource($this$basicModel);
        return rawDataSource != null ? DataSourceFun.getBasicModel(rawDataSource) : null;
    }

    @Nullable
    public static final BasicModel getBasicModel(@NotNull RawDataSource $this$basicModel) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModel, (String)"<this>");
        DasModel dasModel = $this$basicModel.getModel();
        return dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
    }

    @Nullable
    public static final BasicRoot getBasicModelRoot(@NotNull DasDataSource $this$basicModelRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModelRoot, (String)"<this>");
        BasicModel basicModel = DataSourceFun.getBasicModel($this$basicModelRoot);
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public static final BasicRoot getRealModelRoot(@NotNull RawDataSource $this$realModelRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$realModelRoot, (String)"<this>");
        BasicModel basicModel = DataSourceFun.getBasicModel($this$realModelRoot);
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public static final LocalDataSource getLocalDataSource(@NotNull DasDataSource $this$localDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$localDataSource, (String)"<this>");
        RawDataSource rawDataSource = DataSourceFun.getRawDataSource($this$localDataSource);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    public static final boolean isLoading(@NotNull RawDataSource $this$isLoading, @NotNull Project inProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isLoading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inProject, (String)"inProject");
        DataSourceManager<RawDataSource> dataSourceManager = DataSourceManager.byDataSource(inProject, $this$isLoading);
        if (dataSourceManager == null) {
            return false;
        }
        DataSourceManager<RawDataSource> manager = dataSourceManager;
        return manager.isLoading($this$isLoading);
    }

    @ApiStatus.Experimental
    public static final boolean isLoading(@NotNull DataSourceNode $this$isLoading) {
        Intrinsics.checkNotNullParameter((Object)$this$isLoading, (String)"<this>");
        return DataSourceFun.isLoading($this$isLoading.rawDataSource, $this$isLoading.getProject());
    }

    @NotNull
    public static final DBIntrospectionOptions getIntrospectionOptions(@NotNull LocalDataSource $this$getIntrospectionOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$getIntrospectionOptions, (String)"<this>");
        DBIntrospectionOptions.SourceLoading sourceLoading = $this$getIntrospectionOptions.getSourceLoading();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceLoading), (String)"getSourceLoading(...)");
        DBIntrospectionOptions.SourceLoading withSources = sourceLoading;
        TreePattern treePattern = $this$getIntrospectionOptions.getIntrospectionScope();
        Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
        return new DBIntrospectionOptions(withSources, treePattern);
    }

    @ApiStatus.Internal
    @NotNull
    public static final IntrospectionTask preparePathBasedIntrospectionTask(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath objectPath) {
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        ObjectPath path = objectPath;
        IntrospectionTask task = null;
        if (JdbcUrlParserUtil.isDatabaseBounded(connectionPoint)) {
            ObjectPath objectPath2 = path = JdbcUrlParserUtil.toBound(connectionPoint, path);
            task = objectPath2 != null ? IntrospectionTasks.prepareOneElementRefreshTask(objectPath2) : (IntrospectionTask)IntrospectionTasks.prepareCurrentDatabaseTask();
        } else {
            task = IntrospectionTasks.prepareGeneralTask();
        }
        return task;
    }

    public static final boolean isJdbcLogEnabled(@NotNull DatabaseConnectionPoint $this$isJdbcLogEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isJdbcLogEnabled, (String)"<this>");
        String string = $this$isJdbcLogEnabled.getAdditionalProperty("JdbcLog.Enabled");
        if (string != null) {
            String it2 = string;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it2, (Object)"true");
        } else {
            bl = false;
        }
        return bl;
    }
}

