/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.execution.runners.ExecutionUtil;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"connectedIcon", "Ljavax/swing/Icon;", "icon", "getIcon", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "connected", "", "intellij.database.connectivity"})
@JvmName(name="SessionsUiUtil")
public final class SessionsUiUtil {
    @NotNull
    private static final Icon icon;
    @NotNull
    private static final Icon connectedIcon;

    @NotNull
    public static final Icon getIcon(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return SessionsUtil.needToShowProgress(session2) ? SessionsUtil.getProgressIcon(session2.isCancelled()) : SessionsUiUtil.getIcon(session2.isConnected());
    }

    @NotNull
    public static final Icon getIcon(boolean connected) {
        return connected ? connectedIcon : icon;
    }

    static {
        Icon icon = DatabaseIcons.Connector;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Connector");
        SessionsUiUtil.icon = icon;
        Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)SessionsUiUtil.icon);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getLiveIndicator(...)");
        connectedIcon = icon2;
    }
}

