/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationSettingsEditor;
import com.intellij.database.console.runConfiguration.FileAnalysisResult;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTree;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTreeKt;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.list.ListCellBackgroundSupplier;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006LMNOPQB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0002J\b\u0010+\u001a\u00020(H\u0002JB\u0010+\u001a$\u0012\u0004\u0012\u00020,\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-0\f0\u0014j\u0002`/2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J@\u0010+\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u001e\u00104\u001a\u001a\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0004\u0012\u00020(05H\u0002J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0002H\u0014J \u00108\u001a\u00020(2\u0016\u00109\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\b\u0010:\u001a\u00020;H\u0014J\b\u0010<\u001a\u00020(H\u0014J\b\u0010=\u001a\u00020>H\u0002J\u0013\u0010?\u001a\r\u0012\t\u0012\u00070>\u00a2\u0006\u0002\b\u00130@H\u0002J\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020(H\u0002J\u0010\u0010D\u001a\u00020(2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020(H\u0002J\u0010\u0010H\u001a\u00020(2\u0006\u00107\u001a\u00020\u0002H\u0014J\u0010\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020BH\u0002J\b\u0010K\u001a\u00020(H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u000f\u001aJ\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011*#\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u00120\u0014\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "LRU_KEY", "", "analysisFuture", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "Ljava/util/concurrent/Future;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "analysisResult", "", "kotlin.jvm.PlatformType", "Lcom/intellij/database/console/runConfiguration/FileAnalysisResult;", "Lorg/jetbrains/annotations/NotNull;", "", "disposed", "", "filesModel", "Lcom/intellij/util/ui/ListTableModel;", "filesPanel", "Ljavax/swing/JPanel;", "filesRadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "mainPanel", "getProject", "()Lcom/intellij/openapi/project/Project;", "targetsModel", "Lcom/intellij/ui/CollectionListModel;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetItem;", "textField", "Lcom/intellij/ui/EditorTextField;", "textPanel", "textRadioButton", "addTargets", "", "items", "", "analyse", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "Lcom/intellij/openapi/util/Ref;", "", "Lcom/intellij/database/console/runConfiguration/FileSyntaxAnalysisResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "language", "Lcom/intellij/lang/Language;", "consumer", "Lkotlin/Function2;", "applyEditorTo", "s", "cancel", "task", "createEditor", "Ljavax/swing/JComponent;", "disposeEditor", "getDbms", "Lcom/intellij/database/Dbms;", "getFilterDbms", "", "getSelectedMode", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Mode;", "performAnalysis", "prepareAddTargetAction", "a", "Lcom/intellij/ui/AnActionButton;", "repaintTable", "resetEditorFrom", "selectMode", "newType", "updateLanguage", "ActivePanel", "FileRenderer", "ProblemType", "StatusRenderer", "TargetItem", "TargetRenderer", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfigurationSettingsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfigurationSettingsEditor.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,659:1\n1549#2:660\n1620#2,3:661\n1549#2:664\n1620#2,2:665\n1622#2:668\n1620#2,3:669\n1611#2:672\n1855#2:673\n1856#2:675\n1612#2:676\n1726#2,3:677\n1855#2,2:683\n1#3:667\n1#3:674\n14#4:680\n22#5,2:681\n26#5,2:685\n26#6:687\n13309#7,2:688\n*S KotlinDebug\n*F\n+ 1 DatabaseScriptRunConfigurationSettingsEditor.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor\n*L\n298#1:660\n298#1:661,3\n339#1:664\n339#1:665,2\n339#1:668\n356#1:669,3\n404#1:672\n404#1:673\n404#1:675\n404#1:676\n407#1:677,3\n502#1:683,2\n404#1:674\n499#1:680\n501#1:681,2\n501#1:685,2\n168#1:687\n169#1:688,2\n*E\n"})
public final class DatabaseScriptRunConfigurationSettingsEditor
extends SettingsEditor<DatabaseScriptRunConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel mainPanel;
    private volatile boolean disposed;
    private JBRadioButton textRadioButton;
    private JBRadioButton filesRadioButton;
    @NotNull
    private final JPanel textPanel;
    @NotNull
    private final EditorTextField textField;
    @NotNull
    private final JPanel filesPanel;
    @NotNull
    private final ListTableModel<String> filesModel;
    @NotNull
    private final CollectionListModel<TargetItem> targetsModel;
    @NotNull
    private final Map<String, FileAnalysisResult> analysisResult;
    @NotNull
    private final AtomicReference<Pair<Future<?>, ProgressIndicator>> analysisFuture;
    @NotNull
    private final String LRU_KEY;

    public DatabaseScriptRunConfigurationSettingsEditor(@NotNull Project project, @NotNull Function0<DatabaseScriptRunConfiguration> factory) {
        ToolbarDecorator toolbarDecorator;
        CollectionListModel<TargetItem> $this$_init__u24lambda_u249;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        super(() -> DatabaseScriptRunConfigurationSettingsEditor._init_$lambda$0(factory));
        this.project = project;
        Object object = new ColumnInfo[]{new ColumnInfo<String, String>(this){
            @NotNull
            private final FileRenderer rr;
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super("");
                this.rr = new FileRenderer($receiver.getProject());
            }

            @NotNull
            public String valueOf(@NotNull String item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item;
            }

            @NotNull
            public TableCellRenderer getRenderer(@Nullable String o2) {
                return (TableCellRenderer)((Object)this.rr);
            }

            public boolean isCellEditable(@Nullable String item) {
                return true;
            }

            @NotNull
            public TableCellEditor getEditor(@Nullable String item) {
                return (TableCellEditor)new LocalPathCellEditor(this.this$0.getProject());
            }
        }, new ColumnInfo<String, FileAnalysisResult>(this){
            @NotNull
            private final StatusRenderer rr;
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super("");
                this.rr = $receiver.new StatusRenderer();
            }

            @NotNull
            public FileAnalysisResult valueOf(@NotNull String item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                V v2 = DatabaseScriptRunConfigurationSettingsEditor.access$getAnalysisResult$p(this.this$0).get(item);
                Intrinsics.checkNotNull(v2);
                return (FileAnalysisResult)v2;
            }

            @NotNull
            public TableCellRenderer getRenderer(@Nullable String o2) {
                return (TableCellRenderer)((Object)this.rr);
            }
        }};
        this.filesModel = new ListTableModel(object);
        this.targetsModel = new CollectionListModel((Object[])new TargetItem[0]);
        Map map2 = FactoryMap.create(arg_0 -> DatabaseScriptRunConfigurationSettingsEditor.analysisResult$lambda$1(analysisResult.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.analysisResult = map2;
        this.analysisFuture = new AtomicReference();
        this.LRU_KEY = "RunConfigurationTargetLRU";
        EditorTextField editorTextField2 = DatabaseDialogsHelper.createLanguageEditorArea(this.project, Dbms.UNKNOWN, null, null, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"createLanguageEditorArea(...)");
        this.textField = editorTextField2;
        this.textField.setPlaceholder((CharSequence)DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Text.emptyText", new Object[0]));
        this.textField.addSettingsProvider(DatabaseScriptRunConfigurationSettingsEditor::_init_$lambda$3);
        object = new CardLayout();
        this.textPanel = new ActivePanel(this, (CardLayout)object){
            {
                this.add((Component)$receiver.textField);
                this.setVisible(false);
            }
        };
        this.textField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                (textPanel).fire(new ChangeEvent(textField));
            }
        });
        TableView filesList = new TableView(this.filesModel);
        filesList.getEmptyText().setText(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Files.emptyText", new Object[0]));
        filesList.setVisibleRowCount(5);
        filesList.setTableHeader(null);
        filesList.setShowGrid(false);
        filesList.getColumnModel().getColumn(1).setMaxWidth(AllIcons.General.Error.getIconWidth() * 3 / 2);
        ClientProperty.put((JComponent)((JComponent)filesList), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ToolbarDecorator toolbarDecorator2 = ToolbarDecorator.createDecorator((JTable)((JTable)filesList));
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator2, (String)"createDecorator(...)");
        ToolbarDecorator filesDecorator = toolbarDecorator2;
        filesDecorator.setAddAction(arg_0 -> DatabaseScriptRunConfigurationSettingsEditor._init_$lambda$8(this, filesList, arg_0));
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        DatabaseScriptRunConfigurationSettingsEditor databaseScriptRunConfigurationSettingsEditor = this;
        boolean bl = false;
        $this$_init__u24lambda_u249.add((Component)filesDecorator.createPanel(), (Object)"CENTER");
        $this$_init__u24lambda_u249.setVisible(false);
        databaseScriptRunConfigurationSettingsEditor.filesPanel = jPanel;
        this.filesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(@Nullable TableModelEvent e2) {
                this.analyse();
            }
        });
        this.targetsModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(@Nullable ListDataEvent e2) {
                this.updateLanguage();
                this.analyse();
            }

            @Override
            public void intervalRemoved(@Nullable ListDataEvent e2) {
                this.updateLanguage();
                this.analyse();
            }

            @Override
            public void intervalAdded(@Nullable ListDataEvent e2) {
                this.updateLanguage();
                this.analyse();
            }
        });
        $this$_init__u24lambda_u249 = this.targetsModel;
        ListCellBackgroundSupplier<TargetItem> targetsList2 = new ListCellBackgroundSupplier<TargetItem>(this, $this$_init__u24lambda_u249){
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super((ListModel)$super_call_param$1);
            }

            @Nullable
            public Color getCellBackground(@Nullable TargetItem value2, int row) {
                TargetItem targetItem = value2;
                return DatabaseColorManager.getColor(this.this$0.getProject(), targetItem != null ? targetItem.getDs() : null);
            }
        };
        targetsList2.setVisibleRowCount(3);
        targetsList2.getEmptyText().setText(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Targets.emptyText", new Object[0]));
        targetsList2.setCellRenderer((ListCellRenderer)((Object)new TargetRenderer()));
        ToolbarDecorator $this$_init__u24lambda_u2410 = toolbarDecorator = ToolbarDecorator.createDecorator((JList)((JList)targetsList2));
        boolean bl2 = false;
        $this$_init__u24lambda_u2410.setAddAction(this::prepareAddTargetAction);
        String string = DatabaseBundle.message("DatabaseScriptRunConfigurationSetingsEditor.button.recent", new Object[0]);
        Icon icon = AllIcons.Vcs.History;
        $this$_init__u24lambda_u2410.addExtraAction((AnAction)new DumbAwareAction(this, string, icon){
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                Presentation presentation = e2.getPresentation();
                List<String> list = DatabaseViewActions.getLRUNames(this.this$0.getProject(), DatabaseScriptRunConfigurationSettingsEditor.access$getLRU_KEY$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getLRUNames(...)");
                presentation.setEnabled(!((Collection)list).isEmpty());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                List<String> list = DatabaseViewActions.getLRUNames(this.this$0.getProject(), DatabaseScriptRunConfigurationSettingsEditor.access$getLRU_KEY$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getLRUNames(...)");
                List<String> names2 = list;
                DataSourceStorage storage = DataSourceStorage.getProjectStorage(this.this$0.getProject());
                List items2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)names2), (Function1)((Function1)new Function1<String, TargetItem>(storage){
                    final /* synthetic */ DataSourceStorage $storage;
                    {
                        this.$storage = $storage;
                        super(1);
                    }

                    @NotNull
                    public final TargetItem invoke(String it2) {
                        DatabaseScriptRunConfigurationOptions.Target target2;
                        Intrinsics.checkNotNull((Object)it2);
                        int idx = StringsKt.indexOf$default((CharSequence)it2, (char)'/', (int)0, (boolean)false, (int)6, null);
                        DataSourceStorage dataSourceStorage = this.$storage;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)dataSourceStorage), (String)"$storage");
                        if (idx == -1) {
                            target2 = new DatabaseScriptRunConfigurationOptions.Target(it2, null);
                        } else {
                            String string = it2.substring(0, idx);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            String string2 = it2.substring(idx + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            target2 = new DatabaseScriptRunConfigurationOptions.Target(string, string2);
                        }
                        return new TargetItem(dataSourceStorage, target2);
                    }
                })), (Function1)targetsDecorator.1.actionPerformed.items.2.INSTANCE));
                String string = this.getTemplateText();
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<TargetItem>((List<TargetItem>)items2, this.this$0, string){
                    final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, $items);
                    }

                    @Nullable
                    public Icon getIconFor(@Nullable TargetItem value2) {
                        Object object = value2;
                        return object != null && (object = ((TargetItem)object).getDs()) != null ? ((LocalDataSource)object).getIcon() : null;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public String getTextFor(@Nullable TargetItem value2) {
                        Object object;
                        String string;
                        block3: {
                            block2: {
                                void it2;
                                Object object2 = value2;
                                string = object2 != null && (object2 = ((TargetItem)object2).getDs()) != null ? ((AbstractDataSource)object2).getName() : null;
                                object = value2;
                                if (object == null || (object = ((TargetItem)object).getPath()) == null) break block2;
                                Object object3 = object;
                                String string2 = string;
                                boolean bl = false;
                                String string3 = " / " + it2.getDisplayName();
                                string = string2;
                                object = string3;
                                if (string3 != null) break block3;
                            }
                            object = "";
                        }
                        return string + (String)object;
                    }

                    @Nullable
                    public PopupStep<?> onChosen(@Nullable TargetItem selectedValue, boolean finalChoice) {
                        return this.doFinalStep(() -> targetsDecorator.1.actionPerformed.popup.1.onChosen$lambda$1(selectedValue, this.this$0));
                    }

                    private static final void onChosen$lambda$1(TargetItem $selectedValue, DatabaseScriptRunConfigurationSettingsEditor this$0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        if ($selectedValue != null) {
                            DatabaseScriptRunConfigurationSettingsEditor.access$addTargets(this$0, CollectionsKt.listOf((Object)$selectedValue));
                        }
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
                ListPopup popup2 = listPopup;
                popup2.show(JBPopupFactory.getInstance().guessBestPopupLocation((AnAction)this, e2));
            }
        });
        ToolbarDecorator toolbarDecorator3 = toolbarDecorator;
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator3, (String)"apply(...)");
        final ToolbarDecorator targetsDecorator2 = toolbarDecorator3;
        this.mainPanel = (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell = $this$row.cell((JComponent)targetsDecorator2.createPanel());
                        String string = DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Targets", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        cell.label(string, LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null).bottomGap(BottomGap.SMALL);
                Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(){

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        String string = DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.ScriptToExecute", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$buttonsGroup.row(string, (Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Text", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                textRadioButton = (JBRadioButton)ButtonKt.selected((Cell)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null), (boolean)true).applyToComponent((Function1)new Function1<JBRadioButton, Unit>(){

                                    public final void invoke(@NotNull JBRadioButton $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                        $this$applyToComponent.addActionListener(arg_0 -> 1.invoke$lambda$0(this, arg_0));
                                    }

                                    private static final void invoke$lambda$0(DatabaseScriptRunConfigurationSettingsEditor this$0, ActionEvent it2) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                        this$0.selectMode(this$0.getSelectedMode());
                                    }
                                }).getComponent();
                                String string2 = DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Files", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                filesRadioButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string2, null, (int)2, null).applyToComponent((Function1)new Function1<JBRadioButton, Unit>(){

                                    public final void invoke(@NotNull JBRadioButton $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                        $this$applyToComponent.addActionListener(arg_0 -> 2.invoke$lambda$0(this, arg_0));
                                    }

                                    private static final void invoke$lambda$0(DatabaseScriptRunConfigurationSettingsEditor this$0, ActionEvent it2) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                        this$0.selectMode(this$0.getSelectedMode());
                                    }
                                }).getComponent();
                            }
                        }).bottomGap(BottomGap.SMALL);
                    }
                }), (int)3, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        void $this$invoke_u24lambda_u240;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        JPanel jPanel = new JPanel(new CardLayout());
                        DatabaseScriptRunConfigurationSettingsEditor databaseScriptRunConfigurationSettingsEditor = this;
                        JPanel jPanel2 = jPanel;
                        Row row = $this$row;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.add(databaseScriptRunConfigurationSettingsEditor.textPanel);
                        $this$invoke_u24lambda_u240.add(databaseScriptRunConfigurationSettingsEditor.filesPanel);
                        UiNotifyConnector.Once.Companion.installOn((Component)$this$invoke_u24lambda_u240, new Activatable(databaseScriptRunConfigurationSettingsEditor){
                            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void showNotify() {
                                (DatabaseScriptRunConfigurationSettingsEditor.access$getTextPanel$p(this.this$0)).setPreferredSize(DatabaseScriptRunConfigurationSettingsEditor.access$getFilesPanel$p(this.this$0).getPreferredSize());
                            }
                        });
                        row.cell((JComponent)jPanel).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null);
            }
        }));
        UiNotifyConnector.Once.Companion.installOn((Component)this.mainPanel, new Activatable(){

            public void showNotify() {
                Dimension initialSize;
                Window window = ComponentUtil.getWindow((Component)mainPanel);
                DialogWrapperDialog dialogWrapperDialog = window instanceof DialogWrapperDialog ? (DialogWrapperDialog)window : null;
                Dimension dimension = dialogWrapperDialog != null && (dialogWrapperDialog = dialogWrapperDialog.getDialogWrapper()) != null ? dialogWrapperDialog.getInitialSize() : (initialSize = null);
                if (window != null && initialSize != null) {
                    Dimension windowSize = window.getSize();
                    window.setSize(new Dimension(windowSize.width, Math.max(windowSize.height, window.getPreferredSize().height)));
                }
            }
        });
        this.analyse();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DatabaseScriptRunConfigurationOptions.Mode getSelectedMode() {
        JBRadioButton jBRadioButton = this.filesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filesRadioButton");
            jBRadioButton = null;
        }
        return jBRadioButton.isSelected() ? DatabaseScriptRunConfigurationOptions.Mode.FILE : DatabaseScriptRunConfigurationOptions.Mode.TEXT;
    }

    private final void selectMode(DatabaseScriptRunConfigurationOptions.Mode newType) {
        JBRadioButton jBRadioButton = this.textRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textRadioButton");
            jBRadioButton = null;
        }
        jBRadioButton.setSelected(newType == DatabaseScriptRunConfigurationOptions.Mode.TEXT);
        JBRadioButton jBRadioButton2 = this.filesRadioButton;
        if (jBRadioButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filesRadioButton");
            jBRadioButton2 = null;
        }
        jBRadioButton2.setSelected(newType == DatabaseScriptRunConfigurationOptions.Mode.FILE);
        this.textPanel.setVisible(newType == DatabaseScriptRunConfigurationOptions.Mode.TEXT);
        this.filesPanel.setVisible(newType == DatabaseScriptRunConfigurationOptions.Mode.FILE);
    }

    @NotNull
    protected JComponent createEditor() {
        return this.mainPanel;
    }

    /*
     * WARNING - void declaration
     */
    protected void resetEditorFrom(@NotNull DatabaseScriptRunConfiguration s2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)s2), (String)"s");
        DatabaseScriptRunConfigurationOptions options2 = s2.getOptions();
        this.selectMode(options2.getMode());
        String string = options2.getText();
        if (string == null) {
            string = "";
        }
        this.textField.setText(string);
        this.filesModel.setItems(options2.getFiles());
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(this.project);
        Iterable iterable = options2.getTargets();
        CollectionListModel<TargetItem> collectionListModel = this.targetsModel;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DatabaseScriptRunConfigurationOptions.Target target2 = (DatabaseScriptRunConfigurationOptions.Target)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)storage));
            collection2.add(new TargetItem(storage, (DatabaseScriptRunConfigurationOptions.Target)it2));
        }
        collectionListModel.replaceAll((List)destination$iv$iv);
    }

    private final Dbms getDbms() {
        Dbms dbms;
        List list = this.targetsModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Object object = (TargetItem)CollectionsKt.firstOrNull((List)list);
        if ((object != null && (object = ((TargetItem)object).getDs()) != null ? ((LocalDataSource)object).getDbms() : (dbms = null)) == null) {
            Dbms dbms2 = Dbms.UNKNOWN;
            dbms = dbms2;
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"UNKNOWN");
        }
        return dbms;
    }

    private final void prepareAddTargetAction(AnActionButton a) {
        DatabaseSchemaSelectionTree tree2 = new DatabaseSchemaSelectionTree(this.project, this.getFilterDbms());
        JBPopup popup2 = DatabaseSchemaSelectionTreeKt.createPopup(tree2, (Function0<Unit>)((Function0)new Function0<Unit>(tree2, this){
            final /* synthetic */ DatabaseSchemaSelectionTree $tree;
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DatabaseScriptRunConfigurationSettingsEditor.access$prepareAddTargetAction$addTargetsFromSelection(this.$tree, this.this$0);
            }
        }));
        popup2.show(a.getPreferredPopupPoint());
    }

    private final Set<Dbms> getFilterDbms() {
        Sequence sequence;
        List list = this.targetsModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getFilterDbms.1.INSTANCE);
        if (WhenMappings.$EnumSwitchMapping$0[this.getSelectedMode().ordinal()] == 1) {
            List list2 = this.filesModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            sequence = CollectionsKt.asSequence((Iterable)list2);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return SequencesKt.toSet((Sequence)SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<String, Dbms>(this){
            final /* synthetic */ DatabaseScriptRunConfigurationSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Dbms invoke(String f) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(f);
                if (virtualFile == null) return null;
                VirtualFile virtualFile2 = virtualFile;
                Object object = this.this$0;
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl = false;
                Language language = LanguageUtil.getLanguageForPsi((Project)object.getProject(), (VirtualFile)virtualFile3);
                if (language == null) return null;
                Language language2 = language;
                boolean bl2 = false;
                Dbms dbms = DbSqlUtil.getDbms(language2);
                if (dbms == null) return null;
                Object object2 = object = dbms;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)object2, (Object)Dbms.UNKNOWN)) return null;
                boolean bl4 = true;
                if (!bl4) return null;
                Object object3 = object;
                return object3;
            }
        }))));
    }

    /*
     * WARNING - void declaration
     */
    private final void addTargets(List<TargetItem> items2) {
        Collection<CallSite> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.targetsModel.add(items2);
        Iterable iterable = items2;
        String string = this.LRU_KEY;
        int n = 5;
        Project project = this.project;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            String string2;
            block4: {
                block3: {
                    void p2;
                    void it2;
                    TargetItem targetItem = (TargetItem)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    string2 = it2.getDsId();
                    object = it2.getPath();
                    if (object == null) break block3;
                    ObjectPath objectPath = object;
                    String string3 = string2;
                    boolean bl2 = false;
                    String string4 = "/" + p2.serialize();
                    string2 = string3;
                    object = string4;
                    if (string4 != null) break block4;
                }
                object = "";
            }
            collection2.add((CallSite)((Object)(string2 + (String)object)));
        }
        collection2 = (List)destination$iv$iv;
        DatabaseViewActions.addToLRUNames(project, n, string, (List<String>)collection2);
        this.analyse();
    }

    private final void updateLanguage() {
        PsiFile file;
        Language language = DbSqlUtil.getLanguage(this.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.textField.getDocument());
        if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getLanguage() : null), (Object)language2)) {
            return;
        }
        PsiFile psiFile2 = PsiFileFactory.getInstance((Project)this.project).createFileFromText("a.sql", language2, (CharSequence)this.textField.getText());
        Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        this.textField.setNewDocumentAndFileType((FileType)SqlFileType.INSTANCE, document2);
    }

    /*
     * WARNING - void declaration
     */
    protected void applyEditorTo(@NotNull DatabaseScriptRunConfiguration s2) {
        void destination$iv;
        void $this$mapTo$iv;
        DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)s2), (String)"s");
        DatabaseScriptRunConfigurationOptions $this$applyEditorTo_u24lambda_u2415 = databaseScriptRunConfigurationOptions = s2.getOptions();
        boolean bl = false;
        $this$applyEditorTo_u24lambda_u2415.setMode(this.getSelectedMode());
        List list = this.targetsModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable iterable = list;
        Collection collection2 = new ArrayList();
        DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions2 = $this$applyEditorTo_u24lambda_u2415;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            TargetItem targetItem = (TargetItem)item$iv;
            void var12_12 = destination$iv;
            boolean bl2 = false;
            var12_12.add(it2.prepareTarget());
        }
        databaseScriptRunConfigurationOptions2.setTargets((List)destination$iv);
        switch (WhenMappings.$EnumSwitchMapping$0[$this$applyEditorTo_u24lambda_u2415.getMode().ordinal()]) {
            case 2: {
                $this$applyEditorTo_u24lambda_u2415.setText(StringKt.nullize((String)this.textField.getText(), (boolean)true));
                $this$applyEditorTo_u24lambda_u2415.setFiles(new ArrayList());
                break;
            }
            case 1: {
                List list2 = this.filesModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                $this$applyEditorTo_u24lambda_u2415.setFiles(CollectionsKt.toMutableList((Collection)list2));
                $this$applyEditorTo_u24lambda_u2415.setText(null);
            }
        }
    }

    protected void disposeEditor() {
        block0: {
            super.disposeEditor();
            this.disposed = true;
            Pair pair = this.analysisFuture.getAndSet(null);
            if (pair == null) break block0;
            Pair it2 = pair;
            boolean bl = false;
            this.cancel(it2);
        }
    }

    private final void cancel(Pair<? extends Future<?>, ? extends ProgressIndicator> task) {
        ((Future)task.getFirst()).cancel(true);
        ((ProgressIndicator)task.getSecond()).cancel();
    }

    private final void analyse() {
        block3: {
            Pair pair;
            if (this.disposed) {
                return;
            }
            ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getAppScheduledExecutorService(...)");
            ScheduledExecutorService executor = scheduledExecutorService;
            if (this.getSelectedMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
                pair = null;
            } else {
                EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                pair = new Pair(executor.schedule(() -> DatabaseScriptRunConfigurationSettingsEditor.analyse$lambda$17(this, indicator), 100L, TimeUnit.MILLISECONDS), (Object)indicator);
            }
            Pair scheduled = pair;
            Pair pair2 = this.analysisFuture.getAndSet(scheduled);
            if (pair2 == null) break block3;
            Pair it2 = pair2;
            boolean bl = false;
            this.cancel(it2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void performAnalysis() {
        var1_1 = this.analysisFuture;
        synchronized (var1_1) {
            block26: {
                block25: {
                    $i$a$-synchronized-DatabaseScriptRunConfigurationSettingsEditor$performAnalysis$1 = false;
                    v0 = indicator = ProgressManager.getGlobalProgressIndicator();
                    if (v0 != null) {
                        if (v0.isCanceled()) {
                            return;
                        }
                        v1 = false;
                    } else {
                        v1 = false;
                    }
                    if (v1) {
                        return;
                    }
                    paths = new ArrayList<String>(this.filesModel.getItems());
                    targets = new ArrayList<E>(this.targetsModel.getItems());
                    try {
                        var6_7 = targets;
                        destination$iv = new HashSet<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        $i$f$forEach = false;
                        var11_15 = $this$forEach$iv$iv.iterator();
                        while (var11_15.hasNext()) {
                            element$iv = element$iv$iv = var11_15.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
                            it = (TargetItem)element$iv;
                            $i$a$-mapNotNullTo-DatabaseScriptRunConfigurationSettingsEditor$performAnalysis$1$languages$1 = false;
                            if (DbSqlUtil.findLanguage(it.getDs()) == null) continue;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
                            destination$iv.add(it$iv);
                        }
                        languages = (HashSet)destination$iv;
                        for (String path : paths) {
                            block24: {
                                Intrinsics.checkNotNull((Object)this.analysisResult.get(path));
                                $this$all$iv = languages;
                                $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    v2 = true;
                                } else {
                                    for (T element$iv : $this$all$iv) {
                                        it = (Language)element$iv;
                                        $i$a$-all-DatabaseScriptRunConfigurationSettingsEditor$performAnalysis$1$1 = false;
                                        if (fileResult.getPerLanguage().containsKey(it.getID())) continue;
                                        v2 = false;
                                        break block24;
                                    }
                                    v2 = true;
                                }
                            }
                            if (v2) continue;
                            v3 = this.analysisResult.get(path);
                            Intrinsics.checkNotNull((Object)v3);
                            v3.setComputing(true);
                        }
                        this.analysisResult.keySet().removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, performAnalysis$lambda$22$lambda$21(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)((Function1)new Function1<String, Boolean>(paths){
                            final /* synthetic */ ArrayList<String> $paths;
                            {
                                this.$paths = $paths;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(String it2) {
                                return !this.$paths.contains(it2);
                            }
                        })));
                        this.repaintTable();
lbl58:
                        // 2 sources

                        for (String path : paths) {
                            v4 = indicator;
                            v5 = v4 != null ? v4.isCanceled() : false;
                            if (v5) {
                                fileResult = paths.iterator();
                                break block25;
                            }
                            ** GOTO lbl-1000
                        }
                        break block26;
                    }
                    catch (Throwable var19_25) {
                        var6_7 = paths.iterator();
                        while (true) {
                            if (!var6_7.hasNext()) {
                                this.repaintTable();
                                throw var19_25;
                            }
                            path = (String)var6_7.next();
                            v6 = this.analysisResult.get(path);
                            Intrinsics.checkNotNull((Object)v6);
                            v6.setComputing(false);
                        }
                    }
                }
                while (true) {
                    if (!fileResult.hasNext()) {
                        this.repaintTable();
                        return;
                    }
                    path = fileResult.next();
                    v7 = this.analysisResult.get(path);
                    Intrinsics.checkNotNull((Object)v7);
                    v7.setComputing(false);
                }
lbl-1000:
                // 1 sources

                {
                    Intrinsics.checkNotNull((Object)this.analysisResult.get(path));
                    vfile = LocalFileSystem.getInstance().findFileByPath(path);
                    exists = vfile != null && vfile.exists() != false;
                    fileResult.setExists(exists);
                    if (exists) {
                        for (Language language : languages) {
                            if (fileResult.getPerLanguage().containsKey(language.getID())) continue;
                            var13_17 = fileResult.getPerLanguage();
                            Intrinsics.checkNotNullExpressionValue((Object)language.getID(), (String)"getID(...)");
                            v8 = vfile;
                            Intrinsics.checkNotNull((Object)v8);
                            Intrinsics.checkNotNull((Object)language);
                            var15_20 = this.analyse(this.project, v8, language);
                            var13_17.put(var14_19, var15_20);
                        }
                    }
                    fileResult.setComputing(false);
                    ** GOTO lbl58
                }
            }
            var19_24 = paths.iterator();
            while (true) {
                if (!var19_24.hasNext()) {
                    this.repaintTable();
                    var2_3 = Unit.INSTANCE;
                    return;
                }
                path = var19_24.next();
                v9 = this.analysisResult.get(path);
                Intrinsics.checkNotNull((Object)v9);
                v9.setComputing(false);
            }
        }
    }

    private final void repaintTable() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.stateForComponent((Component)this.filesPanel), () -> DatabaseScriptRunConfigurationSettingsEditor.repaintTable$lambda$23(this));
    }

    private final Map<ProblemType, Pair<String, Ref<Integer>>> analyse(Project project, VirtualFile file, Language language) {
        HashMap<ProblemType, Pair<String, Ref<Integer>>> res2 = new HashMap<ProblemType, Pair<String, Ref<Integer>>>();
        this.analyse(project, file, language, (Function2<? super ProblemType, ? super Function0<String>, Unit>)((Function2)new Function2<ProblemType, Function0<? extends String>, Unit>(res2){
            final /* synthetic */ HashMap<ProblemType, Pair<String, Ref<Integer>>> $res;
            {
                this.$res = $res;
                super(2);
            }

            public final void invoke(@NotNull ProblemType type2, @NotNull Function0<String> example) {
                Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
                Intrinsics.checkNotNullParameter(example, (String)"example");
                Pair state = this.$res.get((Object)((Object)type2));
                if (state == null) {
                    state = new Pair(example.invoke(), (Object)Ref.create((Object)1));
                    ((Map)this.$res).put(type2, state);
                } else {
                    ((Ref)state.getSecond()).set((Object)(((Number)((Ref)state.getSecond()).get()).intValue() + 1));
                }
            }
        }));
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void analyse(Project project, VirtualFile file, Language language, Function2<? super ProblemType, ? super Function0<String>, Unit> consumer) {
        v0 = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        if (v0 != null) {
            $this$asSafely$iv = v0;
            $i$f$asSafely = false;
            v1 = $this$asSafely$iv;
            if (!(v1 instanceof SqlLanguageDialect)) {
                v1 = null;
            }
            v2 = (SqlLanguageDialect)v1;
        } else {
            v2 = forced = null;
        }
        if (!(language instanceof SqlLanguageDialect)) ** GOTO lbl-1000
        v3 = forced;
        if (Intrinsics.areEqual((Object)(v3 != null ? v3.getDbms() : null), (Object)((SqlLanguageDialect)language).getDbms())) {
            v4 = (Language)forced;
        } else lbl-1000:
        // 2 sources

        {
            v4 = language;
        }
        parserLanguage = v4;
        $this$use$iv = SqlPsiFacade.getInstance((Project)project).createScriptModel(file, parserLanguage);
        $i$f$use = false;
        try {
            model = (ScriptModel)$this$use$iv;
            $i$a$-use-DatabaseScriptRunConfigurationSettingsEditor$analyse$3 = false;
            v5 = model.everything();
            Intrinsics.checkNotNullExpressionValue(v5, (String)"everything(...)");
            $this$forEach$iv = (Iterable)v5;
            $i$f$forEach = false;
            var13_13 = $this$forEach$iv.iterator();
            while (var13_13.hasNext()) {
                element = element$iv = var13_13.next();
                $i$a$-forEach-DatabaseScriptRunConfigurationSettingsEditor$analyse$3$1 = false;
                if ((PsiElement)ObjectUtils.tryCast(element, PsiElement.class) == null) continue;
                Intrinsics.checkNotNull((Object)var17_17);
                psiElement = var17_17;
                if (psiElement instanceof SqlUseDatabaseStatement) {
                    v6 = ((SqlUseDatabaseStatement)psiElement).getUseReferences();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getUseReferences(...)");
                    v7 = (SqlReferenceExpression)CollectionsKt.firstOrNull((List)v6);
                    kind = v7 != null && (v7 = v7.getReferenceElementType()) != null ? v7.getTargetKind() : null;
                    consumer.invoke((Object)(Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DATABASE) != false ? ProblemType.SWITCH_DATABASE : ProblemType.SWITCH_SCHEMA), (Object)new Function0<String>((Object)psiElement){

                        public final String invoke() {
                            return ((PsiElement)this.receiver).getText();
                        }
                    });
                    continue;
                }
                if (psiElement instanceof IsExternal || PsiTreeUtilKt.getElementType((PsiElement)psiElement) instanceof IsExternal) {
                    consumer.invoke((Object)ProblemType.EXTERNAL_STATEMENT, (Object)new Function0<String>((Object)psiElement){

                        public final String invoke() {
                            return ((PsiElement)this.receiver).getText();
                        }
                    });
                    continue;
                }
                if (!(psiElement instanceof PsiErrorElement)) continue;
                consumer.invoke((Object)ProblemType.SYNTAX_ERRORS, (Object)new Function0<String>((Object)psiElement){

                    @NotNull
                    public final String invoke() {
                        return ((PsiErrorElement)this.receiver).getErrorDescription();
                    }
                });
            }
            var19_19 = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
    }

    private static final DatabaseScriptRunConfiguration _init_$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DatabaseScriptRunConfiguration)((Object)$tmp0.invoke());
    }

    private static final FileAnalysisResult analysisResult$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileAnalysisResult)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$3(EditorEx it2) {
        EditorSettings editorSettings;
        EditorSettings $this$lambda_u243_u24lambda_u242 = editorSettings = it2.getSettings();
        boolean bl = false;
        $this$lambda_u243_u24lambda_u242.setCaretRowShown(false);
        $this$lambda_u243_u24lambda_u242.setAdditionalPageAtBottom(false);
        $this$lambda_u243_u24lambda_u242.setWheelFontChangeEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$8(DatabaseScriptRunConfigurationSettingsEditor this$0, TableView $filesList, AnActionButton it2) {
        void $this$forEach$iv;
        VirtualFile[] virtualFileArray;
        VirtualFile $this$lambda_u248_u24lambda_u245_u24lambda_u244;
        VirtualFile virtualFile;
        VirtualFile[] it3;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filesList, (String)"$filesList");
        List list = this$0.filesModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        VirtualFile[] virtualFileArray2 = (VirtualFile[])CollectionsKt.firstOrNull((List)list);
        if (virtualFileArray2 != null) {
            it3 = virtualFileArray2;
            boolean bl = false;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            LocalFileSystem fs = localFileSystem;
            virtualFile = fs.findFileByPath((String)it3);
            if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                $this$lambda_u248_u24lambda_u245_u24lambda_u244 = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)((NewVirtualFileSystem)fs), (String)it3);
                boolean bl2 = false;
                NewVirtualFile newVirtualFile = (NewVirtualFile)$this$lambda_u248_u24lambda_u245_u24lambda_u244.first;
                if (newVirtualFile == null) {
                    newVirtualFile = (NewVirtualFile)$this$lambda_u248_u24lambda_u245_u24lambda_u244.second;
                }
                virtualFile = (VirtualFile)newVirtualFile;
            }
        } else {
            virtualFile = null;
        }
        VirtualFile anyFile = virtualFile;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor();
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, this$0.project, (Component)$filesList);
        Project project = this$0.project;
        VirtualFile virtualFile2 = anyFile;
        if (virtualFile2 != null) {
            void it4;
            $this$lambda_u248_u24lambda_u245_u24lambda_u244 = virtualFile2;
            Project project2 = project;
            FileChooserDialog fileChooserDialog2 = fileChooserDialog;
            boolean bl = false;
            VirtualFile[] virtualFileArray3 = new VirtualFile[]{it4};
            VirtualFile[] virtualFileArray4 = virtualFileArray3;
            fileChooserDialog = fileChooserDialog2;
            project = project2;
            virtualFileArray = virtualFileArray4;
        } else {
            boolean $i$f$emptyArray = false;
            virtualFileArray = new VirtualFile[]{};
        }
        it3 = virtualFileArray;
        VirtualFile[] virtualFileArray5 = fileChooserDialog.choose(project, Arrays.copyOf(it3, it3.length));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray5, (String)"choose(...)");
        Object[] objectArray = virtualFileArray5;
        boolean $i$f$forEach = false;
        for (void element$iv : $this$forEach$iv) {
            VirtualFile it5 = (VirtualFile)element$iv;
            boolean bl = false;
            this$0.filesModel.addRow((Object)it5.getPath());
        }
    }

    private static final void prepareAddTargetAction$addTargetsFromSelection(DatabaseSchemaSelectionTree tree2, DatabaseScriptRunConfigurationSettingsEditor this$0) {
        Object[] objectArray = tree2.getTree().getSelectedNodes(DefaultMutableTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        List targets2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)prepareAddTargetAction.addTargetsFromSelection.targets.1.INSTANCE));
        this$0.addTargets(targets2);
    }

    private static final void analyse$lambda$17(DatabaseScriptRunConfigurationSettingsEditor this$0, EmptyProgressIndicator $indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        ProgressManager.getInstance().executeProcessUnderProgress(this$0::performAnalysis, (ProgressIndicator)$indicator);
    }

    private static final boolean performAnalysis$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void repaintTable$lambda$23(DatabaseScriptRunConfigurationSettingsEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filesPanel.repaint();
    }

    public static final /* synthetic */ void access$prepareAddTargetAction$addTargetsFromSelection(DatabaseSchemaSelectionTree tree2, DatabaseScriptRunConfigurationSettingsEditor this$0) {
        DatabaseScriptRunConfigurationSettingsEditor.prepareAddTargetAction$addTargetsFromSelection(tree2, this$0);
    }

    public static final /* synthetic */ Map access$getAnalysisResult$p(DatabaseScriptRunConfigurationSettingsEditor $this) {
        return $this.analysisResult;
    }

    public static final /* synthetic */ String access$getLRU_KEY$p(DatabaseScriptRunConfigurationSettingsEditor $this) {
        return $this.LRU_KEY;
    }

    public static final /* synthetic */ void access$addTargets(DatabaseScriptRunConfigurationSettingsEditor $this, List items2) {
        $this.addTargets(items2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ActivePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/UserActivityProviderComponent;", "layout", "Ljava/awt/LayoutManager;", "(Ljava/awt/LayoutManager;)V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Ljavax/swing/event/ChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addChangeListener", "", "changeListener", "fire", "event", "Ljavax/swing/event/ChangeEvent;", "removeChangeListener", "intellij.database.impl"})
    public static class ActivePanel
    extends JPanel
    implements UserActivityProviderComponent {
        @NotNull
        private final EventDispatcher<ChangeListener> dispatcher;

        public ActivePanel(@NotNull LayoutManager layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            super(layout);
            EventDispatcher eventDispatcher = EventDispatcher.create(ChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
            this.dispatcher = eventDispatcher;
        }

        public final void fire(@NotNull ChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ((ChangeListener)this.dispatcher.getMulticaster()).stateChanged(event);
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
            this.dispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
            this.dispatcher.removeListener((EventListener)changeListener);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0014J\u0019\u0010\u0018\u001a\u0013\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001cH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$FileRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "doPaintText", "g_", "Ljava/awt/Graphics2D;", "textStart", "focusAroundIcon", "getRootPath", "", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NonNls;", "intellij.database.impl"})
    public static class FileRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final Project project;

        public FileRenderer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.setTransparentIconBackground(true);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (value2 == null || !(value2 instanceof String) || ((CharSequence)value2).length() == 0) {
                return;
            }
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath((String)value2);
            if (vFile != null) {
                this.setIcon(IconUtil.getIcon((VirtualFile)vFile, (int)2, (Project)this.project));
                VirtualFile parent2 = vFile.getParent();
                if (parent2 != null) {
                    Object object;
                    String projectPath = this.getRootPath();
                    String string = parent2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String parentPath = string;
                    if (projectPath != null && StringsKt.startsWith$default((String)parentPath, (String)projectPath, (boolean)false, (int)2, null)) {
                        String string2 = parentPath.substring(projectPath.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        object = "..." + string2;
                    } else {
                        object = parentPath;
                    }
                    String relativePath = object;
                    String string3 = FileUtil.toSystemDependentName((String)(relativePath + "/"));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
                    String presentablePath = string3;
                    this.append(presentablePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                this.append(vFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.setIcon(UnknownFileType.INSTANCE.getIcon());
                this.append((String)value2, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        @Nullable
        protected String getRootPath() {
            return this.project.getBasePath();
        }

        protected int doPaintText(@NotNull Graphics2D g_, int textStart, boolean focusAroundIcon) {
            Intrinsics.checkNotNullParameter((Object)g_, (String)"g_");
            Dimension dimension = this.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            Dimension ps = dimension;
            Dimension s2 = this.getSize();
            int offset = s2.width - ps.width;
            if (offset < 0) {
                Dimension rs = this.getSize();
                Graphics graphics = g_.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                g2.clipRect(textStart, 0, rs.width - textStart, rs.height);
                int res2 = super.doPaintText(g2, textStart + offset, focusAroundIcon);
                g2.setPaint(new GradientPaint((float)textStart + 0.0f, 0.0f, this.getBackground(), (float)(textStart + rs.height) + 0.0f, 0.0f, ColorUtil.toAlpha((Color)this.getBackground(), (int)0)));
                g2.fillRect(textStart, 0, rs.height, rs.height);
                return res2;
            }
            return super.doPaintText(g_, textStart, focusAroundIcon);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006H&j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "", "(Ljava/lang/String;I)V", "format", "", "r", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "", "SWITCH_SCHEMA", "SWITCH_DATABASE", "EXTERNAL_STATEMENT", "SYNTAX_ERRORS", "intellij.database.impl"})
    public static final abstract class ProblemType
    extends Enum<ProblemType> {
        public static final /* enum */ ProblemType SWITCH_SCHEMA = new SWITCH_SCHEMA("SWITCH_SCHEMA", 0);
        public static final /* enum */ ProblemType SWITCH_DATABASE = new SWITCH_DATABASE("SWITCH_DATABASE", 1);
        public static final /* enum */ ProblemType EXTERNAL_STATEMENT = new EXTERNAL_STATEMENT("EXTERNAL_STATEMENT", 2);
        public static final /* enum */ ProblemType SYNTAX_ERRORS = new SYNTAX_ERRORS("SYNTAX_ERRORS", 3);
        private static final /* synthetic */ ProblemType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ProblemType() {
        }

        @NotNull
        public abstract String format(@NotNull Pair<String, ? extends Ref<Integer>> var1);

        public static ProblemType[] values() {
            return (ProblemType[])$VALUES.clone();
        }

        public static ProblemType valueOf(String value2) {
            return Enum.valueOf(ProblemType.class, value2);
        }

        @NotNull
        public static EnumEntries<ProblemType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ ProblemType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = problemTypeArray = new ProblemType[]{ProblemType.SWITCH_SCHEMA, ProblemType.SWITCH_DATABASE, ProblemType.EXTERNAL_STATEMENT, ProblemType.SYNTAX_ERRORS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType$EXTERNAL_STATEMENT;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "format", "", "r", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "", "intellij.database.impl"})
        static final class EXTERNAL_STATEMENT
        extends ProblemType {
            /*
             * WARNING - void declaration
             */
            EXTERNAL_STATEMENT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull Pair<String, ? extends Ref<Integer>> r) {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                return "Contains " + ((Ref)r.getSecond()).get() + " non-SQL statements, e.g.:<br>" + r.getFirst();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType$SWITCH_DATABASE;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "format", "", "r", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "", "intellij.database.impl"})
        static final class SWITCH_DATABASE
        extends ProblemType {
            /*
             * WARNING - void declaration
             */
            SWITCH_DATABASE() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull Pair<String, ? extends Ref<Integer>> r) {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                return "Contains " + ((Ref)r.getSecond()).get() + " database switches, e.g.:<br>" + r.getFirst();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType$SWITCH_SCHEMA;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "format", "", "r", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "", "intellij.database.impl"})
        static final class SWITCH_SCHEMA
        extends ProblemType {
            /*
             * WARNING - void declaration
             */
            SWITCH_SCHEMA() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull Pair<String, ? extends Ref<Integer>> r) {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                return "Contains " + ((Ref)r.getSecond()).get() + " schema switches, e.g.:<br>" + r.getFirst();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType$SYNTAX_ERRORS;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$ProblemType;", "format", "", "r", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "", "intellij.database.impl"})
        static final class SYNTAX_ERRORS
        extends ProblemType {
            /*
             * WARNING - void declaration
             */
            SYNTAX_ERRORS() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull Pair<String, ? extends Ref<Integer>> r) {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                return "Contains " + ((Ref)r.getSecond()).get() + " syntax errors, e.g.:<br>" + r.getFirst();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$StatusRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "(Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.database.impl"})
    public final class StatusRenderer
    extends ColoredTableCellRenderer {
        public StatusRenderer() {
            this.setTransparentIconBackground(true);
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (!(value2 instanceof FileAnalysisResult)) {
                return;
            }
            Object object = value2;
            DatabaseScriptRunConfigurationSettingsEditor databaseScriptRunConfigurationSettingsEditor = DatabaseScriptRunConfigurationSettingsEditor.this;
            FileAnalysisResult ar = (FileAnalysisResult)object;
            boolean bl = false;
            if (ar.getComputing()) {
                this.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                this.setToolTipText(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.analyzing", new Object[0]));
            } else {
                List list = databaseScriptRunConfigurationSettingsEditor.targetsModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Set languages2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)customizeCellRenderer.1.languages.1.INSTANCE));
                EnumMap<ProblemType, Pair<String, Ref<Integer>>> res2 = new EnumMap<ProblemType, Pair<String, Ref<Integer>>>(ProblemType.class);
                for (Language language : languages2) {
                    Map<ProblemType, Pair<String, Ref<Integer>>> err;
                    if (ar.getPerLanguage().get(language.getID()) == null) continue;
                    boolean bl2 = false;
                    res2.putAll(err);
                }
                if (!((Map)res2).isEmpty()) {
                    this.setIcon(AllIcons.General.Warning);
                    Set set = res2.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    this.setToolTipText(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"<br>", null, null, (int)0, null, (Function1)customizeCellRenderer.1.2.INSTANCE, (int)30, null));
                } else {
                    this.setIcon(AllIcons.General.InspectionsOK);
                    this.setToolTipText(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.no.problems.found", new Object[0]));
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetItem;", "", "storage", "Lcom/intellij/database/dataSource/DataSourceStorage;", "t", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;", "(Lcom/intellij/database/dataSource/DataSourceStorage;Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;)V", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "dsId", "", "path", "Lcom/intellij/database/util/ObjectPath;", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Lcom/intellij/database/util/ObjectPath;)V", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getDsId", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "prepareTarget", "toString", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfigurationSettingsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfigurationSettingsEditor.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,659:1\n1#2:660\n*E\n"})
    public static final class TargetItem {
        @Nullable
        private final LocalDataSource ds;
        @NotNull
        private final String dsId;
        @Nullable
        private final ObjectPath path;

        public TargetItem(@Nullable LocalDataSource ds, @NotNull String dsId, @Nullable ObjectPath path) {
            Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
            this.ds = ds;
            this.dsId = dsId;
            this.path = path;
        }

        @Nullable
        public final LocalDataSource getDs() {
            return this.ds;
        }

        @NotNull
        public final String getDsId() {
            return this.dsId;
        }

        @Nullable
        public final ObjectPath getPath() {
            return this.path;
        }

        /*
         * WARNING - void declaration
         */
        public TargetItem(@NotNull DataSourceStorage storage, @NotNull DatabaseScriptRunConfigurationOptions.Target t) {
            ObjectPath objectPath;
            Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
            Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
            TargetItem targetItem = this;
            LocalDataSource localDataSource = storage.getDataSourceById(t.getDataSourceId());
            String string = t.getDataSourceId();
            if (string == null) {
                string = "";
            }
            String string2 = t.getNamespace();
            if (string2 != null) {
                void it2;
                String string3 = string2;
                String string4 = string;
                LocalDataSource localDataSource2 = localDataSource;
                TargetItem targetItem2 = targetItem;
                boolean bl = false;
                ObjectPath objectPath2 = ObjectPath.deserialize((String)it2);
                targetItem = targetItem2;
                localDataSource = localDataSource2;
                string = string4;
                objectPath = objectPath2;
            } else {
                objectPath = null;
            }
            targetItem(localDataSource, string, objectPath);
        }

        @NotNull
        public final DatabaseScriptRunConfigurationOptions.Target prepareTarget() {
            ObjectPath objectPath = this.path;
            return new DatabaseScriptRunConfigurationOptions.Target(this.dsId, objectPath != null ? objectPath.serialize() : null);
        }

        @NotNull
        public String toString() {
            Object object;
            Object object2 = this.ds;
            if (object2 == null || (object2 = ((AbstractDataSource)object2).getName()) == null) {
                object2 = this.dsId;
            }
            if ((object = this.path) == null || (object = ((ObjectPath)object).toString()) == null) {
                object = "";
            }
            return (String)object2 + "/" + (String)object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\n\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetItem;", "(Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor;)V", "appendCurrentNamespace", "", "parent", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "spKind", "Lcom/intellij/database/model/ObjectKind;", "customizeCellRenderer", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfigurationSettingsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfigurationSettingsEditor.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,659:1\n1#2:660\n14#3:661\n14#3:662\n*S KotlinDebug\n*F\n+ 1 DatabaseScriptRunConfigurationSettingsEditor.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationSettingsEditor$TargetRenderer\n*L\n627#1:661\n632#1:662\n*E\n"})
    public final class TargetRenderer
    extends ColoredListCellRenderer<TargetItem> {
        public TargetRenderer() {
            this.setOpaque(false);
        }

        /*
         * Unable to fully structure code
         */
        protected void customizeCellRenderer(@NotNull JList<? extends TargetItem> list, @Nullable TargetItem value, int index, boolean selected, boolean hasFocus) {
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter(list, (String)"list");
                    v0 = value;
                    if (v0 == null || (v0 = v0.getDs()) == null || (v0 = v0.getIcon()) == null) {
                        v0 = Dbms.UNKNOWN.getIcon();
                    }
                    this.setIcon((Icon)v0);
                    v1 = value;
                    if ((v1 != null ? v1.getDs() : null) != null) {
                        this.append(value.getDs().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Targets.missing", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    }
                    this.append(" / ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    v2 = value;
                    if (v2 == null || (v2 = v2.getDs()) == null) ** GOTO lbl-1000
                    it = v2;
                    $i$a$-let-DatabaseScriptRunConfigurationSettingsEditor$TargetRenderer$customizeCellRenderer$spKind$1 = false;
                    v3 = DbImplUtil.getDatabaseDialect((RawConnectionConfig)it);
                    v2 = v3;
                    if (v3 != null) {
                        v4 = v2.getSearchPathObjectKind();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = null;
                    }
                    spKind = v4;
                    v5 = value;
                    dbDs = DbPsiFacade.getInstance(DatabaseScriptRunConfigurationSettingsEditor.this.getProject()).findDataSource(v5 != null ? v5.getDsId() : null);
                    v6 = value;
                    if ((v6 != null ? v6.getPath() : null) == null) break block10;
                    this.append(value.getPath().getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (spKind == null || value.getPath().reduce(false, (BiFunction<Boolean, ObjectPath, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, customizeCellRenderer$lambda$1(com.intellij.database.model.ObjectKind java.lang.Boolean com.intellij.database.util.ObjectPath ), (Ljava/lang/Boolean;Lcom/intellij/database/util/ObjectPath;)Ljava/lang/Boolean;)((ObjectKind)spKind)).booleanValue()) break block11;
                    v7 = dbDs;
                    if (v7 == null) ** GOTO lbl-1000
                    it = v7;
                    $i$a$-let-DatabaseScriptRunConfigurationSettingsEditor$TargetRenderer$customizeCellRenderer$elem$1 = false;
                    v8 = DbSqlUtilCore.findElement(it, value.getPath());
                    v7 = v8;
                    if (v8 != null && (v7 = v7.getDelegate()) != null) {
                        $this$asSafely$iv = v7;
                        $i$f$asSafely = false;
                        v9 = $this$asSafely$iv;
                        if (!(v9 instanceof BasicNamespaceOwner)) {
                            v9 = null;
                        }
                        v10 = (BasicNamespaceOwner)v9;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v10 = null;
                    }
                    elem = v10;
                    this.appendCurrentNamespace(elem, spKind);
                    break block11;
                }
                if (spKind != null) {
                    $this$asSafely$iv = value.getDs().getModel();
                    $i$f$asSafely = false;
                    v11 = $this$asSafely$iv;
                    if (!(v11 instanceof BasicModel)) {
                        v11 = null;
                    }
                    v12 = (BasicModel)v11;
                    this.appendCurrentNamespace(v12 != null ? v12.getRoot() : null, spKind);
                }
            }
        }

        private final void appendCurrentNamespace(BasicNamespaceOwner parent2, ObjectKind spKind) {
            BasicNamedElement cur;
            Object object = parent2;
            if (object != null && (object = object.getNamespaces()) != null) {
                Object v1;
                block7: {
                    Object object2 = object;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        BasicMateNamespace it2 = (BasicMateNamespace)t;
                        boolean bl = false;
                        if (!it2.isCurrent()) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                v2 = v1;
            } else {
                v2 = cur = null;
            }
            if (!(parent2 instanceof BasicRoot) && parent2 != null) {
                this.append(".", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            }
            if (cur == null) {
                this.append(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.unknown.target", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.append(cur.getName(), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                if (!Intrinsics.areEqual((Object)cur.getKind(), (Object)spKind) && cur instanceof BasicNamespaceOwner) {
                    this.appendCurrentNamespace((BasicNamespaceOwner)((Object)cur), spKind);
                }
            }
        }

        private static final Boolean customizeCellRenderer$lambda$1(ObjectKind $spKind, Boolean res2, ObjectPath p2) {
            Intrinsics.checkNotNull((Object)res2);
            return res2 != false || Intrinsics.areEqual((Object)p2.kind, (Object)$spKind);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseScriptRunConfigurationOptions.Mode.values().length];
            try {
                nArray[DatabaseScriptRunConfigurationOptions.Mode.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseScriptRunConfigurationOptions.Mode.TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

