/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseServiceViewDeleteElementProvider;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.CloseSessionAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JP\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\n2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00140\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0017\u001a\u00020\u00182\u001e\u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00140\nH\u0002J=\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00140\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ@\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00140!2\u001e\u0010\"\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00140\nH\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider;", "Lcom/intellij/ide/DeleteProvider;", "()V", "canDeleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "deleteElement", "", "filterChildren", "", "C", "P", "children", "parents", "condition", "Lkotlin/Function2;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPreprocessedSelection", "Lkotlin/Pair;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "", "getPresentation", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "elements", "groupByRemoveHelpers", "selectedItems", "", "project", "Lcom/intellij/openapi/project/Project;", "([Ljava/lang/Object;Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "removeChildrenIfParentHere", "", "groups", "DialogPresentation", "RemoveHelper", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseServiceViewDeleteElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n12474#2,2:211\n11065#2:213\n11400#2,3:214\n766#3:217\n857#3:218\n2624#3,3:219\n858#3:222\n*S KotlinDebug\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider\n*L\n48#1:211,2\n70#1:213\n70#1:214,3\n81#1:217\n81#1:218\n81#1:219,3\n81#1:222\n*E\n"})
public final class DatabaseServiceViewDeleteElementProvider
implements DeleteProvider {
    @NotNull
    public static final DatabaseServiceViewDeleteElementProvider INSTANCE = new DatabaseServiceViewDeleteElementProvider();

    private DatabaseServiceViewDeleteElementProvider() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<Pair<RemoveHelper, List<Object>>> selection2 = this.getPreprocessedSelection(dataContext);
        if (selection2.isEmpty()) {
            return;
        }
        DialogPresentation presentation = this.getPresentation(selection2);
        int result2 = Messages.showYesNoDialog((Project)project2, (String)presentation.getText(), (String)presentation.getTitle(), (String)presentation.getYesText(), (String)presentation.getNoText(), (Icon)Messages.getWarningIcon());
        if (result2 != 0) {
            return;
        }
        for (Pair<RemoveHelper, List<Object>> pair : selection2) {
            RemoveHelper helper = (RemoveHelper)((Object)pair.getFirst());
            for (Object element2 : (List)pair.getSecond()) {
                if (!helper.canRemove(project2, element2)) continue;
                helper.remove(project2, element2);
            }
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return !((Collection)this.getPreprocessedSelection(dataContext)).isEmpty();
    }

    private final List<Pair<RemoveHelper, List<Object>>> getPreprocessedSelection(DataContext dataContext) {
        Object[] selectedItems;
        Project project;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    Project project2 = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
                    if (project2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    project = project2;
                    Object[] objectArray = (Object[])PlatformCoreDataKeys.SELECTED_ITEMS.getData(dataContext);
                    if (objectArray == null) {
                        return CollectionsKt.emptyList();
                    }
                    selectedItems = objectArray;
                    if (selectedItems.length == 0) break block7;
                    Object[] $this$any$iv = selectedItems;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        Object element$iv;
                        Object it2 = element$iv = $this$any$iv[j];
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it2);
                        if (!(RemoveHelper.Companion.forNode(it2) == null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) break block8;
            }
            return CollectionsKt.emptyList();
        }
        List<Pair<RemoveHelper, List<Object>>> groups2 = this.groupByRemoveHelpers(selectedItems, project);
        return this.removeChildrenIfParentHere(groups2);
    }

    private final List<Pair<RemoveHelper, List<Object>>> removeChildrenIfParentHere(List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> groups2) {
        List compact = new ArrayList();
        for (int i2 = groups2.size() - 1; 0 < i2; --i2) {
            Pair<? extends RemoveHelper, ? extends List<? extends Object>> prev = groups2.get(i2 - 1);
            Pair<? extends RemoveHelper, ? extends List<? extends Object>> cur = groups2.get(i2);
            RemoveHelper helper = (RemoveHelper)((Object)cur.getFirst());
            List filtered2 = this.filterChildren((List)cur.getSecond(), (List)prev.getSecond(), (Function2)new Function2<Object, Object, Boolean>(helper){
                final /* synthetic */ RemoveHelper $helper;
                {
                    this.$helper = $helper;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Object child, @NotNull Object parent2) {
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                    return this.$helper.checkIsParent(child, parent2);
                }
            });
            if (!(!((Collection)filtered2).isEmpty())) continue;
            ((Collection)compact).add(new Pair((Object)helper, filtered2));
        }
        Pair firstGroup = (Pair)CollectionsKt.first(groups2);
        if (!((Collection)firstGroup.getSecond()).isEmpty()) {
            ((Collection)compact).add(firstGroup);
        }
        return compact;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<RemoveHelper, List<Object>>> groupByRemoveHelpers(Object[] selectedItems, Project project) {
        void $this$mapTo$iv$iv;
        RemoveHelper[] $this$map$iv = RemoveHelper.values();
        boolean $i$f$map = false;
        RemoveHelper[] removeHelperArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void helper;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List filteredItems2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])selectedItems), (Function1)((Function1)new Function1<Object, Boolean>((RemoveHelper)helper){
                final /* synthetic */ RemoveHelper $helper;
                {
                    this.$helper = $helper;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Object it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return this.$helper.isSuitableForNode(it2);
                }
            })), (Function1)((Function1)new Function1<Object, Object>((RemoveHelper)helper){
                final /* synthetic */ RemoveHelper $helper;
                {
                    this.$helper = $helper;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull Object it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return this.$helper.unwrapNode(it2);
                }
            })), (Function1)((Function1)new Function1<Object, Boolean>((RemoveHelper)helper, project){
                final /* synthetic */ RemoveHelper $helper;
                final /* synthetic */ Project $project;
                {
                    this.$helper = $helper;
                    this.$project = $project;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Object it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return this.$helper.canRemove(this.$project, it2);
                }
            })));
            collection2.add(new Pair((Object)helper, (Object)filteredItems2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <C, P> List<C> filterChildren(List<? extends C> children2, List<? extends P> parents2, Function2<? super C, ? super P, Boolean> condition2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = children2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                Object child = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Iterable $this$none$iv = parents2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$none$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object parent2 = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!((Boolean)condition2.invoke(child, parent2)).booleanValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DialogPresentation getPresentation(List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> elements2) {
        Pair pair = (Pair)CollectionsKt.singleOrNull(elements2);
        if (pair == null) {
            return DialogPresentation.Companion.default(elements2);
        }
        Pair singleGroup = pair;
        List singleGroupElements = (List)singleGroup.getSecond();
        Object singleElement = CollectionsKt.singleOrNull((List)singleGroupElements);
        RemoveHelper helper = (RemoveHelper)((Object)singleGroup.getFirst());
        Object object = singleElement;
        String title = object == null ? helper.getTitle(singleGroupElements) : helper.getTitle(object);
        Object object2 = singleElement;
        String text2 = object2 == null ? helper.getText(singleGroupElements) : helper.getText(object2);
        Object object3 = singleElement;
        String yes = object3 == null ? helper.getYesText(singleGroupElements) : helper.getYesText(object3);
        Object object4 = singleElement;
        String no = object4 == null ? helper.getNoText(singleGroupElements) : helper.getNoText(object4);
        return new DialogPresentation(title, text2, yes, no);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "", "title", "", "text", "yesText", "noText", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getNoText", "()Ljava/lang/String;", "getText", "getTitle", "getYesText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.database.impl"})
    private static final class DialogPresentation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String title;
        @NotNull
        private final String text;
        @NotNull
        private final String yesText;
        @NotNull
        private final String noText;

        public DialogPresentation(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @NotNull String text2, @NlsActions.ActionText @NotNull String yesText, @NlsActions.ActionText @NotNull String noText) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
            Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
            this.title = title;
            this.text = text2;
            this.yesText = yesText;
            this.noText = noText;
        }

        public /* synthetic */ DialogPresentation(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                String string5 = Messages.getYesButton();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getYesButton(...)");
                string3 = string5;
            }
            if ((n & 8) != 0) {
                String string6 = Messages.getNoButton();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNoButton(...)");
                string4 = string6;
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getYesText() {
            return this.yesText;
        }

        @NotNull
        public final String getNoText() {
            return this.noText;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final String component3() {
            return this.yesText;
        }

        @NotNull
        public final String component4() {
            return this.noText;
        }

        @NotNull
        public final DialogPresentation copy(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @NotNull String text2, @NlsActions.ActionText @NotNull String yesText, @NlsActions.ActionText @NotNull String noText) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
            Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
            return new DialogPresentation(title, text2, yesText, noText);
        }

        public static /* synthetic */ DialogPresentation copy$default(DialogPresentation dialogPresentation, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dialogPresentation.title;
            }
            if ((n & 2) != 0) {
                string2 = dialogPresentation.text;
            }
            if ((n & 4) != 0) {
                string3 = dialogPresentation.yesText;
            }
            if ((n & 8) != 0) {
                string4 = dialogPresentation.noText;
            }
            return dialogPresentation.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DialogPresentation(title=" + this.title + ", text=" + this.text + ", yesText=" + this.yesText + ", noText=" + this.noText + ")";
        }

        public int hashCode() {
            int result2 = this.title.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            result2 = result2 * 31 + this.yesText.hashCode();
            result2 = result2 * 31 + this.noText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DialogPresentation)) {
                return false;
            }
            DialogPresentation dialogPresentation = (DialogPresentation)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)dialogPresentation.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)dialogPresentation.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.yesText, (Object)dialogPresentation.yesText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.noText, (Object)dialogPresentation.noText);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u001e\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00070\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion;", "", "()V", "default", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "elements", "", "Lkotlin/Pair;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "intellij.database.impl"})
        @SourceDebugExtension(value={"SMAP\nDatabaseServiceViewDeleteElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1549#2:211\n1620#2,3:212\n*S KotlinDebug\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion\n*L\n108#1:211\n108#1:212,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DialogPresentation default(@NotNull List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> elements2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(elements2, (String)"elements");
                Iterable $this$map$iv = elements2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add((List)it2.getSecond());
                }
                int size = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)).size();
                String string = DatabaseBundle.message("dialog.title.remove", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Object[] objectArray = new Object[]{size};
                String string2 = DatabaseBundle.message("action.remove.items.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new DialogPresentation(string, string2, null, null, 12, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH'J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH'J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH'J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH'J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH&j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "", "(Ljava/lang/String;I)V", "canRemove", "", "project", "Lcom/intellij/openapi/project/Project;", "any", "", "checkIsParent", "child", "parent", "getNoText", "", "", "getText", "getTitle", "getYesText", "isSuitableForNode", "remove", "", "unwrapNode", "DATA_SOURCE", "SESSION", "CLIENT", "Companion", "intellij.database.impl"})
    public static final abstract class RemoveHelper
    extends Enum<RemoveHelper> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ RemoveHelper DATA_SOURCE;
        public static final /* enum */ RemoveHelper SESSION;
        public static final /* enum */ RemoveHelper CLIENT;
        private static final /* synthetic */ RemoveHelper[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RemoveHelper() {
        }

        public abstract boolean isSuitableForNode(@NotNull Object var1);

        @NotNull
        public abstract Object unwrapNode(@NotNull Object var1);

        public abstract boolean checkIsParent(@NotNull Object var1, @NotNull Object var2);

        @NlsContexts.DialogTitle
        @NotNull
        public String getTitle(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getTitle(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getText(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getYesText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getYesText(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getNoText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getNoText(CollectionsKt.listOf((Object)any));
        }

        @NlsContexts.DialogTitle
        @NotNull
        public abstract String getTitle(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getText(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getYesText(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getNoText(@NotNull List<? extends Object> var1);

        public abstract boolean canRemove(@NotNull Project var1, @NotNull Object var2);

        public abstract void remove(@NotNull Project var1, @NotNull Object var2);

        public static RemoveHelper[] values() {
            return (RemoveHelper[])$VALUES.clone();
        }

        public static RemoveHelper valueOf(String value2) {
            return Enum.valueOf(RemoveHelper.class, value2);
        }

        @NotNull
        public static EnumEntries<RemoveHelper> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ RemoveHelper(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DATA_SOURCE = new DATA_SOURCE("DATA_SOURCE", 0);
            SESSION = new SESSION("SESSION", 1);
            CLIENT = new CLIENT("CLIENT", 2);
            $VALUES = removeHelperArray = new RemoveHelper[]{RemoveHelper.DATA_SOURCE, RemoveHelper.SESSION, RemoveHelper.CLIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper$CLIENT;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "canRemove", "", "project", "Lcom/intellij/openapi/project/Project;", "any", "", "checkIsParent", "child", "parent", "getNoText", "", "", "getText", "getTitle", "getYesText", "isSuitableForNode", "remove", "", "singleSession", "Lcom/intellij/database/console/session/DatabaseSession;", "unwrapNode", "intellij.database.impl"})
        static final class CLIENT
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            CLIENT() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DatabaseSessionClientWithFile;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DatabaseSessionClientWithFile)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent2) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                return Intrinsics.areEqual((Object)parent2, ((DatabaseSessionClientWithFile)child).getSession());
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.detach.from.session", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                DatabaseSession singleSession2 = this.singleSession(any);
                Object[] objectArray = new Object[3];
                objectArray[0] = any.size();
                Object object = singleSession2;
                if (object == null || (object = object.getTitle()) == null) {
                    object = "";
                }
                objectArray[1] = object;
                objectArray[2] = singleSession2 == null ? 0 : 1;
                String string = DatabaseBundle.message("action.detach.clients.from.choice.sessions.session.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                DatabaseSessionClientWithFile cfr_ignored_0 = (DatabaseSessionClientWithFile)any;
                Object[] objectArray = new Object[]{((DatabaseSessionClientWithFile)any).getTitle(), ((DatabaseSession)((DatabaseSessionClientWithFile)any).getSession()).getTitle()};
                String string = DatabaseBundle.message("action.detach.from.session.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = Messages.getYesButton();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getYesButton(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = Messages.getNoButton();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNoButton(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return SessionsUtil.canDetach((DatabaseSessionClientWithFile)any);
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                SessionsUtil.detach((DatabaseSessionClientWithFile)any);
            }

            private final DatabaseSession singleSession(List<? extends Object> any) {
                return (DatabaseSession)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)any), (Function1)singleSession.1.INSTANCE)));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper$Companion;", "", "()V", "forNode", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "any", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final RemoveHelper forNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                for (RemoveHelper value2 : RemoveHelper.values()) {
                    if (!value2.isSuitableForNode(any)) continue;
                    return value2;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper$DATA_SOURCE;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "canRemove", "", "project", "Lcom/intellij/openapi/project/Project;", "any", "", "checkIsParent", "child", "parent", "getNoText", "", "", "getText", "getTitle", "getYesText", "isSuitableForNode", "remove", "", "unwrapNode", "intellij.database.impl"})
        static final class DATA_SOURCE
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            DATA_SOURCE() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DbDataSource;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DbDataSource)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent2) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                return false;
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.close.sessions", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                Object[] objectArray = new Object[]{any.size()};
                String string = DatabaseBundle.message("action.close.all.sessions.for.data.sources.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                Object[] objectArray = new Object[]{((DbDataSource)any).getName()};
                String string = DatabaseBundle.message("action.close.all.sessions.for.data.source.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.close.sessions", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("action.keep.open.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DbDataSource)any);
                return localDataSource != null && CloseSessionAction.CloseAll.canCloseAll(project, localDataSource);
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DbDataSource)any);
                if (localDataSource != null) {
                    CloseSessionAction.CloseAll.closeAll(project, localDataSource);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper$SESSION;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "canRemove", "", "project", "Lcom/intellij/openapi/project/Project;", "any", "", "checkIsParent", "child", "parent", "getNoText", "", "", "getText", "getTitle", "getYesText", "isSuitableForNode", "remove", "", "unwrapNode", "intellij.database.impl"})
        static final class SESSION
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            SESSION() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DatabaseSession;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DatabaseSession)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent2) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                return Intrinsics.areEqual((Object)parent2, (Object)((DatabaseSession)child).getTarget());
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.close.sessions", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getTitle(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.close.session", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                Object[] objectArray = new Object[]{any.size()};
                String string = DatabaseBundle.message("action.close.sessions.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                Object[] objectArray = new Object[]{((DatabaseSession)any).getTitle()};
                String string = DatabaseBundle.message("action.close.session.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("dialog.title.close.sessions", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                String string = DatabaseBundle.message("action.Session.Close.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message("action.keep.open.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return CloseSessionAction.canClose((DatabaseSession)any);
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                CloseSessionAction.close((DatabaseSession)any);
            }
        }
    }
}

