/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.lexer.DbCliLexerAdapter;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WslPath;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbCliUtil {
    public static final String[] INPUT = new String[]{"<"};

    private DbCliUtil() {
    }

    @NotNull
    public static String cutParameter(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(0);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(1);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(2);
        }
        return DbCliUtil.cutParameter(text2, DbCliUtil.asParameterRange(current, next));
    }

    @NotNull
    public static String cutParameter(@NotNull String text2, @NotNull TextRange range) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(3);
        }
        if (range == null) {
            DbCliUtil.$$$reportNull$$$0(4);
        }
        String string = StringUtil.trim((String)range.substring(text2));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static TextRange asParameterRange(@NotNull CliLexeme current, @NotNull CliLexeme next) {
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(6);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(7);
        }
        return new TextRange(current.getEnd(), next.getStart());
    }

    @NotNull
    public static List<CliLexeme> filteredLexemes(@NotNull String text2, @NotNull List<String> parameterizable) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(8);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(9);
        }
        return DbCliUtil.filterLexemes(DbCliUtil.rawLexemes(text2), parameterizable);
    }

    @NotNull
    public static List<Pair<CliLexeme, CliLexeme>> lexemePairs(@NotNull CliContextDescriptor state, @NotNull List<? extends CliLexeme> lexemes, @NotNull String text2, @NotNull CliComponent component2) {
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(10);
        }
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(12);
        }
        if (component2 == null) {
            DbCliUtil.$$$reportNull$$$0(13);
        }
        ArrayList<Pair<CliLexeme, CliLexeme>> result2 = new ArrayList<Pair<CliLexeme, CliLexeme>>();
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(text2);
            if (!component2.isMyLexeme(text2, current, next, state)) continue;
            result2.add((Pair<CliLexeme, CliLexeme>)Pair.create((Object)current, (Object)next));
        }
        ArrayList<Pair<CliLexeme, CliLexeme>> arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static String clearString(@NotNull String s2, @NotNull Function<? super String, String> unquoter) {
        if (s2 == null) {
            DbCliUtil.$$$reportNull$$$0(15);
        }
        if (unquoter == null) {
            DbCliUtil.$$$reportNull$$$0(16);
        }
        return DbCliUtil.unescapeAll(unquoter.apply(s2));
    }

    @NotNull
    public static List<String> getCommandLineArguments(@NotNull CliConfiguration.CliParameterProcessor processor2, @NotNull String command2, @NotNull List<String> parameterizable) {
        if (processor2 == null) {
            DbCliUtil.$$$reportNull$$$0(17);
        }
        if (command2 == null) {
            DbCliUtil.$$$reportNull$$$0(18);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(19);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(command2, parameterizable);
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(command2);
            if (current.isBad()) continue;
            DbCliUtil.appendArgument(command2, current, next, processor2, parameterizable, result2);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String text2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(21);
        }
        Condition condition2 = lexeme -> StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)text2);
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(22);
        }
        return condition2;
    }

    @NotNull
    public static Condition<CliArgument> argumentFinder(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(23);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(24);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(25);
        }
        if (cd == null) {
            DbCliUtil.$$$reportNull$$$0(26);
        }
        Condition condition2 = argument -> argument.isMyLexeme(text2, current, next, cd);
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(27);
        }
        return condition2;
    }

    @NotNull
    public static Condition<? super CliLexeme> argumentWithParameterFinder(@NotNull List<? extends CliLexeme> rawLexemes, @NotNull LexemeIndicators indicators) {
        if (rawLexemes == null) {
            DbCliUtil.$$$reportNull$$$0(28);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(29);
        }
        Condition condition2 = lexeme -> lexeme.isArgument() && ContainerUtil.find((Object[])indicators.getArgs(), DbCliUtil.stringFinder(lexeme)) != null && DbCliUtil.hasParameterAfterArgument(rawLexemes, lexeme, indicators);
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(30);
        }
        return condition2;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String[] args2) {
        if (args2 == null) {
            DbCliUtil.$$$reportNull$$$0(31);
        }
        Condition condition2 = lexeme -> ContainerUtil.find((Object[])args2, DbCliUtil.stringFinder(lexeme)) != null;
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(32);
        }
        return condition2;
    }

    @NotNull
    public static Condition<String> stringFinder(@NotNull CliLexeme lexeme) {
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(33);
        }
        Condition condition2 = s2 -> StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)s2);
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(34);
        }
        return condition2;
    }

    @NotNull
    public static List<String> fromElementsToSeparated(@NotNull Collection<? extends DbElement> elements2, @NotNull Condition<? super DbElement> condition2) {
        if (elements2 == null) {
            DbCliUtil.$$$reportNull$$$0(35);
        }
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(36);
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(elements2, condition2), DasNamed::getName);
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    public static List<String> fromElementsFQNToSeparated(@NotNull Collection<? extends DbElement> elements2, @NotNull Condition<? super DbElement> condition2) {
        if (elements2 == null) {
            DbCliUtil.$$$reportNull$$$0(38);
        }
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(39);
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(elements2, condition2), element2 -> ObjectPaths.of(element2).getDisplayName());
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static List<String> getTablesNames(@NotNull Collection<DbElement> elements2) {
        if (elements2 == null) {
            DbCliUtil.$$$reportNull$$$0(41);
        }
        List list = JBIterable.from(elements2).filter(DasUtil.byClass(DbTable.class)).map(element2 -> (DbTable)element2).map(DbCliUtil::getTableName).toList();
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static String getCommandWithout(@NotNull String command2, LexemeIndicators ... indicators) {
        if (command2 == null) {
            DbCliUtil.$$$reportNull$$$0(43);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(44);
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(command2);
        for (LexemeIndicators indicator : indicators) {
            if (indicator == null) continue;
            int lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            while (lexemeIndex != -1 && lexemeIndex != lexemes.size() - 1) {
                lexemes.remove(lexemeIndex);
                if (indicator.hasParameter()) {
                    while (lexemes.get(lexemeIndex).isWhitespace()) {
                        lexemes.remove(lexemeIndex);
                    }
                    lexemes.remove(lexemeIndex);
                }
                lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            }
        }
        return DbCliUtil.joinLexemes(lexemes);
    }

    @NotNull
    public static String getUserName(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbCliUtil.$$$reportNull$$$0(45);
        }
        return DbCliUtil.getCredentialProperty(dataSource2, Credentials::getUserName, "user");
    }

    @NotNull
    public static String getPassword(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbCliUtil.$$$reportNull$$$0(46);
        }
        return DbCliUtil.getCredentialProperty(dataSource2, Credentials::getPasswordAsString, "password");
    }

    @NotNull
    public static String joinLexemes(@NotNull List<? extends CliLexeme> lexemes) {
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(47);
        }
        String string = StringUtil.join(lexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    static int getIndexFromCommand(@NotNull List<? extends CliLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(49);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(50);
        }
        return ContainerUtil.lastIndexOf(lexemes, DbCliUtil.argumentWithParameterFinder(lexemes, indicators));
    }

    @NotNull
    private static String getCredentialProperty(@NotNull LocalDataSource dataSource2, @NotNull Function<? super Credentials, String> getter, @NotNull String property) {
        Credentials credentials;
        String credentialsValue;
        if (dataSource2 == null) {
            DbCliUtil.$$$reportNull$$$0(51);
        }
        if (getter == null) {
            DbCliUtil.$$$reportNull$$$0(52);
        }
        if (property == null) {
            DbCliUtil.$$$reportNull$$$0(53);
        }
        String string = credentialsValue = (credentials = DatabaseCredentialsAuthProvider.getCredentials(dataSource2)) == null ? null : getter.apply((Credentials)credentials);
        if (StringUtil.isNotEmpty((String)credentialsValue)) {
            String string2 = credentialsValue;
            if (string2 == null) {
                DbCliUtil.$$$reportNull$$$0(54);
            }
            return string2;
        }
        JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(dataSource2);
        String parameter = parsed == null ? null : parsed.getParameter(property);
        String string3 = StringUtil.notNullize((String)parameter);
        if (string3 == null) {
            DbCliUtil.$$$reportNull$$$0(55);
        }
        return string3;
    }

    private static String getTableName(@NotNull DbTable table) {
        DasObject parent2;
        if (table == null) {
            DbCliUtil.$$$reportNull$$$0(56);
        }
        String parentName = (parent2 = DasUtil.getParentOfKind(table, ObjectKind.SCHEMA, true)) == null ? "" : DbCliUtil.quote(parent2.getName()) + ".";
        return parentName + DbCliUtil.quote(table.getName());
    }

    private static boolean hasParameterAfterArgument(@NotNull List<? extends CliLexeme> lexemes, @NotNull CliLexeme lexeme, @NotNull LexemeIndicators indicators) {
        int index2;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(57);
        }
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(58);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(59);
        }
        if ((index2 = lexemes.indexOf(lexeme)) == -1) {
            return false;
        }
        if (!indicators.hasParameter()) {
            return true;
        }
        return lexemes.size() - 1 > index2 && lexemes.get(index2 + 1).isParameter() || lexemes.size() - 2 > index2 && lexemes.get(index2 + 1).isWhitespace() && lexemes.get(index2 + 2).isParameter();
    }

    @NotNull
    public static List<CliLexeme> extractArguments(@NotNull String text2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(60);
        }
        return DbCliUtil.getLexemes(text2, DbCliUtil::index);
    }

    @NotNull
    public static List<CliLexeme> rawLexemes(@NotNull String text2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(61);
        }
        return DbCliUtil.getLexemes(text2, (lexemes, lexer) -> lexemes.add(DbCliUtil.lexeme(lexer)));
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component2, @NotNull CliContextDescriptor state) {
        if (component2 == null) {
            DbCliUtil.$$$reportNull$$$0(62);
        }
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(63);
        }
        return DbCliUtil.createLexeme(component2, state, false);
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component2, @NotNull CliContextDescriptor state, boolean spaceAfter) {
        if (component2 == null) {
            DbCliUtil.$$$reportNull$$$0(64);
        }
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(65);
        }
        String result2 = " " + component2.getFullArgument(state) + " ";
        return DbCliUtil.createLexeme(result2, spaceAfter);
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull String result2, boolean spaceAfter) {
        if (result2 == null) {
            DbCliUtil.$$$reportNull$$$0(66);
        }
        return new CliLexeme(spaceAfter ? StringUtil.trimLeading((String)result2) : StringUtil.trimTrailing((String)result2), DbCliTokenType.SYNTHETIC, -1, -1);
    }

    @NotNull
    public static <T extends CliArgument> List<CliComponent> createComponents(@NotNull CliArgumentGroup<T> group2, @NotNull Function<? super T, ? extends CliComponent> constructor) {
        if (group2 == null) {
            DbCliUtil.$$$reportNull$$$0(67);
        }
        if (constructor == null) {
            DbCliUtil.$$$reportNull$$$0(68);
        }
        List<CliComponent> list = Arrays.stream(group2.getArguments()).map(constructor).collect(Collectors.toList());
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(69);
        }
        return list;
    }

    @NotNull
    public static String extractParameterizable(String ... args2) {
        return DbCliUtil.extract((Condition<? super String>)((Condition)s2 -> StringUtil.endsWith((CharSequence)s2, (CharSequence)"=") || StringUtil.equals((CharSequence)"<", (CharSequence)s2)), args2);
    }

    @NotNull
    public static String extractNonParameterizable(String ... args2) {
        return DbCliUtil.extract((Condition<? super String>)((Condition)s2 -> !StringUtil.endsWith((CharSequence)s2, (CharSequence)"=")), args2);
    }

    @NotNull
    private static String extract(@NotNull Condition<? super String> condition2, String ... args2) {
        if (condition2 == null) {
            DbCliUtil.$$$reportNull$$$0(70);
        }
        if (args2 == null || args2.length == 0) {
            return "";
        }
        String element2 = (String)ContainerUtil.find((Object[])args2, condition2);
        String string = StringUtil.notNullize((String)(element2 == null ? (String)ArrayUtil.getFirstElement((Object[])args2) : element2));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static String pgQuote(@NotNull String s2) {
        if (s2 == null) {
            DbCliUtil.$$$reportNull$$$0(72);
        }
        String string = "'" + DbCliUtil.quote(s2) + "'";
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    public static String quote(@NotNull String s2) {
        if (s2 == null) {
            DbCliUtil.$$$reportNull$$$0(74);
        }
        String string = !DbCliUtil.containsNonAlphaCharacters(s2) ? s2 : StringUtil.wrapWithDoubleQuote((String)DbCliUtil.escapeAllQuotes(s2));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    public static String unescapeAll(@NotNull String s2) {
        if (s2 == null) {
            DbCliUtil.$$$reportNull$$$0(76);
        }
        String string = StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)s2, (char)'\"'), (char)'\''), (char)'\\');
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    public static String fromListToArgument(@NotNull List<String> strings, @NotNull String prefix, @NotNull Function<? super String, String> processor2) {
        if (strings == null) {
            DbCliUtil.$$$reportNull$$$0(78);
        }
        if (prefix == null) {
            DbCliUtil.$$$reportNull$$$0(79);
        }
        if (processor2 == null) {
            DbCliUtil.$$$reportNull$$$0(80);
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(strings, s2 -> prefix + (String)processor2.apply((String)s2)), (String)" ");
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    @Nullable
    public static String getArgumentValue(@NotNull String command2, @NotNull List<String> parameterizable, @NotNull String[] args2) {
        TextRange range;
        if (command2 == null) {
            DbCliUtil.$$$reportNull$$$0(82);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(83);
        }
        if (args2 == null) {
            DbCliUtil.$$$reportNull$$$0(84);
        }
        return (range = DbCliUtil.getArgumentValueRange(command2, parameterizable, args2)) == null ? null : DbCliUtil.cutParameter(command2, range);
    }

    @Nullable
    public static TextRange getArgumentValueRange(@NotNull String command2, @NotNull List<String> parameterizable, @NotNull String[] args2) {
        List<CliLexeme> lexemes;
        int index2;
        if (command2 == null) {
            DbCliUtil.$$$reportNull$$$0(85);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(86);
        }
        if (args2 == null) {
            DbCliUtil.$$$reportNull$$$0(87);
        }
        if ((index2 = ContainerUtil.lastIndexOf(lexemes = DbCliUtil.filteredLexemes(command2, parameterizable), DbCliUtil.lexemeFinder(args2))) == -1) {
            return null;
        }
        CliLexeme current = lexemes.get(index2);
        CliLexeme next = index2 == lexemes.size() - 1 ? DbCliUtil.getLastCharacterLexeme(command2) : lexemes.get(index2 + 1);
        return DbCliUtil.asParameterRange(current, next);
    }

    @NotNull
    public static String[] withEquality(String ... strings) {
        if (strings == null) {
            DbCliUtil.$$$reportNull$$$0(88);
        }
        List longArgs = ContainerUtil.findAll((Object[])strings, s2 -> StringUtil.startsWith((CharSequence)s2, (CharSequence)"--"));
        String[] result2 = new String[strings.length + longArgs.size()];
        System.arraycopy(strings, 0, result2, 0, strings.length);
        for (int i2 = 0; i2 < longArgs.size(); ++i2) {
            result2[strings.length + i2] = (String)longArgs.get(i2) + "=";
        }
        if (result2 == null) {
            DbCliUtil.$$$reportNull$$$0(89);
        }
        return result2;
    }

    public static void iterateOverLexemes(@NotNull String text2, @NotNull List<CliLexeme> lexemes, @NotNull CliLexemeConsumer consumer2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(90);
        }
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(91);
        }
        if (consumer2 == null) {
            DbCliUtil.$$$reportNull$$$0(92);
        }
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme current = lexemes.get(i2);
            CliLexeme next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(text2);
            consumer2.consume(current, next);
        }
    }

    @NotNull
    static CliLexeme getLastCharacterLexeme(@NotNull String text2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(93);
        }
        return new CliLexeme("", DbCliTokenType.BAD, text2.length(), text2.length());
    }

    @NotNull
    private static void appendArgument(@NotNull String command2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor2, @NotNull List<String> parameterizable, @NotNull List<String> result2) {
        if (command2 == null) {
            DbCliUtil.$$$reportNull$$$0(94);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(95);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(96);
        }
        if (processor2 == null) {
            DbCliUtil.$$$reportNull$$$0(97);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(98);
        }
        if (result2 == null) {
            DbCliUtil.$$$reportNull$$$0(99);
        }
        if (DbCliUtil.isParameterizable(current, parameterizable)) {
            DbCliUtil.appendArgumentWithParameter(command2, current, next, processor2, result2);
        } else {
            result2.add(DbCliUtil.unescapeAll(StringUtil.unquoteString((String)current.getText())));
        }
    }

    @NotNull
    private static void appendArgumentWithParameter(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor2, @NotNull List<String> result2) {
        boolean needSpace;
        boolean needEquality;
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(100);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(101);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(102);
        }
        if (processor2 == null) {
            DbCliUtil.$$$reportNull$$$0(103);
        }
        if (result2 == null) {
            DbCliUtil.$$$reportNull$$$0(104);
        }
        String parameter = DbCliUtil.cutParameter(text2, current, next);
        String key2 = current.getText();
        String value2 = processor2.process(current, parameter);
        boolean bl = needEquality = current.getType() == DbCliTokenType.LONG_PARAMETER && !key2.endsWith("=");
        if (needEquality && !StringUtil.isEmpty((String)DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter)))) {
            result2.add(key2 + "=" + value2);
            return;
        }
        boolean bl2 = needSpace = !key2.startsWith("-");
        if (needSpace) {
            result2.add(key2);
            result2.add(value2);
            return;
        }
        result2.add(key2 + value2);
    }

    @NotNull
    private static String escapeAllQuotes(@NotNull String s2) {
        if (s2 == null) {
            DbCliUtil.$$$reportNull$$$0(105);
        }
        String string = StringUtil.escapeChars((String)s2, (char[])new char[]{'\\', '\"', '\''});
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(106);
        }
        return string;
    }

    private static void index(@NotNull Collection<? super CliLexeme> lexemes, @NotNull Lexer lexer) {
        IElementType type2;
        List<IElementType> toSkip;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(107);
        }
        if (lexer == null) {
            DbCliUtil.$$$reportNull$$$0(108);
        }
        if (ContainerUtil.containsIdentity(toSkip = Arrays.asList(DbCliTokenType.BAD, DbCliTokenType.VALUE), (Object)(type2 = Objects.requireNonNull(lexer.getTokenType())))) {
            return;
        }
        lexemes.add(DbCliUtil.lexeme(lexer));
    }

    @NotNull
    private static CliLexeme lexeme(@NotNull Lexer lexer) {
        if (lexer == null) {
            DbCliUtil.$$$reportNull$$$0(109);
        }
        return new CliLexeme(lexer.getTokenText(), Objects.requireNonNull(lexer.getTokenType()), lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private static boolean containsNonAlphaCharacters(@NotNull String value2) {
        if (value2 == null) {
            DbCliUtil.$$$reportNull$$$0(110);
        }
        for (int i2 = 0; i2 < value2.length(); ++i2) {
            if (Character.isLetter(value2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<CliLexeme> getLexemes(@NotNull String text2, @NotNull BiConsumer<? super List<CliLexeme>, ? super Lexer> consumer2) {
        if (text2 == null) {
            DbCliUtil.$$$reportNull$$$0(111);
        }
        if (consumer2 == null) {
            DbCliUtil.$$$reportNull$$$0(112);
        }
        ArrayList<CliLexeme> lexemes = new ArrayList<CliLexeme>();
        DbCliLexerAdapter lexer = new DbCliLexerAdapter();
        lexer.start(text2);
        while (lexer.getTokenType() != null) {
            consumer2.accept(lexemes, (Lexer)lexer);
            lexer.advance();
        }
        Collections.sort(lexemes);
        ArrayList<CliLexeme> arrayList = lexemes;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(113);
        }
        return arrayList;
    }

    @NotNull
    public static List<CliLexeme> filterLexemes(@NotNull List<? extends CliLexeme> lexemes, @NotNull List<String> parameterizable) {
        Pair<CliLexeme, Integer> lexemeOffset;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(114);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(115);
        }
        ArrayList<CliLexeme> result2 = new ArrayList<CliLexeme>();
        for (int i2 = 0; i2 < lexemes.size(); i2 += (Integer)lexemeOffset.getSecond() + 1) {
            lexemeOffset = DbCliUtil.getCurrentLexemeWithOffset(lexemes, i2);
            CliLexeme current = (CliLexeme)lexemeOffset.getFirst();
            CliLexeme previous = i2 == 0 ? new CliLexeme("", DbCliTokenType.BAD, 0, 0) : lexemes.get(i2 - 1);
            boolean isPrevParameterizable = DbCliUtil.isParameterizable(previous, parameterizable);
            if (!current.isArgument() && isPrevParameterizable) continue;
            result2.add(current);
        }
        ArrayList<CliLexeme> arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(116);
        }
        return arrayList;
    }

    @NotNull
    private static Pair<CliLexeme, Integer> getCurrentLexemeWithOffset(List<? extends CliLexeme> lexemes, int index2) {
        int offset = 0;
        while (index2 < lexemes.size() - 1 && lexemes.get(index2).isWhitespaceOrBad()) {
            ++index2;
            ++offset;
        }
        Pair pair = Pair.create((Object)lexemes.get(index2), (Object)offset);
        if (pair == null) {
            DbCliUtil.$$$reportNull$$$0(117);
        }
        return pair;
    }

    private static boolean isParameterizable(@NotNull CliLexeme lexeme, @NotNull List<String> parameterizable) {
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(118);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(119);
        }
        return ArrayUtil.contains((String)lexeme.getText(), (String[])new String[]{"<", ">"}) || lexeme.isArgument() && lexeme.getText().endsWith("=") || parameterizable.contains(lexeme.getText());
    }

    public static GeneralCommandLine buildCommandLine(List<String> args2) {
        GeneralCommandLine line = new GeneralCommandLine(args2);
        WslPath wslPath = WslPath.parseWindowsUncPath((String)line.getExePath());
        if (wslPath != null) {
            line = line.withExePath(wslPath.getLinuxPath());
            try {
                return wslPath.getDistribution().patchCommandLine(line, null, new WSLCommandLineOptions().setExecuteCommandInShell(false));
            }
            catch (ExecutionException e2) {
                return line;
            }
        }
        return line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 20, 22, 27, 30, 32, 34, 37, 40, 42, 48, 54, 55, 69, 71, 73, 75, 77, 81, 89, 106, 113, 116, 117 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: 
            case 24: 
            case 95: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: 
            case 7: 
            case 25: 
            case 96: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 22: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 48: 
            case 54: 
            case 55: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 89: 
            case 106: 
            case 113: 
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/DbCliUtil";
                break;
            }
            case 9: 
            case 19: 
            case 83: 
            case 86: 
            case 98: 
            case 115: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizable";
                break;
            }
            case 10: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 47: 
            case 49: 
            case 57: 
            case 91: 
            case 107: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
            case 13: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 72: 
            case 74: 
            case 76: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoter";
                break;
            }
            case 17: 
            case 80: 
            case 97: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: 
            case 43: 
            case 82: 
            case 85: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawLexemes";
                break;
            }
            case 29: 
            case 44: 
            case 50: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicators";
                break;
            }
            case 31: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 33: 
            case 58: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexeme";
                break;
            }
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 36: 
            case 39: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 45: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 66: 
            case 99: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 78: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 92: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/DbCliUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cutParameter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "lexemePairs";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineArguments";
                break;
            }
            case 22: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "lexemeFinder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "argumentFinder";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "argumentWithParameterFinder";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stringFinder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "fromElementsToSeparated";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "fromElementsFQNToSeparated";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablesNames";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "joinLexemes";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialProperty";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "pgQuote";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeAll";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "fromListToArgument";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "withEquality";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAllQuotes";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexemes";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLexemes";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLexemeWithOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cutParameter";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 22: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 48: 
            case 54: 
            case 55: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 89: 
            case 106: 
            case 113: 
            case 116: 
            case 117: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asParameterRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filteredLexemes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lexemePairs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearString";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineArguments";
                break;
            }
            case 21: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lexemeFinder";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "argumentFinder";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "argumentWithParameterFinder";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stringFinder";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fromElementsToSeparated";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fromElementsFQNToSeparated";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTablesNames";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCommandWithout";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getUserName";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "joinLexemes";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getIndexFromCommand";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialProperty";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasParameterAfterArgument";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "extractArguments";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "rawLexemes";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createLexeme";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createComponents";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "pgQuote";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unescapeAll";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "fromListToArgument";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValue";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValueRange";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "withEquality";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverLexemes";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getLastCharacterLexeme";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "appendArgument";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentWithParameter";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "escapeAllQuotes";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lexeme";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "containsNonAlphaCharacters";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getLexemes";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "filterLexemes";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "isParameterizable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 20, 22, 27, 30, 32, 34, 37, 40, 42, 48, 54, 55, 69, 71, 73, 75, 77, 81, 89, 106, 113, 116, 117 -> new IllegalStateException(string);
        };
    }

    public static interface CliLexemeConsumer {
        public void consume(@NotNull CliLexeme var1, @NotNull CliLexeme var2);
    }
}

