/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GeoViewer;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.content.Content;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GridGeoViewAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GridGeoViewAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        DataGrid grid;
        if (e2 == null) {
            GridGeoViewAction.$$$reportNull$$$0(1);
        }
        if ((grid = GridUtil.getDataGrid((DataContext)e2.getDataContext())) == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setVisible(true);
        if (!JBCefApp.isSupported()) {
            e2.getPresentation().setEnabled(false);
            e2.getPresentation().putClientProperty("ToolTipText", (Object)"Geo Viewer requires JCEF");
            return;
        }
        e2.getPresentation().putClientProperty("ToolTipText", null);
        boolean enabled = grid.getVisibleColumns().size() > 0;
        e2.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            GridGeoViewAction.$$$reportNull$$$0(2);
        }
        if (!JBCefApp.isSupported()) {
            GridGeoViewAction.suggestEnablingJCef(e2);
            return;
        }
        GeoViewer.show(e2);
    }

    private static void suggestEnablingJCef(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            GridGeoViewAction.$$$reportNull$$$0(3);
        }
        if (!PlatformUtils.isDataGrip()) {
            Messages.showWarningDialog((Project)e2.getProject(), (String)DatabaseBundle.message("jcef.not.available", new Object[0]), (String)DatabaseBundle.message("jcef.not.available.text", new Object[0]));
            return;
        }
        int res2 = Messages.showYesNoDialog((Project)e2.getProject(), (String)DatabaseBundle.message("enable.jcef.message", new Object[0]), (String)DatabaseBundle.message("enable.jcef", new Object[0]), (String)DatabaseBundle.message("enable.jcef", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (res2 == 0) {
            Registry.get((String)"ide.browser.jcef.enabled").setValue(true);
            RegistryBooleanOptionDescriptor.suggestRestart(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GridGeoViewAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GridGeoViewAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestEnablingJCef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public static class GridGeoViewCloseAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                GridGeoViewCloseAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                GridGeoViewCloseAction.$$$reportNull$$$0(1);
            }
            if (!JBCefApp.isSupported()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Content viewer = GeoViewer.getViewer(GeoViewer.getLogView(e2));
            e2.getPresentation().setEnabledAndVisible(viewer != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                GridGeoViewCloseAction.$$$reportNull$$$0(2);
            }
            GeoViewer.close(e2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GridGeoViewAction$GridGeoViewCloseAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GridGeoViewAction$GridGeoViewCloseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

