/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DbObjectsSEContributor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbObjectsGoToContributor;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.scopes.DbDataSourceScope;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbObjectCategory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.util.TypeVisibilityStateHolder;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0006,-./01B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u001e\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u001bH\u0014J\u001e\u0010\u001f\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\r\u0010%\u001a\u00070\u0013\u00a2\u0006\u0002\b&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0016J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor;", "Lcom/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)V", "DB_COMMAND", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereCommandInfo;", "myFilterStateService", "Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService;", "createModel", "Lcom/intellij/ide/util/gotoByName/FilteringGotoByModel;", "project", "Lcom/intellij/openapi/project/Project;", "createScopes", "", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "", "findEverywhereScope", "Lcom/intellij/psi/search/SearchScope;", "scopeDescriptors", "findProjectScope", "everywhereScope", "findScopeOrReturnSomething", "scopeId", "getActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "onChanged", "Ljava/lang/Runnable;", "getGroupName", "Lorg/jetbrains/annotations/Nls;", "getSortWeight", "", "getSupportedCommands", "isShownInSeparateTab", "", "Companion", "CustomFiltersAction", "Factory", "FilterStateService", "MyContributor", "MyGotoModel", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n31#2,2:362\n1045#3:364\n766#3:365\n857#3,2:366\n*S KotlinDebug\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor\n*L\n47#1:362,2\n80#1:364\n148#1:365\n148#1:366,2\n*E\n"})
public final class DbObjectsSEContributor
extends AbstractGotoSEContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchEverywhereCommandInfo DB_COMMAND;
    @NotNull
    private final FilterStateService myFilterStateService;

    public DbObjectsSEContributor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super(event);
        this.DB_COMMAND = new SearchEverywhereCommandInfo("db", DatabaseBundle.message("go.to.database.object", new Object[0]), (SearchEverywhereContributor)this);
        Object object = event.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        ComponentManager $this$service$iv = (ComponentManager)object;
        boolean $i$f$service = false;
        Class<FilterStateService> serviceClass$iv = FilterStateService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.myFilterStateService = (FilterStateService)object2;
    }

    public void fetchWeightedElements(@NotNull String pattern2, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        super.fetchWeightedElements(pattern2, progressIndicator, arg_0 -> DbObjectsSEContributor.fetchWeightedElements$lambda$0((Function1)new Function1<FoundItemDescriptor<Object>, Boolean>(consumer2){
            final /* synthetic */ Processor<? super FoundItemDescriptor<Object>> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            @NotNull
            public final Boolean invoke(FoundItemDescriptor<Object> descriptor2) {
                boolean bl;
                Object item = descriptor2.getItem();
                if (item instanceof ItemPresentation) {
                    String string = ((ItemPresentation)item).getPresentableText();
                    if (string == null) {
                        string = "";
                    }
                    TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).locationText(((ItemPresentation)item).getLocationString()).icon(((ItemPresentation)item).getIcon(true)).presentation();
                    Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
                    TargetPresentation presentation = targetPresentation;
                    bl = this.$consumer.process((Object)new FoundItemDescriptor((Object)new PSIPresentationBgRendererWrapper.ItemWithPresentation(item, presentation), descriptor2.getWeight()));
                } else {
                    bl = this.$consumer.process(descriptor2);
                }
                return bl;
            }
        }, arg_0));
    }

    @NotNull
    public String getGroupName() {
        String string = DatabaseBundle.message("go.to.table.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public int getSortWeight() {
        return 450;
    }

    public boolean isShownInSeparateTab() {
        return Companion.hasDatabaseTab(this.myProject);
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        Intrinsics.checkNotNullParameter((Object)onChanged, (String)"onChanged");
        JBIterable jBIterable = JBIterable.from((Iterable)DbPsiFacade.getInstance(this.myProject).getDataSources()).map(arg_0 -> DbObjectsSEContributor.getActions$lambda$1(getActions.dbmses.1.INSTANCE, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"unique(...)");
        Iterable $this$sortedBy$iv = (Iterable)jBIterable;
        boolean $i$f$sortedBy = false;
        List dbmses2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                Dbms it2 = (Dbms)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it2.getDisplayName());
                it2 = (Dbms)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getDisplayName())));
            }
        });
        PersistentSearchEverywhereContributorFilter dbmsFilter2 = new PersistentSearchEverywhereContributorFilter(dbmses2, (TypeVisibilityStateHolder)this.myFilterStateService.getMyDbmsState(), arg_0 -> DbObjectsSEContributor.getActions$lambda$3(getActions.dbmsFilter.1.INSTANCE, arg_0), arg_0 -> DbObjectsSEContributor.getActions$lambda$4(getActions.dbmsFilter.2.INSTANCE, arg_0));
        PersistentSearchEverywhereContributorFilter catFilter2 = new PersistentSearchEverywhereContributorFilter((List)DbObjectCategory.getEntries(), (TypeVisibilityStateHolder)this.myFilterStateService.getMyCategoryState(), arg_0 -> DbObjectsSEContributor.getActions$lambda$5(getActions.catFilter.1.INSTANCE, arg_0), arg_0 -> DbObjectsSEContributor.getActions$lambda$6((Function1)getActions.catFilter.2.INSTANCE, arg_0));
        List actions = CollectionsKt.toMutableList((Collection)this.doGetActions(dbmsFilter2, null, onChanged));
        actions.removeIf(arg_0 -> DbObjectsSEContributor.getActions$lambda$7(getActions.1.INSTANCE, arg_0));
        String string = DatabaseBundle.message("action.dbms.filter.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CustomFiltersAction dbmsFilterAction = new CustomFiltersAction(dbmsFilter2, onChanged, DbDataSourceScope.BADGED_DBMS, string);
        String string2 = DatabaseBundle.message("action.object.kind.filter.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CustomFiltersAction kindFilterAction = new CustomFiltersAction(catFilter2, onChanged, null, string2);
        dbmsFilterAction.getMyOther().add((ToggleAction)kindFilterAction);
        kindFilterAction.getMyOther().add((ToggleAction)dbmsFilterAction);
        actions.add(dbmsFilterAction);
        actions.add(kindFilterAction);
        return actions;
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        boolean dbOnlyCommands = DbObjectsSEContributor.Companion.isDbTabVisible(this.myProject);
        ArrayList<SearchEverywhereCommandInfo> result2 = new ArrayList<SearchEverywhereCommandInfo>();
        if (!dbOnlyCommands) {
            result2.add(this.DB_COMMAND);
        }
        for (DbObjectCategory cat : DbObjectCategory.getEntries()) {
            if (cat == DbObjectCategory.OTHER) continue;
            Object[] objectArray = new Object[]{cat.getDisplayName()};
            result2.add(new SearchEverywhereCommandInfo((String)(dbOnlyCommands ? cat.getId() : "db." + cat.getId()), IdeBundle.message((String)"go.to.class.title.prefix", (Object[])objectArray), (SearchEverywhereContributor)this));
        }
        return result2;
    }

    @NotNull
    public FilteringGotoByModel<?> createModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean isDbTab = DbObjectsSEContributor.Companion.isDbTabVisible(project);
        FilterStateService.SetState<Dbms> dbmses2 = this.myFilterStateService.getMyDbmsState().copy();
        FilterStateService.SetState<DbObjectCategory> categories = this.myFilterStateService.getMyCategoryState().copy();
        return new MyGotoModel(project, (Function1<? super DasObject, Boolean>)((Function1)new Function1<DasObject, Boolean>(isDbTab, dbmses2){
            final /* synthetic */ boolean $isDbTab;
            final /* synthetic */ FilterStateService.SetState<Dbms> $dbmses;
            {
                this.$isDbTab = $isDbTab;
                this.$dbmses = $dbmses;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DasObject it2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (this.$isDbTab) {
                    Dbms dbms = DbImplUtilCore.getDbms(it2);
                    Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                    bl = this.$dbmses.isVisible(dbms);
                } else {
                    bl = true;
                }
                return bl;
            }
        }), (Function1<? super DasObject, Boolean>)((Function1)new Function1<DasObject, Boolean>(isDbTab, categories){
            final /* synthetic */ boolean $isDbTab;
            final /* synthetic */ FilterStateService.SetState<DbObjectCategory> $categories;
            {
                this.$isDbTab = $isDbTab;
                this.$categories = $categories;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DasObject it2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (this.$isDbTab) {
                    ObjectKind objectKind = it2.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                    bl = this.$categories.isVisible(DbObjectCategory.Companion.detect(objectKind));
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    @NotNull
    protected SearchScope findProjectScope(@NotNull List<? extends ScopeDescriptor> scopeDescriptors, @NotNull SearchScope everywhereScope) {
        Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
        Intrinsics.checkNotNullParameter((Object)everywhereScope, (String)"everywhereScope");
        return everywhereScope;
    }

    @NotNull
    protected SearchScope findEverywhereScope(@NotNull List<? extends ScopeDescriptor> scopeDescriptors) {
        Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
        return this.findScopeOrReturnSomething(scopeDescriptors, "all");
    }

    private final SearchScope findScopeOrReturnSomething(List<? extends ScopeDescriptor> scopeDescriptors, String scopeId) {
        ScopeDescriptor found;
        ScopeDescriptor scopeDescriptor = Companion.findScopeById(scopeDescriptors, scopeId);
        if (scopeDescriptor == null) {
            scopeDescriptor = (ScopeDescriptor)CollectionsKt.firstOrNull(scopeDescriptors);
        }
        ScopeDescriptor scopeDescriptor2 = found = scopeDescriptor;
        Object object = scopeDescriptor2 != null ? scopeDescriptor2.getScope() : null;
        if (object == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            object = (SearchScope)globalSearchScope;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ScopeDescriptor> createScopes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = super.createScopes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScopeDescriptor it2 = (ScopeDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!it2.scopeEquals(null) && it2.getScope() instanceof DbDataSourceScope)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean fetchWeightedElements$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Dbms getActions$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Dbms)$tmp0.invoke(p0);
    }

    private static final String getActions$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Icon getActions$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Icon)$tmp0.invoke(p0);
    }

    private static final String getActions$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Icon getActions$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Icon)$tmp0.invoke(p0);
    }

    private static final boolean getActions$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @NotNull
    public static final String getTabId() {
        return Companion.getTabId();
    }

    @JvmStatic
    public static final boolean hasDatabaseTab(@NotNull Project project) {
        return Companion.hasDatabaseTab(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$Companion;", "", "()V", "tabId", "", "getTabId$annotations", "getTabId", "()Ljava/lang/String;", "findCategory", "Lkotlin/Pair;", "Lcom/intellij/database/util/DbObjectCategory;", "pattern", "findScopeById", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "scopeDescriptors", "", "scopeId", "getScopeId", "scope", "hasDatabaseTab", "", "project", "Lcom/intellij/openapi/project/Project;", "hasScopeId", "isCommandEnd", "start", "", "isDbTabVisible", "skipWhitespaces", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTabId() {
            String string = DbObjectsSEContributor.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getTabId$annotations() {
        }

        @JvmStatic
        public final boolean hasDatabaseTab(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PlatformUtils.isDataGrip() || AdvancedSettings.Companion.getBoolean("database.show.search.tab") && !DbPsiFacade.getInstance(project).getDataSources().isEmpty();
        }

        @Nullable
        public final ScopeDescriptor findScopeById(@NotNull List<? extends ScopeDescriptor> scopeDescriptors, @NotNull String scopeId) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
                Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
                Iterable iterable = scopeDescriptors;
                for (Object t : iterable) {
                    ScopeDescriptor it2 = (ScopeDescriptor)t;
                    boolean bl = false;
                    if (!Companion.hasScopeId(it2, scopeId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean hasScopeId(@NotNull ScopeDescriptor scope, @NotNull String scopeId) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
            return Intrinsics.areEqual((Object)this.getScopeId(scope), (Object)scopeId);
        }

        @Nullable
        public final String getScopeId(@NotNull ScopeDescriptor scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            SearchScope searchScope = scope.getScope();
            DbDataSourceScope dbDataSourceScope = searchScope instanceof DbDataSourceScope ? (DbDataSourceScope)searchScope : null;
            return dbDataSourceScope != null ? dbDataSourceScope.getScopeId() : null;
        }

        private final boolean isDbTabVisible(Project project) {
            SearchEverywhereManager manager = SearchEverywhereManager.getInstance((Project)project);
            return !manager.isShown() || Intrinsics.areEqual((Object)this.getTabId(), (Object)manager.getSelectedTabID());
        }

        private final Pair<DbObjectCategory, String> findCategory(String pattern2) {
            String accelerator = SearchTopHitProvider.Companion.getTopHitAccelerator();
            if (!StringsKt.startsWith$default((String)pattern2, (String)accelerator, (boolean)false, (int)2, null)) {
                return null;
            }
            int start2 = accelerator.length();
            if (StringUtil.startsWith((CharSequence)pattern2, (int)start2, (CharSequence)"db")) {
                if (this.isCommandEnd(pattern2, start2 += 2)) {
                    start2 = this.skipWhitespaces(pattern2, start2);
                    String string = pattern2.substring(start2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return new Pair(null, (Object)string);
                }
                if (pattern2.charAt(start2) != '.') {
                    return null;
                }
                ++start2;
            }
            for (DbObjectCategory cat : DbObjectCategory.getEntries()) {
                if (!StringUtil.startsWith((CharSequence)pattern2, (int)start2, (CharSequence)cat.getId())) continue;
                start2 = this.skipWhitespaces(pattern2, start2 + cat.getId().length());
                String string = pattern2.substring(start2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return new Pair((Object)cat, (Object)string);
            }
            return null;
        }

        private final boolean isCommandEnd(String pattern2, int start2) {
            return pattern2.length() <= start2 || Character.isWhitespace(pattern2.charAt(start2));
        }

        private final int skipWhitespaces(String pattern2, int start2) {
            int idx;
            for (idx = start2; idx < pattern2.length() && Character.isWhitespace(pattern2.charAt(idx)); ++idx) {
            }
            return idx;
        }

        public static final /* synthetic */ Pair access$findCategory(Companion $this, String pattern2) {
            return $this.findCategory(pattern2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B2\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction;", "T", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFiltersAction;", "filter", "Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;", "onChanged", "Ljava/lang/Runnable;", "myIcon", "Lcom/intellij/ui/BadgeIconSupplier;", "myDescription", "", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "(Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;Ljava/lang/Runnable;Lcom/intellij/ui/BadgeIconSupplier;Ljava/lang/String;)V", "myOther", "", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getMyOther", "()Ljava/util/List;", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "", "update", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n1855#2,2:362\n*S KotlinDebug\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction\n*L\n291#1:362,2\n*E\n"})
    private static final class CustomFiltersAction<T>
    extends SearchEverywhereFiltersAction<T> {
        @Nullable
        private final BadgeIconSupplier myIcon;
        @NotNull
        private final String myDescription;
        @NotNull
        private final List<ToggleAction> myOther;

        public CustomFiltersAction(@NotNull PersistentSearchEverywhereContributorFilter<T> filter2, @NotNull Runnable onChanged, @Nullable BadgeIconSupplier myIcon, @NotNull String myDescription) {
            Intrinsics.checkNotNullParameter(filter2, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)onChanged, (String)"onChanged");
            Intrinsics.checkNotNullParameter((Object)myDescription, (String)"myDescription");
            super(filter2, onChanged);
            this.myIcon = myIcon;
            this.myDescription = myDescription;
            this.myOther = new ArrayList();
        }

        @NotNull
        public final List<ToggleAction> getMyOther() {
            return this.myOther;
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            super.update(e2);
            if (this.myIcon != null) {
                e2.getPresentation().setIcon(this.myIcon.getLiveIndicatorIcon(this.isActive()));
            }
            e2.getPresentation().setDescription(this.myDescription);
        }

        public void setSelected(@NotNull AnActionEvent e2, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            super.setSelected(e2, state);
            if (state) {
                Iterable $this$forEach$iv = this.myOther;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ToggleAction it2 = (ToggleAction)element$iv;
                    boolean bl = false;
                    it2.setSelected(e2, false);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$Factory;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributorFactory;", "", "()V", "createContributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "initEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            Intrinsics.checkNotNullParameter((Object)initEvent, (String)"initEvent");
            WeightedSearchEverywhereContributor weightedSearchEverywhereContributor = PSIPresentationBgRendererWrapper.wrapIfNecessary((AbstractGotoSEContributor)new DbObjectsSEContributor(initEvent));
            Intrinsics.checkNotNullExpressionValue((Object)weightedSearchEverywhereContributor, (String)"wrapIfNecessary(...)");
            return (SearchEverywhereContributor)weightedSearchEverywhereContributor;
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService;", "", "()V", "myCategoryState", "Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "Lcom/intellij/database/util/DbObjectCategory;", "getMyCategoryState", "()Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "myDbmsState", "Lcom/intellij/database/Dbms;", "getMyDbmsState", "SetState", "intellij.database.impl"})
    private static final class FilterStateService {
        @NotNull
        private final SetState<Dbms> myDbmsState = new SetState();
        @NotNull
        private final SetState<DbObjectCategory> myCategoryState = new SetState();

        public FilterStateService() {
            this.myCategoryState.setVisible(DbObjectCategory.COLUMNS, false);
            this.myCategoryState.setVisible(DbObjectCategory.SERVERS, false);
            this.myCategoryState.setVisible(DbObjectCategory.ROLES, false);
            this.myCategoryState.setVisible(DbObjectCategory.CONSTRAINTS, false);
            this.myCategoryState.setVisible(DbObjectCategory.INDICES, false);
            this.myCategoryState.setVisible(DbObjectCategory.OTHER, false);
        }

        @NotNull
        public final SetState<Dbms> getMyDbmsState() {
            return this.myDbmsState;
        }

        @NotNull
        public final SetState<DbObjectCategory> getMyCategoryState() {
            return this.myCategoryState;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "T", "Lcom/intellij/ide/util/TypeVisibilityStateHolder;", "()V", "myHiddenItems", "", "copy", "isVisible", "", "type", "(Ljava/lang/Object;)Z", "setVisible", "", "value", "(Ljava/lang/Object;Z)V", "intellij.database.impl"})
        public static final class SetState<T>
        implements TypeVisibilityStateHolder<T> {
            @NotNull
            private final Set<T> myHiddenItems;

            public SetState() {
                Set set = Collections.synchronizedSet(new HashSet());
                Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
                this.myHiddenItems = set;
            }

            public void setVisible(T type2, boolean value2) {
                if (value2) {
                    this.myHiddenItems.remove(type2);
                } else {
                    this.myHiddenItems.add(type2);
                }
            }

            public boolean isVisible(T type2) {
                return !this.myHiddenItems.contains(type2);
            }

            @NotNull
            public final SetState<T> copy() {
                SetState<T> res2 = new SetState<T>();
                res2.myHiddenItems.addAll((Collection)this.myHiddenItems);
                return res2;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$MyContributor;", "Lcom/intellij/database/psi/DbObjectsGoToContributor;", "myDbmsFilter", "Lkotlin/Function1;", "Lcom/intellij/database/model/DasObject;", "", "myCatFilter", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getMyCatFilter", "()Lkotlin/jvm/functions/Function1;", "setMyCatFilter", "(Lkotlin/jvm/functions/Function1;)V", "filterObjects", "Lcom/intellij/util/containers/JBIterable;", "objects", "", "intellij.database.impl"})
    private static final class MyContributor
    extends DbObjectsGoToContributor {
        @NotNull
        private final Function1<DasObject, Boolean> myDbmsFilter;
        @NotNull
        private Function1<? super DasObject, Boolean> myCatFilter;

        public MyContributor(@NotNull Function1<? super DasObject, Boolean> myDbmsFilter, @NotNull Function1<? super DasObject, Boolean> myCatFilter) {
            Intrinsics.checkNotNullParameter(myDbmsFilter, (String)"myDbmsFilter");
            Intrinsics.checkNotNullParameter(myCatFilter, (String)"myCatFilter");
            this.myDbmsFilter = myDbmsFilter;
            this.myCatFilter = myCatFilter;
        }

        @NotNull
        public final Function1<DasObject, Boolean> getMyCatFilter() {
            return this.myCatFilter;
        }

        public final void setMyCatFilter(@NotNull Function1<? super DasObject, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.myCatFilter = function1;
        }

        @NotNull
        public JBIterable<DasObject> filterObjects(@NotNull Iterable<? extends DasObject> objects2) {
            Intrinsics.checkNotNullParameter(objects2, (String)"objects");
            JBIterable jBIterable = super.filterObjects(objects2).filter(arg_0 -> MyContributor.filterObjects$lambda$0((Function1)new Function1<DasObject, Boolean>(this.myCatFilter){

                @NotNull
                public final Boolean invoke(@NotNull DasObject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (Boolean)((Function1)this.receiver).invoke((Object)p0);
                }
            }, arg_0)).filter(arg_0 -> MyContributor.filterObjects$lambda$1((Function1)new Function1<DasObject, Boolean>(this.myDbmsFilter){

                @NotNull
                public final Boolean invoke(@NotNull DasObject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (Boolean)((Function1)this.receiver).invoke((Object)p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        private static final boolean filterObjects$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean filterObjects$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018J\n\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u000fH\u0016J\b\u0010%\u001a\u00020\u000fH\u0016J\u0019\u0010&\u001a\u00130\u000f\u00a2\u0006\u000e\b'\u0012\n\b(\u0012\u0006\b\n0)8*H\u0016J\u0013\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010,\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\bH\u0016J\b\u0010/\u001a\u00020\bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\r\u001a(\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0014\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$MyGotoModel;", "Lcom/intellij/ide/util/gotoByName/FilteringGotoByModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbmsFilter", "Lkotlin/Function1;", "Lcom/intellij/database/model/DasObject;", "", "catFilter", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "myContributor", "Lcom/intellij/database/actions/DbObjectsSEContributor$MyContributor;", "mySeparators", "", "", "kotlin.jvm.PlatformType", "getMySeparators", "()[Ljava/lang/String;", "mySeparators$delegate", "Lkotlin/Lazy;", "filterValueFor", "item", "Lcom/intellij/navigation/NavigationItem;", "(Lcom/intellij/navigation/NavigationItem;)Lkotlin/Unit;", "getCheckBoxName", "getContributorList", "", "Lcom/intellij/navigation/ChooseByNameContributor;", "getFullName", "element", "", "getItemProvider", "Lcom/intellij/ide/util/gotoByName/ChooseByNameItemProvider;", "context", "Lcom/intellij/psi/PsiElement;", "getNotFoundMessage", "getNotInMessage", "getPromptText", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getSeparators", "loadInitialCheckBoxState", "saveInitialCheckBoxState", "state", "willOpenEditor", "intellij.database.impl"})
    private static final class MyGotoModel
    extends FilteringGotoByModel<Unit> {
        @NotNull
        private final Lazy mySeparators$delegate;
        @NotNull
        private final MyContributor myContributor;

        public MyGotoModel(@NotNull Project project, @NotNull Function1<? super DasObject, Boolean> dbmsFilter2, @NotNull Function1<? super DasObject, Boolean> catFilter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(dbmsFilter2, (String)"dbmsFilter");
            Intrinsics.checkNotNullParameter(catFilter2, (String)"catFilter");
            super(project, CollectionsKt.emptyList());
            this.mySeparators$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String[]>(this){
                final /* synthetic */ MyGotoModel this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String[] invoke() {
                    return GotoClassModel2.getSeparatorsFromContributors((ChooseByNameContributor[])MyGotoModel.access$getContributors(this.this$0));
                }
            }));
            this.myContributor = new MyContributor(dbmsFilter2, catFilter2);
        }

        private final String[] getMySeparators() {
            Lazy lazy = this.mySeparators$delegate;
            return (String[])lazy.getValue();
        }

        @Nullable
        protected Unit filterValueFor(@NotNull NavigationItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return null;
        }

        @NotNull
        protected List<ChooseByNameContributor> getContributorList() {
            return CollectionsKt.listOf((Object)this.myContributor);
        }

        @NotNull
        public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context) {
            return (ChooseByNameItemProvider)new DefaultChooseByNameItemProvider(context, this){
                final /* synthetic */ MyGotoModel this$0;
                {
                    this.this$0 = $receiver;
                    super($context);
                }

                public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
                    FindSymbolParameters findSymbolParameters;
                    Intrinsics.checkNotNullParameter((Object)base, (String)"base");
                    Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
                    String string = parameters2.getCompletePattern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCompletePattern(...)");
                    Pair category = com.intellij.database.actions.DbObjectsSEContributor$Companion.access$findCategory(DbObjectsSEContributor.Companion, string);
                    if (category != null) {
                        MyGotoModel.access$getMyContributor$p(this.this$0).setMyCatFilter((Function1<? super DasObject, Boolean>)((Function1)new Function1<DasObject, Boolean>((Pair<? extends DbObjectCategory, String>)category){
                            final /* synthetic */ Pair<DbObjectCategory, String> $category;
                            {
                                this.$category = $category;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull DasObject it2) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                DbObjectCategory dbObjectCategory = (DbObjectCategory)((Object)this.$category.getFirst());
                                if (dbObjectCategory != null) {
                                    ObjectKind objectKind = it2.getKind();
                                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                                    bl = dbObjectCategory.contains(objectKind);
                                } else {
                                    bl = true;
                                }
                                return bl;
                            }
                        }));
                        findSymbolParameters = parameters2.withCompletePattern((String)category.getSecond());
                    } else {
                        findSymbolParameters = parameters2;
                    }
                    FindSymbolParameters newParameters2 = findSymbolParameters;
                    return super.filterElementsWithWeights(base, newParameters2, indicator, consumer2);
                }
            };
        }

        @NotNull
        public String getPromptText() {
            Object[] objectArray = new Object[]{StringUtil.toLowerCase((String)this.myContributor.getElementKind())};
            String string = IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getNotInMessage() {
            String string = IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
            return string;
        }

        @NotNull
        public String getNotFoundMessage() {
            String string = IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
            return string;
        }

        @Nullable
        public String getCheckBoxName() {
            return null;
        }

        public boolean loadInitialCheckBoxState() {
            return false;
        }

        public void saveInitialCheckBoxState(boolean state) {
        }

        @NotNull
        public String[] getSeparators() {
            String[] stringArray = this.getMySeparators();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"<get-mySeparators>(...)");
            return stringArray;
        }

        @Nullable
        public String getFullName(@NotNull Object element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return this.myContributor.getQualifiedName((NavigationItem)element2);
        }

        public boolean willOpenEditor() {
            return true;
        }

        public static final /* synthetic */ MyContributor access$getMyContributor$p(MyGotoModel $this) {
            return $this.myContributor;
        }

        public static final /* synthetic */ ChooseByNameContributor[] access$getContributors(MyGotoModel $this) {
            return $this.getContributors();
        }
    }
}

