/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "", "Companion", "DbContextTemplateAction", "intellij.database.impl"})
public final class DbContextTemplateGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dataContext);
        e2.getPresentation().setEnabledAndVisible(ranks.size() == 1 && ranks.contains(DvTreeNodeRank.TL_ELEMENT));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        if (e2 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        DbElement dbElement = DbContextTemplateGroup.Companion.getTargetObject(e2);
        if (dbElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        DbElement target2 = dbElement;
        Dbms dbms = target2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        TemplateContextType templateContextType = DbContextTemplateGroup.Companion.getContextType(dbms);
        if (templateContextType == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        TemplateContextType contextType = templateContextType;
        List templates = DbContextTemplateGroup.Companion.getApplicableTemplates(contextType);
        if (templates.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        int n = 0;
        int n3 = templates.size() + 1;
        AnAction[] anActionArray = new AnAction[n3];
        while (n < n3) {
            int n4 = n++;
            anActionArray[n4] = null;
        }
        AnAction[] result2 = anActionArray;
        result2[0] = Separator.getInstance();
        Iterator iterator = templates.iterator();
        n3 = 0;
        while (iterator.hasNext()) {
            int i2 = n3++;
            TemplateImpl template = (TemplateImpl)iterator.next();
            result2[i2 + 1] = new DbContextTemplateAction(template);
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$Companion;", "", "()V", "getApplicableTemplates", "", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "contextType", "Lcom/intellij/codeInsight/template/TemplateContextType;", "getContextType", "dbms", "Lcom/intellij/database/Dbms;", "getTargetObject", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbContextTemplateGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbContextTemplateGroup.kt\ncom/intellij/database/actions/DbContextTemplateGroup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n288#2,2:108\n766#2:110\n857#2:111\n1747#2,3:112\n858#2:115\n288#2,2:116\n288#2,2:118\n1#3:120\n*S KotlinDebug\n*F\n+ 1 DbContextTemplateGroup.kt\ncom/intellij/database/actions/DbContextTemplateGroup$Companion\n*L\n85#1:108,2\n86#1:110\n86#1:111\n87#1:112,3\n86#1:115\n94#1:116,2\n95#1:118,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<TemplateImpl> getApplicableTemplates(TemplateContextType contextType) {
            void $this$filterTo$iv$iv;
            Object v1;
            block6: {
                List list = TemplateSettings.getInstance().getTemplateGroups();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTemplateGroups(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TemplateGroup it2 = (TemplateGroup)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"SQL")) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            TemplateGroup templateGroup = v1;
            if (templateGroup == null) {
                return CollectionsKt.emptyList();
            }
            TemplateGroup group2 = templateGroup;
            List list = group2.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElements(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable $i$f$firstOrNull = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                TemplateImpl template;
                block7: {
                    template = (TemplateImpl)element$iv$iv;
                    boolean bl2 = false;
                    ArrayList arrayList = template.getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getVariables(...)");
                    Iterable $this$any$iv = arrayList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Variable it3 = (Variable)element$iv;
                            boolean bl3 = false;
                            Expression expression = it3.getExpression();
                            MacroCallNode macroCallNode = expression instanceof MacroCallNode ? (MacroCallNode)expression : null;
                            if (!((macroCallNode != null ? macroCallNode.getMacro() : null) instanceof DbContextMacroBase)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                boolean bl4 = bl && template.getTemplateContext().isEnabled(contextType);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final TemplateContextType getContextType(Dbms dbms) {
            TemplateContextType templateContextType;
            Object v1;
            TemplateContextType it2;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            List allTemplates;
            block3: {
                List list = TemplateContextTypes.getAllContextTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllContextTypes(...)");
                allTemplates = list;
                $this$firstOrNull$iv = allTemplates;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it2 = (TemplateContextType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getContextId(), (Object)("SQL_QUERY_" + dbms.getName()))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((templateContextType = (TemplateContextType)v1) == null) {
                Object v3;
                block4: {
                    $this$firstOrNull$iv = allTemplates;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it2 = (TemplateContextType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getContextId(), (Object)"SQL_QUERY")) continue;
                        v3 = element$iv;
                        break block4;
                    }
                    v3 = null;
                }
                templateContextType = v3;
            }
            return templateContextType;
        }

        private final DbElement getTargetObject(AnActionEvent e2) {
            DasTable gridTable;
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = GridUtil.getDataGrid((DataContext)e2.getDataContext());
            if (dataGrid2 != null) {
                DataGrid it2 = dataGrid2;
                boolean bl = false;
                v1 = DataGridUtil.getDatabaseTable(it2);
            } else {
                v1 = gridTable = null;
            }
            if (gridTable instanceof DbElement) {
                return (DbElement)((Object)gridTable);
            }
            DatabaseView databaseView = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY);
            if (databaseView == null) {
                return null;
            }
            DatabaseView databaseView2 = databaseView;
            Object[] objectArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)databaseView2);
            PsiElement psiElement = objectArray != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : null;
            return psiElement instanceof DbElement ? (DbElement)psiElement : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$DbContextTemplateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "template", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "(Lcom/intellij/codeInsight/template/impl/TemplateImpl;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPresentableText", "", "update", "intellij.database.impl"})
    private static final class DbContextTemplateAction
    extends DumbAwareAction {
        @NotNull
        private final TemplateImpl template;

        public DbContextTemplateAction(@NotNull TemplateImpl template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            this.template = template;
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Presentation presentation = e2.getPresentation();
            String string = this.template.getDescription();
            if (string == null) {
                string = "";
            }
            presentation.setText(StringUtil.capitalize((String)string));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            DbElement dbElement = Companion.getTargetObject(e2);
            if (dbElement == null) {
                return;
            }
            DbElement target2 = dbElement;
            Project project = target2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            boolean preferExisting = DatabaseSettings.getSettings().contextTemplateTarget == DatabaseSettings.ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
            Editor editor2 = DbActionUtils.findOrCreateEditor(target2, preferExisting);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            DbActionUtils.moveCaretToEnd(editor3);
            editor3.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), new SoftReference<DbElement>(target2));
            TemplateEditingAdapter listener2 = new TemplateEditingAdapter(editor3){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                }

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }

                public void templateCancelled(@Nullable Template template) {
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }
            };
            TemplateManager.getInstance((Project)project2).startTemplate(editor3, (Template)this.template, (TemplateEditingListener)listener2);
        }

        @NlsSafe
        private final String getPresentableText(TemplateImpl template) {
            String string = template.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
    }
}

