/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.core;

import com.intellij.bigdatatools.visualization.charts.core.ChartPlotPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.component.PlotComponentProvider;
import org.jetbrains.letsPlot.commons.registration.Disposable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/ChartPlotPanel;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "plotComponentProvider", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;", "(Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;)V", "currentRebuildTask", "Ljava/util/concurrent/Future;", "lastPreferredSize", "Ljava/awt/Dimension;", "recreateComponentFuture", "Ljava/util/concurrent/ScheduledFuture;", "showProgressFuture", "cancelScheduledTasks", "", "dispose", "handleChildRemovedIntern", "child", "Ljava/awt/Component;", "rebuildPlotComponent", "showProgress", "intellij.charts"})
public class ChartPlotPanel
extends JPanel
implements Disposable {
    @NotNull
    private final PlotComponentProvider plotComponentProvider;
    @Nullable
    private Dimension lastPreferredSize;
    @Nullable
    private ScheduledFuture<?> showProgressFuture;
    @Nullable
    private ScheduledFuture<?> recreateComponentFuture;
    @Nullable
    private Future<?> currentRebuildTask;

    public ChartPlotPanel(@NotNull PlotComponentProvider plotComponentProvider) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        super(new BorderLayout());
        this.plotComponentProvider = plotComponentProvider;
        this.setOpaque(false);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(@NotNull ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component2 = e.getChild();
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getChild(...)");
                this.handleChildRemovedIntern(component2);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.cancelScheduledTasks();
                showProgressFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ChartPlotPanel.access$showProgress(this), 1000L, TimeUnit.MILLISECONDS);
                recreateComponentFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ChartPlotPanel.access$rebuildPlotComponent(this), 200L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.cancelScheduledTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelScheduledTasks() {
        try {
            ScheduledFuture<?> scheduledFuture = this.showProgressFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this.showProgressFuture = null;
        }
        try {
            ScheduledFuture<?> scheduledFuture = this.recreateComponentFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this.recreateComponentFuture = null;
        }
        try {
            Future<?> future = this.currentRebuildTask;
            if (future != null) {
                future.cancel(true);
            }
        }
        finally {
            this.currentRebuildTask = null;
        }
    }

    private final void handleChildRemovedIntern(Component child) {
        Component component2 = child;
        if (component2 instanceof Disposable) {
            ((Disposable)((Object)child)).dispose();
        } else if (component2 instanceof JScrollPane) {
            Component component3 = ((JScrollPane)child).getViewport().getView();
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getView(...)");
            this.handleChildRemovedIntern(component3);
        }
    }

    private final void showProgress() {
        DialogPanel dialogPanel;
        this.removeAll();
        DialogPanel $this$showProgress_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)showProgress.loadingPanel.1.INSTANCE);
        boolean bl = false;
        $this$showProgress_u24lambda_u240.setOpaque(false);
        DialogPanel loadingPanel2 = dialogPanel;
        this.add((Component)loadingPanel2);
        this.revalidate();
        this.repaint();
    }

    private final void rebuildPlotComponent() {
        Runnable action2 = () -> ChartPlotPanel.rebuildPlotComponent$lambda$1(this);
        this.currentRebuildTask = ApplicationManager.getApplication().executeOnPooledThread(action2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void rebuildPlotComponent$lambda$1(ChartPlotPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Dimension plotContainerSize = this$0.getSize();
        if (plotContainerSize == null) {
            return;
        }
        Dimension preferredSize = this$0.plotComponentProvider.getPreferredSize(plotContainerSize);
        if (Intrinsics.areEqual((Object)this$0.lastPreferredSize, (Object)preferredSize)) {
            return;
        }
        this$0.lastPreferredSize = preferredSize;
        JComponent providedComponent = this$0.plotComponentProvider.createComponent(plotContainerSize);
        try {
            ScheduledFuture<?> scheduledFuture = this$0.showProgressFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this$0.showProgressFuture = null;
        }
        this$0.removeAll();
        this$0.add(providedComponent);
        this$0.revalidate();
        this$0.repaint();
        this$0.currentRebuildTask = null;
    }

    public static final /* synthetic */ void access$showProgress(ChartPlotPanel $this) {
        $this.showProgress();
    }

    public static final /* synthetic */ void access$rebuildPlotComponent(ChartPlotPanel $this) {
        $this.rebuildPlotComponent();
    }
}

