/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.analyser.checkers;

import com.intellij.bigdatatools.visualization.charts.analyser.checkers.SeriesChecker;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnModifier;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.StockSeriesSettings;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.ColumnId;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/StockSeriesChecker;", "Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/SeriesChecker;", "()V", "check", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "intellij.charts"})
public final class StockSeriesChecker
implements SeriesChecker {
    @Override
    @NotNull
    public List<SeriesSettings> check(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        List<Column<Number>> numericalColumns = SeriesChecker.Companion.getNumericalColumns(dataFrame);
        List<Column<String>> stringColumns = SeriesChecker.Companion.getStringColumns(dataFrame);
        if (numericalColumns.size() < 4 || stringColumns.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ColumnId columnId = dataFrame.getColumnId((Column)CollectionsKt.first(stringColumns));
        if (columnId == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId xColumnId = columnId;
        Set foundColumns = new LinkedHashSet();
        ColumnId openColumnId = StockSeriesChecker.check$findStockColumn(numericalColumns, dataFrame, foundColumns, "open");
        ColumnId closeColumnId = StockSeriesChecker.check$findStockColumn(numericalColumns, dataFrame, foundColumns, "close");
        ColumnId highColumnId = StockSeriesChecker.check$findStockColumn(numericalColumns, dataFrame, foundColumns, "high");
        ColumnId lowColumnId = StockSeriesChecker.check$findStockColumn(numericalColumns, dataFrame, foundColumns, "low");
        if (openColumnId == null || closeColumnId == null || highColumnId == null || lowColumnId == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new StockSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(xColumnId, ColumnModifier.None)), null, new ColumnSettings(openColumnId, null, 2, null), new ColumnSettings(closeColumnId, null, 2, null), new ColumnSettings(highColumnId, null, 2, null), new ColumnSettings(lowColumnId, null, 2, null), false, 66, null));
    }

    /*
     * Unable to fully structure code
     */
    private static final ColumnId check$findStockColumn(List<? extends Column<Number>> numericalColumns, DataFrame $dataFrame, Set<ColumnId> foundColumns, String namePart) {
        block5: {
            var6_4 = numericalColumns;
            for (T var8_6 : var6_4) {
                it = (Column)var8_6;
                $i$a$-find-StockSeriesChecker$check$findStockColumn$found$1 = false;
                if (CollectionsKt.contains((Iterable)foundColumns, (Object)$dataFrame.getColumnId(it))) ** GOTO lbl-1000
                v0 = it.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)v0, (CharSequence)namePart, (boolean)false, (int)2, null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = var8_6;
                break block5;
            }
            v2 = null;
        }
        v3 = v2;
        if (v3 == null) {
            return null;
        }
        found = v3;
        v4 = $dataFrame.getColumnId(found);
        if (v4 == null) {
            return null;
        }
        id = v4;
        ((Collection)foundColumns).add(id);
        return id;
    }
}

