/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.google;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.testing.google.CMakeGoogleTestRunConfigurationType;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkDetector;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CMakeGoogleTestFrameworkDetector
implements CidrTestFrameworkDetector {
    private static final Set<String> GOOGLE_TEST_MACRO_PLUS_NAMES = new HashSet<String>();
    @NonNls
    private static final String[] GOOGLE_TEST_STANDARD_LIBS;

    public boolean hasTestConfiguration(@NotNull CidrBuildTarget<?> target, @NotNull CidrBuildConfigurationHelper<? extends CidrBuildConfiguration, ? extends CidrBuildTarget<?>> helper) {
        if (target == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(1);
        }
        if (target instanceof CMakeTarget && helper instanceof CMakeBuildConfigurationHelper) {
            return CMakeGoogleTestFrameworkDetector.isGoogleTestTarget((CMakeTarget)target, (CMakeBuildConfigurationHelper)helper);
        }
        return false;
    }

    @NotNull
    public CMakeGoogleTestRunConfigurationType getTestConfigurationType() {
        CMakeGoogleTestRunConfigurationType cMakeGoogleTestRunConfigurationType = CMakeGoogleTestRunConfigurationType.getInstance();
        if (cMakeGoogleTestRunConfigurationType == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(2);
        }
        return cMakeGoogleTestRunConfigurationType;
    }

    @NotNull
    @RegExp
    public String getTestHeaderName() {
        return "gtest[.]h";
    }

    @NotNull
    public Collection<String> getTestMacros() {
        Set<String> set = GOOGLE_TEST_MACRO_PLUS_NAMES;
        if (set == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static boolean isGoogleTestTarget(@NotNull CMakeTarget target, @NotNull CMakeBuildConfigurationHelper helper) {
        CMakeConfiguration config;
        if (target == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            CMakeGoogleTestFrameworkDetector.$$$reportNull$$$0(5);
        }
        if (target.isExecutable() && (config = (CMakeConfiguration)helper.getDefaultConfiguration((CidrBuildTarget)target)) != null) {
            @NonNls HashSet<E> gtLibNames = new HashSet();
            Arrays.asList(GOOGLE_TEST_STANDARD_LIBS).forEach(libTargetName -> {
                gtLibNames.add("lib" + libTargetName + ".a");
                gtLibNames.add(libTargetName + ".lib");
            });
            return null != ContainerUtil.find((Iterable)config.getLinkerFlags(), it -> gtLibNames.contains(StringUtil.toLowerCase((String)PathUtil.getFileName((String)it))));
        }
        return false;
    }

    static {
        GOOGLE_TEST_MACRO_PLUS_NAMES.addAll(CidrGoogleTestConstants.GOOGLE_TEST_MACRO_NAMES);
        GOOGLE_TEST_MACRO_PLUS_NAMES.add("testing::");
        GOOGLE_TEST_STANDARD_LIBS = new String[]{"gtest", "gtest_main", "gmock", "gmock_main"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/google/CMakeGoogleTestFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/google/CMakeGoogleTestFrameworkDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestConfigurationType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasTestConfiguration";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGoogleTestTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

