/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.js.utils;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.ml.inline.completion.js.utils.JSDialectMLCompletionLexer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J(\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J.\u0010 \u001a\u00020\u0011*\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110%H\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "dialectOptionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;Lcom/intellij/lang/javascript/DialectOptionHolder;)V", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "collectBracket", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "createBaseLexer", "Lcom/intellij/lang/javascript/JSFlexAdapter;", "findStringMarkers", "getLexingResult", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexer$LexingResult;", "lexemes", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexeme;", "lexer", "Lcom/intellij/lexer/Lexer;", "onBracketToken", "onToken", "update", "Lcom/intellij/openapi/util/UserDataHolder;", "key", "Lcom/intellij/openapi/util/Key;", "value", "Lkotlin/Function1;", "Companion", "intellij.ml.inline.completion.js"})
@SourceDebugExtension(value={"SMAP\nJSTSEnclosuresLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTSEnclosuresLexer.kt\ncom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,159:1\n1747#2,3:160\n1726#2,3:169\n959#2,7:172\n163#3,6:163\n*S KotlinDebug\n*F\n+ 1 JSTSEnclosuresLexer.kt\ncom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexer\n*L\n35#1:160,3\n124#1:169,3\n125#1:172,7\n122#1:163,6\n*E\n"})
public final class JSDialectMLCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DialectOptionHolder dialectOptionHolder;
    @NotNull
    private final TokenSet bracketsSet;
    @NotNull
    private static final Key<Integer> BRACES_CNT_KEY = new Key("full.line.js.lexer.braces.cnt");

    public JSDialectMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition, @NotNull DialectOptionHolder dialectOptionHolder) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        Intrinsics.checkNotNullParameter((Object)dialectOptionHolder, (String)"dialectOptionHolder");
        super(enclosuresDefinition);
        this.dialectOptionHolder = dialectOptionHolder;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.XML_LBRACE, JSTokenTypes.XML_RBRACE, JSTokenTypes.XML_START_TAG_START, JSTokenTypes.XML_TAG_END, JSTokenTypes.XML_END_TAG_START, JSTokenTypes.XML_EMPTY_TAG_END};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @NotNull
    protected JSFlexAdapter createBaseLexer() {
        return new JSFlexAdapter(this.dialectOptionHolder);
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset2, @NotNull MLCompletionLexerAdapter.LexemesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            this.onBracketToken(token, text2, offset2, collector2);
        } else {
            this.findStringMarkers(token, text2, offset2, collector2);
        }
    }

    @Override
    @NotNull
    protected MLCompletionLexer.LexingResult getLexingResult(@NotNull List<? extends MLCompletionLexeme> lexemes, @NotNull Lexer lexer2) {
        MLCompletionLexer.LexingResult lexingResult;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(lexemes, (String)"lexemes");
            Intrinsics.checkNotNullParameter((Object)lexer2, (String)"lexer");
            Iterable $this$any$iv = lexemes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MLCompletionLexeme it = (MLCompletionLexeme)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getText(), (Object)"<") || Intrinsics.areEqual((Object)it.getText(), (Object)">"))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            CharSequence charSequence = lexer2.getBufferSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
            lexingResult = new MLCompletionLexer.LexingResult(lexemes, MLCompletionLexer.LexingContext.constructor-impl(charSequence), null);
        } else {
            lexingResult = super.getLexingResult(lexemes, lexer2);
        }
        return lexingResult;
    }

    private final void onBracketToken(IElementType token, String text2, int offset2, MLCompletionLexerAdapter.LexemesCollector collector2) {
        MLCompletionLexerAdapter.Location location = collector2.getCurrentLocation();
        if (location instanceof MLCompletionLexerAdapter.Location.StringLiteral) {
            if (Intrinsics.areEqual((Object)token, (Object)JSTokenTypes.LBRACE)) {
                collector2.stringTemplate('{', offset2, "${");
                collector2.getCurrentLocation().getData().putUserData(BRACES_CNT_KEY, (Object)0);
            }
        } else if (location instanceof MLCompletionLexerAdapter.Location.Global) {
            this.collectBracket(token, text2, offset2, collector2);
        } else if (location instanceof MLCompletionLexerAdapter.Location.StringTemplate) {
            IElementType iElementType = token;
            if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.LBRACE)) {
                this.update(collector2.getCurrentLocation().getData(), BRACES_CNT_KEY, (Function1<? super Integer, Integer>)((Function1)onBracketToken.1.INSTANCE));
                collector2.bracket('{', offset2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.RBRACE)) {
                int currentBalance2 = this.update(collector2.getCurrentLocation().getData(), BRACES_CNT_KEY, (Function1<? super Integer, Integer>)((Function1)onBracketToken.currentBalance.1.INSTANCE));
                if (currentBalance2 == -1) {
                    MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector2, '}', offset2, null, 4, null);
                } else {
                    collector2.bracket('}', offset2);
                }
            } else {
                this.collectBracket(token, text2, offset2, collector2);
            }
        }
    }

    private final void collectBracket(IElementType token, String text2, int offset2, MLCompletionLexerAdapter.LexemesCollector collector2) {
        if (!(((CharSequence)text2).length() > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_END_TAG_START)) {
            if (Intrinsics.areEqual((Object)text2, (Object)"</")) {
                collector2.bracket('<', offset2);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_EMPTY_TAG_END)) {
            if (Intrinsics.areEqual((Object)text2, (Object)"/>")) {
                collector2.bracket('>', offset2 + 1);
            }
        } else if (text2.length() == 1) {
            collector2.bracket(StringsKt.first((CharSequence)text2), offset2);
        }
    }

    private final void findStringMarkers(IElementType token, String text2, int offset2, MLCompletionLexerAdapter.LexemesCollector collector2) {
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_LITERAL)) {
            char quote = StringsKt.first((CharSequence)text2);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, quote, offset2, null, 4, null);
                if (StringsKt.last((CharSequence)text2) == quote && text2.length() > 1) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, quote, offset2 + text2.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE)) {
            if (this.getEnclosures().isStringMarker(StringsKt.first((CharSequence)text2))) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, StringsKt.first((CharSequence)text2), offset2, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL)) {
            char slash = StringsKt.first((CharSequence)text2);
            if (this.getEnclosures().isStringMarker(slash)) {
                int closingSlashOffset;
                block19: {
                    int n;
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, slash, offset2, null, 4, null);
                    CharSequence $this$indexOfLast$iv = text2;
                    boolean $i$f$indexOfLast = false;
                    int n2 = $this$indexOfLast$iv.length() + -1;
                    if (0 <= n2) {
                        do {
                            int index$iv = n2--;
                            char it = $this$indexOfLast$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it == slash)) continue;
                            n = index$iv;
                            break block19;
                        } while (0 <= n2);
                    }
                    n = closingSlashOffset = -1;
                }
                if (closingSlashOffset > 0) {
                    boolean isEscaped;
                    boolean bl;
                    block20: {
                        Iterable $this$all$iv = (Iterable)RangesKt.until((int)(closingSlashOffset + 1), (int)text2.length());
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            Iterator index$iv = $this$all$iv.iterator();
                            while (index$iv.hasNext()) {
                                int element$iv;
                                int it = element$iv = ((IntIterator)index$iv).nextInt();
                                boolean bl2 = false;
                                if (Character.isLetter(text2.charAt(it))) continue;
                                bl = false;
                                break block20;
                            }
                            bl = true;
                        }
                    }
                    boolean actuallyClosing = bl;
                    Iterable $this$takeWhile$iv = (Iterable)RangesKt.downTo((int)(closingSlashOffset - 1), (int)0);
                    boolean $i$f$takeWhile = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $this$takeWhile$iv) {
                        int it = ((Number)item$iv).intValue();
                        boolean bl3 = false;
                        if (!(text2.charAt(it) == '\\')) break;
                        list$iv.add(item$iv);
                    }
                    boolean bl4 = isEscaped = ((List)list$iv).size() % 2 != 0;
                    if (actuallyClosing && !isEscaped) {
                        MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, slash, offset2 + closingSlashOffset, null, 4, null);
                    }
                }
            }
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) ? true : Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) && (Intrinsics.areEqual((Object)text2, (Object)"'") || Intrinsics.areEqual((Object)text2, (Object)"\""))) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, StringsKt.first((CharSequence)text2), offset2, null, 4, null);
        }
    }

    private final int update(UserDataHolder $this$update, Key<Integer> key, Function1<? super Integer, Integer> value) {
        Integer n = (Integer)$this$update.getUserData(key);
        if (n == null) {
            n = 0;
        }
        int newValue = ((Number)value.invoke((Object)n)).intValue();
        $this$update.putUserData(key, (Object)newValue);
        return newValue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexer$Companion;", "", "()V", "BRACES_CNT_KEY", "Lcom/intellij/openapi/util/Key;", "", "intellij.ml.inline.completion.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

