/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.icons.AllIcons;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.function.IntUnaryOperator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 :*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0001:B'\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0016\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J6\u0010.\u001a\u00020/2\u0016\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00020\u0004j\u0002`2012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u0011J\u001c\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u00032\u0006\u00108\u001a\u000209H\u0016R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u001a\u0010$\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010#\"\u0004\b%\u0010&R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0017\u00a8\u0006;"}, d2={"Lcom/intellij/profiler/ui/flamegraph/GroupRootFlameGraphNode;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "Lcom/intellij/profiler/model/CallTreeNode;", "originalNode", "group", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;)V", "content", "getContent", "()Lcom/intellij/profiler/model/CallTreeNode;", "currentIcon", "Ljavax/swing/Icon;", "getCurrentIcon", "()Ljavax/swing/Icon;", "depth", "", "getDepth", "()I", "end", "", "getEnd", "()D", "getGroup", "()Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "groupLength", "getGroupLength", "()Ljava/lang/Integer;", "iconStartX", "iconStartY", "iconWidth", "getIconWidth", "isFolded", "", "()Z", "isIconVisible", "setIconVisible", "(Z)V", "start", "getStart", "contains", "value", "containsIcon", "x", "y", "drawIcon", "", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "g", "Ljava/awt/Graphics2D;", "iconStart", "nodeHeight", "mapDepth", "transformDepth", "Ljava/util/function/IntUnaryOperator;", "Companion", "intellij.profiler.common"})
@ApiStatus.Experimental
public final class GroupRootFlameGraphNode<Call extends BaseCallStackElement>
implements FlameGraphNode<CallTreeNode<? extends Call>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlameGraphNode<CallTreeNode<Call>> originalNode;
    @NotNull
    private final FoldingNodesGroup<Call> group;
    private int iconStartX;
    private int iconStartY;
    private boolean isIconVisible;
    public static final int ICON_RIGHT_MARGIN = 4;
    @NotNull
    private static final Icon expandIcon;
    @NotNull
    private static final Icon collapseIcon;

    public GroupRootFlameGraphNode(@NotNull FlameGraphNode<CallTreeNode<Call>> originalNode, @NotNull FoldingNodesGroup<Call> group2) {
        Intrinsics.checkNotNullParameter(originalNode, (String)"originalNode");
        Intrinsics.checkNotNullParameter(group2, (String)"group");
        this.originalNode = originalNode;
        this.group = group2;
        this.iconStartX = -1;
        this.iconStartY = -1;
    }

    @NotNull
    public final FoldingNodesGroup<Call> getGroup() {
        return this.group;
    }

    @Override
    @NotNull
    public CallTreeNode<Call> getContent() {
        return this.originalNode.getContent();
    }

    @Override
    public int getDepth() {
        return this.originalNode.getDepth();
    }

    @Override
    public double getEnd() {
        return this.originalNode.getEnd();
    }

    @Override
    public double getStart() {
        return this.originalNode.getStart();
    }

    @Override
    public boolean contains(double value, int depth) {
        return this.originalNode.contains(value, depth);
    }

    private final boolean isFolded() {
        return this.group.isFolded();
    }

    public final boolean isIconVisible() {
        return this.isIconVisible;
    }

    public final void setIconVisible(boolean bl) {
        this.isIconVisible = bl;
    }

    private final Icon getCurrentIcon() {
        return this.isFolded() ? expandIcon : collapseIcon;
    }

    public final int getIconWidth() {
        return this.getCurrentIcon().getIconWidth();
    }

    @Nullable
    public final Integer getGroupLength() {
        return this.group.getLength();
    }

    @Override
    @NotNull
    public FlameGraphNode<CallTreeNode<Call>> mapDepth(@NotNull IntUnaryOperator transformDepth) {
        Intrinsics.checkNotNullParameter((Object)transformDepth, (String)"transformDepth");
        return new GroupRootFlameGraphNode<Call>(this.originalNode.mapDepth(transformDepth), this.group);
    }

    public final void drawIcon(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g, int iconStart, int nodeHeight) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Icon icon = this.getCurrentIcon();
        int iconHeight = icon.getIconHeight();
        int verticalMargin = (nodeHeight - iconHeight + 1) / 2;
        this.iconStartX = iconStart;
        this.iconStartY = verticalMargin;
        icon.paintIcon((Component)((Object)component), g, iconStart, verticalMargin);
    }

    public final boolean containsIcon(int x, int y) {
        return this.isIconVisible && x >= this.iconStartX - 1 && x <= this.iconStartX + this.getCurrentIcon().getIconWidth() + 1 && y >= this.iconStartY - 1 && y <= this.iconStartY + this.getCurrentIcon().getIconHeight() + 1;
    }

    static {
        Icon icon = AllIcons.Profiler.ExpandNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ExpandNode");
        expandIcon = icon;
        Icon icon2 = AllIcons.Profiler.CollapseNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"CollapseNode");
        collapseIcon = icon2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/flamegraph/GroupRootFlameGraphNode$Companion;", "", "()V", "ICON_RIGHT_MARGIN", "", "collapseIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "expandIcon", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

