/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.navigation.JsonQualifiedNameProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaCacheManager;
import com.jetbrains.jsonSchema.impl.JsonSchemaFileValuesIndex;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorage;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonCachedValues {
    private static final Key<CachedValue<JsonSchemaObject>> JSON_OBJECT_CACHE_KEY = Key.create((String)"JsonSchemaObjectCache");
    static final String URL_CACHE_KEY = "JsonSchemaUrlCache";
    private static final Key<CachedValue<String>> SCHEMA_URL_KEY = Key.create((String)"JsonSchemaUrlCache");
    static final String ID_CACHE_KEY = "JsonSchemaIdCache";
    static final String OBSOLETE_ID_CACHE_KEY = "JsonSchemaObsoleteIdCache";
    private static final Key<CachedValue<String>> SCHEMA_ID_CACHE_KEY = Key.create((String)"JsonSchemaIdCache");
    static final String ID_PATHS_CACHE_KEY = "JsonSchemaIdToPointerCache";
    private static final Key<CachedValue<Map<String, String>>> SCHEMA_ID_PATHS_CACHE_KEY = Key.create((String)"JsonSchemaIdToPointerCache");
    private static final Key<CachedValue<List<JsonSchemaCatalogEntry>>> SCHEMA_CATALOG_CACHE_KEY = Key.create((String)"JsonSchemaCatalogCache");
    public static final Key<CachedValue<JsonSchemaObject>> OBJECT_FOR_FILE_KEY = new Key("JsonCachedValues.OBJ_KEY");

    @Nullable
    public static JsonSchemaObject getSchemaObject(@NotNull VirtualFile schemaFile, @NotNull Project project2) {
        if (schemaFile == null) {
            JsonCachedValues.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(1);
        }
        JsonFileResolver.startFetchingHttpFileIfNeeded(schemaFile, project2);
        if (Registry.is((String)"json.schema.object.v2")) {
            return JsonSchemaObjectStorage.getInstance(project2).getOrComputeSchemaRootObject(schemaFile);
        }
        return JsonCachedValues.computeForFile(schemaFile, project2, psiFile -> JsonSchemaCacheManager.getInstance(psiFile.getProject()).computeSchemaObject(schemaFile, (PsiFile)psiFile), JSON_OBJECT_CACHE_KEY);
    }

    @Nullable
    public static String getSchemaUrlFromSchemaProperty(@NotNull VirtualFile file, @NotNull Project project2) {
        JsonSchemaObject schemaRootOrNull;
        if (file == null) {
            JsonCachedValues.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"json.schema.object.v2") && (schemaRootOrNull = JsonSchemaObjectStorage.getInstance(project2).getComputedSchemaRootOrNull(file)) != null) {
            return schemaRootOrNull.getSchema();
        }
        String value = JsonSchemaFileValuesIndex.getCachedValue(project2, file, URL_CACHE_KEY);
        if (value != null) {
            return "$NULL$".equals(value) ? null : value;
        }
        PsiFile psiFile = JsonCachedValues.resolveFile(file, project2);
        return psiFile == null ? null : JsonCachedValues.getOrCompute(psiFile, JsonCachedValues::fetchSchemaUrl, SCHEMA_URL_KEY);
    }

    private static PsiFile resolveFile(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            JsonCachedValues.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(5);
        }
        if (project2.isDisposed() || !file.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)project2).findFile(file);
    }

    @Nullable
    private static String fetchSchemaUrl(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        if (psiFile instanceof JsonFile) {
            String url = JsonSchemaFileValuesIndex.readTopLevelProps(psiFile.getFileType(), psiFile.getText()).get(URL_CACHE_KEY);
            return url == null || "$NULL$".equals(url) ? null : url;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)psiFile, JsonSchemaObjectReadingUtils.NULL_OBJ);
        if (walker != null) {
            Collection<PsiElement> roots = walker.getRoots(psiFile);
            for (PsiElement root : (Collection)ObjectUtils.notNull(roots, List.of())) {
                JsonValueAdapter adapter = walker.createValueAdapter(root);
                JsonObjectValueAdapter object = adapter != null ? adapter.getAsObject() : null;
                if (object == null) continue;
                List<JsonPropertyAdapter> list2 = object.getPropertyList();
                for (JsonPropertyAdapter propertyAdapter : list2) {
                    JsonValueAdapter item;
                    Collection<JsonValueAdapter> values;
                    if (!"$schema".equals(propertyAdapter.getName()) || (values = propertyAdapter.getValues()).size() != 1 || !(item = (JsonValueAdapter)ContainerUtil.getFirstItem(values)).isStringLiteral()) continue;
                    return StringUtil.unquoteString((String)item.getDelegate().getText());
                }
            }
        }
        return null;
    }

    @Nullable
    public static String getSchemaId(@NotNull VirtualFile schemaFile, @NotNull Project project2) {
        JsonSchemaObject schemaRootOrNull;
        if (schemaFile == null) {
            JsonCachedValues.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(7);
        }
        if (schemaFile instanceof LightVirtualFile) {
            return null;
        }
        if (Registry.is((String)"json.schema.object.v2") && (schemaRootOrNull = JsonSchemaObjectStorage.getInstance(project2).getOrComputeSchemaRootObject(schemaFile)) != null) {
            return schemaRootOrNull.getId();
        }
        String value = JsonSchemaFileValuesIndex.getCachedValue(project2, schemaFile, ID_CACHE_KEY);
        if (value != null && !"$NULL$".equals(value)) {
            return JsonPointerUtil.normalizeId(value);
        }
        String obsoleteValue = JsonSchemaFileValuesIndex.getCachedValue(project2, schemaFile, OBSOLETE_ID_CACHE_KEY);
        if (obsoleteValue != null && !"$NULL$".equals(obsoleteValue)) {
            return JsonPointerUtil.normalizeId(obsoleteValue);
        }
        if ("$NULL$".equals(value) || "$NULL$".equals(obsoleteValue)) {
            return null;
        }
        String result2 = JsonCachedValues.computeForFile(schemaFile, project2, JsonCachedValues::fetchSchemaId, SCHEMA_ID_CACHE_KEY);
        return result2 == null ? null : JsonPointerUtil.normalizeId(result2);
    }

    @Nullable
    private static <T> T computeForFile(@NotNull VirtualFile schemaFile, @NotNull Project project2, @NotNull Function<? super PsiFile, ? extends T> eval, @NotNull Key<CachedValue<T>> cacheKey) {
        PsiFile psiFile;
        if (schemaFile == null) {
            JsonCachedValues.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(9);
        }
        if (eval == null) {
            JsonCachedValues.$$$reportNull$$$0(10);
        }
        if (cacheKey == null) {
            JsonCachedValues.$$$reportNull$$$0(11);
        }
        if ((psiFile = JsonCachedValues.resolveFile(schemaFile, project2)) == null) {
            return null;
        }
        return JsonCachedValues.getOrCompute(psiFile, eval, cacheKey);
    }

    public static Collection<String> getAllIdsInFile(PsiFile psiFile) {
        Map<String, String> map = JsonCachedValues.getOrComputeIdsMap(psiFile);
        return map == null ? ContainerUtil.emptyList() : map.keySet();
    }

    @Nullable
    public static String resolveId(PsiFile psiFile, String id) {
        Map<String, String> map = JsonCachedValues.getOrComputeIdsMap(psiFile);
        return map == null ? null : map.get(id);
    }

    @Nullable
    public static Map<String, String> getOrComputeIdsMap(PsiFile psiFile) {
        return JsonCachedValues.getOrCompute(psiFile, JsonCachedValues::computeIdsMap, SCHEMA_ID_PATHS_CACHE_KEY);
    }

    @NotNull
    private static Map<String, String> computeIdsMap(PsiFile file) {
        Map map = SyntaxTraverser.psiTraverser((PsiElement)file).filter(JsonProperty.class).filter(p -> "$id".equals(StringUtil.unquoteString((String)p.getNameElement().getText()))).filter(p -> p.getValue() instanceof JsonStringLiteral).toMap(p -> ((JsonStringLiteral)Objects.requireNonNull(p.getValue())).getValue(), p -> JsonQualifiedNameProvider.generateQualifiedName(p.getParent(), JsonQualifiedNameKind.JsonPointer));
        if (map == null) {
            JsonCachedValues.$$$reportNull$$$0(12);
        }
        return map;
    }

    @Nullable
    static String fetchSchemaId(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JsonCachedValues.$$$reportNull$$$0(13);
        }
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        Map<String, String> props = JsonSchemaFileValuesIndex.readTopLevelProps(psiFile.getFileType(), psiFile.getText());
        String id = props.get(ID_CACHE_KEY);
        if (id != null && !"$NULL$".equals(id)) {
            return id;
        }
        String obsoleteId = props.get(OBSOLETE_ID_CACHE_KEY);
        return obsoleteId == null || "$NULL$".equals(obsoleteId) ? null : obsoleteId;
    }

    @Nullable
    public static List<JsonSchemaCatalogEntry> getSchemaCatalog(@NotNull VirtualFile catalog, @NotNull Project project2) {
        if (catalog == null) {
            JsonCachedValues.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            JsonCachedValues.$$$reportNull$$$0(15);
        }
        if (!catalog.isValid()) {
            return null;
        }
        return JsonCachedValues.computeForFile(catalog, project2, JsonCachedValues::computeSchemaCatalog, SCHEMA_CATALOG_CACHE_KEY);
    }

    private static List<JsonSchemaCatalogEntry> computeSchemaCatalog(PsiFile catalog) {
        if (!catalog.isValid()) {
            return null;
        }
        VirtualFile virtualFile = catalog.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        JsonValue value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)catalog, () -> catalog instanceof JsonFile ? ((JsonFile)catalog).getTopLevelValue() : null);
        if (!(value instanceof JsonObject)) {
            return null;
        }
        JsonProperty schemas = ((JsonObject)value).findProperty("schemas");
        if (schemas == null) {
            return null;
        }
        JsonValue schemasValue = schemas.getValue();
        if (!(schemasValue instanceof JsonArray)) {
            return null;
        }
        ArrayList<JsonSchemaCatalogEntry> catalogMap = new ArrayList<JsonSchemaCatalogEntry>();
        JsonCachedValues.fillMap((JsonArray)schemasValue, catalogMap);
        return catalogMap;
    }

    private static void fillMap(@NotNull JsonArray array, @NotNull List<JsonSchemaCatalogEntry> catalogMap) {
        if (array == null) {
            JsonCachedValues.$$$reportNull$$$0(16);
        }
        if (catalogMap == null) {
            JsonCachedValues.$$$reportNull$$$0(17);
        }
        for (JsonValue value : array.getValueList()) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (obj == null) continue;
            JsonProperty fileMatch = obj.findProperty("fileMatch");
            List masks = fileMatch == null ? ContainerUtil.emptyList() : JsonCachedValues.resolveMasks(fileMatch.getValue());
            String urlString = JsonCachedValues.readStringValue(obj.findProperty("url"));
            if (urlString == null) continue;
            catalogMap.add(new JsonSchemaCatalogEntry(masks, urlString, JsonCachedValues.readStringValue(obj.findProperty("name")), JsonCachedValues.readStringValue(obj.findProperty("description"))));
        }
    }

    @Nullable
    @NlsSafe
    private static String readStringValue(@Nullable JsonProperty property) {
        String urlStringValue;
        if (property == null) {
            return null;
        }
        JsonValue urlValue = property.getValue();
        if (urlValue instanceof JsonStringLiteral && !StringUtil.isEmpty((String)(urlStringValue = ((JsonStringLiteral)urlValue).getValue()))) {
            return urlStringValue;
        }
        return null;
    }

    @NotNull
    private static Collection<String> resolveMasks(@Nullable JsonValue value) {
        if (value instanceof JsonStringLiteral) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JsonStringLiteral)value).getValue());
            if (list2 == null) {
                JsonCachedValues.$$$reportNull$$$0(18);
            }
            return list2;
        }
        if (value instanceof JsonArray) {
            ArrayList<String> strings = new ArrayList<String>();
            for (JsonValue val : ((JsonArray)value).getValueList()) {
                if (!(val instanceof JsonStringLiteral)) continue;
                strings.add(((JsonStringLiteral)val).getValue());
            }
            ArrayList<String> arrayList = strings;
            if (arrayList == null) {
                JsonCachedValues.$$$reportNull$$$0(19);
            }
            return arrayList;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            JsonCachedValues.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @Nullable
    private static <T> T getOrCompute(@NotNull PsiFile psiFile, @NotNull Function<? super PsiFile, ? extends T> eval, @NotNull Key<CachedValue<T>> key2) {
        if (psiFile == null) {
            JsonCachedValues.$$$reportNull$$$0(21);
        }
        if (eval == null) {
            JsonCachedValues.$$$reportNull$$$0(22);
        }
        if (key2 == null) {
            JsonCachedValues.$$$reportNull$$$0(23);
        }
        return (T)CachedValuesManager.getCachedValue((PsiElement)psiFile, key2, () -> CachedValueProvider.Result.create((Object)eval.fun((Object)psiFile), (Object[])new Object[]{psiFile}));
    }

    @Nullable
    static JsonSchemaObject computeSchemaForFile(@NotNull PsiFile file, @NotNull JsonSchemaService service) {
        PsiFile originalFile;
        JsonSchemaObject value;
        if (file == null) {
            JsonCachedValues.$$$reportNull$$$0(24);
        }
        if (service == null) {
            JsonCachedValues.$$$reportNull$$$0(25);
        }
        return (value = (JsonSchemaObject)CachedValuesManager.getCachedValue((PsiElement)(originalFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file)), OBJECT_FOR_FILE_KEY, () -> {
            Pair<PsiFile, JsonSchemaObject> schema = JsonCachedValues.getSchemaFile(originalFile, service);
            PsiFile psiFile = (PsiFile)schema.first;
            JsonSchemaObject object = schema.second == null ? JsonSchemaObjectReadingUtils.NULL_OBJ : (JsonSchemaObject)schema.second;
            return psiFile == null ? CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{originalFile, service}) : CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{originalFile, psiFile, service});
        })) == JsonSchemaObjectReadingUtils.NULL_OBJ ? null : value;
    }

    public static boolean hasComputedSchemaObjectForFile(@NotNull PsiFile file) {
        CachedValue data2;
        if (file == null) {
            JsonCachedValues.$$$reportNull$$$0(26);
        }
        if ((data2 = (CachedValue)((PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file)).getUserData(OBJECT_FOR_FILE_KEY)) == null) {
            return false;
        }
        Getter cachedValueGetter = data2.getUpToDateOrNull();
        if (cachedValueGetter == null) {
            return false;
        }
        JsonSchemaObject upToDateCachedValueOrNull = (JsonSchemaObject)cachedValueGetter.get();
        return upToDateCachedValueOrNull != null && upToDateCachedValueOrNull != JsonSchemaObjectReadingUtils.NULL_OBJ;
    }

    @NotNull
    private static Pair<PsiFile, JsonSchemaObject> getSchemaFile(@NotNull PsiFile originalFile, @NotNull JsonSchemaService service) {
        VirtualFile virtualFile;
        if (originalFile == null) {
            JsonCachedValues.$$$reportNull$$$0(27);
        }
        if (service == null) {
            JsonCachedValues.$$$reportNull$$$0(28);
        }
        VirtualFile schemaFile = (virtualFile = originalFile.getVirtualFile()) == null ? null : JsonCachedValues.getSchemaFile(virtualFile, service);
        JsonSchemaObject schemaObject = virtualFile == null ? null : service.getSchemaObject(virtualFile);
        PsiFile psiFile = schemaFile == null || !schemaFile.isValid() ? null : originalFile.getManager().findFile(schemaFile);
        return new Pair((Object)psiFile, (Object)schemaObject);
    }

    static VirtualFile getSchemaFile(@NotNull VirtualFile sourceFile, @NotNull JsonSchemaService service) {
        JsonSchemaServiceImpl serviceImpl;
        Collection<VirtualFile> schemas;
        if (sourceFile == null) {
            JsonCachedValues.$$$reportNull$$$0(29);
        }
        if (service == null) {
            JsonCachedValues.$$$reportNull$$$0(30);
        }
        if ((schemas = (serviceImpl = (JsonSchemaServiceImpl)service).getSchemasForFile(sourceFile, true, false)).isEmpty()) {
            return null;
        }
        assert (schemas.size() == 1);
        return schemas.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eval";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonCachedValues";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogMap";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonCachedValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIdsMap";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaUrlFromSchemaProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeForFile";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchSchemaId";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaCatalog";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCompute";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeSchemaForFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasComputedSchemaObjectForFile";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 18, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

