/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.surroundWith;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.surroundWith.JsonSurrounderBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonWithObjectLiteralSurrounder
extends JsonSurrounderBase {
    public String getTemplateDescription() {
        return JsonBundle.message("surround.with.object.literal.desc", new Object[0]);
    }

    @Override
    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(0);
        }
        return !JsonPsiUtil.isPropertyKey(elements[0]) && (elements[0] instanceof JsonProperty || elements.length == 1);
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, PsiElement @NotNull [] elements) {
        JsonValue newNameElement;
        if (project2 == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(3);
        }
        if (!this.isApplicable(elements)) {
            return null;
        }
        JsonElementGenerator generator = new JsonElementGenerator(project2);
        PsiElement firstElement = elements[0];
        if (firstElement instanceof JsonValue) {
            assert (elements.length == 1) : "Only single JSON value can be wrapped in object literal";
            JsonObject replacement = (JsonObject)generator.createValue(this.createReplacementText(firstElement.getText()));
            replacement = (JsonObject)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getPropertyList().get(0).getNameElement();
        } else {
            assert (firstElement instanceof JsonProperty);
            String propertiesText = JsonWithObjectLiteralSurrounder.getTextAndRemoveMisc(firstElement, elements[elements.length - 1]);
            JsonObject tempJsonObject = (JsonObject)generator.createValue(this.createReplacementText("{\n" + propertiesText) + "\n}");
            JsonProperty replacement = tempJsonObject.getPropertyList().get(0);
            replacement = (JsonProperty)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getNameElement();
        }
        TextRange rangeWithQuotes = newNameElement.getTextRange();
        return new TextRange(rangeWithQuotes.getStartOffset() + 1, rangeWithQuotes.getEndOffset() - 1);
    }

    @Override
    @NotNull
    protected String createReplacementText(@NotNull String textInRange) {
        if (textInRange == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(4);
        }
        String string2 = "{\n\"property\": " + textInRange + "\n}";
        if (string2 == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textInRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/surroundWith/JsonWithObjectLiteralSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/surroundWith/JsonWithObjectLiteralSurrounder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "surroundElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReplacementText";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

