/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.common;

import com.intellij.execution.process.mediator.common.QuotaOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState;", "", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "Active", "Expired", "New", "Lcom/intellij/execution/process/mediator/common/QuotaState$Active;", "Lcom/intellij/execution/process/mediator/common/QuotaState$Expired;", "Lcom/intellij/execution/process/mediator/common/QuotaState$New;", "intellij.execution.process.mediator.common"})
public abstract class QuotaState {
    private QuotaState() {
    }

    @NotNull
    public abstract QuotaOptions getOptions();

    public /* synthetic */ QuotaState(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0005J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$Active;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "elapsedMs", "", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;J)V", "getElapsedMs", "()J", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "isExpired", "remaining", "toString", "", "intellij.execution.process.mediator.common"})
    public static final class Active
    extends QuotaState {
        @NotNull
        private final QuotaOptions options;
        private final long elapsedMs;

        public Active(@NotNull QuotaOptions options, long elapsedMs) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
            this.elapsedMs = elapsedMs;
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        public final long getElapsedMs() {
            return this.elapsedMs;
        }

        public final long remaining() {
            return this.getOptions().isUnlimited() ? Long.MAX_VALUE : this.getOptions().getTimeLimitMs() - this.elapsedMs;
        }

        public final boolean isExpired() {
            return this.remaining() <= 0L;
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        public final long component2() {
            return this.elapsedMs;
        }

        @NotNull
        public final Active copy(@NotNull QuotaOptions options, long elapsedMs) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Active(options, elapsedMs);
        }

        public static /* synthetic */ Active copy$default(Active active, QuotaOptions quotaOptions, long l, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = active.options;
            }
            if ((n & 2) != 0) {
                l = active.elapsedMs;
            }
            return active.copy(quotaOptions, l);
        }

        @NotNull
        public String toString() {
            return "Active(options=" + this.options + ", elapsedMs=" + this.elapsedMs + ")";
        }

        public int hashCode() {
            int result = this.options.hashCode();
            result = result * 31 + Long.hashCode(this.elapsedMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Active)) {
                return false;
            }
            Active active = (Active)other;
            if (!Intrinsics.areEqual((Object)this.options, (Object)active.options)) {
                return false;
            }
            return this.elapsedMs == active.elapsedMs;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$Expired;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "intellij.execution.process.mediator.common"})
    public static final class Expired
    extends QuotaState {
        @NotNull
        public static final Expired INSTANCE = new Expired();

        private Expired() {
            super(null);
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return QuotaOptions.Companion.getEXCEEDED();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$New;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;)V", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.execution.process.mediator.common"})
    public static final class New
    extends QuotaState {
        @NotNull
        private final QuotaOptions options;

        public New(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        @NotNull
        public final New copy(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new New(options);
        }

        public static /* synthetic */ New copy$default(New new_, QuotaOptions quotaOptions, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = new_.options;
            }
            return new_.copy(quotaOptions);
        }

        @NotNull
        public String toString() {
            return "New(options=" + this.options + ")";
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof New)) {
                return false;
            }
            New new_ = (New)other;
            return Intrinsics.areEqual((Object)this.options, (Object)new_.options);
        }
    }
}

