/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathLanguageInjector
implements MultiHostInjector {
    private static final Key<Pair<String, TextRange[]>> CACHED_FILES = Key.create((String)"CACHED_FILES");

    private static TextRange @Nullable [] getCachedRanges(XmlAttribute attribute) {
        Pair pair = (Pair)attribute.getUserData(CACHED_FILES);
        if (pair != null) {
            if (!attribute.getValue().equals(pair.getFirst())) {
                attribute.putUserData(CACHED_FILES, null);
                return null;
            }
        } else {
            return null;
        }
        return (TextRange[])pair.getSecond();
    }

    private synchronized TextRange @NotNull [] getInjectionRanges(XmlAttribute attribute, XsltChecker.LanguageLevel languageLevel) {
        TextRange[] ranges;
        TextRange[] cachedFiles = XPathLanguageInjector.getCachedRanges(attribute);
        if (cachedFiles != null) {
            if (cachedFiles == null) {
                XPathLanguageInjector.$$$reportNull$$$0(0);
            }
            return cachedFiles;
        }
        String value = attribute.getDisplayValue();
        if (value == null) {
            if (TextRange.EMPTY_ARRAY == null) {
                XPathLanguageInjector.$$$reportNull$$$0(1);
            }
            return TextRange.EMPTY_ARRAY;
        }
        if (XsltSupport.mayBeAVT(attribute)) {
            int i;
            SmartList avtRanges = new SmartList();
            int j = 0;
            Lexer lexer = null;
            while ((i = XsltSupport.getAVTOffset(value, j)) != -1) {
                if (lexer == null) {
                    lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageLevel.getXPathVersion().getLanguage())).createLexer(attribute.getProject());
                }
                lexer.start((CharSequence)value, i, value.length());
                j = -1;
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenType() == XPathTokenTypes.RBRACE) {
                        j = lexer.getTokenStart();
                        break;
                    }
                    lexer.advance();
                }
                if (j != -1) {
                    avtRanges.add(AVTRange.create(attribute, i, j + 1, j > i + 1));
                    continue;
                }
                avtRanges.add(AVTRange.create(attribute, i, value.length(), false));
                break;
            }
            ranges = avtRanges.isEmpty() ? TextRange.EMPTY_ARRAY : avtRanges.toArray(TextRange.EMPTY_ARRAY);
        } else {
            ranges = new TextRange[]{attribute.getValueTextRange()};
        }
        attribute.putUserData(CACHED_FILES, (Object)Pair.create((Object)attribute.getValue(), (Object)ranges));
        if (ranges == null) {
            XPathLanguageInjector.$$$reportNull$$$0(2);
        }
        return ranges;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            XPathLanguageInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        TextRange[] ranges;
        XmlAttributeValueImpl value;
        PsiElement parent;
        if (registrar == null) {
            XPathLanguageInjector.$$$reportNull$$$0(4);
        }
        if (context == null) {
            XPathLanguageInjector.$$$reportNull$$$0(5);
        }
        if (!((parent = (value = (XmlAttributeValueImpl)context).getParent()) instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        if (!XsltSupport.isXPathAttribute(attribute)) {
            return;
        }
        ASTNode type = value.findChildByType(XmlElementType.XML_ENTITY_REF);
        if (type != null) {
            return;
        }
        XsltChecker.LanguageLevel languageLevel = XsltSupport.getXsltLanguageLevel(attribute.getContainingFile());
        for (TextRange range : ranges = this.getInjectionRanges(attribute, languageLevel)) {
            String prefix;
            TextRange rangeInsideHost;
            if (range instanceof AVTRange) {
                if (((AVTRange)range).myComplete) {
                    rangeInsideHost = range.shiftRight(2).grown(-2);
                    prefix = "";
                } else {
                    rangeInsideHost = range.shiftRight(2).grown(-1);
                    prefix = "{";
                }
            } else {
                rangeInsideHost = range;
                prefix = "";
            }
            if (!value.getTextRange().contains(rangeInsideHost.shiftRight(value.getTextRange().getStartOffset()))) continue;
            registrar.startInjecting(languageLevel.getXPathVersion().getLanguage()).addPlace(prefix, "", (PsiLanguageInjectionHost)value, rangeInsideHost).doneInjecting();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionRanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static final class AVTRange
    extends TextRange {
        final boolean myComplete;

        private AVTRange(int startOffset, int endOffset, boolean iscomplete) {
            super(startOffset, endOffset);
            this.myComplete = iscomplete;
        }

        public static AVTRange create(XmlAttribute attribute, int startOffset, int endOffset, boolean iscomplete) {
            return new AVTRange(attribute.displayToPhysical(startOffset), attribute.displayToPhysical(endOffset), iscomplete);
        }
    }
}

