/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.toolWindow;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.lang.makefile.toolWindow.MakefileFileNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileTargetNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileTreeNode;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/lang/makefile/toolWindow/MakefileCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.makefile"})
public final class MakefileCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile rootDir;

    public MakefileCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rootDir = ProjectUtil.guessProjectDir((Project)this.project);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void customizeCellRenderer(@NotNull JTree tree2, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MakefileTreeNode cfr_ignored_0 = (MakefileTreeNode)value;
        this.setIcon(((MakefileTreeNode)value).getIcon());
        if (value instanceof MakefileTargetNode) {
            Object object = ReadAction.compute(() -> MakefileCellRenderer.customizeCellRenderer$lambda$0(value));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            if (((Boolean)object).booleanValue()) {
                this.append(((MakefileTreeNode)value).getName(), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                return;
            }
        }
        this.append(((MakefileTreeNode)value).getName());
        if (!(value instanceof MakefileFileNode)) return;
        if (this.project.isDisposed()) return;
        VirtualFile virtualFile = (VirtualFile)ReadAction.compute(() -> MakefileCellRenderer.customizeCellRenderer$lambda$1(value));
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (this.rootDir == null) return;
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.rootDir);
        if (string == null) {
            string = file.getPath();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String relativePath = string2;
        if (StringsKt.isBlank((CharSequence)relativePath)) {
            return;
        }
        this.append(" ");
        this.append(relativePath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private static final Boolean customizeCellRenderer$lambda$0(Object $value) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        return ((MakefileTargetNode)$value).isSpecialTarget();
    }

    private static final VirtualFile customizeCellRenderer$lambda$1(Object $value) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        PsiFile psiFile = ((MakefileFileNode)$value).getPsiFile();
        return psiFile != null && (psiFile = psiFile.getContainingDirectory()) != null ? psiFile.getVirtualFile() : null;
    }
}

