/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationFactory;
import com.jetbrains.lang.makefile.MakefileRunConfigurationType;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "()V", "findTarget", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij.makefile"})
public final class MakefileRunConfigurationProducer
extends LazyRunConfigurationProducer<MakefileRunConfiguration> {
    protected boolean setupConfigurationFromContext(@NotNull MakefileRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String path;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context.getPsiLocation();
        if (!((psiElement != null ? psiElement.getContainingFile() : null) instanceof MakefileFile)) {
            return false;
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        Location location = context.getLocation();
        String string = path = location != null && (location = location.getVirtualFile()) != null ? location.getPath() : null;
        String string2 = macroManager.collapsePath(path);
        if (string2 == null) {
            string2 = "";
        }
        configuration.setFilename(string2);
        MakefileTarget makefileTarget = this.findTarget(context);
        String string3 = makefileTarget != null ? makefileTarget.getName() : null;
        if (string3 == null) {
            string3 = "";
        }
        configuration.setTarget(string3);
        if (((CharSequence)configuration.getTarget()).length() > 0) {
            configuration.setName(configuration.getTarget());
        } else {
            configuration.setName(new File(path).getName());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfigurationFromContext(@NotNull MakefileRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        if (!Intrinsics.areEqual((Object)macroManager.expandPath(configuration.getFilename()), (location = context.getLocation()) != null && (location = location.getVirtualFile()) != null ? location.getPath() : null)) return false;
        MakefileTarget makefileTarget = this.findTarget(context);
        if (!Intrinsics.areEqual((Object)configuration.getTarget(), (Object)(makefileTarget != null ? makefileTarget.getName() : null))) return false;
        return true;
    }

    private final MakefileTarget findTarget(ConfigurationContext context) {
        MakefileTarget target;
        PsiElement element;
        for (element = context.getPsiLocation(); element != null && !(element instanceof MakefileTarget); element = element.getParent()) {
        }
        PsiElement psiElement = element;
        MakefileTarget makefileTarget = target = psiElement instanceof MakefileTarget ? (MakefileTarget)psiElement : null;
        boolean bl = makefileTarget != null ? !makefileTarget.isSpecialTarget() : false;
        if (bl) {
            return target;
        }
        return null;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return new MakefileRunConfigurationFactory(MakefileRunConfigurationType.Companion.getInstance());
    }
}

