/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.lang.makefile.MakefileFileChooserDescriptor;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.UtilsKt;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0014J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "argumentsField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "environmentVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "filenameField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "panel$delegate", "Lkotlin/Lazy;", "targetCompletionProvider", "Lcom/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider;", "targetField", "Lcom/intellij/ui/TextFieldWithAutoCompletion;", "", "kotlin.jvm.PlatformType", "workingDirectoryField", "applyEditorTo", "", "configuration", "createComponentWithMacroBrowse", "Ljavax/swing/JComponent;", "textAccessor", "createEditor", "resetEditorFrom", "updateTargetCompletion", "filename", "intellij.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileRunConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileRunConfigurationEditor.kt\ncom/jetbrains/lang/makefile/MakefileRunConfigurationEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1549#2:108\n1620#2,3:109\n*S KotlinDebug\n*F\n+ 1 MakefileRunConfigurationEditor.kt\ncom/jetbrains/lang/makefile/MakefileRunConfigurationEditor\n*L\n64#1:108\n64#1:109,3\n*E\n"})
public final class MakefileRunConfigurationEditor
extends SettingsEditor<MakefileRunConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final TextFieldWithBrowseButton filenameField;
    @NotNull
    private final TextFieldWithAutoCompletion.StringsCompletionProvider targetCompletionProvider;
    @NotNull
    private final TextFieldWithAutoCompletion<String> targetField;
    @NotNull
    private final ExpandableTextField argumentsField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirectoryField;
    @NotNull
    private final EnvironmentVariablesComponent environmentVarsComponent;
    @NotNull
    private final Lazy panel$delegate;

    public MakefileRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filenameField = new TextFieldWithBrowseButton();
        this.targetCompletionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)CollectionsKt.emptyList(), UtilsKt.getMakefileTargetIcon());
        this.targetField = new TextFieldWithAutoCompletion(this.project, (TextFieldWithAutoCompletionListProvider)this.targetCompletionProvider, true, "");
        this.argumentsField = new ExpandableTextField();
        this.workingDirectoryField = new TextFieldWithBrowseButton();
        this.environmentVarsComponent = new EnvironmentVariablesComponent();
        this.panel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JPanel>(this){
            final /* synthetic */ MakefileRunConfigurationEditor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final JPanel invoke() {
                return FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.filename.label", new Object[0]), (JComponent)MakefileRunConfigurationEditor.access$getFilenameField$p(this.this$0)).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.target.label", new Object[0]), (JComponent)MakefileRunConfigurationEditor.access$getTargetField$p(this.this$0)).addComponent((JComponent)LabeledComponent.create((JComponent)((JComponent)MakefileRunConfigurationEditor.access$getArgumentsField$p(this.this$0)), (String)MakefileLangBundle.message("run.configuration.editor.arguments.label", new Object[0]))).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.working.directory.label", new Object[0]), MakefileRunConfigurationEditor.access$createComponentWithMacroBrowse(this.this$0, MakefileRunConfigurationEditor.access$getWorkingDirectoryField$p(this.this$0))).addComponent((JComponent)MakefileRunConfigurationEditor.access$getEnvironmentVarsComponent$p(this.this$0)).getPanel();
            }
        }));
        this.filenameField.addBrowseFolderListener(MakefileLangBundle.message("file.chooser.title", new Object[0]), MakefileLangBundle.message("file.chooser.description", new Object[0]), this.project, (FileChooserDescriptor)new MakefileFileChooserDescriptor());
        this.filenameField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = filenameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.updateTargetCompletion(string);
            }
        });
        this.workingDirectoryField.addBrowseFolderListener(MakefileLangBundle.message("working.directory.file.chooser", new Object[0]), MakefileLangBundle.message("working.directory.file.chooser.description", new Object[0]), this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    private final JPanel getPanel() {
        Lazy lazy = this.panel$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JPanel)object;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTargetCompletion(@NotNull String filename) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filename);
        if (file != null && (psiFile = PsiManager.getInstance((Project)this.project).findFile(file)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<MakefileTarget> iterable = UtilsKt.findTargets(psiFile);
            TextFieldWithAutoCompletion.StringsCompletionProvider stringsCompletionProvider = this.targetCompletionProvider;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MakefileTarget makefileTarget = (MakefileTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            stringsCompletionProvider.setItems((Collection)((List)destination$iv$iv));
            return;
        }
        this.targetCompletionProvider.setItems((Collection)CollectionsKt.emptyList());
    }

    @NotNull
    protected JPanel createEditor() {
        return this.getPanel();
    }

    protected void applyEditorTo(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = this.filenameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        configuration.setFilename(string);
        String string2 = this.targetField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        configuration.setTarget(string2);
        String string3 = this.workingDirectoryField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        configuration.setWorkingDirectory(string3);
        EnvironmentVariablesData environmentVariablesData = this.environmentVarsComponent.getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
        configuration.setEnvironmentVariables(environmentVariablesData);
        String string4 = this.argumentsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        configuration.setArguments(string4);
    }

    protected void resetEditorFrom(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        this.filenameField.setText(configuration.getFilename());
        this.targetField.setText(configuration.getTarget());
        this.workingDirectoryField.setText(configuration.getWorkingDirectory());
        this.environmentVarsComponent.setEnvData(configuration.getEnvironmentVariables());
        this.argumentsField.setText(configuration.getArguments());
        this.updateTargetCompletion(configuration.getFilename());
    }

    private final JComponent createComponentWithMacroBrowse(TextFieldWithBrowseButton textAccessor) {
        JPanel jPanel;
        FixedSizeButton button = new FixedSizeButton((JComponent)textAccessor);
        button.setIcon(AllIcons.Actions.ListFiles);
        button.addActionListener(arg_0 -> MakefileRunConfigurationEditor.createComponentWithMacroBrowse$lambda$2(button, textAccessor, arg_0));
        JPanel $this$createComponentWithMacroBrowse_u24lambda_u243 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createComponentWithMacroBrowse_u24lambda_u243.add((Component)textAccessor, "Center");
        $this$createComponentWithMacroBrowse_u24lambda_u243.add((Component)button, "East");
        return jPanel;
    }

    private static final void createComponentWithMacroBrowse$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createComponentWithMacroBrowse$lambda$2(FixedSizeButton $button, TextFieldWithBrowseButton $textAccessor, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$button, (String)"$button");
        Intrinsics.checkNotNullParameter((Object)$textAccessor, (String)"$textAccessor");
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        Set set = PathMacros.getInstance().getUserMacroNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getUserMacroNames(...)");
        jBPopupFactory.createPopupChooserBuilder(CollectionsKt.toList((Iterable)set)).setItemChosenCallback(arg_0 -> MakefileRunConfigurationEditor.createComponentWithMacroBrowse$lambda$2$lambda$1((Function1)new Function1<String, Unit>($textAccessor){
            final /* synthetic */ TextFieldWithBrowseButton $textAccessor;
            {
                this.$textAccessor = $textAccessor;
                super(1);
            }

            public final void invoke(@NotNull String item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                this.$textAccessor.setText("$" + item + "$");
            }
        }, arg_0)).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)$button);
    }

    public static final /* synthetic */ TextFieldWithAutoCompletion access$getTargetField$p(MakefileRunConfigurationEditor $this) {
        return $this.targetField;
    }

    public static final /* synthetic */ ExpandableTextField access$getArgumentsField$p(MakefileRunConfigurationEditor $this) {
        return $this.argumentsField;
    }

    public static final /* synthetic */ JComponent access$createComponentWithMacroBrowse(MakefileRunConfigurationEditor $this, TextFieldWithBrowseButton textAccessor) {
        return $this.createComponentWithMacroBrowse(textAccessor);
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getWorkingDirectoryField$p(MakefileRunConfigurationEditor $this) {
        return $this.workingDirectoryField;
    }

    public static final /* synthetic */ EnvironmentVariablesComponent access$getEnvironmentVarsComponent$p(MakefileRunConfigurationEditor $this) {
        return $this.environmentVarsComponent;
    }
}

