/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.lang.makefile.MakeSettings;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileProjectSettings;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\f0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/lang/makefile/MakeConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cygwinField", "Lcom/intellij/ui/components/JBCheckBox;", "getCygwinField$annotations", "()V", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "settings", "Lcom/jetbrains/lang/makefile/MakefileProjectSettings;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getHelpTopic", "isModified", "", "reset", "intellij.makefile"})
public final class MakeConfigurable
implements Configurable {
    @Nullable
    private final MakefileProjectSettings settings;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final JBCheckBox cygwinField;

    public MakeConfigurable(@Nullable Project project) {
        Project project2 = project;
        this.settings = project2 != null ? (MakefileProjectSettings)project2.getService(MakefileProjectSettings.class) : null;
        this.pathField = new TextFieldWithBrowseButton();
        Object[] objectArray = new Object[]{!SystemInfo.isWindows ? 0 : 1};
        this.cygwinField = new JBCheckBox(MakefileLangBundle.message("configurable.use.cygwin.checkbox", objectArray));
        this.pathField.addBrowseFolderListener(MakefileLangBundle.message("make.file.chooser.title", new Object[0]), MakefileLangBundle.message("make.file.chooser.description", new Object[0]), project, new FileChooserDescriptor(true, false, false, false, false, false));
    }

    private static /* synthetic */ void getCygwinField$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        Object object = this.settings;
        if (!Intrinsics.areEqual((Object)(object != null && (object = ((MakefileProjectSettings)object).getSettings()) != null ? ((MakeSettings)object).getPath() : null), (Object)this.pathField.getText())) return true;
        MakeSettings makeSettings = this.settings.getSettings();
        if (makeSettings == null) return true;
        if (makeSettings.getUseCygwin() != this.cygwinField.isSelected()) return true;
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = MakefileLangBundle.message("configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void apply() {
        MakefileProjectSettings makefileProjectSettings = this.settings;
        MakeSettings makeSettings = makefileProjectSettings != null ? makefileProjectSettings.getSettings() : null;
        if (makeSettings != null) {
            String string = this.pathField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            makeSettings.setPath(string);
        }
        MakefileProjectSettings makefileProjectSettings2 = this.settings;
        MakeSettings makeSettings2 = makefileProjectSettings2 != null ? makefileProjectSettings2.getSettings() : null;
        if (makeSettings2 != null) {
            makeSettings2.setUseCygwin(this.cygwinField.isSelected());
        }
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(MakefileLangBundle.message("configurable.path.field.label", new Object[0]), (JComponent)this.pathField).addComponent((JComponent)this.cygwinField).addComponentFillVertically((JComponent)new Spacer(), 0).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        return jPanel;
    }

    public void reset() {
        Object object = this.settings;
        if (object == null || (object = ((MakefileProjectSettings)object).getSettings()) == null || (object = ((MakeSettings)object).getPath()) == null) {
            object = "";
        }
        this.pathField.setText((String)object);
        Object object2 = this.settings;
        this.cygwinField.setSelected(object2 != null && (object2 = ((MakefileProjectSettings)object2).getSettings()) != null ? ((MakeSettings)object2).getUseCygwin() : false);
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.buildtools.make";
    }
}

