"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __knownSymbol = (name, symbol) => {
  return (symbol = Symbol[name]) ? symbol : Symbol.for("Symbol." + name);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __await = function(promise, isYieldStar) {
  this[0] = promise;
  this[1] = isYieldStar;
};
var __yieldStar = (value) => {
  var obj = value[__knownSymbol("asyncIterator")];
  var isAwait = false;
  var method;
  var it = {};
  if (obj == null) {
    obj = value[__knownSymbol("iterator")]();
    method = (k) => it[k] = (x) => obj[k](x);
  } else {
    obj = obj.call(value);
    method = (k) => it[k] = (v) => {
      if (isAwait) {
        isAwait = false;
        if (k === "throw")
          throw v;
        return v;
      }
      isAwait = true;
      return {
        done: false,
        value: new __await(new Promise((resolve) => {
          var x = obj[k](v);
          if (!(x instanceof Object))
            throw TypeError("Object expected");
          resolve(x);
        }), 1)
      };
    };
  }
  return it[__knownSymbol("iterator")] = () => it, method("next"), "throw" in obj ? method("throw") : it.throw = (x) => {
    throw x;
  }, "return" in obj && method("return"), it;
};

// node_modules/@volar/source-map/lib/binarySearch.js
var require_binarySearch = __commonJS({
  "node_modules/@volar/source-map/lib/binarySearch.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.binarySearch = binarySearch2;
    function binarySearch2(values, searchValue) {
      let low = 0;
      let high = values.length - 1;
      let match;
      while (low <= high) {
        const mid = Math.floor((low + high) / 2);
        const midValue = values[mid];
        if (midValue < searchValue) {
          low = mid + 1;
        } else if (midValue > searchValue) {
          high = mid - 1;
        } else {
          low = mid;
          high = mid;
          match = mid;
          break;
        }
      }
      const finalLow = Math.max(Math.min(low, high, values.length - 1), 0);
      const finalHigh = Math.min(Math.max(low, high, 0), values.length - 1);
      return { low: finalLow, high: finalHigh, match };
    }
  }
});

// node_modules/@volar/source-map/lib/translateOffset.js
var require_translateOffset = __commonJS({
  "node_modules/@volar/source-map/lib/translateOffset.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.translateOffset = translateOffset;
    function translateOffset(start, fromOffsets, toOffsets, fromLengths, toLengths = fromLengths) {
      const isSorted = fromOffsets.every((value, index) => index === 0 || fromOffsets[index - 1] <= value);
      if (!isSorted) {
        throw new Error("fromOffsets must be sorted in ascending order");
      }
      let low = 0;
      let high = fromOffsets.length - 1;
      while (low <= high) {
        const mid = Math.floor((low + high) / 2);
        const fromOffset = fromOffsets[mid];
        const fromLength = fromLengths[mid];
        if (start >= fromOffset && start <= fromOffset + fromLength) {
          const toLength = toLengths[mid];
          const toOffset = toOffsets[mid];
          let rangeOffset = Math.min(start - fromOffset, toLength);
          return toOffset + rangeOffset;
        } else if (start < fromOffset) {
          high = mid - 1;
        } else {
          low = mid + 1;
        }
      }
    }
  }
});

// node_modules/@volar/source-map/lib/sourceMap.js
var require_sourceMap = __commonJS({
  "node_modules/@volar/source-map/lib/sourceMap.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SourceMap = void 0;
    var binarySearch_1 = require_binarySearch();
    var translateOffset_1 = require_translateOffset();
    var SourceMap = class {
      constructor(mappings) {
        this.mappings = mappings;
      }
      toSourceRange(generatedStart, generatedEnd, fallbackToAnyMatch, filter) {
        return this.findMatchingStartEnd(generatedStart, generatedEnd, fallbackToAnyMatch, "generatedOffsets", filter);
      }
      toGeneratedRange(sourceStart, sourceEnd, fallbackToAnyMatch, filter) {
        return this.findMatchingStartEnd(sourceStart, sourceEnd, fallbackToAnyMatch, "sourceOffsets", filter);
      }
      toSourceLocation(generatedOffset, filter) {
        return this.findMatchingOffsets(generatedOffset, "generatedOffsets", filter);
      }
      toGeneratedLocation(sourceOffset, filter) {
        return this.findMatchingOffsets(sourceOffset, "sourceOffsets", filter);
      }
      *findMatchingOffsets(offset, fromRange, filter) {
        const memo = this.getMemoBasedOnRange(fromRange);
        if (memo.offsets.length === 0) {
          return;
        }
        const { low: start, high: end } = (0, binarySearch_1.binarySearch)(memo.offsets, offset);
        const skip = /* @__PURE__ */ new Set();
        const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
        for (let i = start; i <= end; i++) {
          for (const mapping of memo.mappings[i]) {
            if (skip.has(mapping)) {
              continue;
            }
            skip.add(mapping);
            if (filter && !filter(mapping.data)) {
              continue;
            }
            const mapped = (0, translateOffset_1.translateOffset)(offset, mapping[fromRange], mapping[toRange], getLengths2(mapping, fromRange), getLengths2(mapping, toRange));
            if (mapped !== void 0) {
              yield [mapped, mapping];
            }
          }
        }
      }
      *findMatchingStartEnd(start, end, fallbackToAnyMatch, fromRange, filter) {
        const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
        const mappedStarts = [];
        let hadMatch = false;
        for (const [mappedStart, mapping] of this.findMatchingOffsets(start, fromRange)) {
          if (filter && !filter(mapping.data)) {
            continue;
          }
          mappedStarts.push([mappedStart, mapping]);
          const mappedEnd = (0, translateOffset_1.translateOffset)(end, mapping[fromRange], mapping[toRange], getLengths2(mapping, fromRange), getLengths2(mapping, toRange));
          if (mappedEnd !== void 0) {
            hadMatch = true;
            yield [mappedStart, mappedEnd, mapping, mapping];
          }
        }
        if (!hadMatch && fallbackToAnyMatch) {
          for (const [mappedStart, mappingStart] of mappedStarts) {
            for (const [mappedEnd, mappingEnd] of this.findMatchingOffsets(end, fromRange)) {
              if (filter && !filter(mappingEnd.data) || mappedEnd < mappedStart) {
                continue;
              }
              yield [mappedStart, mappedEnd, mappingStart, mappingEnd];
              break;
            }
            ;
          }
        }
      }
      getMemoBasedOnRange(fromRange) {
        var _a, _b;
        return fromRange === "sourceOffsets" ? (_a = this.sourceCodeOffsetsMemo) != null ? _a : this.sourceCodeOffsetsMemo = this.createMemo("sourceOffsets") : (_b = this.generatedCodeOffsetsMemo) != null ? _b : this.generatedCodeOffsetsMemo = this.createMemo("generatedOffsets");
      }
      createMemo(key) {
        const offsetsSet = /* @__PURE__ */ new Set();
        for (const mapping of this.mappings) {
          for (let i = 0; i < mapping[key].length; i++) {
            offsetsSet.add(mapping[key][i]);
            offsetsSet.add(mapping[key][i] + getLengths2(mapping, key)[i]);
          }
        }
        const offsets = [...offsetsSet].sort((a, b) => a - b);
        const mappings = offsets.map(() => /* @__PURE__ */ new Set());
        for (const mapping of this.mappings) {
          for (let i = 0; i < mapping[key].length; i++) {
            const startIndex = (0, binarySearch_1.binarySearch)(offsets, mapping[key][i]).match;
            const endIndex = (0, binarySearch_1.binarySearch)(offsets, mapping[key][i] + getLengths2(mapping, key)[i]).match;
            for (let i2 = startIndex; i2 <= endIndex; i2++) {
              mappings[i2].add(mapping);
            }
          }
        }
        return { offsets, mappings };
      }
    };
    exports2.SourceMap = SourceMap;
    function getLengths2(mapping, key) {
      var _a;
      return key == "sourceOffsets" ? mapping.lengths : (_a = mapping.generatedLengths) != null ? _a : mapping.lengths;
    }
  }
});

// node_modules/@volar/source-map/index.js
var require_source_map = __commonJS({
  "node_modules/@volar/source-map/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar(require_sourceMap(), exports2);
    __exportStar(require_translateOffset(), exports2);
  }
});

// node_modules/@volar/language-core/lib/editorFeatures.js
var require_editorFeatures = __commonJS({
  "node_modules/@volar/language-core/lib/editorFeatures.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isHoverEnabled = isHoverEnabled;
    exports2.isInlayHintsEnabled = isInlayHintsEnabled;
    exports2.isCodeLensEnabled = isCodeLensEnabled;
    exports2.isSemanticTokensEnabled = isSemanticTokensEnabled;
    exports2.isCallHierarchyEnabled = isCallHierarchyEnabled;
    exports2.isRenameEnabled = isRenameEnabled;
    exports2.isDefinitionEnabled = isDefinitionEnabled;
    exports2.isTypeDefinitionEnabled = isTypeDefinitionEnabled;
    exports2.isReferencesEnabled = isReferencesEnabled;
    exports2.isImplementationEnabled = isImplementationEnabled;
    exports2.isHighlightEnabled = isHighlightEnabled;
    exports2.isSymbolsEnabled = isSymbolsEnabled;
    exports2.isFoldingRangesEnabled = isFoldingRangesEnabled;
    exports2.isSelectionRangesEnabled = isSelectionRangesEnabled;
    exports2.isLinkedEditingEnabled = isLinkedEditingEnabled;
    exports2.isColorEnabled = isColorEnabled;
    exports2.isDocumentLinkEnabled = isDocumentLinkEnabled;
    exports2.isDiagnosticsEnabled = isDiagnosticsEnabled;
    exports2.isCodeActionsEnabled = isCodeActionsEnabled;
    exports2.isFormattingEnabled = isFormattingEnabled;
    exports2.isCompletionEnabled = isCompletionEnabled;
    exports2.isAutoInsertEnabled = isAutoInsertEnabled;
    exports2.isSignatureHelpEnabled = isSignatureHelpEnabled;
    exports2.shouldReportDiagnostics = shouldReportDiagnostics;
    exports2.resolveRenameNewName = resolveRenameNewName;
    exports2.resolveRenameEditText = resolveRenameEditText;
    function isHoverEnabled(info) {
      return !!info.semantic;
    }
    function isInlayHintsEnabled(info) {
      return !!info.semantic;
    }
    function isCodeLensEnabled(info) {
      return !!info.semantic;
    }
    function isSemanticTokensEnabled(info) {
      var _a, _b, _c;
      return typeof info.semantic === "object" ? (_c = (_b = (_a = info.semantic).shouldHighlight) == null ? void 0 : _b.call(_a)) != null ? _c : true : !!info.semantic;
    }
    function isCallHierarchyEnabled(info) {
      return !!info.navigation;
    }
    function isRenameEnabled(info) {
      var _a, _b, _c;
      return typeof info.navigation === "object" ? (_c = (_b = (_a = info.navigation).shouldRename) == null ? void 0 : _b.call(_a)) != null ? _c : true : !!info.navigation;
    }
    function isDefinitionEnabled(info) {
      return !!info.navigation;
    }
    function isTypeDefinitionEnabled(info) {
      return !!info.navigation;
    }
    function isReferencesEnabled(info) {
      return !!info.navigation;
    }
    function isImplementationEnabled(info) {
      return !!info.navigation;
    }
    function isHighlightEnabled(info) {
      return !!info.navigation;
    }
    function isSymbolsEnabled(info) {
      return !!info.structure;
    }
    function isFoldingRangesEnabled(info) {
      return !!info.structure;
    }
    function isSelectionRangesEnabled(info) {
      return !!info.structure;
    }
    function isLinkedEditingEnabled(info) {
      return !!info.structure;
    }
    function isColorEnabled(info) {
      return !!info.structure;
    }
    function isDocumentLinkEnabled(info) {
      return !!info.structure;
    }
    function isDiagnosticsEnabled(info) {
      return !!info.verification;
    }
    function isCodeActionsEnabled(info) {
      return !!info.verification;
    }
    function isFormattingEnabled(info) {
      return !!info.format;
    }
    function isCompletionEnabled(info) {
      return !!info.completion;
    }
    function isAutoInsertEnabled(info) {
      return !!info.completion;
    }
    function isSignatureHelpEnabled(info) {
      return !!info.completion;
    }
    function shouldReportDiagnostics(info) {
      var _a, _b, _c;
      return typeof info.verification === "object" ? (_c = (_b = (_a = info.verification).shouldReport) == null ? void 0 : _b.call(_a)) != null ? _c : true : !!info.verification;
    }
    function resolveRenameNewName(newName, info) {
      var _a, _b, _c;
      return typeof info.navigation === "object" ? (_c = (_b = (_a = info.navigation).resolveRenameNewName) == null ? void 0 : _b.call(_a, newName)) != null ? _c : newName : newName;
    }
    function resolveRenameEditText(text, info) {
      var _a, _b, _c;
      return typeof info.navigation === "object" ? (_c = (_b = (_a = info.navigation).resolveRenameEditText) == null ? void 0 : _b.call(_a, text)) != null ? _c : text : text;
    }
  }
});

// node_modules/@volar/language-core/lib/linkedCodeMap.js
var require_linkedCodeMap = __commonJS({
  "node_modules/@volar/language-core/lib/linkedCodeMap.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LinkedCodeMap = void 0;
    var source_map_1 = require_source_map();
    var LinkedCodeMap = class extends source_map_1.SourceMap {
      *getLinkedOffsets(start) {
        for (const mapped of this.toGeneratedLocation(start)) {
          yield mapped[0];
        }
        for (const mapped of this.toSourceLocation(start)) {
          yield mapped[0];
        }
      }
    };
    exports2.LinkedCodeMap = LinkedCodeMap;
  }
});

// node_modules/@volar/language-core/lib/types.js
var require_types = __commonJS({
  "node_modules/@volar/language-core/lib/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/@volar/language-core/lib/utils.js
var require_utils = __commonJS({
  "node_modules/@volar/language-core/lib/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileMap = void 0;
    var FileMap = class extends Map {
      constructor(caseSensitive) {
        super();
        this.caseSensitive = caseSensitive;
        this.originalFileNames = /* @__PURE__ */ new Map();
      }
      keys() {
        return this.originalFileNames.values();
      }
      get(key) {
        return super.get(this.normalizeId(key));
      }
      has(key) {
        return super.has(this.normalizeId(key));
      }
      set(key, value) {
        this.originalFileNames.set(this.normalizeId(key), key);
        return super.set(this.normalizeId(key), value);
      }
      delete(key) {
        this.originalFileNames.delete(this.normalizeId(key));
        return super.delete(this.normalizeId(key));
      }
      clear() {
        this.originalFileNames.clear();
        return super.clear();
      }
      normalizeId(id) {
        return this.caseSensitive ? id : id.toLowerCase();
      }
    };
    exports2.FileMap = FileMap;
  }
});

// node_modules/@volar/language-core/index.js
var require_language_core = __commonJS({
  "node_modules/@volar/language-core/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultMapperFactory = exports2.SourceMap = void 0;
    exports2.createLanguage = createLanguage;
    exports2.forEachEmbeddedCode = forEachEmbeddedCode;
    var source_map_1 = require_source_map();
    Object.defineProperty(exports2, "SourceMap", { enumerable: true, get: function() {
      return source_map_1.SourceMap;
    } });
    __exportStar(require_editorFeatures(), exports2);
    __exportStar(require_linkedCodeMap(), exports2);
    __exportStar(require_types(), exports2);
    __exportStar(require_utils(), exports2);
    var source_map_2 = require_source_map();
    var linkedCodeMap_1 = require_linkedCodeMap();
    var defaultMapperFactory = (mappings) => new source_map_2.SourceMap(mappings);
    exports2.defaultMapperFactory = defaultMapperFactory;
    function createLanguage(plugins, scriptRegistry, sync) {
      const virtualCodeToSourceScriptMap = /* @__PURE__ */ new WeakMap();
      const virtualCodeToSourceMap = /* @__PURE__ */ new WeakMap();
      const virtualCodeToLinkedCodeMap = /* @__PURE__ */ new WeakMap();
      const language = {
        mapperFactory: exports2.defaultMapperFactory,
        plugins,
        scripts: {
          fromVirtualCode(virtualCode) {
            return virtualCodeToSourceScriptMap.get(virtualCode);
          },
          get(id) {
            sync(id);
            const result = scriptRegistry.get(id);
            if (result == null ? void 0 : result.isAssociationDirty) {
              this.set(id, result.snapshot, result.languageId);
            }
            return scriptRegistry.get(id);
          },
          set(id, snapshot, languageId, _plugins = plugins) {
            var _a, _b, _c;
            if (!languageId) {
              for (const plugin of plugins) {
                languageId = (_a = plugin.getLanguageId) == null ? void 0 : _a.call(plugin, id);
                if (languageId) {
                  break;
                }
              }
            }
            if (!languageId) {
              console.warn(`languageId not found for ${id}`);
              return;
            }
            let associatedOnly = false;
            for (const plugin of plugins) {
              if ((_b = plugin.isAssociatedFileOnly) == null ? void 0 : _b.call(plugin, id, languageId)) {
                associatedOnly = true;
                break;
              }
            }
            if (scriptRegistry.has(id)) {
              const sourceScript = scriptRegistry.get(id);
              if (sourceScript.languageId !== languageId || sourceScript.associatedOnly !== associatedOnly) {
                this.delete(id);
                return this.set(id, snapshot, languageId);
              } else if (associatedOnly) {
                sourceScript.snapshot = snapshot;
              } else if (sourceScript.isAssociationDirty || sourceScript.snapshot !== snapshot) {
                sourceScript.snapshot = snapshot;
                const codegenCtx = prepareCreateVirtualCode(sourceScript);
                if (sourceScript.generated) {
                  const { updateVirtualCode, createVirtualCode } = sourceScript.generated.languagePlugin;
                  const newVirtualCode = updateVirtualCode ? updateVirtualCode(id, sourceScript.generated.root, snapshot, codegenCtx) : createVirtualCode == null ? void 0 : createVirtualCode(id, languageId, snapshot, codegenCtx);
                  if (newVirtualCode) {
                    sourceScript.generated.root = newVirtualCode;
                    sourceScript.generated.embeddedCodes.clear();
                    for (const code of forEachEmbeddedCode(sourceScript.generated.root)) {
                      virtualCodeToSourceScriptMap.set(code, sourceScript);
                      sourceScript.generated.embeddedCodes.set(code.id, code);
                    }
                    return sourceScript;
                  } else {
                    this.delete(id);
                    return;
                  }
                }
                triggerTargetsDirty(sourceScript);
              } else {
                return sourceScript;
              }
            } else {
              const sourceScript = {
                id,
                languageId,
                snapshot,
                associatedIds: /* @__PURE__ */ new Set(),
                targetIds: /* @__PURE__ */ new Set(),
                associatedOnly
              };
              scriptRegistry.set(id, sourceScript);
              if (associatedOnly) {
                return sourceScript;
              }
              for (const languagePlugin of _plugins) {
                const virtualCode = (_c = languagePlugin.createVirtualCode) == null ? void 0 : _c.call(languagePlugin, id, languageId, snapshot, prepareCreateVirtualCode(sourceScript));
                if (virtualCode) {
                  sourceScript.generated = {
                    root: virtualCode,
                    languagePlugin,
                    embeddedCodes: /* @__PURE__ */ new Map()
                  };
                  for (const code of forEachEmbeddedCode(virtualCode)) {
                    virtualCodeToSourceScriptMap.set(code, sourceScript);
                    sourceScript.generated.embeddedCodes.set(code.id, code);
                  }
                  break;
                }
              }
              return sourceScript;
            }
          },
          delete(id) {
            var _a, _b, _c;
            const sourceScript = scriptRegistry.get(id);
            if (sourceScript) {
              (_c = (_a = sourceScript.generated) == null ? void 0 : (_b = _a.languagePlugin).disposeVirtualCode) == null ? void 0 : _c.call(_b, id, sourceScript.generated.root);
              scriptRegistry.delete(id);
              triggerTargetsDirty(sourceScript);
            }
          }
        },
        maps: {
          get(virtualCode, sourceScript) {
            var _a, _b;
            let mapCache = virtualCodeToSourceMap.get(virtualCode.snapshot);
            if (!mapCache) {
              virtualCodeToSourceMap.set(virtualCode.snapshot, mapCache = /* @__PURE__ */ new WeakMap());
            }
            if (!mapCache.has(sourceScript.snapshot)) {
              const mappings = (_b = (_a = virtualCode.associatedScriptMappings) == null ? void 0 : _a.get(sourceScript.id)) != null ? _b : virtualCode.mappings;
              mapCache.set(sourceScript.snapshot, language.mapperFactory(mappings));
            }
            return mapCache.get(sourceScript.snapshot);
          },
          *forEach(virtualCode) {
            const sourceScript = virtualCodeToSourceScriptMap.get(virtualCode);
            yield [
              sourceScript,
              this.get(virtualCode, sourceScript)
            ];
            if (virtualCode.associatedScriptMappings) {
              for (const [relatedScriptId] of virtualCode.associatedScriptMappings) {
                const relatedSourceScript = scriptRegistry.get(relatedScriptId);
                if (relatedSourceScript) {
                  yield [
                    relatedSourceScript,
                    this.get(virtualCode, relatedSourceScript)
                  ];
                }
              }
            }
          }
        },
        linkedCodeMaps: {
          get(virtualCode) {
            const sourceScript = virtualCodeToSourceScriptMap.get(virtualCode);
            let mapCache = virtualCodeToLinkedCodeMap.get(virtualCode.snapshot);
            if ((mapCache == null ? void 0 : mapCache[0]) !== sourceScript.snapshot) {
              virtualCodeToLinkedCodeMap.set(virtualCode.snapshot, mapCache = [
                sourceScript.snapshot,
                virtualCode.linkedCodeMappings ? new linkedCodeMap_1.LinkedCodeMap(virtualCode.linkedCodeMappings) : void 0
              ]);
            }
            return mapCache[1];
          }
        }
      };
      return language;
      function triggerTargetsDirty(sourceScript) {
        sourceScript.targetIds.forEach((id) => {
          const sourceScript2 = scriptRegistry.get(id);
          if (sourceScript2) {
            sourceScript2.isAssociationDirty = true;
          }
        });
      }
      function prepareCreateVirtualCode(sourceScript) {
        var _a;
        for (const id of sourceScript.associatedIds) {
          (_a = scriptRegistry.get(id)) == null ? void 0 : _a.targetIds.delete(sourceScript.id);
        }
        sourceScript.associatedIds.clear();
        sourceScript.isAssociationDirty = false;
        return {
          getAssociatedScript(id) {
            sync(id);
            const relatedSourceScript = scriptRegistry.get(id);
            if (relatedSourceScript) {
              relatedSourceScript.targetIds.add(sourceScript.id);
              sourceScript.associatedIds.add(relatedSourceScript.id);
            }
            return relatedSourceScript;
          }
        };
      }
    }
    function* forEachEmbeddedCode(virtualCode) {
      yield virtualCode;
      if (virtualCode.embeddedCodes) {
        for (const embeddedCode of virtualCode.embeddedCodes) {
          yield* __yieldStar(forEachEmbeddedCode(embeddedCode));
        }
      }
    }
  }
});

// node_modules/@volar/typescript/lib/common.js
var require_common = __commonJS({
  "node_modules/@volar/typescript/lib/common.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveFileLanguageId = resolveFileLanguageId;
    function resolveFileLanguageId(path) {
      const ext = path.split(".").pop();
      switch (ext) {
        case "js":
          return "javascript";
        case "cjs":
          return "javascript";
        case "mjs":
          return "javascript";
        case "ts":
          return "typescript";
        case "cts":
          return "typescript";
        case "mts":
          return "typescript";
        case "jsx":
          return "javascriptreact";
        case "tsx":
          return "typescriptreact";
        case "json":
          return "json";
      }
    }
  }
});

// node_modules/@volar/typescript/lib/node/dedupe.js
var require_dedupe = __commonJS({
  "node_modules/@volar/typescript/lib/node/dedupe.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.dedupeDocumentSpans = dedupeDocumentSpans;
    function dedupeDocumentSpans(items) {
      return dedupe(items, (item) => [
        item.fileName,
        item.textSpan.start,
        item.textSpan.length
      ].join(":"));
    }
    function dedupe(items, getKey) {
      const map = /* @__PURE__ */ new Map();
      for (const item of items.reverse()) {
        map.set(getKey(item), item);
      }
      return [...map.values()];
    }
  }
});

// node_modules/@volar/typescript/lib/node/utils.js
var require_utils2 = __commonJS({
  "node_modules/@volar/typescript/lib/node/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getServiceScript = getServiceScript2;
    function getServiceScript2(language, fileName) {
      var _a, _b;
      const sourceScript = language.scripts.get(fileName);
      if (sourceScript == null ? void 0 : sourceScript.targetIds.size) {
        for (const targetId of sourceScript.targetIds) {
          const targetScript = language.scripts.get(targetId);
          if (targetScript == null ? void 0 : targetScript.generated) {
            const serviceScript = (_a = targetScript.generated.languagePlugin.typescript) == null ? void 0 : _a.getServiceScript(targetScript.generated.root);
            if (serviceScript) {
              return [serviceScript, targetScript, sourceScript];
            }
          }
        }
      }
      if (sourceScript == null ? void 0 : sourceScript.associatedOnly) {
        return [void 0, sourceScript, sourceScript];
      }
      if (sourceScript == null ? void 0 : sourceScript.generated) {
        const serviceScript = (_b = sourceScript.generated.languagePlugin.typescript) == null ? void 0 : _b.getServiceScript(sourceScript.generated.root);
        if (serviceScript) {
          return [serviceScript, sourceScript, sourceScript];
        }
      }
      return [void 0, void 0, void 0];
    }
  }
});

// node_modules/@volar/typescript/lib/node/transform.js
var require_transform = __commonJS({
  "node_modules/@volar/typescript/lib/node/transform.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transformCallHierarchyItem = transformCallHierarchyItem;
    exports2.transformDiagnostic = transformDiagnostic;
    exports2.fillSourceFileText = fillSourceFileText;
    exports2.transformFileTextChanges = transformFileTextChanges;
    exports2.transformDocumentSpan = transformDocumentSpan;
    exports2.transformSpan = transformSpan;
    exports2.transformTextChange = transformTextChange;
    exports2.transformTextSpan = transformTextSpan;
    exports2.toSourceOffset = toSourceOffset;
    exports2.toSourceRanges = toSourceRanges2;
    exports2.toSourceOffsets = toSourceOffsets;
    exports2.toGeneratedRanges = toGeneratedRanges2;
    exports2.toGeneratedOffset = toGeneratedOffset;
    exports2.toGeneratedOffsets = toGeneratedOffsets;
    exports2.getMappingOffset = getMappingOffset;
    var language_core_1 = require_language_core();
    var utils_1 = require_utils2();
    var transformedDiagnostics = /* @__PURE__ */ new WeakMap();
    var transformedSourceFile = /* @__PURE__ */ new WeakSet();
    function transformCallHierarchyItem(language, item, filter) {
      var _a, _b, _c;
      const span = transformSpan(language, item.file, item.span, filter);
      const selectionSpan = transformSpan(language, item.file, item.selectionSpan, filter);
      return __spreadProps(__spreadValues({}, item), {
        file: (_a = span == null ? void 0 : span.fileName) != null ? _a : item.file,
        span: (_b = span == null ? void 0 : span.textSpan) != null ? _b : { start: 0, length: 0 },
        selectionSpan: (_c = selectionSpan == null ? void 0 : selectionSpan.textSpan) != null ? _c : { start: 0, length: 0 }
      });
    }
    function transformDiagnostic(language, diagnostic, program, isTsc) {
      var _a;
      if (!transformedDiagnostics.has(diagnostic)) {
        transformedDiagnostics.set(diagnostic, void 0);
        const { relatedInformation } = diagnostic;
        if (relatedInformation) {
          diagnostic.relatedInformation = relatedInformation.map((d) => transformDiagnostic(language, d, program, isTsc)).filter((d) => !!d);
        }
        if (diagnostic.file !== void 0 && diagnostic.start !== void 0 && diagnostic.length !== void 0) {
          const [serviceScript] = (0, utils_1.getServiceScript)(language, diagnostic.file.fileName);
          if (serviceScript) {
            const [sourceSpanFileName, sourceSpan] = (_a = transformTextSpan(void 0, language, serviceScript, {
              start: diagnostic.start,
              length: diagnostic.length
            }, language_core_1.shouldReportDiagnostics)) != null ? _a : [];
            const actualDiagnosticFile = sourceSpanFileName ? diagnostic.file.fileName === sourceSpanFileName ? diagnostic.file : program == null ? void 0 : program.getSourceFile(sourceSpanFileName) : void 0;
            if (sourceSpan && actualDiagnosticFile) {
              if (isTsc) {
                fillSourceFileText(language, diagnostic.file);
              }
              transformedDiagnostics.set(diagnostic, __spreadProps(__spreadValues({}, diagnostic), {
                file: actualDiagnosticFile,
                start: sourceSpan.start,
                length: sourceSpan.length
              }));
            }
          } else {
            transformedDiagnostics.set(diagnostic, diagnostic);
          }
        } else {
          transformedDiagnostics.set(diagnostic, diagnostic);
        }
      }
      return transformedDiagnostics.get(diagnostic);
    }
    function fillSourceFileText(language, sourceFile) {
      if (transformedSourceFile.has(sourceFile)) {
        return;
      }
      transformedSourceFile.add(sourceFile);
      const [serviceScript] = (0, utils_1.getServiceScript)(language, sourceFile.fileName);
      if (serviceScript && !serviceScript.preventLeadingOffset) {
        const sourceScript = language.scripts.fromVirtualCode(serviceScript.code);
        sourceFile.text = sourceScript.snapshot.getText(0, sourceScript.snapshot.getLength()) + sourceFile.text.substring(sourceScript.snapshot.getLength());
      }
    }
    function transformFileTextChanges(language, changes, filter) {
      var _a;
      const changesPerFile = {};
      const newFiles = /* @__PURE__ */ new Set();
      for (const fileChanges of changes) {
        const [_, source] = (0, utils_1.getServiceScript)(language, fileChanges.fileName);
        if (source) {
          fileChanges.textChanges.forEach((c) => {
            var _a2, _b;
            const { fileName, textSpan } = (_a2 = transformSpan(language, fileChanges.fileName, c.span, filter)) != null ? _a2 : {};
            if (fileName && textSpan) {
              ((_b = changesPerFile[fileName]) != null ? _b : changesPerFile[fileName] = []).push(__spreadProps(__spreadValues({}, c), { span: textSpan }));
            }
          });
        } else {
          const list = (_a = changesPerFile[fileChanges.fileName]) != null ? _a : changesPerFile[fileChanges.fileName] = [];
          fileChanges.textChanges.forEach((c) => {
            list.push(c);
          });
          if (fileChanges.isNewFile) {
            newFiles.add(fileChanges.fileName);
          }
        }
      }
      const result = [];
      for (const fileName in changesPerFile) {
        result.push({
          fileName,
          isNewFile: newFiles.has(fileName),
          textChanges: changesPerFile[fileName]
        });
      }
      return result;
    }
    function transformDocumentSpan(language, documentSpan, filter, shouldFallback) {
      let textSpan = transformSpan(language, documentSpan.fileName, documentSpan.textSpan, filter);
      if (!textSpan && shouldFallback) {
        textSpan = {
          fileName: documentSpan.fileName,
          textSpan: { start: 0, length: 0 }
        };
      }
      if (!textSpan) {
        return;
      }
      const contextSpan = transformSpan(language, documentSpan.fileName, documentSpan.contextSpan, filter);
      const originalTextSpan = transformSpan(language, documentSpan.originalFileName, documentSpan.originalTextSpan, filter);
      const originalContextSpan = transformSpan(language, documentSpan.originalFileName, documentSpan.originalContextSpan, filter);
      return __spreadProps(__spreadValues({}, documentSpan), {
        fileName: textSpan.fileName,
        textSpan: textSpan.textSpan,
        contextSpan: contextSpan == null ? void 0 : contextSpan.textSpan,
        originalFileName: originalTextSpan == null ? void 0 : originalTextSpan.fileName,
        originalTextSpan: originalTextSpan == null ? void 0 : originalTextSpan.textSpan,
        originalContextSpan: originalContextSpan == null ? void 0 : originalContextSpan.textSpan
      });
    }
    function transformSpan(language, fileName, textSpan, filter) {
      var _a;
      if (!fileName || !textSpan) {
        return;
      }
      const [serviceScript] = (0, utils_1.getServiceScript)(language, fileName);
      if (serviceScript) {
        const [sourceSpanFileName, sourceSpan] = (_a = transformTextSpan(void 0, language, serviceScript, textSpan, filter)) != null ? _a : [];
        if (sourceSpan && sourceSpanFileName) {
          return {
            fileName: sourceSpanFileName,
            textSpan: sourceSpan
          };
        }
      } else {
        return {
          fileName,
          textSpan
        };
      }
    }
    function transformTextChange(sourceScript, language, serviceScript, textChange, filter) {
      var _a;
      const [sourceSpanFileName, sourceSpan] = (_a = transformTextSpan(sourceScript, language, serviceScript, textChange.span, filter)) != null ? _a : [];
      if (sourceSpan && sourceSpanFileName) {
        return [sourceSpanFileName, {
          newText: textChange.newText,
          span: sourceSpan
        }];
      }
      return void 0;
    }
    function transformTextSpan(sourceScript, language, serviceScript, textSpan, filter) {
      const start = textSpan.start;
      const end = textSpan.start + textSpan.length;
      for (const [fileName, sourceStart, sourceEnd] of toSourceRanges2(sourceScript, language, serviceScript, start, end, filter)) {
        return [fileName, {
          start: sourceStart,
          length: sourceEnd - sourceStart
        }];
      }
    }
    function toSourceOffset(sourceScript, language, serviceScript, position, filter) {
      for (const source of toSourceOffsets(sourceScript, language, serviceScript, position, filter)) {
        return source;
      }
    }
    function* toSourceRanges2(sourceScript, language, serviceScript, start, end, filter) {
      if (sourceScript) {
        const map = language.maps.get(serviceScript.code, sourceScript);
        for (const [sourceStart, sourceEnd] of map.toSourceRange(start - getMappingOffset(language, serviceScript), end - getMappingOffset(language, serviceScript), true, filter)) {
          yield [sourceScript.id, sourceStart, sourceEnd];
        }
      } else {
        for (const [sourceScript2, map] of language.maps.forEach(serviceScript.code)) {
          for (const [sourceStart, sourceEnd] of map.toSourceRange(start - getMappingOffset(language, serviceScript), end - getMappingOffset(language, serviceScript), true, filter)) {
            yield [sourceScript2.id, sourceStart, sourceEnd];
          }
        }
      }
    }
    function* toSourceOffsets(sourceScript, language, serviceScript, position, filter) {
      if (sourceScript) {
        const map = language.maps.get(serviceScript.code, sourceScript);
        for (const [sourceOffset, mapping] of map.toSourceLocation(position - getMappingOffset(language, serviceScript))) {
          if (filter(mapping.data)) {
            yield [sourceScript.id, sourceOffset];
          }
        }
      } else {
        for (const [sourceScript2, map] of language.maps.forEach(serviceScript.code)) {
          for (const [sourceOffset, mapping] of map.toSourceLocation(position - getMappingOffset(language, serviceScript))) {
            if (filter(mapping.data)) {
              yield [sourceScript2.id, sourceOffset];
            }
          }
        }
      }
    }
    function* toGeneratedRanges2(language, serviceScript, sourceScript, start, end, filter) {
      const map = language.maps.get(serviceScript.code, sourceScript);
      for (const [generateStart, generateEnd] of map.toGeneratedRange(start, end, true, filter)) {
        yield [
          generateStart + getMappingOffset(language, serviceScript),
          generateEnd + getMappingOffset(language, serviceScript)
        ];
      }
    }
    function toGeneratedOffset(language, serviceScript, sourceScript, position, filter) {
      for (const [generateOffset] of toGeneratedOffsets(language, serviceScript, sourceScript, position, filter)) {
        return generateOffset;
      }
    }
    function* toGeneratedOffsets(language, serviceScript, sourceScript, position, filter) {
      const map = language.maps.get(serviceScript.code, sourceScript);
      for (const [generateOffset, mapping] of map.toGeneratedLocation(position)) {
        if (filter(mapping.data)) {
          yield [generateOffset + getMappingOffset(language, serviceScript), mapping];
        }
      }
    }
    function getMappingOffset(language, serviceScript) {
      if (serviceScript.preventLeadingOffset) {
        return 0;
      }
      const sourceScript = language.scripts.fromVirtualCode(serviceScript.code);
      return sourceScript.snapshot.getLength();
    }
  }
});

// node_modules/@volar/typescript/lib/node/decorateLanguageService.js
var require_decorateLanguageService = __commonJS({
  "node_modules/@volar/typescript/lib/node/decorateLanguageService.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decorateLanguageService = decorateLanguageService;
    var language_core_1 = require_language_core();
    var dedupe_1 = require_dedupe();
    var transform_1 = require_transform();
    var utils_1 = require_utils2();
    var windowsPathReg = /\\/g;
    function decorateLanguageService(language, languageService) {
      const { getNavigationTree, getOutliningSpans } = languageService;
      languageService.getNavigationTree = (filePath) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (serviceScript || (targetScript == null ? void 0 : targetScript.associatedOnly)) {
          const tree = getNavigationTree(targetScript.id);
          tree.childItems = void 0;
          return tree;
        } else {
          return getNavigationTree(fileName);
        }
      };
      languageService.getOutliningSpans = (filePath) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (serviceScript || (targetScript == null ? void 0 : targetScript.associatedOnly)) {
          return [];
        } else {
          return getOutliningSpans(fileName);
        }
      };
      const { findReferences, findRenameLocations, getCompletionEntryDetails, getCompletionsAtPosition, getDefinitionAndBoundSpan, getDefinitionAtPosition, getFileReferences, getFormattingEditsForDocument, getFormattingEditsForRange, getFormattingEditsAfterKeystroke, getImplementationAtPosition, getLinkedEditingRangeAtPosition, getQuickInfoAtPosition, getSignatureHelpItems, getReferencesAtPosition, getSemanticDiagnostics, getSyntacticDiagnostics, getSuggestionDiagnostics, getTypeDefinitionAtPosition, getEncodedSemanticClassifications, getDocumentHighlights, getApplicableRefactors, getEditsForFileRename, getEditsForRefactor, getRenameInfo, getCodeFixesAtPosition, prepareCallHierarchy, provideCallHierarchyIncomingCalls, provideCallHierarchyOutgoingCalls, provideInlayHints, organizeImports } = languageService;
      languageService.getFormattingEditsForDocument = (filePath, options) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const map = language.maps.get(serviceScript.code, targetScript);
          if (!map.mappings.some((mapping) => (0, language_core_1.isFormattingEnabled)(mapping.data))) {
            return [];
          }
          const edits = getFormattingEditsForDocument(targetScript.id, options);
          return edits.map((edit) => {
            var _a;
            return (_a = (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, language_core_1.isFormattingEnabled)) == null ? void 0 : _a[1];
          }).filter((edit) => !!edit);
        } else {
          return getFormattingEditsForDocument(fileName, options);
        }
      };
      languageService.getFormattingEditsForRange = (filePath, start, end, options) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const generateStart = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, start, language_core_1.isFormattingEnabled);
          const generateEnd = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, end, language_core_1.isFormattingEnabled);
          if (generateStart !== void 0 && generateEnd !== void 0) {
            const edits = getFormattingEditsForRange(targetScript.id, generateStart, generateEnd, options);
            return edits.map((edit) => {
              var _a;
              return (_a = (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, language_core_1.isFormattingEnabled)) == null ? void 0 : _a[1];
            }).filter((edit) => !!edit);
          }
          return [];
        } else {
          return getFormattingEditsForRange(fileName, start, end, options);
        }
      };
      languageService.getFormattingEditsAfterKeystroke = (filePath, position, key, options) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isFormattingEnabled);
          if (generatePosition !== void 0) {
            const edits = getFormattingEditsAfterKeystroke(targetScript.id, generatePosition, key, options);
            return edits.map((edit) => {
              var _a;
              return (_a = (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, language_core_1.isFormattingEnabled)) == null ? void 0 : _a[1];
            }).filter((edit) => !!edit);
          }
          return [];
        } else {
          return getFormattingEditsAfterKeystroke(fileName, position, key, options);
        }
      };
      languageService.getEditsForFileRename = (oldFilePath, newFilePath, formatOptions, preferences) => {
        const edits = getEditsForFileRename(oldFilePath, newFilePath, formatOptions, preferences);
        return (0, transform_1.transformFileTextChanges)(language, edits, language_core_1.isRenameEnabled);
      };
      languageService.getLinkedEditingRangeAtPosition = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isLinkedEditingEnabled);
          if (generatePosition !== void 0) {
            const info = getLinkedEditingRangeAtPosition(targetScript.id, generatePosition);
            if (info) {
              return {
                ranges: info.ranges.map((span) => {
                  var _a;
                  return (_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, span, language_core_1.isLinkedEditingEnabled)) == null ? void 0 : _a[1];
                }).filter((span) => !!span),
                wordPattern: info.wordPattern
              };
            }
          }
        } else {
          return getLinkedEditingRangeAtPosition(fileName, position);
        }
      };
      languageService.prepareCallHierarchy = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isCallHierarchyEnabled);
          if (generatePosition !== void 0) {
            const item = prepareCallHierarchy(targetScript.id, generatePosition);
            if (Array.isArray(item)) {
              return item.map((item2) => (0, transform_1.transformCallHierarchyItem)(language, item2, language_core_1.isCallHierarchyEnabled));
            } else if (item) {
              return (0, transform_1.transformCallHierarchyItem)(language, item, language_core_1.isCallHierarchyEnabled);
            }
          }
        } else {
          return prepareCallHierarchy(fileName, position);
        }
      };
      languageService.provideCallHierarchyIncomingCalls = (filePath, position) => {
        let calls = [];
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isCallHierarchyEnabled);
          if (generatePosition !== void 0) {
            calls = provideCallHierarchyIncomingCalls(targetScript.id, generatePosition);
          }
        } else {
          calls = provideCallHierarchyIncomingCalls(fileName, position);
        }
        return calls.map((call) => {
          const from = (0, transform_1.transformCallHierarchyItem)(language, call.from, language_core_1.isCallHierarchyEnabled);
          const fromSpans = call.fromSpans.map((span) => {
            var _a;
            return (_a = (0, transform_1.transformSpan)(language, call.from.file, span, language_core_1.isCallHierarchyEnabled)) == null ? void 0 : _a.textSpan;
          }).filter((span) => !!span);
          return {
            from,
            fromSpans
          };
        });
      };
      languageService.provideCallHierarchyOutgoingCalls = (filePath, position) => {
        let calls = [];
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isCallHierarchyEnabled);
          if (generatePosition !== void 0) {
            calls = provideCallHierarchyOutgoingCalls(targetScript.id, generatePosition);
          }
        } else {
          calls = provideCallHierarchyOutgoingCalls(fileName, position);
        }
        return calls.map((call) => {
          const to = (0, transform_1.transformCallHierarchyItem)(language, call.to, language_core_1.isCallHierarchyEnabled);
          const fromSpans = call.fromSpans.map((span) => {
            var _a;
            return serviceScript ? (_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, span, language_core_1.isCallHierarchyEnabled)) == null ? void 0 : _a[1] : span;
          }).filter((span) => !!span);
          return {
            to,
            fromSpans
          };
        });
      };
      languageService.organizeImports = (args, formatOptions, preferences) => {
        const unresolved = organizeImports(args, formatOptions, preferences);
        return (0, transform_1.transformFileTextChanges)(language, unresolved, language_core_1.isCodeActionsEnabled);
      };
      languageService.getQuickInfoAtPosition = (filePath, position) => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const infos = [];
          for (const [generatePosition] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1.isHoverEnabled)) {
            const info = getQuickInfoAtPosition(targetScript.id, generatePosition);
            if (info) {
              const textSpan = (_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, info.textSpan, language_core_1.isHoverEnabled)) == null ? void 0 : _a[1];
              if (textSpan) {
                infos.push(__spreadProps(__spreadValues({}, info), {
                  textSpan
                }));
              }
            }
          }
          if (infos.length === 1) {
            return infos[0];
          } else if (infos.length >= 2) {
            const combine = __spreadValues({}, infos[0]);
            combine.displayParts = (_b = combine.displayParts) == null ? void 0 : _b.slice();
            combine.documentation = (_c = combine.documentation) == null ? void 0 : _c.slice();
            combine.tags = (_d = combine.tags) == null ? void 0 : _d.slice();
            const displayPartsStrs = /* @__PURE__ */ new Set([displayPartsToString(infos[0].displayParts)]);
            const documentationStrs = /* @__PURE__ */ new Set([displayPartsToString(infos[0].documentation)]);
            const tagsStrs = /* @__PURE__ */ new Set();
            for (const tag of (_e = infos[0].tags) != null ? _e : []) {
              tagsStrs.add(tag.name + "__volar__" + displayPartsToString(tag.text));
            }
            for (let i = 1; i < infos.length; i++) {
              const { displayParts, documentation, tags } = infos[i];
              if ((displayParts == null ? void 0 : displayParts.length) && !displayPartsStrs.has(displayPartsToString(displayParts))) {
                displayPartsStrs.add(displayPartsToString(displayParts));
                (_f = combine.displayParts) != null ? _f : combine.displayParts = [];
                combine.displayParts.push(__spreadProps(__spreadValues({}, displayParts[0]), { text: "\n\n" + displayParts[0].text }));
                combine.displayParts.push(...displayParts.slice(1));
              }
              if ((documentation == null ? void 0 : documentation.length) && !documentationStrs.has(displayPartsToString(documentation))) {
                documentationStrs.add(displayPartsToString(documentation));
                (_g = combine.documentation) != null ? _g : combine.documentation = [];
                combine.documentation.push(__spreadProps(__spreadValues({}, documentation[0]), { text: "\n\n" + documentation[0].text }));
                combine.documentation.push(...documentation.slice(1));
              }
              for (const tag of tags != null ? tags : []) {
                if (!tagsStrs.has(tag.name + "__volar__" + displayPartsToString(tag.text))) {
                  tagsStrs.add(tag.name + "__volar__" + displayPartsToString(tag.text));
                  (_h = combine.tags) != null ? _h : combine.tags = [];
                  combine.tags.push(tag);
                }
              }
            }
            return combine;
          }
        } else {
          return getQuickInfoAtPosition(fileName, position);
        }
      };
      languageService.getSignatureHelpItems = (filePath, position, options) => {
        var _a;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isSignatureHelpEnabled);
          if (generatePosition !== void 0) {
            const result = getSignatureHelpItems(targetScript.id, generatePosition, options);
            if (result) {
              const applicableSpan = (_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, result.applicableSpan, language_core_1.isSignatureHelpEnabled)) == null ? void 0 : _a[1];
              if (applicableSpan) {
                return __spreadProps(__spreadValues({}, result), {
                  applicableSpan
                });
              }
            }
          }
        } else {
          return getSignatureHelpItems(fileName, position, options);
        }
      };
      languageService.getDocumentHighlights = (filePath, position, filesToSearch) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isHighlightEnabled, (fileName2, position2) => getDocumentHighlights(fileName2, position2, filesToSearch), function* (result) {
          var _a;
          for (const ref of result) {
            for (const reference of ref.highlightSpans) {
              yield [(_a = reference.fileName) != null ? _a : ref.fileName, reference.textSpan.start];
            }
          }
        });
        const resolved = unresolved.flat().map((highlights) => {
          return __spreadProps(__spreadValues({}, highlights), {
            highlightSpans: highlights.highlightSpans.map((span) => {
              var _a, _b, _c, _d;
              const { textSpan } = (_b = (0, transform_1.transformSpan)(language, (_a = span.fileName) != null ? _a : highlights.fileName, span.textSpan, language_core_1.isHighlightEnabled)) != null ? _b : {};
              if (textSpan) {
                return __spreadProps(__spreadValues({}, span), {
                  contextSpan: (_d = (0, transform_1.transformSpan)(language, (_c = span.fileName) != null ? _c : highlights.fileName, span.contextSpan, language_core_1.isHighlightEnabled)) == null ? void 0 : _d.textSpan,
                  textSpan
                });
              }
            }).filter((span) => !!span)
          });
        });
        return resolved;
      };
      languageService.getApplicableRefactors = (filePath, positionOrRange, preferences, triggerReason, kind, includeInteractiveActions) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          if (typeof positionOrRange === "number") {
            const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, positionOrRange, language_core_1.isCodeActionsEnabled);
            if (generatePosition !== void 0) {
              return getApplicableRefactors(targetScript.id, generatePosition, preferences, triggerReason, kind, includeInteractiveActions);
            }
          } else {
            for (const [generatedStart, generatedEnd] of (0, transform_1.toGeneratedRanges)(language, serviceScript, sourceScript, positionOrRange.pos, positionOrRange.end, language_core_1.isCodeActionsEnabled)) {
              return getApplicableRefactors(targetScript.id, { pos: generatedStart, end: generatedEnd }, preferences, triggerReason, kind, includeInteractiveActions);
            }
          }
          return [];
        } else {
          return getApplicableRefactors(fileName, positionOrRange, preferences, triggerReason, kind, includeInteractiveActions);
        }
      };
      languageService.getEditsForRefactor = (filePath, formatOptions, positionOrRange, refactorName, actionName, preferences) => {
        let edits;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          if (typeof positionOrRange === "number") {
            const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, positionOrRange, language_core_1.isCodeActionsEnabled);
            if (generatePosition !== void 0) {
              edits = getEditsForRefactor(targetScript.id, formatOptions, generatePosition, refactorName, actionName, preferences);
            }
          } else {
            for (const [generatedStart, generatedEnd] of (0, transform_1.toGeneratedRanges)(language, serviceScript, sourceScript, positionOrRange.pos, positionOrRange.end, language_core_1.isCodeActionsEnabled)) {
              edits = getEditsForRefactor(targetScript.id, formatOptions, { pos: generatedStart, end: generatedEnd }, refactorName, actionName, preferences);
            }
          }
        } else {
          edits = getEditsForRefactor(fileName, formatOptions, positionOrRange, refactorName, actionName, preferences);
        }
        if (edits) {
          edits.edits = (0, transform_1.transformFileTextChanges)(language, edits.edits, language_core_1.isCodeActionsEnabled);
          return edits;
        }
      };
      languageService.getRenameInfo = (filePath, position, options) => {
        var _a;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return {
            canRename: false,
            localizedErrorMessage: "Cannot rename"
          };
        }
        if (serviceScript) {
          let failed;
          for (const [generateOffset] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1.isRenameEnabled)) {
            const info = getRenameInfo(targetScript.id, generateOffset, options);
            if (info.canRename) {
              const span = (_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, info.triggerSpan, language_core_1.isRenameEnabled)) == null ? void 0 : _a[1];
              if (span) {
                info.triggerSpan = span;
                return info;
              }
            } else {
              failed = info;
            }
          }
          if (failed) {
            return failed;
          }
          return {
            canRename: false,
            localizedErrorMessage: "Failed to get rename locations"
          };
        } else {
          return getRenameInfo(fileName, position, options);
        }
      };
      languageService.getCodeFixesAtPosition = (filePath, start, end, errorCodes, formatOptions, preferences) => {
        let fixes = [];
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          const generateStart = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, start, language_core_1.isCodeActionsEnabled);
          const generateEnd = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, end, language_core_1.isCodeActionsEnabled);
          if (generateStart !== void 0 && generateEnd !== void 0) {
            fixes = getCodeFixesAtPosition(targetScript.id, generateStart, generateEnd, errorCodes, formatOptions, preferences);
          }
        } else {
          fixes = getCodeFixesAtPosition(fileName, start, end, errorCodes, formatOptions, preferences);
        }
        fixes = fixes.map((fix) => {
          fix.changes = (0, transform_1.transformFileTextChanges)(language, fix.changes, language_core_1.isCodeActionsEnabled);
          return fix;
        });
        return fixes;
      };
      languageService.getEncodedSemanticClassifications = (filePath, span, format) => {
        var _a, _b;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return {
            spans: [],
            endOfLineState: 0
          };
        }
        if (serviceScript) {
          let start;
          let end;
          const map = language.maps.get(serviceScript.code, targetScript);
          for (const mapping of map.mappings) {
            if ((0, language_core_1.isSemanticTokensEnabled)(mapping.data) && mapping.sourceOffsets[0] >= span.start && mapping.sourceOffsets[0] <= span.start + span.length) {
              start != null ? start : start = mapping.generatedOffsets[0];
              end != null ? end : end = mapping.generatedOffsets[mapping.generatedOffsets.length - 1] + ((_a = mapping.generatedLengths) != null ? _a : mapping.lengths)[mapping.lengths.length - 1];
              start = Math.min(start, mapping.generatedOffsets[0]);
              end = Math.max(end, mapping.generatedOffsets[mapping.generatedOffsets.length - 1] + ((_b = mapping.generatedLengths) != null ? _b : mapping.lengths)[mapping.lengths.length - 1]);
            }
          }
          start != null ? start : start = 0;
          end != null ? end : end = targetScript.snapshot.getLength();
          const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript);
          start += mappingOffset;
          end += mappingOffset;
          const result = getEncodedSemanticClassifications(targetScript.id, { start, length: end - start }, format);
          const spans = [];
          for (let i = 0; i < result.spans.length; i += 3) {
            for (const [_, sourceStart, sourceEnd] of (0, transform_1.toSourceRanges)(sourceScript, language, serviceScript, result.spans[i], result.spans[i] + result.spans[i + 1], language_core_1.isSemanticTokensEnabled)) {
              spans.push(sourceStart, sourceEnd - sourceStart, result.spans[i + 2]);
              break;
            }
          }
          result.spans = spans;
          return result;
        } else {
          return getEncodedSemanticClassifications(fileName, span, format);
        }
      };
      languageService.getSyntacticDiagnostics = (filePath) => {
        var _a;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        return getSyntacticDiagnostics((_a = targetScript == null ? void 0 : targetScript.id) != null ? _a : fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || language.scripts.get(d.file.fileName) === sourceScript);
      };
      languageService.getSemanticDiagnostics = (filePath) => {
        var _a;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        return getSemanticDiagnostics((_a = targetScript == null ? void 0 : targetScript.id) != null ? _a : fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || !d.file || language.scripts.get(d.file.fileName) === sourceScript);
      };
      languageService.getSuggestionDiagnostics = (filePath) => {
        var _a;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        return getSuggestionDiagnostics((_a = targetScript == null ? void 0 : targetScript.id) != null ? _a : fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || !d.file || language.scripts.get(d.file.fileName) === sourceScript);
      };
      languageService.getDefinitionAndBoundSpan = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isDefinitionEnabled, (fileName2, position2) => getDefinitionAndBoundSpan(fileName2, position2), function* (result) {
          var _a;
          for (const ref of (_a = result.definitions) != null ? _a : []) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const textSpan = unresolved.map((s) => {
          var _a;
          return (_a = (0, transform_1.transformSpan)(language, fileName, s.textSpan, language_core_1.isDefinitionEnabled)) == null ? void 0 : _a.textSpan;
        }).filter((s) => !!s)[0];
        if (!textSpan) {
          return;
        }
        const definitions = unresolved.map((s) => {
          var _a, _b;
          return (_b = (_a = s.definitions) == null ? void 0 : _a.map((s2) => (0, transform_1.transformDocumentSpan)(language, s2, language_core_1.isDefinitionEnabled, s2.fileName !== fileName)).filter((s2) => !!s2)) != null ? _b : [];
        }).flat();
        return {
          textSpan,
          definitions: (0, dedupe_1.dedupeDocumentSpans)(definitions)
        };
      };
      languageService.findReferences = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isReferencesEnabled, (fileName2, position2) => findReferences(fileName2, position2), function* (result) {
          for (const ref of result) {
            for (const reference of ref.references) {
              yield [reference.fileName, reference.textSpan.start];
            }
          }
        });
        const resolved = unresolved.flat().map((symbol) => {
          const definition = (0, transform_1.transformDocumentSpan)(language, symbol.definition, language_core_1.isDefinitionEnabled, true);
          return {
            definition,
            references: symbol.references.map((r) => (0, transform_1.transformDocumentSpan)(language, r, language_core_1.isReferencesEnabled)).filter((r) => !!r)
          };
        });
        return resolved;
      };
      languageService.getDefinitionAtPosition = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isDefinitionEnabled, (fileName2, position2) => getDefinitionAtPosition(fileName2, position2), function* (result) {
          for (const ref of result) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isDefinitionEnabled, s.fileName !== fileName)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      languageService.getTypeDefinitionAtPosition = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isTypeDefinitionEnabled, (fileName2, position2) => getTypeDefinitionAtPosition(fileName2, position2), function* (result) {
          for (const ref of result) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isTypeDefinitionEnabled)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      languageService.getImplementationAtPosition = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isImplementationEnabled, (fileName2, position2) => getImplementationAtPosition(fileName2, position2), function* (result) {
          for (const ref of result) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isImplementationEnabled)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      languageService.findRenameLocations = (filePath, position, findInStrings, findInComments, preferences) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isRenameEnabled, (fileName2, position2) => findRenameLocations(fileName2, position2, findInStrings, findInComments, preferences), function* (result) {
          for (const ref of result) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isRenameEnabled)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      languageService.getReferencesAtPosition = (filePath, position) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = linkedCodeFeatureWorker(fileName, position, language_core_1.isReferencesEnabled, (fileName2, position2) => getReferencesAtPosition(fileName2, position2), function* (result) {
          for (const ref of result) {
            yield [ref.fileName, ref.textSpan.start];
          }
        });
        const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isReferencesEnabled)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      languageService.getCompletionsAtPosition = (filePath, position, options, formattingSettings) => {
        var _a, _b;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const results = [];
          for (const [generatedOffset, mapping] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1.isCompletionEnabled)) {
            const result = getCompletionsAtPosition(targetScript.id, generatedOffset, options, formattingSettings);
            if (!result) {
              continue;
            }
            if (typeof mapping.data.completion === "object" && mapping.data.completion.onlyImport) {
              result.entries = result.entries.filter((entry) => !!entry.sourceDisplay);
            }
            for (const entry of result.entries) {
              entry.replacementSpan = entry.replacementSpan && ((_a = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, entry.replacementSpan, language_core_1.isCompletionEnabled)) == null ? void 0 : _a[1]);
            }
            result.optionalReplacementSpan = result.optionalReplacementSpan && ((_b = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, result.optionalReplacementSpan, language_core_1.isCompletionEnabled)) == null ? void 0 : _b[1]);
            const isAdditional = typeof mapping.data.completion === "object" && mapping.data.completion.isAdditional;
            if (isAdditional) {
              results.push(result);
            } else {
              results.unshift(result);
            }
          }
          if (results.length) {
            return __spreadProps(__spreadValues({}, results[0]), {
              entries: results.map((additionalResult) => additionalResult.entries).flat()
            });
          }
        } else {
          return getCompletionsAtPosition(fileName, position, options, formattingSettings);
        }
      };
      languageService.getCompletionEntryDetails = (filePath, position, entryName, formatOptions, source, preferences, data) => {
        let details;
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return void 0;
        }
        if (serviceScript) {
          const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1.isCompletionEnabled);
          if (generatePosition !== void 0) {
            details = getCompletionEntryDetails(targetScript.id, generatePosition, entryName, formatOptions, source, preferences, data);
          }
        } else {
          return getCompletionEntryDetails(fileName, position, entryName, formatOptions, source, preferences, data);
        }
        if (details == null ? void 0 : details.codeActions) {
          for (const codeAction of details.codeActions) {
            codeAction.changes = (0, transform_1.transformFileTextChanges)(language, codeAction.changes, language_core_1.isCompletionEnabled);
          }
        }
        return details;
      };
      languageService.provideInlayHints = (filePath, span, preferences) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (targetScript == null ? void 0 : targetScript.associatedOnly) {
          return [];
        }
        if (serviceScript) {
          let start;
          let end;
          const map = language.maps.get(serviceScript.code, targetScript);
          for (const mapping of map.mappings) {
            if ((0, language_core_1.isInlayHintsEnabled)(mapping.data) && mapping.sourceOffsets[0] >= span.start && mapping.sourceOffsets[0] <= span.start + span.length) {
              start != null ? start : start = mapping.generatedOffsets[0];
              end != null ? end : end = mapping.generatedOffsets[mapping.generatedOffsets.length - 1];
              start = Math.min(start, mapping.generatedOffsets[0]);
              end = Math.max(end, mapping.generatedOffsets[mapping.generatedOffsets.length - 1]);
            }
          }
          if (start === void 0 || end === void 0) {
            start = 0;
            end = 0;
          }
          const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript);
          start += mappingOffset;
          end += mappingOffset;
          const result = provideInlayHints(targetScript.id, { start, length: end - start }, preferences);
          const hints = [];
          for (const hint of result) {
            const sourcePosition = (0, transform_1.toSourceOffset)(sourceScript, language, serviceScript, hint.position, language_core_1.isInlayHintsEnabled);
            if (sourcePosition !== void 0) {
              hints.push(__spreadProps(__spreadValues({}, hint), {
                position: sourcePosition[1]
              }));
            }
          }
          return hints;
        } else {
          return provideInlayHints(fileName, span, preferences);
        }
      };
      languageService.getFileReferences = (filePath) => {
        const fileName = filePath.replace(windowsPathReg, "/");
        const unresolved = getFileReferences(fileName);
        const resolved = unresolved.map((s) => (0, transform_1.transformDocumentSpan)(language, s, language_core_1.isReferencesEnabled)).filter((s) => !!s);
        return (0, dedupe_1.dedupeDocumentSpans)(resolved);
      };
      function linkedCodeFeatureWorker(fileName, position, filter, worker, getLinkedCodes) {
        const results = [];
        const processedFilePositions = /* @__PURE__ */ new Set();
        const [serviceScript, targetScript, sourceScript] = (0, utils_1.getServiceScript)(language, fileName);
        if (serviceScript) {
          for (const [generatedOffset] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, filter)) {
            process(targetScript.id, generatedOffset);
          }
        } else {
          process(fileName, position);
        }
        return results;
        function process(fileName2, position2) {
          if (processedFilePositions.has(fileName2 + ":" + position2)) {
            return;
          }
          processedFilePositions.add(fileName2 + ":" + position2);
          const result = worker(fileName2, position2);
          if (!result) {
            return;
          }
          results.push(result);
          for (const ref of getLinkedCodes(result)) {
            processedFilePositions.add(ref[0] + ":" + ref[1]);
            const [serviceScript2] = (0, utils_1.getServiceScript)(language, ref[0]);
            if (!serviceScript2) {
              continue;
            }
            const linkedCodeMap = language.linkedCodeMaps.get(serviceScript2.code);
            if (!linkedCodeMap) {
              continue;
            }
            const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript2);
            for (const linkedCodeOffset of linkedCodeMap.getLinkedOffsets(ref[1] - mappingOffset)) {
              process(ref[0], linkedCodeOffset + mappingOffset);
            }
          }
        }
      }
    }
    function displayPartsToString(displayParts) {
      if (displayParts) {
        return displayParts.map((displayPart) => displayPart.text).join("");
      }
      return "";
    }
  }
});

// node_modules/@volar/typescript/lib/resolveModuleName.js
var require_resolveModuleName = __commonJS({
  "node_modules/@volar/typescript/lib/resolveModuleName.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createResolveModuleName = createResolveModuleName;
    function createResolveModuleName(ts, host, languagePlugins, getSourceScript) {
      var _a, _b, _c, _d;
      const toSourceFileInfo = /* @__PURE__ */ new Map();
      const moduleResolutionHost = {
        readFile: host.readFile.bind(host),
        directoryExists: (_a = host.directoryExists) == null ? void 0 : _a.bind(host),
        realpath: (_b = host.realpath) == null ? void 0 : _b.bind(host),
        getCurrentDirectory: (_c = host.getCurrentDirectory) == null ? void 0 : _c.bind(host),
        getDirectories: (_d = host.getDirectories) == null ? void 0 : _d.bind(host),
        useCaseSensitiveFileNames: typeof host.useCaseSensitiveFileNames === "function" ? host.useCaseSensitiveFileNames.bind(host) : host.useCaseSensitiveFileNames,
        fileExists(fileName) {
          var _a2, _b2;
          for (const { typescript } of languagePlugins) {
            if (!typescript) {
              continue;
            }
            for (const { extension } of typescript.extraFileExtensions) {
              if (fileName.endsWith(`.d.${extension}.ts`)) {
                const sourceFileName = fileName.slice(0, -`.d.${extension}.ts`.length) + `.${extension}`;
                if (fileExists(sourceFileName)) {
                  const sourceScript = getSourceScript(sourceFileName);
                  if (sourceScript == null ? void 0 : sourceScript.generated) {
                    const serviceScript = (_a2 = sourceScript.generated.languagePlugin.typescript) == null ? void 0 : _a2.getServiceScript(sourceScript.generated.root);
                    if (serviceScript) {
                      const dtsPath = sourceFileName + ".d.ts";
                      if ((serviceScript.extension === ".js" || serviceScript.extension === ".jsx") && fileExists(dtsPath)) {
                        toSourceFileInfo.set(fileName, {
                          sourceFileName: dtsPath,
                          extension: ".ts"
                        });
                      } else {
                        toSourceFileInfo.set(fileName, {
                          sourceFileName,
                          extension: serviceScript.extension
                        });
                      }
                      return true;
                    }
                  }
                }
              }
            }
            if (typescript.resolveHiddenExtensions && fileName.endsWith(`.d.ts`)) {
              for (const { extension } of typescript.extraFileExtensions) {
                const sourceFileName = fileName.slice(0, -`.d.ts`.length) + `.${extension}`;
                if (fileExists(sourceFileName)) {
                  const sourceScript = getSourceScript(sourceFileName);
                  if (sourceScript == null ? void 0 : sourceScript.generated) {
                    const serviceScript = (_b2 = sourceScript.generated.languagePlugin.typescript) == null ? void 0 : _b2.getServiceScript(sourceScript.generated.root);
                    if (serviceScript) {
                      toSourceFileInfo.set(fileName, {
                        sourceFileName,
                        extension: serviceScript.extension
                      });
                      return true;
                    }
                  }
                }
              }
            }
          }
          return host.fileExists(fileName);
        }
      };
      return (moduleName, containingFile, compilerOptions, cache, redirectedReference, resolutionMode) => {
        const result = ts.resolveModuleName(moduleName, containingFile, compilerOptions, moduleResolutionHost, cache, redirectedReference, resolutionMode);
        if (result.resolvedModule) {
          const sourceFileInfo = toSourceFileInfo.get(result.resolvedModule.resolvedFileName);
          if (sourceFileInfo) {
            result.resolvedModule.resolvedFileName = sourceFileInfo.sourceFileName;
            result.resolvedModule.extension = sourceFileInfo.extension;
          }
        }
        toSourceFileInfo.clear();
        return result;
      };
      function fileExists(fileName) {
        var _a2, _b2, _c2, _d2, _e;
        if (host.fileExists(fileName)) {
          const fileSize = (_e = (_d2 = (_b2 = (_a2 = ts.sys).getFileSize) == null ? void 0 : _b2.call(_a2, fileName)) != null ? _d2 : (_c2 = host.readFile(fileName)) == null ? void 0 : _c2.length) != null ? _e : 0;
          return fileSize < 4 * 1024 * 1024;
        }
        return false;
      }
    }
  }
});

// node_modules/@volar/typescript/lib/node/decorateLanguageServiceHost.js
var require_decorateLanguageServiceHost = __commonJS({
  "node_modules/@volar/typescript/lib/node/decorateLanguageServiceHost.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decorateLanguageServiceHost = decorateLanguageServiceHost;
    exports2.searchExternalFiles = searchExternalFiles;
    var resolveModuleName_1 = require_resolveModuleName();
    function decorateLanguageServiceHost(ts, language, languageServiceHost) {
      var _a, _b, _c, _d, _e;
      const pluginExtensions = language.plugins.map((plugin) => {
        var _a2, _b2;
        return (_b2 = (_a2 = plugin.typescript) == null ? void 0 : _a2.extraFileExtensions.map((ext) => "." + ext.extension)) != null ? _b2 : [];
      }).flat();
      const scripts = /* @__PURE__ */ new Map();
      const crashFileNames = /* @__PURE__ */ new Set();
      const readDirectory = (_a = languageServiceHost.readDirectory) == null ? void 0 : _a.bind(languageServiceHost);
      const resolveModuleNameLiterals = (_b = languageServiceHost.resolveModuleNameLiterals) == null ? void 0 : _b.bind(languageServiceHost);
      const resolveModuleNames = (_c = languageServiceHost.resolveModuleNames) == null ? void 0 : _c.bind(languageServiceHost);
      const getScriptSnapshot = languageServiceHost.getScriptSnapshot.bind(languageServiceHost);
      const getScriptKind = (_d = languageServiceHost.getScriptKind) == null ? void 0 : _d.bind(languageServiceHost);
      if (readDirectory) {
        languageServiceHost.readDirectory = (path, extensions, exclude, include, depth) => {
          if (extensions) {
            for (const ext of pluginExtensions) {
              if (!extensions.includes(ext)) {
                extensions = [...extensions, ext];
              }
            }
          }
          return readDirectory(path, extensions, exclude, include, depth);
        };
      }
      if (pluginExtensions.length) {
        const resolveModuleName = (0, resolveModuleName_1.createResolveModuleName)(ts, languageServiceHost, language.plugins, (fileName) => language.scripts.get(fileName));
        const getCanonicalFileName = ((_e = languageServiceHost.useCaseSensitiveFileNames) == null ? void 0 : _e.call(languageServiceHost)) ? (fileName) => fileName : (fileName) => fileName.toLowerCase();
        const moduleResolutionCache = ts.createModuleResolutionCache(languageServiceHost.getCurrentDirectory(), getCanonicalFileName, languageServiceHost.getCompilationSettings());
        if (resolveModuleNameLiterals) {
          languageServiceHost.resolveModuleNameLiterals = (moduleLiterals, containingFile, redirectedReference, options, ...rest) => {
            if (moduleLiterals.every((name) => !pluginExtensions.some((ext) => name.text.endsWith(ext)))) {
              return resolveModuleNameLiterals(moduleLiterals, containingFile, redirectedReference, options, ...rest);
            }
            return moduleLiterals.map((moduleLiteral) => {
              return resolveModuleName(moduleLiteral.text, containingFile, options, moduleResolutionCache, redirectedReference);
            });
          };
        }
        if (resolveModuleNames) {
          languageServiceHost.resolveModuleNames = (moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile) => {
            if (moduleNames.every((name) => !pluginExtensions.some((ext) => name.endsWith(ext)))) {
              return resolveModuleNames(moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile);
            }
            return moduleNames.map((moduleName) => {
              return resolveModuleName(moduleName, containingFile, options, moduleResolutionCache, redirectedReference).resolvedModule;
            });
          };
        }
      }
      languageServiceHost.getScriptSnapshot = (fileName) => {
        const virtualScript = updateVirtualScript(fileName);
        if (virtualScript) {
          return virtualScript.snapshot;
        }
        return getScriptSnapshot(fileName);
      };
      if (getScriptKind) {
        languageServiceHost.getScriptKind = (fileName) => {
          const virtualScript = updateVirtualScript(fileName);
          if (virtualScript) {
            return virtualScript.scriptKind;
          }
          return getScriptKind(fileName);
        };
      }
      function updateVirtualScript(fileName) {
        var _a2, _b2;
        if (crashFileNames.has(fileName)) {
          return;
        }
        let version;
        try {
          version = languageServiceHost.getScriptVersion(fileName);
        } catch (e) {
          crashFileNames.add(fileName);
        }
        if (version === void 0) {
          return;
        }
        let script = scripts.get(fileName);
        if (!script || script[0] !== version) {
          script = [version];
          const sourceScript = language.scripts.get(fileName);
          if (sourceScript == null ? void 0 : sourceScript.generated) {
            const serviceScript = (_a2 = sourceScript.generated.languagePlugin.typescript) == null ? void 0 : _a2.getServiceScript(sourceScript.generated.root);
            if (serviceScript) {
              if (serviceScript.preventLeadingOffset) {
                script[1] = {
                  extension: serviceScript.extension,
                  scriptKind: serviceScript.scriptKind,
                  snapshot: serviceScript.code.snapshot
                };
              } else {
                const sourceContents = sourceScript.snapshot.getText(0, sourceScript.snapshot.getLength());
                const virtualContents = sourceContents.split("\n").map((line) => " ".repeat(line.length)).join("\n") + serviceScript.code.snapshot.getText(0, serviceScript.code.snapshot.getLength());
                script[1] = {
                  extension: serviceScript.extension,
                  scriptKind: serviceScript.scriptKind,
                  snapshot: ts.ScriptSnapshot.fromString(virtualContents)
                };
              }
            }
            if ((_b2 = sourceScript.generated.languagePlugin.typescript) == null ? void 0 : _b2.getExtraServiceScripts) {
              console.warn("getExtraServiceScripts() is not available in TS plugin.");
            }
          }
          scripts.set(fileName, script);
        }
        return script[1];
      }
    }
    function searchExternalFiles(ts, project, exts) {
      if (project.projectKind !== ts.server.ProjectKind.Configured) {
        return [];
      }
      const configFile = project.getProjectName();
      const config = ts.readJsonConfigFile(configFile, project.readFile.bind(project));
      const parseHost = {
        useCaseSensitiveFileNames: project.useCaseSensitiveFileNames(),
        fileExists: project.fileExists.bind(project),
        readFile: project.readFile.bind(project),
        readDirectory: (...args) => {
          args[1] = exts;
          return project.readDirectory(...args);
        }
      };
      const parsed = ts.parseJsonSourceFileConfigFileContent(config, parseHost, project.getCurrentDirectory());
      return parsed.fileNames;
    }
  }
});

// node_modules/@volar/typescript/lib/quickstart/createLanguageServicePlugin.js
var require_createLanguageServicePlugin = __commonJS({
  "node_modules/@volar/typescript/lib/quickstart/createLanguageServicePlugin.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decoratedLanguageServiceHosts = exports2.decoratedLanguageServices = exports2.projectExternalFileExtensions = exports2.externalFiles = void 0;
    exports2.createLanguageServicePlugin = createLanguageServicePlugin2;
    exports2.arrayItemsEqual = arrayItemsEqual;
    var language_core_1 = require_language_core();
    var common_1 = require_common();
    var decorateLanguageService_1 = require_decorateLanguageService();
    var decorateLanguageServiceHost_1 = require_decorateLanguageServiceHost();
    exports2.externalFiles = /* @__PURE__ */ new WeakMap();
    exports2.projectExternalFileExtensions = /* @__PURE__ */ new WeakMap();
    exports2.decoratedLanguageServices = /* @__PURE__ */ new WeakSet();
    exports2.decoratedLanguageServiceHosts = /* @__PURE__ */ new WeakSet();
    function createLanguageServicePlugin2(create) {
      return (modules) => {
        const { typescript: ts } = modules;
        const pluginModule = {
          create(info) {
            if (!exports2.decoratedLanguageServices.has(info.languageService) && !exports2.decoratedLanguageServiceHosts.has(info.languageServiceHost)) {
              exports2.decoratedLanguageServices.add(info.languageService);
              exports2.decoratedLanguageServiceHosts.add(info.languageServiceHost);
              const { languagePlugins, setup } = create(ts, info);
              const extensions = languagePlugins.map((plugin) => {
                var _a, _b;
                return (_b = (_a = plugin.typescript) == null ? void 0 : _a.extraFileExtensions.map((ext) => "." + ext.extension)) != null ? _b : [];
              }).flat();
              exports2.projectExternalFileExtensions.set(info.project, extensions);
              const getScriptSnapshot = info.languageServiceHost.getScriptSnapshot.bind(info.languageServiceHost);
              const getScriptVersion = info.languageServiceHost.getScriptVersion.bind(info.languageServiceHost);
              const syncedScriptVersions = new language_core_1.FileMap(ts.sys.useCaseSensitiveFileNames);
              const language = (0, language_core_1.createLanguage)([
                ...languagePlugins,
                { getLanguageId: common_1.resolveFileLanguageId }
              ], new language_core_1.FileMap(ts.sys.useCaseSensitiveFileNames), (fileName) => {
                const version = getScriptVersion(fileName);
                if (syncedScriptVersions.get(fileName) === version) {
                  return;
                }
                syncedScriptVersions.set(fileName, version);
                const snapshot = getScriptSnapshot(fileName);
                if (snapshot) {
                  language.scripts.set(fileName, snapshot);
                } else {
                  language.scripts.delete(fileName);
                }
              });
              (0, decorateLanguageService_1.decorateLanguageService)(language, info.languageService);
              (0, decorateLanguageServiceHost_1.decorateLanguageServiceHost)(ts, language, info.languageServiceHost);
              setup == null ? void 0 : setup(language);
            }
            return info.languageService;
          },
          getExternalFiles(project, updateLevel = 0) {
            if (updateLevel >= 1 || !exports2.externalFiles.has(project)) {
              const oldFiles = exports2.externalFiles.get(project);
              const extensions = exports2.projectExternalFileExtensions.get(project);
              const newFiles = (extensions == null ? void 0 : extensions.length) ? (0, decorateLanguageServiceHost_1.searchExternalFiles)(ts, project, extensions) : [];
              exports2.externalFiles.set(project, newFiles);
              if (oldFiles && !arrayItemsEqual(oldFiles, newFiles)) {
                project.refreshDiagnostics();
              }
            }
            return exports2.externalFiles.get(project);
          }
        };
        return pluginModule;
      };
    }
    function arrayItemsEqual(a, b) {
      if (a.length !== b.length) {
        return false;
      }
      const set = new Set(a);
      for (const file of b) {
        if (!set.has(file)) {
          return false;
        }
      }
      return true;
    }
  }
});

// src/index.ts
var import_createLanguageServicePlugin = __toESM(require_createLanguageServicePlugin());

// src/code.ts
var AngularVirtualCode = class {
  constructor(fileName, ctx, useCaseSensitiveFileNames) {
    this.fileName = fileName;
    this.ctx = ctx;
    this.useCaseSensitiveFileNames = useCaseSensitiveFileNames;
    this.snapshot = createEmptySnapshot();
    this.mappings = [];
    this.associatedScriptMappings = /* @__PURE__ */ new Map();
  }
  get id() {
    return "main";
  }
  get languageId() {
    return "typescript";
  }
  sourceFileUpdated(snapshot, _languageId) {
    this.associatedScriptMappings.clear();
    let templateInSync = true;
    if (this.transpiledTemplate) {
      if (snapshot.getChangeRange(this.transpiledTemplate.snapshot) !== void 0 || !sameContents(snapshot, this.transpiledTemplate.sourceCode[this.normalizeId(this.fileName)])) {
        templateInSync = false;
      } else if (this.transpiledTemplate.mappings.find((mapping) => {
        var _a, _b, _c;
        return !sameContents(
          (_a = this.ctx.getAssociatedScript(mapping.fileName)) == null ? void 0 : _a.snapshot,
          (_c = (_b = this.transpiledTemplate) == null ? void 0 : _b.sourceCode) == null ? void 0 : _c[this.normalizeId(mapping.fileName)]
        );
      })) {
        templateInSync = false;
      }
    }
    if (this.transpiledTemplate && templateInSync) {
      this.snapshot = this.transpiledTemplate.snapshot;
      this.mappings = [];
      this.transpiledTemplate.mappings.forEach((mappingSet) => {
        let mappingsWithData;
        if (this.normalizeId(mappingSet.fileName) === this.normalizeId(this.fileName)) {
          mappingsWithData = this.mappings;
        } else {
          const associatedScript = this.ctx.getAssociatedScript(mappingSet.fileName);
          const scriptId = associatedScript == null ? void 0 : associatedScript.id;
          if (scriptId) {
            if (!this.associatedScriptMappings.has(scriptId)) {
              this.associatedScriptMappings.set(scriptId, []);
            }
            mappingsWithData = this.associatedScriptMappings.get(scriptId);
          } else {
            return;
          }
        }
        for (let i = 0; i < mappingSet.sourceOffsets.length; i++) {
          const isComponentFile = mappingSet.fileName === this.fileName;
          const sourceOffset = mappingSet.sourceOffsets[i];
          const sourceLength = mappingSet.sourceLengths[i];
          const diagnosticsOffset = mappingSet.diagnosticsOffsets[i];
          const diagnosticsLength = mappingSet.diagnosticsLengths[i];
          const generatedOffset = mappingSet.generatedOffsets[i];
          const generatedLength = mappingSet.generatedLengths[i];
          mappingsWithData.push({
            sourceOffsets: [sourceOffset],
            lengths: [sourceLength],
            generatedOffsets: [generatedOffset],
            generatedLengths: [generatedLength],
            data: {
              format: true,
              completion: true,
              navigation: true,
              semantic: true,
              structure: true,
              verification: diagnosticsOffset == sourceOffset && diagnosticsLength == sourceLength,
              types: mappingSet.types[i] === 1
            }
          });
          if (diagnosticsOffset >= 0 && (diagnosticsOffset != sourceOffset || diagnosticsLength != sourceLength)) {
            mappingsWithData.push({
              sourceOffsets: [diagnosticsOffset],
              lengths: [diagnosticsLength],
              generatedOffsets: [generatedOffset],
              generatedLengths: [generatedLength],
              data: {
                format: false,
                completion: false,
                navigation: false,
                semantic: false,
                structure: false,
                verification: true,
                types: false
              }
            });
          }
        }
      });
    } else {
      this.snapshot = snapshot;
      this.mappings = [{
        generatedOffsets: [0],
        sourceOffsets: [0],
        lengths: [snapshot.getLength()],
        data: {
          format: true,
          completion: true,
          navigation: true,
          semantic: true,
          structure: true,
          verification: true,
          types: true
        }
      }];
    }
    return this;
  }
  transpiledTemplateUpdated(transpiledCode, sourceCode, mappings) {
    if (transpiledCode) {
      this.transpiledTemplate = {
        mappings,
        sourceCode: Object.fromEntries(Object.entries(sourceCode).map(([key, value]) => {
          return [this.normalizeId(key), value];
        })),
        snapshot: createScriptSnapshot(transpiledCode)
      };
    } else {
      this.transpiledTemplate = void 0;
    }
  }
  normalizeId(id) {
    return this.useCaseSensitiveFileNames ? id : id.toLowerCase();
  }
};
function fullDiffTextChangeRange(oldText, newText) {
  for (let start = 0; start < oldText.length && start < newText.length; start++) {
    if (oldText[start] !== newText[start]) {
      let end = oldText.length;
      for (let i = 0; i < oldText.length - start && i < newText.length - start; i++) {
        if (oldText[oldText.length - i - 1] !== newText[newText.length - i - 1]) {
          break;
        }
        end--;
      }
      let length = end - start;
      let newLength = length + (newText.length - oldText.length);
      if (newLength < 0) {
        length -= newLength;
        newLength = 0;
      }
      return {
        span: { start, length },
        newLength
      };
    }
  }
  return void 0;
}
function sameContents(snapshot, code) {
  return !!snapshot && !!code && snapshot.getText(0, snapshot.getLength()) === code;
}
function createScriptSnapshot(code) {
  const changeRanges = /* @__PURE__ */ new Map();
  return {
    getText: (start, end) => (code != null ? code : "").slice(start, end),
    getLength: () => (code != null ? code : "").length,
    getChangeRange(oldSnapshot) {
      if (!changeRanges.has(oldSnapshot)) {
        changeRanges.set(oldSnapshot, void 0);
        const oldText = oldSnapshot.getText(0, oldSnapshot.getLength());
        const changeRange = fullDiffTextChangeRange(oldText, code != null ? code : "");
        if (changeRange) {
          changeRanges.set(oldSnapshot, changeRange);
        }
      }
      return changeRanges.get(oldSnapshot);
    }
  };
}
function createEmptySnapshot() {
  return {
    getText: (start, end) => "",
    getLength: () => 0,
    getChangeRange(oldSnapshot) {
      return {
        span: {
          start: 0,
          length: oldSnapshot.getLength()
        },
        newLength: 0
      };
    }
  };
}

// src/decorateLanguageService.ts
var import_utils = __toESM(require_utils2());
var import_transform = __toESM(require_transform());
var console2 = __toESM(require("console"));
function toSourceRange(sourceScript, language, serviceScript, start, end, filter) {
  for (const result of (0, import_transform.toSourceRanges)(sourceScript, language, serviceScript, start, end, filter)) {
    return result;
  }
  return void 0;
}
function toGeneratedRange(language, serviceScript, sourceScript, start, end, filter) {
  for (const result of (0, import_transform.toGeneratedRanges)(language, serviceScript, sourceScript, start, end, filter)) {
    return result;
  }
  return void 0;
}
function createUnboundReverseMapper(language, languageService) {
  return function(ts, sourceFile, generatedRange) {
    const [serviceScript, targetScript, sourceScript] = (0, import_utils.getServiceScript)(language, sourceFile.fileName);
    if (targetScript == null ? void 0 : targetScript.associatedOnly) {
      return void 0;
    }
    const program = languageService.getProgram();
    const generatedFile = targetScript ? program == null ? void 0 : program.getSourceFile(targetScript.id) : void 0;
    if (serviceScript && sourceFile && generatedFile) {
      try {
        let generatedRangePosStart = ts.getPositionOfLineAndCharacter(generatedFile, generatedRange.start.line, generatedRange.start.character);
        let generatedRangePosEnd = ts.getPositionOfLineAndCharacter(generatedFile, generatedRange.end.line, generatedRange.end.character);
        const sourceRange = toSourceRange(sourceScript, language, serviceScript, generatedRangePosStart, generatedRangePosEnd, (it) => it.types);
        if (sourceRange !== void 0) {
          return {
            fileName: sourceRange[0],
            pos: sourceRange[1],
            end: sourceRange[2]
          };
        }
      } catch (e) {
        console2.error(e);
      }
    }
    return void 0;
  };
}
function decorateIdeLanguageServiceExtensions(language, languageService, unboundReverseMapper) {
  let { webStormGetElementType, webStormGetTypeProperties, webStormGetSymbolType } = languageService;
  if (webStormGetElementType === void 0 || webStormGetElementType === void 0 || webStormGetSymbolType === void 0)
    return;
  languageService.webStormGetElementType = (ts, fileName, startOffset, endOffset, forceReturnType, reverseMapper) => {
    const [serviceScript, targetScript, sourceScript] = (0, import_utils.getServiceScript)(language, fileName);
    if (targetScript == null ? void 0 : targetScript.associatedOnly) {
      return void 0;
    }
    const program = languageService.getProgram();
    const sourceFile = program == null ? void 0 : program.getSourceFile(fileName);
    const generatedFile = targetScript ? program == null ? void 0 : program.getSourceFile(targetScript.id) : void 0;
    if (serviceScript && sourceFile && generatedFile) {
      try {
        const generatedRange = toGeneratedRange(language, serviceScript, sourceScript, startOffset, endOffset, (it) => it.types);
        if (generatedRange !== void 0) {
          return webStormGetElementType(ts, targetScript.id, generatedRange[0], generatedRange[1], forceReturnType, unboundReverseMapper.bind(null, ts));
        }
      } catch (e) {
      }
      return void 0;
    } else {
      return webStormGetElementType(ts, fileName, startOffset, endOffset, forceReturnType, reverseMapper);
    }
  };
  languageService.webStormGetSymbolType = (ts, symbolId, _reverseMapper) => {
    return webStormGetSymbolType(ts, symbolId, unboundReverseMapper.bind(null, ts));
  };
  languageService.webStormGetTypeProperties = (ts, typeId, _reverseMapper) => {
    return webStormGetTypeProperties(ts, typeId, unboundReverseMapper.bind(null, ts));
  };
}
function decorateNgLanguageServiceExtensions(language, languageService, unboundReverseMapper, webStormGetElementType) {
  languageService.webStormNgUpdateTranspiledTemplate = (_ts, fileName, transpiledCode, sourceCode, mappings) => {
    var _a;
    const sourceScript = language.scripts.get(fileName);
    const virtualCode = (_a = sourceScript == null ? void 0 : sourceScript.generated) == null ? void 0 : _a.root;
    if (sourceScript && virtualCode instanceof AngularVirtualCode) {
      virtualCode.transpiledTemplateUpdated(transpiledCode, sourceCode, mappings);
    }
  };
  languageService.webStormNgGetGeneratedElementType = (ts, fileName, startOffset, endOffset, forceReturnType) => {
    let program = languageService.getProgram();
    if (!program) {
      return void 0;
    }
    const sourceFile = program.getSourceFile(fileName);
    if (!sourceFile) {
      return void 0;
    }
    return webStormGetElementType(ts, fileName, startOffset, endOffset, forceReturnType, unboundReverseMapper.bind(null, ts));
  };
}

// src/ngSourceMap.ts
var AngularSourceMap = class {
  constructor(mappings) {
    this.mappings = mappings;
  }
  toSourceRange(generatedStart, generatedEnd, fallbackToAnyMatch, filter) {
    return this.findMatchingStartEnd(generatedStart, generatedEnd, "generatedOffsets", filter, fallbackToAnyMatch);
  }
  toGeneratedRange(sourceStart, sourceEnd, fallbackToAnyMatch, filter) {
    return this.findMatchingStartEnd(sourceStart, sourceEnd, "sourceOffsets", filter, fallbackToAnyMatch);
  }
  toSourceLocation(generatedOffset, filter) {
    return this.findMatchingOffsets(generatedOffset, "generatedOffsets", filter);
  }
  toGeneratedLocation(sourceOffset, filter) {
    return this.findMatchingOffsets(sourceOffset, "sourceOffsets", filter);
  }
  *findMatchingOffsets(offset, fromRange, filter) {
    const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
    for (const match of this.getStorageBasedOnRange(fromRange).findMatchingMappingIndexes(offset, filter)) {
      yield [mapOffset(match, offset, fromRange, toRange), match[0]];
    }
  }
  *findMatchingStartEnd(start, end, fromRange, filter, fallbackToAnyMatch) {
    const length = end - start;
    if (length < 0) {
      return;
    }
    if (length == 0) {
      for (const match of this.findMatchingOffsets(start, fromRange, filter)) {
        yield [match[0], 0, match[1], match[1]];
      }
      return;
    }
    const startMatches = [];
    for (const [startMapping, index] of this.getStorageBasedOnRange(fromRange).findMatchingMappingIndexes(start, filter)) {
      startMatches.push([startMapping, index]);
    }
    const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
    startMatches.sort((a, b) => getSpanLength(a, fromRange) - getSpanLength(b, fromRange));
    let hadMatch = false;
    for (const match of startMatches) {
      const fromStartOffset = getStartOffset(match, fromRange);
      const fromLength = getSpanLength(match, fromRange);
      if (end <= fromStartOffset + fromLength) {
        const toStartOffset = getStartOffset(match, toRange);
        const toLength = getSpanLength(match, toRange);
        if (toLength == fromLength) {
          const startOffset = toStartOffset + start - fromStartOffset;
          hadMatch = true;
          yield [startOffset, startOffset + length, match[0], match[0]];
        } else if (fromStartOffset == start && fromLength == length) {
          hadMatch = true;
          yield [toStartOffset, toStartOffset + toLength, match[0], match[0]];
        } else {
        }
      }
    }
    if (hadMatch) {
      return;
    }
    const endMatches = [];
    for (const endMapping of this.getStorageBasedOnRange(fromRange).findMatchingMappingIndexes(start + length, filter)) {
      const fromLength = getSpanLength(endMapping, fromRange);
      const toLength = getSpanLength(endMapping, toRange);
      if (fromLength == toLength) {
        endMatches.push(endMapping);
      }
    }
    endMatches.sort((a, b) => getSpanLength(a, fromRange) - getSpanLength(b, fromRange));
    for (let fallback = 0; fallback < 2; fallback++) {
      if (hadMatch || fallback && !fallbackToAnyMatch) {
        break;
      }
      for (const startMatch of startMatches) {
        let mapping = startMatch[0];
        const fromLength = getSpanLength(startMatch, fromRange);
        const toLength = getSpanLength(startMatch, toRange);
        if (fromLength != toLength) {
          continue;
        }
        for (const endMatch of endMatches) {
          if (!fallback && endMatch[0] != mapping) {
            continue;
          }
          const startOffset = mapOffset(startMatch, start, fromRange, toRange);
          const endOffset = mapOffset(endMatch, end, fromRange, toRange);
          if (startOffset <= endOffset) {
            hadMatch = true;
            yield [startOffset, endOffset, mapping, endMatch[0]];
          }
        }
      }
    }
  }
  getStorageBasedOnRange(fromRange) {
    var _a, _b;
    return fromRange === "sourceOffsets" ? (_a = this.sourceCodeOffsetsStorage) != null ? _a : this.sourceCodeOffsetsStorage = this.createStorage("sourceOffsets") : (_b = this.generatedCodeOffsetsStorage) != null ? _b : this.generatedCodeOffsetsStorage = this.createStorage("generatedOffsets");
  }
  createStorage(key) {
    if (!this.mappings.every((mapping) => areRangesSortedAndNonOverlapping(mapping[key], getLengths(mapping, key)))) {
      throw new Error("Ranges within one mapping should be sorted and non-overlapping.");
    }
    return new BinarySearchStorage(this.mappings, key);
  }
};
var BinarySearchStorage = class {
  constructor(originalMappings, key) {
    this.key = key;
    const offsetsSet = /* @__PURE__ */ new Set();
    for (const mapping of originalMappings) {
      for (let i = 0; i < mapping[key].length; i++) {
        offsetsSet.add(mapping[key][i]);
        offsetsSet.add(mapping[key][i] + getLengths(mapping, key)[i]);
      }
    }
    const offsets = [...offsetsSet].sort((a, b) => a - b);
    const mappings = offsets.map(() => /* @__PURE__ */ new Set());
    for (const mapping of originalMappings) {
      for (let i = 0; i < mapping[key].length; i++) {
        const startIndex = binarySearch(offsets, mapping[key][i]).match;
        const endIndex = binarySearch(offsets, mapping[key][i] + getLengths(mapping, key)[i]).match;
        for (let i2 = startIndex; i2 <= endIndex; i2++) {
          mappings[i2].add(mapping);
        }
      }
    }
    this.offsets = offsets;
    this.mappings = mappings;
  }
  *findMatchingMappingIndexes(offset, filter) {
    if (this.offsets.length === 0) {
      return;
    }
    const fromRange = this.key;
    const { low: start, high: end } = binarySearch(this.offsets, offset);
    const skip = /* @__PURE__ */ new Set();
    for (let i = start; i <= end; i++) {
      for (const mapping of this.mappings[i]) {
        if (skip.has(mapping)) {
          continue;
        }
        skip.add(mapping);
        if (filter && !filter(mapping.data)) {
          continue;
        }
        const fromOffsets = mapping[fromRange];
        const fromLengths = getLengths(mapping, fromRange);
        let low = 0;
        let high = fromOffsets.length - 1;
        while (low <= high) {
          const mid = Math.floor((low + high) / 2);
          const fromOffset = fromOffsets[mid];
          const fromLength = fromLengths[mid];
          if (offset >= fromOffset && offset <= fromOffset + fromLength) {
            yield [mapping, mid];
            break;
          } else if (offset < fromOffset) {
            high = mid - 1;
          } else {
            low = mid + 1;
          }
        }
      }
    }
  }
};
function getLengths(mapping, key) {
  var _a;
  return key == "sourceOffsets" ? mapping.lengths : (_a = mapping.generatedLengths) != null ? _a : mapping.lengths;
}
function getStartOffset(mappingIndex, rangeKey) {
  const [mapping, index] = mappingIndex;
  return mapping[rangeKey][index];
}
function getSpanLength(mappingIndex, rangeKey) {
  const [mapping, index] = mappingIndex;
  return getLengths(mapping, rangeKey)[index];
}
function mapOffset(mappingIndex, offset, fromRange, toRange) {
  const fromOffset = getStartOffset(mappingIndex, fromRange);
  const toOffset = getStartOffset(mappingIndex, toRange);
  if (fromOffset == offset) {
    return toOffset;
  } else {
    const toLength = getSpanLength(mappingIndex, toRange);
    return toOffset + Math.min(offset - fromOffset, toLength);
  }
}
function binarySearch(values, searchValue) {
  let low = 0;
  let high = values.length - 1;
  let match;
  while (low <= high) {
    const mid = Math.floor((low + high) / 2);
    const midValue = values[mid];
    if (midValue < searchValue) {
      low = mid + 1;
    } else if (midValue > searchValue) {
      high = mid - 1;
    } else {
      low = mid;
      high = mid;
      match = mid;
      break;
    }
  }
  const finalLow = Math.max(Math.min(low, high, values.length - 1), 0);
  const finalHigh = Math.min(Math.max(low, high, 0), values.length - 1);
  return { low: finalLow, high: finalHigh, match };
}
function areRangesSortedAndNonOverlapping(offsets, lenghts) {
  let lastEnd = 0;
  for (let i = 0; i < offsets.length; i++) {
    if (offsets[i] < lastEnd) {
      return false;
    }
    lastEnd = offsets[i] + lenghts[i];
  }
  return true;
}

// src/index.ts
function loadLanguagePlugins(ts, info) {
  addNgCommands(ts, info);
  let ngTcbBlocks = /* @__PURE__ */ new Map();
  return {
    languagePlugins: [{
      getLanguageId(scriptId) {
        return scriptId.endsWith(".html") ? "html" : void 0;
      },
      isAssociatedFileOnly(_scriptId, languageId) {
        return languageId === "html";
      },
      createVirtualCode(scriptId, languageId, snapshot, ctx) {
        if (languageId === "typescript" && !scriptId.endsWith(".d.ts") && scriptId.indexOf("/node_modules/") < 0) {
          let virtualCode = ngTcbBlocks.get(scriptId);
          if (!virtualCode) {
            virtualCode = new AngularVirtualCode(scriptId, ctx, ts.sys.useCaseSensitiveFileNames);
            ngTcbBlocks.set(scriptId, virtualCode);
          }
          return virtualCode.sourceFileUpdated(snapshot);
        }
        return void 0;
      },
      updateVirtualCode(scriptId, virtualCode, newSnapshot, ctx) {
        return virtualCode.sourceFileUpdated(newSnapshot);
      },
      typescript: {
        extraFileExtensions: [{
          extension: "html",
          scriptKind: ts.ScriptKind.Deferred,
          isMixedContent: true
        }],
        getServiceScript(rootVirtualCode) {
          return {
            code: rootVirtualCode,
            extension: ".ts",
            scriptKind: ts.ScriptKind.TS,
            preventLeadingOffset: true
          };
        }
      }
    }],
    setup(language) {
      language.mapperFactory = (mappings) => new AngularSourceMap(mappings);
      const unboundReverseMapper = createUnboundReverseMapper(language, info.languageService);
      let { webStormGetElementType } = info.languageService;
      decorateIdeLanguageServiceExtensions(language, info.languageService, unboundReverseMapper);
      decorateNgLanguageServiceExtensions(language, info.languageService, unboundReverseMapper, webStormGetElementType);
    }
  };
}
var ngTranspiledTemplateCommand = "ngTranspiledTemplate";
var ngGetGeneratedElementTypeCommand = "ngGetGeneratedElementType";
function addNgCommands(ts, info) {
  let projectService = info.project.projectService;
  projectService.logger.info("Angular: called handler processing");
  let session = info.session;
  if (session == void 0) {
    projectService.logger.info("Angular: there is no session in info.");
    return;
  }
  if (session.addProtocolHandler == void 0) {
    projectService.logger.info("Angular: there is no addProtocolHandler method.");
    return;
  }
  if (session.webStormNgCommandsAdded)
    return;
  session.webStormNgCommandsAdded = true;
  session.addProtocolHandler(ngTranspiledTemplateCommand, ngTranspiledTemplateHandler.bind(null, ts, session, projectService));
  session.addProtocolHandler(ngGetGeneratedElementTypeCommand, ngGetGeneratedElementTypeHandler.bind(null, ts, session, projectService));
  projectService.logger.info("Angular specific commands are successfully added.");
}
var ngTranspiledTemplateHandler = (ts, session, projectService, request) => {
  const requestArguments = request.arguments;
  let fileName = ts.server.toNormalizedPath(requestArguments.file);
  let project = projectService.getDefaultProjectForFile(fileName, true);
  if (project) {
    project.getLanguageService().webStormNgUpdateTranspiledTemplate(
      ts,
      fileName,
      requestArguments.transpiledContent,
      requestArguments.sourceCode,
      requestArguments.mappings
    );
    session.change(
      {
        file: fileName,
        line: 1,
        offset: 1,
        endLine: 1,
        endOffset: 1,
        insertString: ""
      }
    );
  }
  return {
    responseRequired: true,
    response: {}
  };
};
var ngGetGeneratedElementTypeHandler = (ts, _session, projectService, request) => {
  var _a, _b;
  const requestArguments = request.arguments;
  let fileName = ts.server.toNormalizedPath(requestArguments.file);
  let project = projectService.getDefaultProjectForFile(fileName, true);
  return (_b = (_a = project == null ? void 0 : project.getLanguageService()) == null ? void 0 : _a.webStormNgGetGeneratedElementType(
    ts,
    fileName,
    requestArguments.startOffset,
    requestArguments.endOffset,
    requestArguments.forceReturnType
  )) != null ? _b : { responseRequired: true, response: void 0 };
};
var init = (0, import_createLanguageServicePlugin.createLanguageServicePlugin)(loadLanguagePlugins);
module.exports = init;
//# sourceMappingURL=index.js.map
