/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ContainerPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.devcontainers.Devcontainer;
import com.intellij.docker.agent.pipe.DockerLogPipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.agent.util.DockerComposeData;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntimeKt;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.docker.view.details.container.DockerContainerDetailsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J)\u0010.\u001a\b\u0012\u0004\u0012\u00020/0,2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J\b\u00106\u001a\u00020%H\u0014J\u001e\u00107\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00100\u001a\u00020\u00172\u0006\u00108\u001a\u000202H\u0016J\u0015\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0010\u00a2\u0006\u0002\b=J\u000e\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u000202J\u0006\u0010B\u001a\u000202J\u0006\u0010C\u001a\u000202J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00170,H\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J\u001d\u0010G\u001a\u0002052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u000202H\u0000\u00a2\u0006\u0002\bJJ\u0015\u0010K\u001a\u0002052\u0006\u0010L\u001a\u00020%H\u0000\u00a2\u0006\u0002\bMJ\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020O0,2\u0006\u0010P\u001a\u0002022\u0006\u0010Q\u001a\u00020@H\u0016J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J\b\u0010T\u001a\u00020\u0017H\u0016J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u0002050,H\u0016J'\u0010V\u001a\b\u0012\u0004\u0012\u0002050,2\u0017\u0010W\u001a\u0013\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u0002050X\u00a2\u0006\u0002\bZH\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006["}, d2={"Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "container", "Lcom/intellij/docker/agent/DockerAgentContainer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentContainer;Lcom/intellij/openapi/project/Project;)V", "agent", "Lcom/intellij/docker/agent/DockerAgent;", "getAgent", "()Lcom/intellij/docker/agent/DockerAgent;", "agentApplication", "getAgentApplication", "()Lcom/intellij/docker/agent/DockerAgentContainer;", "agentContainer", "getAgentContainer", "composeData", "Lcom/intellij/docker/agent/util/DockerComposeData;", "getComposeData", "()Lcom/intellij/docker/agent/util/DockerComposeData;", "containerName", "", "getContainerName", "()Ljava/lang/String;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider$intellij_clouds_docker", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "myAgentApplication", "myComposeData", "myContainerNames", "", "getMyContainerNames", "()[Ljava/lang/String;", "myStatus", "Lcom/intellij/docker/DockerStatus;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "attach", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "captureExecOutput", "", "command", "includeErr", "", "([Ljava/lang/String;Z)Ljava/util/concurrent/CompletableFuture;", "deleteContainer", "", "doGetStatus", "exec", "asRoot", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "getHeaderComponent$intellij_clouds_docker", "hasExposedPort", "port", "", "isPaused", "isRunning", "isStopped", "pauseContainer", "processesJson", "restartContainer", "setAgentApplication", "newAgentContainer", "withNewStatus", "setAgentApplication$intellij_clouds_docker", "setStatus", "status", "setStatus$intellij_clouds_docker", "showLog", "Lcom/intellij/docker/agent/pipe/DockerLogPipe;", "showTimestamps", "tail", "startContainer", "stopContainerAsync", "toString", "unpauseContainer", "updateContainer", "modifyConfig", "Lkotlin/Function1;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "Lkotlin/ExtensionFunctionType;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerApplicationRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerApplicationRuntime.kt\ncom/intellij/docker/runtimes/DockerApplicationRuntime\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n12474#2,2:234\n1#3:236\n*S KotlinDebug\n*F\n+ 1 DockerApplicationRuntime.kt\ncom/intellij/docker/runtimes/DockerApplicationRuntime\n*L\n163#1:234,2\n*E\n"})
public final class DockerApplicationRuntime
extends DockerContainerRuntime {
    @NotNull
    private volatile DockerAgentContainer myAgentApplication;
    @Nullable
    private volatile DockerComposeData myComposeData;
    @NotNull
    private volatile DockerStatus myStatus;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull DockerAgentContainer container, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, project);
        this.myAgentApplication = container;
        this.myComposeData = DockerComposeUtilsKt.getComposeData(container);
        this.myStatus = DockerApplicationRuntimeKt.access$createStatusFromAgentContainer(container);
    }

    @Override
    @NotNull
    public DockerAgentContainer getAgentApplication() {
        return this.myAgentApplication;
    }

    @Override
    @NotNull
    public DockerRuntimeDetailsProvider getDetailsProvider$intellij_clouds_docker() {
        return new DockerContainerDetailsProvider(this);
    }

    @NotNull
    public final RemoteServer<DockerCloudConfiguration> getServer() {
        return this.getContext().getServer();
    }

    @NotNull
    public final DockerAgent getAgent() {
        return this.getContext().getAgent();
    }

    @NotNull
    public final DockerAgentContainer getAgentContainer() {
        return this.getAgentApplication();
    }

    @Nullable
    public final String getContainerName() {
        return this.getAgentApplication().getContainerName();
    }

    @Nullable
    public final DockerComposeData getComposeData() {
        return this.myComposeData;
    }

    private final String[] getMyContainerNames() {
        return this.getAgentApplication().getContainerNames();
    }

    @Override
    @NotNull
    protected DockerStatus doGetStatus() {
        return this.myStatus;
    }

    public final void setAgentApplication$intellij_clouds_docker(@NotNull DockerAgentContainer newAgentContainer, boolean withNewStatus) {
        Intrinsics.checkNotNullParameter((Object)newAgentContainer, (String)"newAgentContainer");
        this.myAgentApplication = newAgentContainer;
        this.myComposeData = DockerComposeUtilsKt.getComposeData(newAgentContainer);
        if (withNewStatus) {
            this.setStatus$intellij_clouds_docker(DockerApplicationRuntimeKt.access$createStatusFromAgentContainer(newAgentContainer));
        }
    }

    public final void setStatus$intellij_clouds_docker(@NotNull DockerStatus status2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
            this.myStatus = status2;
            DockerComposeData dockerComposeData = this.myComposeData;
            if (dockerComposeData == null) break block1;
            DockerComposeData it = dockerComposeData;
            boolean bl = false;
            ComposeServiceRuntime composeServiceRuntime = this.getContext().getRuntimesManager().findComposeService(it.getProject(), it.getService());
            if (composeServiceRuntime != null) {
                composeServiceRuntime.updateParentAndSelfStatus$intellij_clouds_docker();
            }
        }
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent$intellij_clouds_docker(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        DockerApplicationRuntime runtime2 = this;
        Scaffold $this$getHeaderComponent_u24lambda_u241 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u241.segment((Function1<? super Scaffold.SimpleSegment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment, Unit>(runtime2){
            final /* synthetic */ DockerApplicationRuntime $runtime;
            {
                this.$runtime = $runtime;
                super(1);
            }

            public final void invoke(@NotNull Scaffold.SimpleSegment $this$segment) {
                DockerComposeData composeData;
                Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(this.$runtime){
                    final /* synthetic */ DockerApplicationRuntime $runtime;
                    {
                        this.$runtime = $runtime;
                        super(1);
                    }

                    public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                        $this$textFragment.setIcon(this.$runtime.getStatus().getIcon());
                        String string = this.$runtime.getContainerName();
                        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"/")) == null) {
                            string = "<unknown>";
                        }
                        $this$textFragment.append(string, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        $this$textFragment.append(" " + DockerAbstractDashboardTabKt.shortenDockerId(this.$runtime.getId()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        $this$textFragment.setToolTipText(this.$runtime.getId());
                    }
                }));
                DockerImageRuntime imageRuntime = DockerUtils.getImage(this.$runtime);
                if (imageRuntime != null) {
                    $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(imageRuntime, this.$runtime){
                        final /* synthetic */ DockerImageRuntime $imageRuntime;
                        final /* synthetic */ DockerApplicationRuntime $runtime;
                        {
                            this.$imageRuntime = $imageRuntime;
                            this.$runtime = $runtime;
                            super(1);
                        }

                        public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                            $this$textFragment.setIcon(DockerIcons.SingleImage);
                            String imageName2 = this.$imageRuntime.getPresentableName();
                            $this$textFragment.append(imageName2, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, () -> getHeaderComponent.1.2.invoke$lambda$0(this.$imageRuntime));
                            $this$textFragment.setToolTipText(this.$runtime.getImageId());
                        }

                        private static final void invoke$lambda$0(DockerImageRuntime $imageRuntime) {
                            DockerUiUtilsKt.select($imageRuntime);
                        }
                    }));
                }
                if ((composeData = this.$runtime.getComposeData()) != null) {
                    String composeProject = composeData.getProject();
                    ComposeApplicationRuntime composeProjectRuntime = this.$runtime.getContext().getRuntimesManager().findComposeProject(composeProject);
                    if (composeProjectRuntime != null) {
                        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(composeProjectRuntime){
                            final /* synthetic */ ComposeApplicationRuntime $composeProjectRuntime;
                            {
                                this.$composeProjectRuntime = $composeProjectRuntime;
                                super(1);
                            }

                            public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                                Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                                $this$textFragment.setIcon(this.$composeProjectRuntime.getStatus().getIcon());
                                $this$textFragment.append(this.$composeProjectRuntime.getPresentableName(), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, () -> getHeaderComponent.1.3.invoke$lambda$0(this.$composeProjectRuntime));
                            }

                            private static final void invoke$lambda$0(ComposeApplicationRuntime $composeProjectRuntime) {
                                DockerUiUtilsKt.select($composeProjectRuntime);
                            }
                        }));
                    }
                }
                ScaffoldKt.button$default($this$segment, null, null, "Dev.Container.Connect", (Function0)new Function0<Boolean>(this.$runtime){
                    final /* synthetic */ DockerApplicationRuntime $runtime;
                    {
                        this.$runtime = $runtime;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !(this.$runtime.getStatus() instanceof DockerTransitionStatus) && Devcontainer.Companion.asDevcontainer(this.$runtime.getAgentContainer()) != null;
                    }
                }, 3, null);
                ScaffoldKt.button$default($this$segment, null, DockerBundle.message("DockerContainerDashboardTab.button.start", new Object[0]), "Docker.RemoteServers.StartContainer", (Function0)new Function0<Boolean>(this.$runtime){
                    final /* synthetic */ DockerApplicationRuntime $runtime;
                    {
                        this.$runtime = $runtime;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !this.$runtime.isRunning() && !(this.$runtime.getStatus() instanceof DockerTransitionStatus);
                    }
                }, 1, null);
                ScaffoldKt.button$default($this$segment, null, DockerBundle.message("DockerContainerDashboardTab.button.restart", new Object[0]), "Docker.RemoteServers.RestartContainer", (Function0)new Function0<Boolean>((Object)this.$runtime){

                    @NotNull
                    public final Boolean invoke() {
                        return ((DockerApplicationRuntime)this.receiver).isRunning();
                    }
                }, 1, null);
                ScaffoldKt.button$default($this$segment, null, DockerBundle.message("DockerContainerDashboardTab.button.stop", new Object[0]), "Docker.RemoteServers.StopContainer", (Function0)new Function0<Boolean>((Object)this.$runtime){

                    @NotNull
                    public final Boolean invoke() {
                        return ((DockerApplicationRuntime)this.receiver).isRunning();
                    }
                }, 1, null);
                ScaffoldKt.button$default($this$segment, null, DockerBundle.message("DockerContainerDashboardTab.button.terminal", new Object[0]), "Docker.RemoteServers.CreateTerminal", (Function0)new Function0<Boolean>((Object)this.$runtime){

                    @NotNull
                    public final Boolean invoke() {
                        return ((DockerApplicationRuntime)this.receiver).isRunning();
                    }
                }, 1, null);
                ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.ShowContainerFiles");
                ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.InspectContainerOrImage");
                ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.CopyContainerImageId");
                ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.CopyContainerId");
            }
        }));
    }

    public final boolean isRunning() {
        return this.getStatus() instanceof DockerContainerStatus.Up;
    }

    public final boolean isPaused() {
        return this.getStatus() instanceof DockerContainerStatus.Paused;
    }

    public final boolean isStopped() {
        return this.getStatus() instanceof DockerContainerStatus.Stopped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasExposedPort(int port) {
        Intrinsics.checkNotNullExpressionValue((Object)this.getAgentContainer().getContainer().ports, (String)"ports");
        Object[] $this$any$iv = this.getAgentContainer().getContainer().ports;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            ContainerPort it = (ContainerPort)element$iv;
            boolean bl = false;
            Integer n3 = it.getPrivatePort();
            int n4 = port;
            if (n3 != null && n3 == n4) {
                Integer n5 = it.getPublicPort();
                n4 = port;
                if (n5 != null && n5 == n4) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> startContainer() {
        return this.runStatusTransition(DockerTransitionStatus.STARTING, this.getAgentApplication().startContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> restartContainer() {
        return this.runStatusTransition(DockerTransitionStatus.STARTING, this.getAgentApplication().restartContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> pauseContainer() {
        return this.getAgentApplication().pauseContainer();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> unpauseContainer() {
        return this.getAgentApplication().unpauseContainer();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> stopContainerAsync() {
        return this.runStatusTransition(DockerTransitionStatus.STOPPING, this.getAgentApplication().stopContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteContainer() {
        return this.runStatusTransition(DockerTransitionStatus.DELETING, this.getAgentApplication().deleteContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<DockerLogPipe> showLog(boolean showTimestamps, int tail) {
        return this.getAgentApplication().showLog(showTimestamps, tail);
    }

    @Override
    @NotNull
    public CompletableFuture<String> processesJson() {
        return this.getAgentApplication().computeProcessesJson();
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach() {
        return this.getAgentApplication().attach();
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String command, boolean asRoot) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DockerAgentContainer dockerAgentContainer = this.getAgentApplication();
        String[] stringArray = ParametersListUtil.parseToArray((String)command);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
        return DockerAgentContainer.exec$default(dockerAgentContainer, stringArray, null, asRoot, null, 10, null);
    }

    @Override
    @NotNull
    public CompletableFuture<byte[]> captureExecOutput(@NotNull String[] command, boolean includeErr) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return this.getAgentApplication().captureExecOutput(command, includeErr);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> updateContainer(@NotNull Function1<? super CreateContainerCmd, Unit> modifyConfig) {
        Intrinsics.checkNotNullParameter(modifyConfig, (String)"modifyConfig");
        return this.getAgentApplication().updateContainer(modifyConfig);
    }

    @NotNull
    public String toString() {
        String it = this.getId();
        boolean bl = false;
        String hash = DockerUtil.shortedId(it);
        String string = Integer.toHexString(this.hashCode());
        String string2 = Arrays.toString(this.getMyContainerNames());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return "@" + string + " id: " + hash + ", [CNT]: " + string2;
    }
}

