/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="DockerRegistry")
public class DockerRegistryConfiguration
extends CloudConfigurationBase<DockerRegistryConfiguration> {
    @Nls
    private String myName;
    @NlsSafe
    private String myAddress;
    @NlsSafe
    private String myUsername;
    private String myRegistryProviderId;

    @Nls
    public String getName() {
        return this.myName;
    }

    public void setName(@Nls String name2) {
        this.myName = name2;
    }

    public DockerRegistryConfiguration withName(@Nls String name2) {
        this.setName(name2);
        return this;
    }

    public String getRegistryProviderId() {
        return this.myRegistryProviderId;
    }

    public void setRegistryProviderId(String registryProviderId) {
        this.myRegistryProviderId = registryProviderId;
    }

    @NlsSafe
    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    @Transient
    public void setValuesPack(@Nls String serviceName, String address, String username, String password) {
        if (!(Objects.equals(serviceName, this.myName) && Objects.equals(address, this.myAddress) && Objects.equals(username, this.myUsername))) {
            this.clearPasswordSafe();
        }
        this.myName = serviceName;
        this.myAddress = address;
        this.myUsername = username;
        this.setPasswordSafe(password);
    }

    public void clearPasswordSafe() {
        CredentialAttributes oldAttributes = this.createCredentialAttributes();
        if (oldAttributes != null) {
            PasswordSafe.getInstance().set(oldAttributes, null);
        }
    }

    @NlsSafe
    public String getUsername() {
        return this.myUsername;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public DockerAuthConfig getAuthConfig() {
        String username = StringUtil.isEmpty((String)this.myUsername) ? (StringUtil.isEmpty((String)this.myName) ? "any" : this.myName.toLowerCase(Locale.ROOT).trim().replaceAll("\\s+", "_")) : this.myUsername;
        return new DockerAuthConfig(username, this.getPasswordSafe(), this.getEmail(), this.myAddress);
    }

    @Nullable
    protected String getServiceName() {
        String name2 = this.getName();
        return StringUtil.isEmpty((String)name2) ? null : "IntelliJ Platform Docker Registry - " + name2;
    }

    protected String getCredentialUser() {
        String username = this.getUsername();
        return StringUtil.isEmpty((String)username) ? "any" : username;
    }

    public boolean mayContainTag(@NotNull DockerRepoTag tag2) {
        if (tag2 == null) {
            DockerRegistryConfiguration.$$$reportNull$$$0(0);
        }
        return tag2.isOwnedBy(this.getAddress(), this.getUsername());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/docker/registry/DockerRegistryConfiguration", "mayContainTag"));
    }
}

