/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.injectors;

import com.intellij.docker.dockerFile.parser.psi.DockerFileHeredocContentBlock;
import com.intellij.docker.dockerFile.parser.psi.DockerFileRunCommand;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/dockerFile/injectors/DockerFileShellScriptInjector;", "Lcom/intellij/psi/LanguageInjector;", "()V", "getLanguagesToInject", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "injectionPlacesRegistrar", "Lcom/intellij/psi/InjectedLanguagePlaces;", "intellij.clouds.docker.file"})
public final class DockerFileShellScriptInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)injectionPlacesRegistrar, (String)"injectionPlacesRegistrar");
        Language language = Language.findLanguageByID((String)"Shell Script");
        if (language == null) {
            return;
        }
        Language shLang = language;
        if (host instanceof DockerFileRunCommand) {
            if (((DockerFileRunCommand)host).getParametersInJsonForm() != null) {
                return;
            }
            if (((DockerFileRunCommand)host).getHeredoc() != null) {
                return;
            }
            PsiElement run2 = ((DockerFileRunCommand)host).getFirstChild();
            PsiElement psiElement = run2.getNextSibling();
            if (psiElement == null) {
                return;
            }
            PsiElement whiteSpaceAfterRun = psiElement;
            int startOffset = run2.getTextLength() + whiteSpaceAfterRun.getTextLength();
            if (startOffset > ((DockerFileRunCommand)host).getTextLength()) {
                return;
            }
            injectionPlacesRegistrar.addPlace(shLang, new TextRange(startOffset, ((DockerFileRunCommand)host).getTextLength()), null, " ");
        } else if (host instanceof DockerFileHeredocContentBlock) {
            injectionPlacesRegistrar.addPlace(shLang, new TextRange(Math.min(1, ((DockerFileHeredocContentBlock)host).getTextLength()), ((DockerFileHeredocContentBlock)host).getTextLength()), null, " ");
        }
    }
}

