/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlIntegerType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/composeFile/model/LimitedIntegerType;", "Lorg/jetbrains/yaml/meta/model/YamlIntegerType;", "from", "", "to", "quotedValuesAllowed", "", "(IIZ)V", "getFrom", "()I", "getTo", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.docker.compose"})
public final class LimitedIntegerType
extends YamlIntegerType {
    private final int from;
    private final int to;

    public LimitedIntegerType(int from, int to, boolean quotedValuesAllowed) {
        super(quotedValuesAllowed);
        this.from = from;
        this.to = to;
    }

    public /* synthetic */ LimitedIntegerType(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        this(n, n2, bl);
    }

    public final int getFrom() {
        return this.from;
    }

    public final int getTo() {
        return this.to;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.validateScalarValue(scalarValue, holder);
        String string = scalarValue.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n == null) {
            return;
        }
        int n2 = n;
        int n3 = this.from;
        if (!(n2 <= this.to ? n3 <= n2 : false)) {
            Object[] objectArray = new Object[]{this.from, this.to};
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("ComposeLimitedIntegerType.validation.error", objectArray), new LocalQuickFix[0]);
        }
    }
}

