/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.actions;

import com.intellij.docker.compose.ComposeFilesSynchronizedWithServiceView;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/composeFile/actions/SyncComposeFileWithServiceView;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getYAMLFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "intellij.clouds.docker.compose"})
public final class SyncComposeFileWithServiceView
extends DumbAwareAction
implements TooltipDescriptionProvider {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ComposeFilesSynchronizedWithServiceView $this$actionPerformed_u24lambda_u240 = ComposeFilesSynchronizedWithServiceView.Companion.getInstance();
        boolean bl = false;
        YAMLFile yAMLFile = this.getYAMLFile(e);
        VirtualFile virtualFile3 = virtualFile2 = yAMLFile != null ? yAMLFile.getVirtualFile() : null;
        if (virtualFile3 == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)virtualFile3);
        VirtualFile file2 = virtualFile2;
        if ($this$actionPerformed_u24lambda_u240.getFiles().contains(file2)) {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $this$actionPerformed_u24lambda_u240.removeFile(string);
        } else {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $this$actionPerformed_u24lambda_u240.addFile(string);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        YAMLFile yamlFile = this.getYAMLFile(e);
        if (yamlFile != null && ComposeFileUtil.isDockerComposeYamlFile(yamlFile)) {
            List<VirtualFile> files = ComposeFilesSynchronizedWithServiceView.Companion.getInstance().getFiles();
            e.getPresentation().setVisible(true);
            if (files.contains(yamlFile.getVirtualFile())) {
                e.getPresentation().setIcon(AllIcons.Actions.StopRefresh);
                e.getPresentation().setText(DockerComposeBundle.message("SyncComposeFileWithServiceView.disable.sync.text", new Object[0]));
                e.getPresentation().setDescription("");
            } else {
                e.getPresentation().setIcon(AllIcons.Actions.Refresh);
                e.getPresentation().setText(DockerComposeBundle.message("SyncComposeFileWithServiceView.enable.sync.text", new Object[0]));
                e.getPresentation().setDescription(DockerComposeBundle.message("SyncComposeFileWithServiceView.enable.sync.description", new Object[0]));
            }
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final YAMLFile getYAMLFile(AnActionEvent $this$getYAMLFile) {
        Object object = $this$getYAMLFile.getData(CommonDataKeys.PSI_FILE);
        return object instanceof YAMLFile ? (YAMLFile)object : null;
    }
}

