/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.compose.ComposeNavigatableHelper;
import com.intellij.docker.composeFile.ComposeFileReferenceResolver;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;

public class ComposeFileNavigatableHelperImpl
extends ComposeNavigatableHelper {
    private static final Key<CachedValue<Map<String, PsiElement>>> SERVICES_KEY = Key.create((String)(ComposeFileNavigatableHelperImpl.class.getName() + ":DOCKER_COMPOSE_SERVICES"));

    @Override
    @Nullable
    public PsiElement findComposeService(@NotNull PsiFile file2, @NotNull String serviceName) {
        if (file2 == null) {
            ComposeFileNavigatableHelperImpl.$$$reportNull$$$0(0);
        }
        if (serviceName == null) {
            ComposeFileNavigatableHelperImpl.$$$reportNull$$$0(1);
        }
        return ComposeFileNavigatableHelperImpl.computeComposeServicesMap(file2).get(serviceName);
    }

    @Override
    public List<PsiElement> findAllComposeServices(PsiFile file2) {
        return new ArrayList<PsiElement>(ComposeFileNavigatableHelperImpl.computeComposeServicesMap(file2).values());
    }

    @NotNull
    private static Map<String, PsiElement> computeComposeServicesMap(PsiFile file2) {
        if (!(file2 instanceof YAMLFile) || !ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)file2)) {
            Map<String, PsiElement> map2 = Collections.emptyMap();
            if (map2 == null) {
                ComposeFileNavigatableHelperImpl.$$$reportNull$$$0(2);
            }
            return map2;
        }
        Map map3 = (Map)CachedValuesManager.getCachedValue((PsiElement)file2, SERVICES_KEY, () -> {
            Map<String, PsiElement> services = ComposeFileReferenceResolver.SERVICES.resolveAll(file2).stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(e -> e.getKeyText().trim(), e -> e.getKey(), (k1, k2) -> k1));
            return new CachedValueProvider.Result(services, new Object[]{file2});
        });
        if (map3 == null) {
            ComposeFileNavigatableHelperImpl.$$$reportNull$$$0(3);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileNavigatableHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileNavigatableHelperImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeComposeServicesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findComposeService";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

