/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.agent.compose.cli.DockerComposeExecCliBuilder;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.PtyOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceExecCmd
extends AbstractServiceCmd<ComposeServiceExecCmd> {
    private static final Logger LOG = Logger.getInstance(ComposeServiceExecCmd.class);
    @Nullable
    private PtyOptions myPtyOptions;
    private boolean mySetupWorkingDirectory;
    private boolean mySaveAllDocuments;

    public ComposeServiceExecCmd(@NotNull RemoteDockerRuntime dockerRuntime2) {
        if (dockerRuntime2 == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime2);
        this.mySaveAllDocuments = true;
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        return this.execute(false);
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine() throws IOException {
        GeneralCommandLine generalCommandLine = DockerComposeCliUtil.buildCommandLine(ComposeServiceExecCmd.buildExecCommand(this, false));
        if (generalCommandLine == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(1);
        }
        return generalCommandLine;
    }

    @NotNull
    public String execDetached() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler = this.execute(true);
        ProcessOutput processOutput2 = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        if (processOutput2.checkSuccess(LOG)) {
            String string = processOutput2.getStdout().trim();
            if (string == null) {
                ComposeServiceExecCmd.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new ExecutionException(processOutput2.getStderr());
    }

    @Override
    @NotNull
    protected ComposeServiceExecCmd getThis() {
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(3);
        }
        return composeServiceExecCmd;
    }

    @Nullable
    public PtyOptions getPtyOptions() {
        return this.myPtyOptions;
    }

    @NotNull
    public ComposeServiceExecCmd withPtyOptions(@Nullable PtyOptions ptyOptions) {
        this.myPtyOptions = ptyOptions;
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(4);
        }
        return composeServiceExecCmd;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ComposeServiceExecCmd withNoPty(@Nullable Boolean noPty) {
        ComposeServiceExecCmd composeServiceExecCmd = this.withPtyOptions(DockerComposeCliUtil.defaultPtyOptionsByNoPty(noPty));
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(5);
        }
        return composeServiceExecCmd;
    }

    public boolean isSetupWorkingDirectory() {
        return this.mySetupWorkingDirectory;
    }

    @NotNull
    public ComposeServiceExecCmd withSetupWorkingDirectory(boolean setupWorkingDirectory) {
        this.mySetupWorkingDirectory = setupWorkingDirectory;
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(6);
        }
        return composeServiceExecCmd;
    }

    public boolean isSaveAllDocuments() {
        return this.mySaveAllDocuments;
    }

    @NotNull
    public ComposeServiceExecCmd withSaveAllDocuments(boolean saveAllDocuments) {
        this.mySaveAllDocuments = saveAllDocuments;
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(7);
        }
        return composeServiceExecCmd;
    }

    @NotNull
    private KillableColoredProcessHandler execute(boolean detached) throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = DockerComposeCliUtil.run(ComposeServiceExecCmd.buildExecCommand(this, detached), this.getDockerRuntime(), ProgressManager.getInstance().getProgressIndicator());
        if (killableColoredProcessHandler == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(8);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static DockerComposeExecCliBuilder buildExecCommand(@NotNull ComposeServiceExecCmd cmd, boolean detached) throws IOException {
        if (cmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.path.required", new Object[0]));
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.service.name.required", new Object[0]));
        }
        if (cmd.getCommand() == null) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.command.required", new Object[0]));
        }
        if (cmd.isSaveAllDocuments()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ServiceCmdExecUtils.saveAllDocumentsAsIs());
        }
        List<Path> configurationPaths = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(cmd.getConfigurationPaths());
        DockerComposeExecCliBuilder result2 = ((DockerComposeExecCliBuilder)((DockerComposeExecCliBuilder)((DockerComposeExecCliBuilder)((DockerComposeExecCliBuilder)DockerComposeCliUtil.buildExecCommand(cmd.getDockerRuntime().getAccount()).withRuntimeEnvironment(cmd.getEnvironment()).withEnvironment(cmd.getEnvs())).withFiles(configurationPaths)).withDetached(detached).withPtyOptions(DockerComposeCliUtil.toDockerComposePtyOptions(cmd.getPtyOptions())).withSubcommandOptions(cmd.getSubcommandOptions())).withCmd(cmd.getCommand()).withProjectName(cmd.getProjectName())).withService(cmd.getServiceName());
        if (cmd.isSetupWorkingDirectory()) {
            result2.withWorkingDir(cmd.getWorkingDir());
        }
        DockerComposeExecCliBuilder dockerComposeExecCliBuilder = result2;
        if (dockerComposeExecCliBuilder == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(10);
        }
        return dockerComposeExecCliBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceExecCmd";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceExecCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execDetached";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withPtyOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoPty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withSetupWorkingDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withSaveAllDocuments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExecCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildExecCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

