/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.intellij.docker.agent.progress.AgentResultCallbackTemplate;
import com.intellij.docker.agent.util.DockerLogMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"messagePattern", "", "timestampPattern", "lastMessageTimestamp", "Ljava/time/ZonedDateTime;", "Lcom/github/dockerjava/api/DockerClient;", "containerId", "toDockerMessage", "Lcom/intellij/docker/agent/util/DockerLogMessage;", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerLogUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerLogUtils.kt\ncom/intellij/docker/agent/util/DockerLogUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class DockerLogUtilsKt {
    @NotNull
    private static final String timestampPattern = "^\\[?(?<timestamp>[^\\s\\]]*)]? ";
    @NotNull
    private static final String messagePattern = "(?<entry>.*?)\\s*$";

    @Nullable
    public static final ZonedDateTime lastMessageTimestamp(@NotNull DockerClient $this$lastMessageTimestamp, @NotNull String containerId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$lastMessageTimestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        AgentResultCallbackTemplate.Adapter<Frame> logToLastTimestampCallback2 = new AgentResultCallbackTemplate.Adapter<Frame>(){
            @NotNull
            private StringBuffer log;
            {
                this.log = new StringBuffer();
            }

            /*
             * WARNING - void declaration
             */
            public void onNext(@Nullable Frame frame) {
                String string;
                StringBuffer stringBuffer = this.log;
                Frame frame2 = frame;
                if (frame2 != null) {
                    void it;
                    Frame frame3 = frame2;
                    StringBuffer stringBuffer2 = stringBuffer;
                    boolean bl = false;
                    byte[] byArray = it.getPayload();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    string = new String(byArray2, charset2);
                    stringBuffer = stringBuffer2;
                } else {
                    string = null;
                }
                stringBuffer.append(string);
            }

            @Nullable
            public final ZonedDateTime timestamp() {
                E element$iv;
                block1: {
                    String[] stringArray = new String[]{"\n"};
                    List $this$last$iv = StringsKt.split$default((CharSequence)this.log, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$last = false;
                    ListIterator<E> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        element$iv = iterator$iv.previous();
                        String it = (String)element$iv;
                        boolean bl = false;
                        boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                        if (!bl2) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("List contains no element matching the predicate.");
                }
                DockerLogMessage dockerLogMessage = DockerLogUtilsKt.toDockerMessage((String)element$iv);
                return dockerLogMessage != null ? dockerLogMessage.getTimestamp() : null;
            }
        };
        Object object2 = $this$lastMessageTimestamp;
        try {
            DockerClient $this$lastMessageTimestamp_u24lambda_u241 = object2;
            boolean bl = false;
            ($this$lastMessageTimestamp_u24lambda_u241.logContainerCmd(containerId).withStdErr(true).withStdOut(true).withTimestamps(true).withTail(1).exec((ResultCallback)logToLastTimestampCallback2)).awaitStarted(100L, TimeUnit.MILLISECONDS);
            boolean it = logToLastTimestampCallback2.awaitCompletion(100L, TimeUnit.MILLISECONDS);
            boolean bl2 = false;
            object = Result.constructor-impl((Object)logToLastTimestampCallback2.timestamp());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (ZonedDateTime)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Nullable
    public static final DockerLogMessage toDockerMessage(@NotNull String $this$toDockerMessage) {
        DockerLogMessage dockerLogMessage;
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)$this$toDockerMessage, (String)"<this>");
        Pattern pattern = Pattern.compile("^\\[?(?<timestamp>[^\\s\\]]*)]? (?<entry>.*?)\\s*$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern logLinePattern = pattern;
        Matcher it = matcher = logLinePattern.matcher($this$toDockerMessage);
        boolean bl = false;
        Matcher matcher2 = it.find() ? matcher : null;
        if (matcher2 != null) {
            Object object;
            it = matcher2;
            boolean bl2 = false;
            Object object2 = $this$toDockerMessage;
            try {
                String $this$toDockerMessage_u24lambda_u244_u24lambda_u243 = object2;
                boolean bl3 = false;
                ZonedDateTime timestamp2 = ZonedDateTime.parse(it.group("timestamp")).truncatedTo(ChronoUnit.NANOS);
                String message = it.group("entry");
                Intrinsics.checkNotNull((Object)timestamp2);
                Intrinsics.checkNotNull((Object)message);
                object = Result.constructor-impl((Object)new DockerLogMessage(timestamp2, message));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            dockerLogMessage = (DockerLogMessage)(Result.isFailure-impl((Object)object2) ? null : object2);
        } else {
            dockerLogMessage = null;
        }
        return dockerLogMessage;
    }
}

