/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fs;

import com.intellij.docker.agent.fs.LsEntry;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LS_ENTRY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SYMLINK_DELIMITER", "", "parseLsEntry", "Lcom/intellij/docker/agent/fs/LsEntry;", "entry", "intellij.clouds.docker.agent"})
public final class LsParsingKt {
    private static final Pattern LS_ENTRY_PATTERN = Pattern.compile("^(?<kind>[-dl]).{9}.?\\h+\\d+\\h+\\d+\\h+\\d+\\h+(?<size>\\d+)\\h+(?<date>\\d{4}-\\d{2}-\\d{2})\\h(?<time>\\d{2}:\\d{2}:\\d{2})(?<nanos>\\.\\d{9})?\\h(?<offsetHours>[+-]\\d{2})(?<offsetMinutes>\\d{2})\\h(?<nameAndTarget>.+)$");
    @NotNull
    private static final String SYMLINK_DELIMITER = " -> ";

    @Nullable
    public static final LsEntry parseLsEntry(@NotNull String entry) {
        long l;
        long l2;
        String nameAndTarget;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Matcher matcher = LS_ENTRY_PATTERN.matcher(entry);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.find()) {
            return null;
        }
        char kind = matcher2.group("kind").charAt(0);
        boolean directory = kind == 'd';
        boolean symlink = kind == 'l';
        String name2 = nameAndTarget = matcher2.group("nameAndTarget");
        String target2 = null;
        if (symlink) {
            Intrinsics.checkNotNull((Object)nameAndTarget);
            int delimiter = StringsKt.indexOf$default((CharSequence)nameAndTarget, (String)SYMLINK_DELIMITER, (int)0, (boolean)false, (int)6, null);
            if (delimiter > 0) {
                String string = nameAndTarget.substring(0, delimiter);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                name2 = string;
                String string2 = nameAndTarget.substring(delimiter + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                target2 = string2;
            }
        }
        try {
            String string = matcher2.group("size");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
        long size = l2;
        try {
            String nanos = matcher2.group("nanos");
            String string = matcher2.group("date");
            String string3 = matcher2.group("time");
            String string4 = nanos;
            if (string4 == null) {
                string4 = ".000000000";
            }
            l = OffsetDateTime.parse(string + "T" + string3 + string4 + matcher2.group("offsetHours") + ":" + matcher2.group("offsetMinutes")).toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            return null;
        }
        long timestamp2 = l;
        String string = name2;
        Intrinsics.checkNotNull((Object)string);
        return new LsEntry(string, directory, size, timestamp2, symlink, target2);
    }
}

