/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerResource;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerResourceDownloader;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/LocalFeatureDownloader;", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResourceDownloader;", "resource", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "workingDir", "Ljava/nio/file/Path;", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;Ljava/nio/file/Path;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;)V", "downloadAndExtract", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.docker.agent"})
public final class LocalFeatureDownloader
extends DevcontainerResourceDownloader {
    public LocalFeatureDownloader(@NotNull DevcontainerResource resource, @NotNull Path workingDir2, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super(resource, workingDir2, proxy);
    }

    @Override
    @Nullable
    public Object downloadAndExtract(@NotNull Continuation<? super Path> $completion) {
        String[] stringArray = new String[]{"/"};
        Iterable iterable = StringsKt.split$default((CharSequence)(this.getResource().getRef().getNamespace() + "/" + this.getResource().getRef().getId()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String normalizedRelPath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new String[]{normalizedRelPath};
        Path absolutePath = Path.of(((Object)this.getWorkingDir()).toString(), (String[])objectArray);
        Intrinsics.checkNotNull((Object)absolutePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(absolutePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            objectArray = new Object[]{absolutePath};
            this.getProxy().getPrinter().printError(DockerAgentBundle.Companion.message("devcontainers.feature.can.t.be.found", objectArray));
            return null;
        }
        return absolutePath;
    }
}

