/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeDeserializer;
import com.intellij.docker.agent.compose.beans.DockerComposeVersion;
import com.intellij.docker.agent.compose.parser.DockerComposeConfigurationStreamParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/compose/parser/PureDockerComposeConfigurationParser;", "Lcom/intellij/docker/agent/compose/parser/DockerComposeConfigurationStreamParser;", "()V", "parseBean", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "reader", "Ljava/io/Reader;", "parseVersion", "Lcom/intellij/docker/agent/compose/beans/DockerComposeVersion;", "intellij.clouds.docker.agent"})
public final class PureDockerComposeConfigurationParser
implements DockerComposeConfigurationStreamParser {
    @Override
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull Reader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object object = DockerComposeDeserializer.Companion.getMapper().readValue(reader, DockerComposeConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (DockerComposeConfiguration)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DockerComposeVersion parseVersion(@NotNull Reader reader) throws IOException {
        DockerComposeVersion dockerComposeVersion;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Closeable closeable = (Closeable)DockerComposeDeserializer.Companion.getMapper().getFactory().createParser(reader);
        Throwable throwable = null;
        try {
            JsonParser parser = (JsonParser)closeable;
            boolean bl = false;
            TreeNode treeNode = parser.getCodec().readTree(parser);
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
            JsonNode jsonNode = (JsonNode)treeNode;
            Intrinsics.checkNotNull((Object)parser);
            dockerComposeVersion = DockerComposeDeserializer.Companion.getDockerComposeConfigurationVersion(jsonNode, parser);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dockerComposeVersion;
    }
}

