/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerKt;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\n\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServersStep;", "Lcom/intellij/ide/wizard/StepAdapter;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "cfg", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "(Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "component", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "dialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "gdbServer", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "getWizard", "()Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "_commit", "", "finishChosen", "", "_init", "getComponent", "getHelpId", "", "getPreferredFocusedComponent", "intellij.clion.embedded"})
public final class GdbServersStep
extends StepAdapter {
    @NotNull
    private final GdbServerWizard wizard;
    @NotNull
    private final RunnerAndConfigurationSettings cfg;
    @Nullable
    private DialogPanel dialogPanel;
    private GdbServer gdbServer;
    @Nullable
    private JComponent preferredFocusedComponent;
    @NotNull
    private final BorderLayoutPanel component;

    public GdbServersStep(@NotNull GdbServerWizard wizard, @NotNull RunnerAndConfigurationSettings cfg) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.wizard = wizard;
        this.cfg = cfg;
        this.component = new BorderLayoutPanel();
    }

    @NotNull
    public final GdbServerWizard getWizard() {
        return this.wizard;
    }

    public void _commit(boolean finishChosen) {
        DialogPanel dialogPanel = this.dialogPanel;
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        if (finishChosen) {
            this.wizard.verifyName();
            RunConfiguration runConfiguration = this.cfg.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration");
            CustomGdbServerRunConfiguration embedCfg = (CustomGdbServerRunConfiguration)runConfiguration;
            Object object = this.wizard.getState().getRemotePort();
            int port = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)GdbServerKt.getPORT_RANGE());
            CustomGdbServerRunConfiguration $this$_commit_u24lambda_u240 = embedCfg;
            boolean bl = false;
            $this$_commit_u24lambda_u240.setName(this.wizard.getState().getConfigurationName());
            $this$_commit_u24lambda_u240.setGdbRemoteString("tcp::" + port);
            GdbServer gdbServer = this.gdbServer;
            if (gdbServer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer = null;
            }
            $this$_commit_u24lambda_u240.setServerExecutable(gdbServer.getGdbserverExe(this.wizard.getState()));
            GdbServer gdbServer2 = this.gdbServer;
            if (gdbServer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer2 = null;
            }
            $this$_commit_u24lambda_u240.setProgramParameters(gdbServer2.generateConnectionString(this.wizard.getState(), port));
            $this$_commit_u24lambda_u240.setDownloadType(this.wizard.getState().getDownloadType());
            GdbServer gdbServer3 = this.gdbServer;
            if (gdbServer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer3 = null;
            }
            $this$_commit_u24lambda_u240.setResetCommand(gdbServer3.getResetCommand());
            ApplicationManager.getApplication().runWriteAction(() -> GdbServersStep._commit$lambda$2(this));
            Project project = this.wizard.getProject();
            GdbServer gdbServer4 = this.gdbServer;
            if (gdbServer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer4 = null;
            }
            EmbeddedUsagesCollector.logWizardSuccess(project, gdbServer4.getType());
        }
        this.component.removeAll();
        this.dialogPanel = null;
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.component;
    }

    public void _init() {
        super._init();
        this.gdbServer = GdbServer.Companion.byId(this.wizard.getState().getDebugProbe());
        this.wizard.setFinishEnabled(true);
        GdbServer gdbServer = this.gdbServer;
        if (gdbServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
            gdbServer = null;
        }
        DialogPanel dialogPanel = this.dialogPanel = gdbServer.getDialogPanel(this.wizard);
        Intrinsics.checkNotNull((Object)dialogPanel);
        this.component.addToCenter((Component)dialogPanel);
        List list = ComponentUtil.findComponentsOfType((JComponent)((JComponent)this.dialogPanel), Tree.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
        this.preferredFocusedComponent = (JComponent)CollectionsKt.getOrNull((List)list, (int)0);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.preferredFocusedComponent;
    }

    @NotNull
    public final String getHelpId() {
        GdbServer gdbServer = this.gdbServer;
        if (gdbServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
            gdbServer = null;
        }
        return "embedded.gdbserver.wizard." + gdbServer + ".getId()";
    }

    private static final void _commit$lambda$2(GdbServersStep this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RunManager $this$_commit_u24lambda_u242_u24lambda_u241 = RunManager.Companion.getInstance(this$0.wizard.getProject());
        boolean bl = false;
        $this$_commit_u24lambda_u242_u24lambda_u241.addConfiguration(this$0.cfg);
        $this$_commit_u24lambda_u242_u24lambda_u241.setSelectedConfiguration(this$0.cfg);
    }
}

