/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.ui.ClickListener;
import com.intellij.ui.dualView.TreeTableView;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/GotoAddressOnClickListener;", "Lcom/intellij/ui/ClickListener;", "table", "Lcom/intellij/ui/dualView/TreeTableView;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "addressColumnNumber", "", "nodeToAddressMapper", "Lkotlin/Function1;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "(Lcom/intellij/ui/dualView/TreeTableView;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;ILkotlin/jvm/functions/Function1;)V", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "clickCount", "intellij.clion.embedded"})
public final class GotoAddressOnClickListener
extends ClickListener {
    @NotNull
    private final TreeTableView table;
    @NotNull
    private final CidrDebugProcess debugProcess;
    private final int addressColumnNumber;
    @NotNull
    private final Function1<DefaultMutableTreeNode, Address> nodeToAddressMapper;

    public GotoAddressOnClickListener(@NotNull TreeTableView table, @NotNull CidrDebugProcess debugProcess, int addressColumnNumber, @NotNull Function1<? super DefaultMutableTreeNode, Address> nodeToAddressMapper) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter(nodeToAddressMapper, (String)"nodeToAddressMapper");
        this.table = table;
        this.debugProcess = debugProcess;
        this.addressColumnNumber = addressColumnNumber;
        this.nodeToAddressMapper = nodeToAddressMapper;
    }

    public boolean onClick(@NotNull MouseEvent event, int clickCount) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int clickedColumnNumber = this.table.columnAtPoint(event.getPoint());
        if (this.table.getColumnModel().getColumn(clickedColumnNumber).getModelIndex() == this.addressColumnNumber) {
            List list = this.table.getSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelection(...)");
            Object object = CollectionsKt.firstOrNull((List)list);
            DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            if (defaultMutableTreeNode == null) {
                return false;
            }
            DefaultMutableTreeNode node = defaultMutableTreeNode;
            Address address = (Address)this.nodeToAddressMapper.invoke((Object)node);
            if (address == null || (address = AddressUtil.addressToRange((Address)address, (long)1L)) == null) {
                return false;
            }
            Address address2 = address;
            FreeRtosDataManagerKt.showMemoryRange(this.debugProcess, (AddressRange)address2);
            return true;
        }
        return false;
    }
}

