/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.RtosOptions;
import com.intellij.clion.embedded.execution.rtos.RtosSettings;
import com.intellij.clion.embedded.execution.rtos.RtosType;
import com.intellij.clion.embedded.execution.rtos.RtosUsagesCollector;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/RtosSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/rtos/RtosOptions;", "getState", "()Lcom/intellij/clion/embedded/execution/rtos/RtosOptions;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "RtosTypeListCellRenderer", "intellij.clion.embedded"})
public final class RtosSettingsConfigurable
extends BoundConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final RtosOptions state;

    public RtosSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = EmbeddedBundle.message("configurable.RtosSettingsConfigurable.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "settings.rtos.enable");
        this.project = project;
        this.state = RtosSettings.Companion.getState(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RtosOptions getState() {
        return this.state;
    }

    public void apply() {
        super.apply();
        RtosUsagesCollector.INSTANCE.getRTOS_SETTINGS_CHANGED().log(this.project, (Object)this.state.isRtosEnabled(), (Object)this.state.getRtosType());
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ RtosSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RtosSettingsConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = EmbeddedBundle.message("rtos.panel.selector.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell rtosEnabled2 = ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(string), (String)EmbeddedBundle.message("rtos.panel.selector.hint", new Object[0]), (int)0, null, (int)6, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0.getState())){

                            @Nullable
                            public Object get() {
                                return ((RtosOptions)((Object)this.receiver)).isRtosEnabled();
                            }

                            public void set(@Nullable Object value) {
                                ((RtosOptions)((Object)this.receiver)).setRtosEnabled((Boolean)value);
                            }
                        }));
                        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)RtosType.getEntries(), (ListCellRenderer)new RtosTypeListCellRenderer()), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0.getState())){

                            @Nullable
                            public Object get() {
                                return ((RtosOptions)((Object)this.receiver)).getRtosType();
                            }

                            public void set(@Nullable Object value) {
                                ((RtosOptions)((Object)this.receiver)).setRtosType((RtosType)((Object)value));
                            }
                        }))).enabledIf(ButtonKt.getSelected((Cell)rtosEnabled2));
                    }
                }), (int)1, null);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J@\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0002\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/RtosSettingsConfigurable$RtosTypeListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/clion/embedded/execution/rtos/RtosType;", "()V", "delegate", "Ljavax/swing/DefaultListCellRenderer;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.clion.embedded"})
    private static final class RtosTypeListCellRenderer
    implements ListCellRenderer<RtosType> {
        @NotNull
        private final DefaultListCellRenderer delegate = new DefaultListCellRenderer();

        @Override
        @Nullable
        public Component getListCellRendererComponent(@Nullable JList<? extends RtosType> list, @Nullable RtosType value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.delegate.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
        }
    }
}

