/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.intellij.clion.embedded.execution.rtos.GdbRtosSupport;
import com.intellij.clion.embedded.execution.rtos.GdbRtosSupportKt;
import com.intellij.clion.embedded.execution.rtos.RtosLLThread;
import com.intellij.clion.embedded.execution.rtos.RtosLLValue;
import com.intellij.clion.embedded.execution.rtos.RtosOptions;
import com.intellij.clion.embedded.execution.rtos.RtosSettings;
import com.intellij.clion.embedded.execution.rtos.RtosType;
import com.intellij.clion.embedded.execution.rtos.RtosUsagesCollector;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManager;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosPosixPort;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosRegistry;
import com.intellij.clion.embedded.execution.rtos.freertos.Task;
import com.intellij.clion.embedded.execution.rtos.zephyr.ZephyrUtilsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "rtosType", "Lcom/intellij/clion/embedded/execution/rtos/RtosType;", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "RtosCommonCommands", "intellij.clion.embedded"})
public final class GdbRtosSupport
implements CidrDebugProcessConfigurator {
    @Nullable
    private RtosType rtosType;

    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerDriverConfiguration, (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration debuggerDriverConfiguration2 = debuggerDriverConfiguration;
        if (!(debuggerDriverConfiguration2 instanceof GDBDriverConfiguration)) {
            return;
        }
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RtosOptions state = RtosSettings.Companion.getState(project);
        if (!state.isRtosEnabled()) {
            return;
        }
        Project project2 = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RtosUsagesCollector.INSTANCE.logTryDetectRtos(project2, state.getRtosType());
        process.postCommand(arg_0 -> GdbRtosSupport.configure$lambda$0(debuggerDriverConfiguration2, state, this, process, arg_0));
    }

    private static final void configure$lambda$0(DebuggerDriverConfiguration $debuggerDriverConfiguration, RtosOptions $state, GdbRtosSupport this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)$debuggerDriverConfiguration, (String)"$debuggerDriverConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)$state), (String)"$state");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            try {
                block11: {
                    block10: {
                        driver.executeInterpreterCommand(-1L, -1, "python " + GdbRtosSupportKt.generateRtosImportScript($debuggerDriverConfiguration, $state.getRtosType()));
                        String string = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_init(\"" + $state.getRtosType().name() + "\")");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
                        String consoleOutput = string;
                        Map map = (Map)GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(consoleOutput, BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)));
                        if (map == null) {
                            return;
                        }
                        Map answer = map;
                        CharSequence charSequence = (CharSequence)answer.get("name");
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block9;
                        Object v = answer.get("name");
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        this$0.rtosType = RtosType.valueOf((String)v);
                        if (this$0.rtosType == RtosType.FREERTOS) {
                            FreeRtosDataManager dataManager = new FreeRtosDataManager($process, driver);
                            FreeRtosRegistry.Companion.registerObjectsTab($process, dataManager);
                            if (dataManager.getConfig().isPosix() && SystemInfo.isLinux) {
                                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)new FreeRtosPosixPort());
                            } else {
                                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)this$0.new RtosCommonCommands());
                            }
                            Project project = $process.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            RtosUsagesCollector.INSTANCE.logRtosDetected(project, RtosType.FREERTOS);
                            break block9;
                        }
                        if (this$0.rtosType != RtosType.ZEPHYR) break block10;
                        Project project = $process.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        if (ZephyrUtilsKt.isZephyrConfigurationComplete(project, driver)) break block11;
                    }
                    if (this$0.rtosType != RtosType.AZURE) break block9;
                }
                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)this$0.new RtosCommonCommands());
                Project project = $process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RtosType rtosType = this$0.rtosType;
                Intrinsics.checkNotNull((Object)((Object)rtosType));
                RtosUsagesCollector.INSTANCE.logRtosDetected(project, rtosType);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.info("RTOS integration state: " + $state.getRtosType() + ", RTOS has not been found");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0016J6\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J1\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*H\u0002\u00a2\u0006\u0002\u0010+\u00a8\u0006,"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport$RtosCommonCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "(Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport;)V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "evaluate", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "expression", "", "language", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DebuggerLanguage;", "getData", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "value", "getFrames", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList;", "from", "", "count", "untilFirstLineWithCode", "", "getThreads", "", "getVariableChildren", "getVariables", "", "switchTaskContextAndExecute", "T", "task", "Lcom/intellij/clion/embedded/execution/rtos/RtosLLThread;", "callable", "Lkotlin/Function0;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/intellij/clion/embedded/execution/rtos/RtosLLThread;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.clion.embedded"})
    private final class RtosCommonCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)stopTuple, (String)"stopTuple");
            return GdbRtosSupportKt.rtosDoReadStopPlaceAsync(bridge, stopTuple, (Function0<? extends CompletableFuture<DebuggerDriver.StopPlace>>)((Function0)new Function0<CompletableFuture<DebuggerDriver.StopPlace>>(this, bridge, driver, stopTuple){
                final /* synthetic */ RtosCommonCommands this$0;
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ GDBDriver $driver;
                final /* synthetic */ GDBTuple $stopTuple;
                {
                    this.this$0 = $receiver;
                    this.$bridge = $bridge;
                    this.$driver = $driver;
                    this.$stopTuple = $stopTuple;
                    super(0);
                }

                @NotNull
                public final CompletableFuture<DebuggerDriver.StopPlace> invoke() {
                    CompletableFuture completableFuture = RtosCommonCommands.access$doReadStopPlaceAsync$s228224222(this.this$0, this.$bridge, this.$driver, this.$stopTuple);
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"access$doReadStopPlaceAsync$s228224222(...)");
                    return completableFuture;
                }
            }));
        }

        @NotNull
        public List<LLThread> getThreads(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            return GdbRtosSupportKt.getRtosThreads(bridge, (Function2<? super Long, ? super List<Task>, ? extends List<? extends LLThread>>)((Function2)getThreads.1.INSTANCE));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T switchTaskContextAndExecute(GDBDriver.Bridge bridge, RtosLLThread task, Function0<? extends T> callable) {
            DebuggerDriver.StopPlace stopPlace = bridge.getStopPlace();
            if (Intrinsics.areEqual((Object)(stopPlace != null && (stopPlace = stopPlace.frame) != null ? stopPlace.getProgramCounter() : null), (Object)task.getProgramCounter())) {
                return (T)callable.invoke();
            }
            bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
            bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_thread(" + task.getStackTopAddress() + ")", new Object[0]);
            try {
                Object object = callable.invoke();
                return (T)object;
            }
            finally {
                bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_back()", new Object[0]);
            }
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand(() -> RtosCommonCommands.getFrames$lambda$0(this, bridge, thread, from, count, untilFirstLineWithCode));
                Intrinsics.checkNotNull((Object)object);
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = super.getFrames(bridge, thread, from, count, untilFirstLineWithCode);
                Intrinsics.checkNotNull((Object)resultList2);
                resultList = resultList2;
            }
            return resultList;
        }

        @NotNull
        public List<LLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            List list;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getVariables$lambda$1(this, bridge, thread, frame)));
                Intrinsics.checkNotNull((Object)object);
                list = (List)object;
            } else {
                List list2 = super.getVariables(bridge, thread, frame);
                Intrinsics.checkNotNull((Object)list2);
                list = list2;
            }
            return list;
        }

        @NotNull
        public LLValueData getData(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value) {
            LLValueData lLValueData;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getData$lambda$2(this, bridge, value)));
                Intrinsics.checkNotNull((Object)object);
                lLValueData = (LLValueData)object;
            } else {
                LLValueData lLValueData2 = bridge.doLoadVariableData(value);
                Intrinsics.checkNotNull((Object)lLValueData2);
                lLValueData = lLValueData2;
            }
            return lLValueData;
        }

        @NotNull
        public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value, int from, int count) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getVariableChildren$lambda$3(this, bridge, value, from, count)));
                Intrinsics.checkNotNull((Object)object);
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = bridge.doGetVariableChildren(value, from, count);
                Intrinsics.checkNotNull((Object)resultList2);
                resultList = resultList2;
            }
            return resultList;
        }

        @NotNull
        public LLValue evaluate(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) {
            LLValue lLValue;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.EvaluationCommand<LLValue>(expression, this, bridge, thread, frame, language){
                    final /* synthetic */ String $expression;
                    final /* synthetic */ RtosCommonCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLThread $thread;
                    final /* synthetic */ LLFrame $frame;
                    final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;
                    {
                        this.$expression = $expression;
                        this.this$0 = $receiver;
                        this.$bridge = $bridge;
                        this.$thread = $thread;
                        this.$frame = $frame;
                        this.$language = $language;
                        super($expression);
                    }

                    @NotNull
                    public LLValue call() {
                        Object object = RtosCommonCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, (RtosLLThread)this.$thread, (Function0)new Function0<LLValue>(this.$bridge, this.$thread, this.$frame, this.$expression, this.$language){
                            final /* synthetic */ GDBDriver.Bridge $bridge;
                            final /* synthetic */ LLThread $thread;
                            final /* synthetic */ LLFrame $frame;
                            final /* synthetic */ String $expression;
                            final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;
                            {
                                this.$bridge = $bridge;
                                this.$thread = $thread;
                                this.$frame = $frame;
                                this.$expression = $expression;
                                this.$language = $language;
                                super(0);
                            }

                            @NotNull
                            public final LLValue invoke() {
                                return this.$bridge.doEvaluate(((RtosLLThread)this.$thread).getGdbThreadId(), this.$frame.getIndex(), this.$expression, this.$language);
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"access$switchTaskContextAndExecute(...)");
                        return (LLValue)object;
                    }
                });
                Intrinsics.checkNotNull((Object)object);
                lLValue = (LLValue)object;
            } else {
                LLValue lLValue2 = bridge.doEvaluate(thread.getId(), frame.getIndex(), expression, language);
                Intrinsics.checkNotNull((Object)lLValue2);
                lLValue = lLValue2;
            }
            return lLValue;
        }

        private static final DebuggerDriver.ResultList getFrames$lambda$0(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, int $from, int $count, boolean $untilFirstLineWithCode) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bridge, (String)"$bridge");
            Intrinsics.checkNotNullParameter((Object)$thread, (String)"$thread");
            return (DebuggerDriver.ResultList)this$0.switchTaskContextAndExecute($bridge, (RtosLLThread)$thread, (Function0)new Function0<DebuggerDriver.ResultList<LLFrame>>($bridge, $from, $count, $untilFirstLineWithCode){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ int $from;
                final /* synthetic */ int $count;
                final /* synthetic */ boolean $untilFirstLineWithCode;
                {
                    this.$bridge = $bridge;
                    this.$from = $from;
                    this.$count = $count;
                    this.$untilFirstLineWithCode = $untilFirstLineWithCode;
                    super(0);
                }

                @NotNull
                public final DebuggerDriver.ResultList<LLFrame> invoke() {
                    return this.$bridge.doGetFrames(1L, this.$from, this.$count, this.$untilFirstLineWithCode);
                }
            });
        }

        private static final List getVariables$lambda$1(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bridge, (String)"$bridge");
            Intrinsics.checkNotNullParameter((Object)$thread, (String)"$thread");
            Intrinsics.checkNotNullParameter((Object)$frame, (String)"$frame");
            return (List)this$0.switchTaskContextAndExecute($bridge, (RtosLLThread)$thread, (Function0)new Function0<List<LLValue>>($bridge, $thread, $frame){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ LLFrame $frame;
                {
                    this.$bridge = $bridge;
                    this.$thread = $thread;
                    this.$frame = $frame;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<LLValue> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.$bridge.doGetFrameVariables(((RtosLLThread)this.$thread).getGdbThreadId(), this.$frame.getIndex());
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doGetFrameVariables(...)");
                    Iterable iterable = list;
                    LLThread lLThread = this.$thread;
                    LLFrame lLFrame = this.$frame;
                    boolean $i$f$map = false;
                    void var5_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LLValue lLValue = (LLValue)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        RtosLLThread rtosLLThread = (RtosLLThread)lLThread;
                        int n = lLFrame.getIndex();
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(new RtosLLValue(rtosLLThread, n, (LLValue)it));
                    }
                    return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                }
            });
        }

        private static final LLValueData getData$lambda$2(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLValue $value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bridge, (String)"$bridge");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            return (LLValueData)this$0.switchTaskContextAndExecute($bridge, ((RtosLLValue)$value).getMyRtosLLThread(), (Function0)new Function0<LLValueData>($bridge, $value){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLValue $value;
                {
                    this.$bridge = $bridge;
                    this.$value = $value;
                    super(0);
                }

                @NotNull
                public final LLValueData invoke() {
                    return this.$bridge.doLoadVariableData(this.$value);
                }
            });
        }

        private static final DebuggerDriver.ResultList getVariableChildren$lambda$3(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLValue $value, int $from, int $count) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bridge, (String)"$bridge");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            return (DebuggerDriver.ResultList)this$0.switchTaskContextAndExecute($bridge, ((RtosLLValue)$value).getMyRtosLLThread(), (Function0)new Function0<DebuggerDriver.ResultList<LLValue>>($bridge, $value, $from, $count){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLValue $value;
                final /* synthetic */ int $from;
                final /* synthetic */ int $count;
                {
                    this.$bridge = $bridge;
                    this.$value = $value;
                    this.$from = $from;
                    this.$count = $count;
                    super(0);
                }

                @NotNull
                public final DebuggerDriver.ResultList<LLValue> invoke() {
                    return this.$bridge.doGetVariableChildren(this.$value, this.$from, this.$count);
                }
            });
        }

        public static final /* synthetic */ CompletableFuture access$doReadStopPlaceAsync$s228224222(RtosCommonCommands $this, GDBDriver.Bridge p0, GDBDriver p1, GDBTuple p2) {
            return super.doReadStopPlaceAsync(p0, p1, p2);
        }

        public static final /* synthetic */ Object access$switchTaskContextAndExecute(RtosCommonCommands $this, GDBDriver.Bridge bridge, RtosLLThread task, Function0 callable) {
            return $this.switchTaskContextAndExecute(bridge, task, callable);
        }
    }
}

