/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.custom;

import com.intellij.clion.embedded.execution.custom.CustomGdbServerConfigurationHelper;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerLauncher;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfigurationSettingsEditor;
import com.intellij.clion.embedded.execution.custom.McuResetActionKt;
import com.intellij.clion.embedded.execution.custom.TargetResetType;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.gdbserver.ConnectionMode;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGdbServerRunConfiguration
extends GdbServerRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction,
DebugTargetParameters {
    private static final String ATTR_RESET_COMMAND = "reset-cmd";
    private static final String ATTR_RESET_AFTER_DOWNLOAD = "reset-after-download";
    private static final String ATTR_RESET_TYPE = "reset-type";
    private static final String ATTR_CONNECTION_MODE = "connection-mode";
    private static final String ATTR_CUSTOM_SCRIPT = "custom-script";
    private static final String ATTR_DEBUGGER_WORKING_DIR = "debugger-working-dir";
    private static final String ATTR_DEBUGGER_ENV_PASS_PARENT = "debugger-env-pass-parent";
    private static final String ATTR_GDBSERVER_ENABLE = "gdbserver-enable";
    private static final String ATTR_CONSOLE_ENABLED = "console-enabled";
    private static final String ATTR_CONSOLE_PORT = "console-port";
    public static final String ELEMENT_DEBUGGER_PARAMS = "extra-debugger-params";
    private static final String DEFAULT_RESET_COMMAND = "monitor reset";
    private static final TargetResetType DEFAULT_RESET_TYPE = TargetResetType.AFTER_DOWNLOAD;
    private static final ConnectionMode DEFAULT_CONNECTION_MODE = ConnectionMode.REMOTE;
    private String myResetCommand = "monitor reset";
    private TargetResetType myResetType = DEFAULT_RESET_TYPE;
    private ConnectionMode myConnectionMode = DEFAULT_CONNECTION_MODE;
    private String myCustomScript = "";
    private String myDebuggerWorkingDir = "";
    private Map<String, String> myDebuggerEnvVars = new LinkedHashMap<String, String>();
    private boolean myDebuggerEnvPassParent = true;
    private boolean myGdbserverEnable = true;
    private int myConsolePort = 0;
    private boolean myConsoleEnabled = false;

    public CustomGdbServerRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public int getUniqueID() {
        return super.getUniqueID();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new CustomGdbServerRunConfigurationSettingsEditor(this.getProject(), this.getHelper());
    }

    @NotNull
    public CidrCompoundConfigurationHelper getHelper() {
        return new CustomGdbServerConfigurationHelper(this.getProject());
    }

    public void readExternal(@NotNull Element parentElement) throws InvalidDataException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        if (element != null) {
            this.myResetCommand = element.getAttributeValue(ATTR_RESET_COMMAND, DEFAULT_RESET_COMMAND);
            TargetResetType defaultResetType = DEFAULT_RESET_TYPE;
            String myResetAfterDownload = element.getAttributeValue(ATTR_RESET_AFTER_DOWNLOAD);
            if (myResetAfterDownload != null) {
                defaultResetType = Boolean.FALSE.toString().equals(myResetAfterDownload) ? TargetResetType.NEVER : TargetResetType.AFTER_DOWNLOAD;
            }
            this.myResetType = (TargetResetType)Utils.readEnumAttr((Element)element, (String)ATTR_RESET_TYPE, (Enum)defaultResetType);
            this.myConnectionMode = (ConnectionMode)Utils.readEnumAttr((Element)element, (String)ATTR_CONNECTION_MODE, (Enum)DEFAULT_CONNECTION_MODE);
            this.myGdbserverEnable = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTR_GDBSERVER_ENABLE));
            this.myConsoleEnabled = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTR_CONSOLE_ENABLED));
            this.myConsolePort = Utils.readIntAttr((Element)element, (String)ATTR_CONSOLE_PORT, (int)0);
            Element debuggerParams = element.getChild(ELEMENT_DEBUGGER_PARAMS);
            this.myDebuggerWorkingDir = "";
            this.myDebuggerEnvVars.clear();
            this.myDebuggerEnvPassParent = true;
            this.myCustomScript = "";
            if (debuggerParams != null) {
                this.myDebuggerWorkingDir = debuggerParams.getAttributeValue(ATTR_DEBUGGER_WORKING_DIR, "");
                EnvironmentVariablesComponent.readExternal((Element)debuggerParams, this.myDebuggerEnvVars);
                this.myDebuggerEnvPassParent = Boolean.TRUE.toString().equals(debuggerParams.getAttributeValue(ATTR_DEBUGGER_ENV_PASS_PARENT));
                this.myCustomScript = debuggerParams.getAttributeValue(ATTR_CUSTOM_SCRIPT, "");
            }
        }
    }

    public void writeExternal(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        assert (element != null);
        element.setAttribute(ATTR_RESET_COMMAND, this.myResetCommand);
        element.setAttribute(ATTR_RESET_TYPE, this.myResetType.name());
        element.setAttribute(ATTR_CONNECTION_MODE, this.myConnectionMode.toString());
        element.setAttribute(ATTR_GDBSERVER_ENABLE, String.valueOf(this.myGdbserverEnable));
        element.setAttribute(ATTR_CONSOLE_ENABLED, String.valueOf(this.myConsoleEnabled));
        element.setAttribute(ATTR_CONSOLE_PORT, String.valueOf(this.myConsolePort));
        Element debuggerParams = new Element(ELEMENT_DEBUGGER_PARAMS);
        element.addContent(debuggerParams);
        debuggerParams.setAttribute(ATTR_DEBUGGER_WORKING_DIR, this.myDebuggerWorkingDir);
        EnvironmentVariablesComponent.writeExternal((Element)debuggerParams, this.myDebuggerEnvVars);
        debuggerParams.setAttribute(ATTR_DEBUGGER_ENV_PASS_PARENT, String.valueOf(this.myDebuggerEnvPassParent));
        debuggerParams.setAttribute(ATTR_CUSTOM_SCRIPT, String.valueOf(this.myCustomScript));
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(3);
        }
        CustomGdbServerLauncher launcher = new CustomGdbServerLauncher(environment, this, this.getDebuggerData().getOrCreateDebuggerToolchain());
        return new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    @NotNull
    public String getResetCommand() {
        String string = this.myResetCommand;
        if (string == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setResetCommand(@NotNull String resetCommand) {
        if (resetCommand == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myResetCommand = resetCommand;
    }

    public TargetResetType getResetType() {
        return this.myResetType;
    }

    public void setResetType(TargetResetType resetType) {
        this.myResetType = resetType;
    }

    @NotNull
    public ConnectionMode getConnectionMode() {
        ConnectionMode connectionMode = this.myConnectionMode;
        if (connectionMode == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(6);
        }
        return connectionMode;
    }

    public void setConnectionMode(@NotNull ConnectionMode connectionMode) {
        if (connectionMode == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(7);
        }
        this.myConnectionMode = connectionMode;
    }

    @NotNull
    public String getCustomScript() {
        String string = this.myCustomScript;
        if (string == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setCustomScript(@NotNull String customScript) {
        if (customScript == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(9);
        }
        this.myCustomScript = customScript;
    }

    @NotNull
    public String getDebuggerWorkingDir() {
        String string = this.myDebuggerWorkingDir;
        if (string == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setDebuggerWorkingDir(@NotNull String debuggerWorkingDir) {
        if (debuggerWorkingDir == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(11);
        }
        this.myDebuggerWorkingDir = debuggerWorkingDir;
    }

    @NotNull
    public Map<String, String> getDebuggerEnvVars() {
        Map<String, String> map = this.myDebuggerEnvVars;
        if (map == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(12);
        }
        return map;
    }

    public void setDebuggerEnvVars(@NotNull @NotNull Map<@NotNull String, @NotNull String> debuggerEnvVars) {
        if (debuggerEnvVars == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(13);
        }
        this.myDebuggerEnvVars = debuggerEnvVars;
    }

    public boolean isDebuggerEnvPassParent() {
        return this.myDebuggerEnvPassParent;
    }

    public void setDebuggerEnvPassParent(boolean debuggerEnvPassParent) {
        this.myDebuggerEnvPassParent = debuggerEnvPassParent;
    }

    public boolean isGdbserverEnable() {
        return this.myGdbserverEnable;
    }

    public void setGdbserverEnable(boolean gdbserverEnable) {
        this.myGdbserverEnable = gdbserverEnable;
    }

    public int getConsolePort() {
        return this.myConsolePort;
    }

    public void setConsolePort(int consolePort) {
        this.myConsolePort = consolePort;
    }

    public boolean isConsoleEnabled() {
        return this.myConsoleEnabled;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.myConsoleEnabled = consoleEnabled;
    }

    private void updateResetType(boolean before, boolean after) {
        this.myResetType = before ? (after ? TargetResetType.BOTH_TIMES : TargetResetType.BEFORE_DOWNLOAD) : (after ? TargetResetType.AFTER_DOWNLOAD : TargetResetType.NEVER);
    }

    public boolean isResetBeforeLoad() {
        return this.myResetType == TargetResetType.BEFORE_DOWNLOAD || this.myResetType == TargetResetType.BOTH_TIMES;
    }

    public void setResetBeforeLoad(boolean value) {
        this.updateResetType(value, this.isResetAfterLoad());
    }

    public boolean isResetAfterLoad() {
        return this.myResetType == TargetResetType.AFTER_DOWNLOAD || this.myResetType == TargetResetType.BOTH_TIMES;
    }

    public void setResetAfterLoad(boolean value) {
        this.updateResetType(this.isResetBeforeLoad(), value);
    }

    public void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<? super AnAction> actions) {
        AnAction resetAction;
        if (state == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(14);
        }
        if (processHandler == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(15);
        }
        if (console == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(16);
        }
        if (actions == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(17);
        }
        if ((resetAction = ActionManager.getInstance().getAction("intellij.clion.embedded.mcu.reset")) != null) {
            String command = this.getResetCommand().trim();
            processHandler.putUserData(McuResetActionKt.RESET_COMMAND, (Object)command);
            actions.add((AnAction)resetAction);
        } else {
            Logger.getLogger(CustomGdbServerRunConfiguration.class.getName()).severe("MCU Reset Action not found");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetCommand";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customScript";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerWorkingDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerEnvVars";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionMode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomScript";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerWorkingDir";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerEnvVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setResetCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setConnectionMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCustomScript";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerWorkingDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerEnvVars";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 10, 12 -> new IllegalStateException(string);
        };
    }
}

